/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.InternalRep;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclInteger;
import tcl.lang.TclObject;
import tcl.lang.Util;

public class TclBoolean
extends InternalRep {
    private boolean value;

    private TclBoolean(Interp interp, String string) throws TclException {
        this.value = Util.getBoolean((Interp)interp, (String)string);
    }

    private TclBoolean(boolean bl) {
        this.value = bl;
    }

    protected InternalRep duplicate() {
        return new TclBoolean(this.value);
    }

    public static boolean get(Interp interp, TclObject tclObject) throws TclException {
        TclBoolean.setBooleanFromAny(interp, tclObject);
        TclBoolean tclBoolean = (TclBoolean)tclObject.getInternalRep();
        return tclBoolean.value;
    }

    public static TclObject newInstance(boolean bl) {
        return new TclObject(new TclBoolean(bl));
    }

    private static void setBooleanFromAny(Interp interp, TclObject tclObject) throws TclException {
        InternalRep internalRep = tclObject.getInternalRep();
        if (!(internalRep instanceof TclBoolean)) {
            if (internalRep instanceof TclInteger) {
                int n = TclInteger.get(interp, tclObject);
                tclObject.setInternalRep(new TclBoolean(n != 0));
            } else {
                tclObject.setInternalRep(new TclBoolean(interp, tclObject.toString()));
            }
        }
    }

    public String toString() {
        if (this.value) {
            return "1";
        }
        return "0";
    }
}

