/*
 * Declaration of the PGraphItem canvas item type.  It needs to be declared
 * in a separate file because the PhDatasetItem type refers to elements
 * of this structure
 */

#ifndef _PHGRAPH_INCLUDED
#define _PHGRAPH_INCLUDED 1

typedef struct PGraphItem  {
    Tk_Item header;		/* Generic stuff that's the same for all
				 * types.  MUST BE FIRST IN STRUCTURE. */
    Tk_Outline outline;		/* Outline structure */
    Tk_Outline axis_outline;	/* Outline structure */
    Tk_Canvas canvas;		/* Canvas containing item.  Needed for
				 * parsing arrow shapes. */
    double origin[2];		/* Origin of circle */
    double radius;		/* Radius of circle */
    Tk_Tile fillTile;		/* Tile for filling rectangle/oval. */
    Tk_Tile activeFillTile;	/* Tile for filling rectangle/oval if state is active. */
    Tk_Tile disabledFillTile;	/* Tile for filling rectangle/oval if state is disabled. */
    XColor *fillColor;		/* Color for filling circle. */
    XColor *axisColor;		/* Color for drawing the axis. */
    XColor *activeFillColor;	/* Color for filling rectangle/oval if state is active. */
    XColor *disabledFillColor;	/* Color for filling rectangle/oval if state is disabled. */
    Pixmap fillStipple;		/* Stipple bitmap for filling item. */
    Pixmap activeFillStipple;	/* Stipple bitmap for filling item if state is active. */
    Pixmap disabledFillStipple;	/* Stipple bitmap for filling item if state is disabled. */
    GC fillGC;			/* Graphics context for filling item. */
    int rings;			/* Number of donut shaped rings to use for
				 * drawing datasets */
    int sense;			/* Direction of increasing phase.  A positive
				 * (or zero) integer indicates a clockwise
				 * direction. */
    double rmax;		/* Max radial value at outer edge of graph.
    				 * Units are user-defined.  This is analogous
				 * to xmin/xmax for xy graphs. */
    double poledir;		/* Direction of 0 degrees */
    double *arrowPtr;		/* Pointer to array of coordinates describing
				 * the arrow at 0 degrees */
    int axislength;		/* radial size of the axis lines */
    int resize_id;		/* Id of the last graph resize.  Datasets
				 * should use this value to determine if they
				 * need to be rescaled. */
    char *configCmd;		/* Command to execute whenever the graph
				 * item is configured */
    int arrowon;		/* Draw the arrow at 0 degrees or no? */
    float arrowShapeA;          /* Distance from tip of arrowhead to center. */
    float arrowShapeB;          /* Distance from tip of arrowhead to trailing
				 * point, measured along shaft. */
    float arrowShapeC;          /* Distance of trailing points from outside
				 * edge of shaft. */
    GC arrowGC;			/* GC for drawing the arrowhead */
    GC drawableGC;		/* Graphics context for copying the drawable
				 * onto the canvas */
    Pixmap drawable;
    Pixmap clipMask;

    int	master;			/* Canvas id of the master for this item */
    int nchildren;		/* Number of children */
    int child_arr_size;		/* Size fo children array */
    Tk_Item **children;		/* Array of Tk_Item *'s specifying the 
				 * children of this item */
} PGraphItem;

#endif
