# macintosh.tcl --
# Macintosh platform specific settings
# Note that there is also some platform code in main.tcl to bootstap things

# Pick a large display size
option add *Text.height 		25 	startup
option add *Text.width 			80 	startup

# The name of the per-user preferences file
proc Platform_File {key} {
    switch $key {
	prefs {
	    return ":WebTk Preferences"
	}
	macros {
	    return ":WebTk Macros"
	}
	tcl {
	    return ":WebTk User Tcl Code"
	}
	def {
	    return ":WebTk User Preferences"
	}
	log {
	    return ":WebTk Log File"
	}
	tmp {
	    return ":Temp File"
	}
    }
}

# Wait for a dialog before doing a grab
proc Platform_WaitVisibility {win} {
    catch {tkwait visibility $win}
}

proc Platform_TempFile {url} {
    global WebTk
    regsub {(\?|#).*} $url {} url
    file mkdir [file join $WebTk(home) cache]
    return [file join $WebTk(home) cache [lindex [split $url /] end]]
}

proc Platform_Install {{src webtk:} {dest "Hard Disk:Tcl/Tk 4.1:webtk"}} {
    set save [pwd]
    cd $src
    foreach f [lsort [glob *.TCL *.tcl tclIndex]] { 
	puts $f ; update idletasks
	File_Copy $f $dest
    }
    foreach dir [list [file join $dest html] [file join $dest images]] {
	catch {mkdir $dir}
	cd $dir
	foreach f [lsort [glob *]] {
	    puts $f ; update idletasks
	    File_Copy $f $dir
	}
    }
    cd $save
}

