#
# Distributed as part of the Mach Operating System
#
# 
# Mach Operating System
# Copyright (c) 1992 Carnegie Mellon University
# All Rights Reserved.
# 
# Permission to use, copy, modify and distribute this software and its
# documentation is hereby granted, provided that both the copyright
# notice and this permission notice appear in all copies of the
# software, derivative works or modified versions, and any portions
# thereof, and that both notices appear in supporting documentation.
# 
# CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
# CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
# ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
# 
# Carnegie Mellon requests users of this software to return to
# 
#  Software Distribution Coordinator  or  Software.Distribution@CS.CMU.EDU
#  School of Computer Science
#  Carnegie Mellon University
#  Pittsburgh PA 15213-3890
# 
# any improvements or extensions that they make and grant Carnegie Mellon
# the rights to redistribute these changes.
# 
# 
# HISTORY
# $Log:	osf.mach3.mk,v $
# Revision 2.3  92/07/08  18:05:43  mrt
# 	Added conditional definition of DEF_MIGFLAGS to -MD
# 	[92/07/03            mrt]
# 
# Revision 2.2  92/05/20  20:15:59  mrt
# 	First checkin
# 	[92/05/20  14:48:16  mrt]
# 

#
#  Project rules for building Mach 3.0 sources
#

#
#  C compiler variations
#    This looks correct but we are not ready for this yet
#

#_GCC_EXEC_PREFIX_?=/afs/cs.cmu.edu/projet/mach3/latest/release/@sys/lib/gcc-

#ANSI_CC?=${_GCC_EXEC_PREFIX_}gcc -B${_GCC_EXEC_PREFIX_} 
ANSI_CC?=gcc
TRADITIONAL_CC?=${ANSI_CC} -traditional
WRITABLE_STRINGS_CC?=${ANSI_CC} -fwritable-strings

#ANSI_LD?=${_GCC_EXEC_PREFIX_}ld
ANSI_LD?=ld
TRADITIONAL_LD?=${ANSI_LD}
WRITABLE_STRINGS_LD?=${ANSI_LD}

#ANSI_AR?=${_GCC_EXEC_PREFIX_}ar
ANSI_AR?=ar
TRADITIONAL_AR?=${ANSI_AR}
WRITABLE_STRINGS_AR?=${ANSI_AR}

#ANSI_RANLIB?=${_GCC_EXEC_PREFIX_}ranlib
ANSI_RANLIB?=ranlib
TRADITIONAL_RANLIB?=${ANSI_RANLIB}
WRITABLE_STRINGS_RANLIB?=${ANSI_RANLIB}

#/lib/cpp doesn't grok -nostdinc
#_host_NOSTDINC_=
#_ansi_NOSTDINC_=-nostdinc
#_traditional_NOSTDINC_=-nostdinc
#_writable_strings_NOSTDINC_=-nostdinc
#_CC_NOSTDINC_=${_${_CCTYPE_}_NOSTDINC_}

_host_GENINC_=
_ansi_GENINC_=`${GENPATH} -I.` 
_traditional_GENINC_=`${GENPATH} -I.` 
_writable_strings_GENINC_=`${GENPATH} -I.` 
_CC_GENINC_?=${_${_CCTYPE_}_GENINC_}

DEF_CCFLAGS?=-MD
_CCDEFS_=-DBSD44 -DMACH -DCMU -D${target_machine}

DEF_MIGFLAGS?=-MD
MIG?=mig
.if defined(_GCC_EXEC_PREFIX)
USEMIGCPP=-cc ${_GCC_EXEC_PREFIX_}cpp
.endif

_MIGFLAGS_=\
	${USEMIGCPP}\
	${DEF_MIGFLAGS}\
	${${.TARGET}_MIGENV:U${MIGENV}}\
	${${.TARGET}_MIGFLAGS:U${MIGFLAGS}}\
	${${.TARGET}_MIGARGS:U${MIGARGS}}\
	${_CC_NOSTDINC_} ${_GENINC_} ${_CC_INCDIRS_}

.if defined(MIG_DEFS) || defined(MIG_USRS) || defined(MIG_SRVS)

_MIGH_DEF_ = ${${.TARGET}_MIGHDEF:U${.TARGET:.h=.defs}}
${MIG_HDRS}: $${_MIGH_DEF_}
	${MIG} ${_MIGFLAGS_} \
		-header ${.TARGET} -server /dev/null -user /dev/null \
		${${_MIGH_DEF_}:P} \

_MIGU_DEF_ = ${${.TARGET}_MIGUDEF:U${.TARGET:S/User.c/.defs/}}
${MIG_USRS}: $${_MIGU_DEF_}
	${MIG} ${_MIGFLAGS_} \
		-user ${.TARGET} -server /dev/null \
		${${_MIGU_DEF_}:P} 

_MIGS_DEF_ = ${${.TARGET}_MIGSDEF:U${.TARGET:S/Server.c/.defs/}}
${MIG_SRVS}: $${_MIGS_DEF_}
	${MIG} ${_MIGFLAGS_} \
		-header /dev/null -user /dev/null -server ${.TARGET} \
		${${_MIGS_DEF_}:P} 

.endif
