#pragma once

/* second argument of open / file status flags */
#define O_RDONLY   000000
#define O_WRONLY   000001
#define O_RDWR     000002
#define O_APPEND   000010
#define O_CREAT    001000
#define O_EXCL     004000
#define O_NOCTTY   000040
#define O_NONBLOCK 000020
#define O_TRUNC    002000

#ifndef _POSIX_SOURCE
#define O_NDELAY   000004
#define O_ASYNC    000100
#define O_SHLOCK   000200
#define O_EXLOCK   000400
#endif

#define O_ACCMODE   000003

/* BSD compatability: */
#ifndef _POSIX_SOURCE
#define FNDELAY O_NDELAY
#define FSHLOCK O_SHLOCK
#define FEXLOCK O_EXLOCK
#define FAPPEND O_APPEND
#define FASYNC  O_ASYNC
#define FCREAT  O_CREAT
#define FTRUNC  O_TRUNC
#define FEXCL   O_EXCL
#endif

/* These bits are not meaningful in open: */
#define _OPEN_BAD (O_ASYNC|O_SHLOCK|O_EXLOCK)

