/* Minimum values.  We support limits larger than these, but
   conforming Posix applications can't count on more than this. */
#define _POSIX_ARG_MAX    4096
#define _POSIX_CHILD_MAX     6
#define _POSIX_LINK_MAX      8
#define _POSIX_MAX_CANON   255
#define _POSIX_MAX_INPUT   255
#define _POSIX_NAME_MAX     14
#define _POSIX_NGROUPS_MAX   0
#define _POSIX_OPEN_MAX     16
#define _POSIX_PATH_MAX    255
#define _POSIX_PIPE_BUF    512

/* Run-time increasable values.  There are at least this many, but
   there might be more later.  */
#define NGROUPS_MAX 16

/* Run-time invariant values (possible indeterminate) */
/* ARG_MAX is indeterminate */
/* CHILD_MAX is indeterminate */
/* OPEN_MAX is indeterminate, but the value is accessible through 
   getdtablesize().  We don't put that here because of setdtablesize().  */

/* Pathname variable values */
/* These values are based on the ufs file server.  If a more restrictive
   Posix-compliance-claiming server is added to the system, these must be
   reduced accordingly */
#define LINK_MAX   32767
#define MAX_CANON  _POSIX_MAX_CANON
#define MAX_INPUT  _POSIX_MAX_INPUT
#define NAME_MAX   255
#define PATH_MAX   1023
#define PIPE_BUF   512		/* Is this right?   */

/* Compatability definitions */
#ifndef _POSIX_SOURCE
#define MAXSYMLINKS 32

#define MAXLINK   LINK_MAX
#define CANBSIZ   MAX_CANON
#define NGROUPS   NGROUPS_MAX

#ifdef ARG_MAX
#define NCARGS ARG_MAX
#endif

#ifdef CHILD_MAX
#define MAXUPRC CHILD_MAX
#endif

#ifdef OPEN_MAX
#define NOFILE OPEN_MAX
#endif

#define MAXPATHLEN (PATH_MAX + 1)
#define MAXNAMLEN  NAME_MAX

#define NBBY 8			/* I guess it's a limit... :-) */
#endif /* _POSIX_SOURCE */
