#ifndef	_fs_user_
#define	_fs_user_

/* Module fs */

#include <mach/kern_return.h>
#if	(defined(__STDC__) || defined(c_plusplus)) || defined(LINTLIBRARY)
#include <mach/port.h>
#include <mach/message.h>
#endif

#include <mach/std_types.h>
#include <mach/mach_types.h>
#include <device/device_types.h>
#include <device/net_status.h>
#include <gnu/types.h>
#include <hurd/hurd_types.h>
#include <lib/libhurd.h>

/* Routine file_exec */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t rpc_file_exec
#if	defined(LINTLIBRARY)
    (exec_file, exec_task, argv, argvCnt, envp, envpCnt, fds, fdsCnt, cwdir, authserver, ctty_fstype, ctty_fsid, ctty_fileid, deallocregion, deallocsize, flags, use_start_addr, start_addr)
	file_t exec_file;
	mach_port_t exec_task;
	data_t argv;
	mach_msg_type_number_t argvCnt;
	data_t envp;
	mach_msg_type_number_t envpCnt;
	fd_array_t fds;
	mach_msg_type_number_t fdsCnt;
	mach_port_t cwdir;
	mach_port_t authserver;
	int ctty_fstype;
	fsid_t ctty_fsid;
	int ctty_fileid;
	vm_address_t deallocregion;
	vm_size_t deallocsize;
	int flags;
	int *use_start_addr;
	vm_address_t *start_addr;
{ return rpc_file_exec(exec_file, exec_task, argv, argvCnt, envp, envpCnt, fds, fdsCnt, cwdir, authserver, ctty_fstype, ctty_fsid, ctty_fileid, deallocregion, deallocsize, flags, use_start_addr, start_addr); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t exec_file,
	mach_port_t exec_task,
	data_t argv,
	mach_msg_type_number_t argvCnt,
	data_t envp,
	mach_msg_type_number_t envpCnt,
	fd_array_t fds,
	mach_msg_type_number_t fdsCnt,
	mach_port_t cwdir,
	mach_port_t authserver,
	int ctty_fstype,
	fsid_t ctty_fsid,
	int ctty_fileid,
	vm_address_t deallocregion,
	vm_size_t deallocsize,
	int flags,
	int *use_start_addr,
	vm_address_t *start_addr
);
#else
    ();
#endif
#endif

/* Routine file_chown */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t rpc_file_chown
#if	defined(LINTLIBRARY)
    (chown_file, new_owner, new_group)
	file_t chown_file;
	uid_t new_owner;
	gid_t new_group;
{ return rpc_file_chown(chown_file, new_owner, new_group); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t chown_file,
	uid_t new_owner,
	gid_t new_group
);
#else
    ();
#endif
#endif

/* Routine file_chauthor */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t rpc_file_chauthor
#if	defined(LINTLIBRARY)
    (chauth_file, new_author)
	file_t chauth_file;
	uid_t new_author;
{ return rpc_file_chauthor(chauth_file, new_author); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t chauth_file,
	uid_t new_author
);
#else
    ();
#endif
#endif

/* Routine file_chmod */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t rpc_file_chmod
#if	defined(LINTLIBRARY)
    (chmod_file, new_mode)
	file_t chmod_file;
	mode_t new_mode;
{ return rpc_file_chmod(chmod_file, new_mode); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t chmod_file,
	mode_t new_mode
);
#else
    ();
#endif
#endif

/* Routine file_chflags */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t rpc_file_chflags
#if	defined(LINTLIBRARY)
    (chflags_file, new_flags)
	file_t chflags_file;
	int new_flags;
{ return rpc_file_chflags(chflags_file, new_flags); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t chflags_file,
	int new_flags
);
#else
    ();
#endif
#endif

/* Routine file_utimes */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t rpc_file_utimes
#if	defined(LINTLIBRARY)
    (utimes_file, new_atime, new_mtime)
	file_t utimes_file;
	time_value_t new_atime;
	time_value_t new_mtime;
{ return rpc_file_utimes(utimes_file, new_atime, new_mtime); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t utimes_file,
	time_value_t new_atime,
	time_value_t new_mtime
);
#else
    ();
#endif
#endif

/* Routine file_seek */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t rpc_file_seek
#if	defined(LINTLIBRARY)
    (seek_file, offset, whence, newp)
	file_t seek_file;
	int offset;
	int whence;
	int *newp;
{ return rpc_file_seek(seek_file, offset, whence, newp); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t seek_file,
	int offset,
	int whence,
	int *newp
);
#else
    ();
#endif
#endif

/* Routine file_truncate */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t rpc_file_truncate
#if	defined(LINTLIBRARY)
    (trunc_file, new_size)
	file_t trunc_file;
	int new_size;
{ return rpc_file_truncate(trunc_file, new_size); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t trunc_file,
	int new_size
);
#else
    ();
#endif
#endif

/* Routine file_lock */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t rpc_file_lock
#if	defined(LINTLIBRARY)
    (lock_file, flags)
	file_t lock_file;
	int flags;
{ return rpc_file_lock(lock_file, flags); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t lock_file,
	int flags
);
#else
    ();
#endif
#endif

/* Routine file_getcontrol */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t rpc_file_getcontrol
#if	defined(LINTLIBRARY)
    (file, control)
	file_t file;
	mach_port_t *control;
{ return rpc_file_getcontrol(file, control); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t file,
	mach_port_t *control
);
#else
    ();
#endif
#endif

/* Routine file_statfs */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t rpc_file_statfs
#if	defined(LINTLIBRARY)
    (file, info)
	file_t file;
	fsys_statfsbuf_t *info;
{ return rpc_file_statfs(file, info); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t file,
	fsys_statfsbuf_t *info
);
#else
    ();
#endif
#endif

/* Routine file_sync */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t rpc_file_sync
#if	defined(LINTLIBRARY)
    (file, wait)
	file_t file;
	int wait;
{ return rpc_file_sync(file, wait); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t file,
	int wait
);
#else
    ();
#endif
#endif

/* Routine file_syncfs */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t rpc_file_syncfs
#if	defined(LINTLIBRARY)
    (file, wait, do_children)
	file_t file;
	int wait;
	int do_children;
{ return rpc_file_syncfs(file, wait, do_children); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t file,
	int wait,
	int do_children
);
#else
    ();
#endif
#endif

/* Routine file_pathconf */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t rpc_file_pathconf
#if	defined(LINTLIBRARY)
    (file, pathconf)
	file_t file;
	pathconf_t *pathconf;
{ return rpc_file_pathconf(file, pathconf); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t file,
	pathconf_t *pathconf
);
#else
    ();
#endif
#endif

/* Routine file_getlinknode */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t rpc_file_getlinknode
#if	defined(LINTLIBRARY)
    (file, linknode)
	file_t file;
	file_t *linknode;
{ return rpc_file_getlinknode(file, linknode); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t file,
	file_t *linknode
);
#else
    ();
#endif
#endif

/* Routine dir_pathtrans */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t rpc_dir_pathtrans
#if	defined(LINTLIBRARY)
    (start_dir, pathname, flags, mode, do_retry, retry_name, result)
	file_t start_dir;
	string_t pathname;
	int flags;
	mode_t mode;
	retry_type *do_retry;
	string_t retry_name;
	file_t *result;
{ return rpc_dir_pathtrans(start_dir, pathname, flags, mode, do_retry, retry_name, result); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t start_dir,
	string_t pathname,
	int flags,
	mode_t mode,
	retry_type *do_retry,
	string_t retry_name,
	file_t *result
);
#else
    ();
#endif
#endif

/* Routine dir_mkdir */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t rpc_dir_mkdir
#if	defined(LINTLIBRARY)
    (directory, name, mode)
	file_t directory;
	string_t name;
	mode_t mode;
{ return rpc_dir_mkdir(directory, name, mode); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t directory,
	string_t name,
	mode_t mode
);
#else
    ();
#endif
#endif

/* Routine dir_rmdir */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t rpc_dir_rmdir
#if	defined(LINTLIBRARY)
    (directory, name)
	file_t directory;
	string_t name;
{ return rpc_dir_rmdir(directory, name); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t directory,
	string_t name
);
#else
    ();
#endif
#endif

/* Routine dir_unlink */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t rpc_dir_unlink
#if	defined(LINTLIBRARY)
    (directory, name)
	file_t directory;
	string_t name;
{ return rpc_dir_unlink(directory, name); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t directory,
	string_t name
);
#else
    ();
#endif
#endif

/* Routine dir_link */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t rpc_dir_link
#if	defined(LINTLIBRARY)
    (oldfile, newdirectory, newname)
	file_t oldfile;
	file_t newdirectory;
	string_t newname;
{ return rpc_dir_link(oldfile, newdirectory, newname); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t oldfile,
	file_t newdirectory,
	string_t newname
);
#else
    ();
#endif
#endif

/* Routine dir_rename */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t rpc_dir_rename
#if	defined(LINTLIBRARY)
    (olddirectory, oldname, newdirectory, newname)
	file_t olddirectory;
	string_t oldname;
	file_t newdirectory;
	string_t newname;
{ return rpc_dir_rename(olddirectory, oldname, newdirectory, newname); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t olddirectory,
	string_t oldname,
	file_t newdirectory,
	string_t newname
);
#else
    ();
#endif
#endif

/* Routine dir_set_translator */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t rpc_dir_set_translator
#if	defined(LINTLIBRARY)
    (directory, name, flags, oldtrans_flags, trans_name, existing)
	file_t directory;
	string_t name;
	int flags;
	int oldtrans_flags;
	string_t trans_name;
	mach_port_t existing;
{ return rpc_dir_set_translator(directory, name, flags, oldtrans_flags, trans_name, existing); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t directory,
	string_t name,
	int flags,
	int oldtrans_flags,
	string_t trans_name,
	mach_port_t existing
);
#else
    ();
#endif
#endif

/* Routine dir_get_translator */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t rpc_dir_get_translator
#if	defined(LINTLIBRARY)
    (directory, name, trans_control)
	file_t directory;
	string_t name;
	mach_port_t *trans_control;
{ return rpc_dir_get_translator(directory, name, trans_control); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t directory,
	string_t name,
	mach_port_t *trans_control
);
#else
    ();
#endif
#endif

/* Routine dir_get_transname */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t rpc_dir_get_transname
#if	defined(LINTLIBRARY)
    (directory, name, trans_name)
	file_t directory;
	string_t name;
	string_t trans_name;
{ return rpc_dir_get_transname(directory, name, trans_name); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t directory,
	string_t name,
	string_t trans_name
);
#else
    ();
#endif
#endif

/* Routine dir_stat_translator */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t rpc_dir_stat_translator
#if	defined(LINTLIBRARY)
    (directory, name, info)
	file_t directory;
	string_t name;
	fsys_statfsbuf_t *info;
{ return rpc_dir_stat_translator(directory, name, info); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	file_t directory,
	string_t name,
	fsys_statfsbuf_t *info
);
#else
    ();
#endif
#endif

#endif	_fs_user_
