#ifndef	_misc_user_
#define	_misc_user_

/* Module misc */

#include <mach/kern_return.h>
#if	(defined(__STDC__) || defined(c_plusplus)) || defined(LINTLIBRARY)
#include <mach/port.h>
#include <mach/message.h>
#endif

#include <mach/std_types.h>
#include <mach/mach_types.h>
#include <device/device_types.h>
#include <device/net_status.h>
#include <gnu/types.h>
#include <hurd/hurd_types.h>
#include <lib/libhurd.h>

/* Routine sig_post */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t sig_post
#if	defined(LINTLIBRARY)
    (process, signal, orphaned, cttykill, willstop)
	sigthread_t process;
	int signal;
	int orphaned;
	int cttykill;
	int *willstop;
{ return sig_post(process, signal, orphaned, cttykill, willstop); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	sigthread_t process,
	int signal,
	int orphaned,
	int cttykill,
	int *willstop
);
#else
    ();
#endif
#endif

/* Routine io_select_done */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t io_select_done
#if	defined(LINTLIBRARY)
    (notify_port, select_result, id_tag)
	mach_port_t notify_port;
	int select_result;
	int id_tag;
{ return io_select_done(notify_port, select_result, id_tag); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	mach_port_t notify_port,
	int select_result,
	int id_tag
);
#else
    ();
#endif
#endif

/* Routine proc_newids */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t proc_newids
#if	defined(LINTLIBRARY)
    (process, ppid, pgrp, orphaned)
	sigthread_t process;
	pid_t ppid;
	pid_t pgrp;
	int orphaned;
{ return proc_newids(process, ppid, pgrp, orphaned); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	sigthread_t process,
	pid_t ppid,
	pid_t pgrp,
	int orphaned
);
#else
    ();
#endif
#endif

/* Routine alix_ptrace */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t alix_ptrace
#if	defined(LINTLIBRARY)
    (process, request, addr, data, ret)
	sigthread_t process;
	int request;
	int addr;
	int data;
	int *ret;
{ return alix_ptrace(process, request, addr, data, ret); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	sigthread_t process,
	int request,
	int addr,
	int data,
	int *ret
);
#else
    ();
#endif
#endif

/* Routine startup_dosync */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t startup_dosync
#if	defined(LINTLIBRARY)
    (process)
	sigthread_t process;
{ return startup_dosync(process); }
#else
#if	(defined(__STDC__) || defined(c_plusplus))
(
	sigthread_t process
);
#else
    ();
#endif
#endif

#endif	_misc_user_
