#ifndef _GDB_CTHREADS_H_
#define _GDB_CTHREADS_H_
/* Mach 3.0 cthreads defs for gdb.

   Copyright (C) 1992 Free Software Foundation, Inc.

This file is part of GDB.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include <mach.h>
#include <cthreads.h>
#include <cthread_internals.h>

/*
 * Mis-use the struct cproc busy field in the copy of
 * the cproc in gdb's address space.
 *
 * This *can* be done otherwise, but I'm too lazy.
 */
#define CPROC_REVERSE_MAP(x) ((x)->busy)

/* For cproc and kernel thread mapping */
typedef struct gdb_thread {
  mach_port_t	name;
  CORE_ADDR	sp;
  CORE_ADDR	pc;
  CORE_ADDR	fp;
  cproc_t	cproc;
  boolean_t     in_emulator;
} *gdb_thread_t;

#endif /*_GDB_CTHREADS_H_ */
