#
 ! 4 byte floating point => 8 byte floating point conversion routine

 !-----------------------------------------------------------------------------
 ! ported to 68000 by Kai-Uwe Bloem, 12/89
 !  #1  original author: Peter S. Housel 06/03/89
 !  #2	added support for denormalized numbers			-kub-, 01/90
 !  #3  Redid register usage, and then added wrapper routine
 !	to provide C68 IEEE compatibility	Dave & Keith Walker	02/92
 !-----------------------------------------------------------------------------

	.sect .text

#ifndef NOACK
	.define	.cff8
#endif /* NOACK */
#ifndef NOC68
	.define	.sftodf
#endif /* NOC68 */

BIAS4	=	0x7F - 1
BIAS8	=	0x3FF - 1

!----------------------------------------
!	C68 wrapper routine
!	(float -> double)
!
!	sp	Return address
!	sp+4	address of result
!	sp+8	address of value
!----------------------------------------
#ifndef NOC68
.sftodf:
	move.l	4(sp),a1	! result address
	move.l	8(sp),a0	! value address
	move.l	(a0),(a1)	! move across value
	move.l  #0,4(a1)
	jsr	shared		! call common code

!	C8 exit routine - tidy up stack

	move.l	(sp)+,a0	! get return address
	lea	8(sp),sp	! remove parameters from stack
	jmp	(a0)		! ... and return
#endif /* NOC68 */

!-----------------------------------------------
!	Entry point for ACK
!
!		sp	Return address
!		sp+4	argument
!		sp+8	results area
!			(overwrites part of arguement)
!-----------------------------------------------
#ifndef NOACK
.cff8:
	lea	4(sp),a1	! result address
#endif /* NOACK */

!-----------------------------------------------
!	The code from here is common to the
!	ACK and C68 compilers.
!
!	Register useage when this point reached
!
!	A1	Address for result
!-----------------------------------------------
shared:
	move.w	(a1),d0		! extract exponent
	move.w	d0,d2		! extract sign
	lsr.w	#7,d0
	and.w	#0xff,d0	! kill sign bit (exponent is 8 bits)

	move.w	d2,d1
	and.w	#0x7f,d1	! remove exponent from mantissa
	tst.w	d0		! check for zero exponent - no leading "1"
	beq	0f		! for denormalized numbers
	or.w	#0x80,d1	! restore implied leading "1"
	bra	1f
0:	add.w	#1,d0		! "normalize" exponent
1:	move.w	d1,(a1)

	add.w	#BIAS8-BIAS4-3,d0	! adjust bias, account for shift
	clr.w	d1		! dummy rounding info
	jmp	.norm8

