| scg386.x
|	SoftWare Character Generator for VGA display card
|							Auther:takamiti@mix
#include <minix/config.h>
#include "protect.h"
#include "vga.h"

#define CH_High	 8
#define TOP_OFS	12

|*============================================================================*
|*				text
|*============================================================================*
		.text

.define	_draw_ank
.define	_draw_dbc
.define	_scr_up
.define	_scr_down
.define	_clr_scr
.define	_clr_line
.define	_cur_off
.define	_cur_on
.define _mov_left
.define _mov_right
.define _pixel_addr
#if (LANGUAGE == JAPANESE)
.define _ms2jis
#endif

|	eax = Y-axis	->	ebx = &scr_buf[x][y]
|	edi = X-axis		edi = pixel address
pixeladdr:	add	ax,vid_Ytop
		cmp	ax,#SCR_LINES
		jc	pxaddr
		sub	ax,#SCR_LINES
pxaddr:		push	ax
		movb	cl,#LINE_WIDTH
		mulb	cl
		add	ax,di
		movzx	ebx,ax
		add	ebx,#_scr_buf		| scr_buf[x][y]
		pop	ax
		mov	cx,#CHAR_PER_LINE
		mul	cx
		add	ax,di
		movzx	edi,ax			| pixel address
		ret

|	pixel_addr(x, y)
_pixel_addr:	push	ebp
		mov	ebp,esp
		push	edi
		mov	edi,8(ebp)
		mov	eax,12(ebp)
		call	pixeladdr
		mov	vid_ptr,edi
		mov	img_ptr,ebx
		mov	eax,edi
		pop	edi
		pop	ebp
		ret

#if (LANGUAGE == JAPANESE)
_ms2jis:	push	ebp
		mov	ebp,esp
		mov	eax,8(ebp)
		shlb	ah,#1
		cmpb	al,#0x80
		adc	ax,#0x1F61
		addb	al,#0x7F
		jc	ms2j
		addb	al,#0x0A2
ms2j:		andb	ah,#0x07F
		pop	ebp
		ret
#endif

|	draw_ank(attr, char)
_draw_ank:	push	ebp
		mov	ebp,esp
		push	es
		push	edi
		push	esi

		mov	edi,vid_ptr
		cmp	edi,#LAST_COLUMN
		jl	d_ank00
		jmp	draw_exit
		|ja	draw_exit
d_ank00:	mov	esi,#_ankfont
		mov	eax,12(ebp)	| char code
		and	eax,#0xff
		shl	eax,#4
		add	esi,eax
		mov	ax,_VIDEO_SEG
		mov	es,ax

		mov	dx,#GRH_CTRL_REG
		mov	ax,#0x0F01
		outw
		mov	ax,#0x0003
		outw
		mov	ecx,#CHAR_HIGH
		test	_disp_stat,#NO_BACK_GR_BIT
		jnz	d_ank1

		mov	eax,8(ebp)		| attr
		xorb	al,al
		outw
		push	ecx
		mov	ax,#0xff08
d_ank0:		outw
		seg	es
		orb	(edi),al
		add	edi,#BYTE_PER_LINE
		loop	d_ank0
		pop	ecx

d_ank1:		mov	edi,vid_ptr
		movb	ah,8(ebp)
		xorb	al,al
		outw
		movb	al,#0x08
d_ank2:		movb	ah,(esi)
		outw
		seg	es
		orb	(edi),al
		inc	esi
		add	edi,#BYTE_PER_LINE
		loop	d_ank2

		test	_disp_stat,#UNDER_LINE_BIT
		jz	d_ank3
		sub	edi,#BYTE_PER_LINE
		movb	ah,#0xff
		outw
		seg	es
		orb	(edi),al
d_ank3:
		mov	ebx,img_ptr
		movb	al,8(ebp)
		movb	(ebx),al
		mov	eax,#1

def_mode:	add	ebx,eax
		cmp	ebx,#_scr_buf + SCRBUF_SIZE
		jae	overrun
		mov	img_ptr,ebx
		add	vid_ptr,eax
overrun:
		xor	ax,ax
		outw
		inc	ax
		outw
		movb	al,#0x03
		outw
		mov	ax,#0xff08
		outw
draw_exit:
		pop	esi
		pop	edi
		pop	es
		pop	ebp
		ret


|	draw_dbc(attr, &sysfont_tbl[?], fontindex)
_draw_dbc:	push	ebp
		mov	ebp,esp
		push	es
		push	edi
		push	esi

		mov	edi,vid_ptr
		cmp	edi,#LAST_COLUMN - 1
		ja	draw_exit
		mov	ax,_VIDEO_SEG
		mov	es,ax

		mov	dx,#GRH_CTRL_REG
		mov	ax,#0x0f01
		outw
		mov	ax,#0x0003
		outw
		mov	ecx,#CHAR_HIGH
		test	_disp_stat,#NO_BACK_GR_BIT
		jnz	d_dbc1
		mov	eax,8(ebp)		| attr
		xorb	al,al
		outw
		mov	ax,#0xff08
d_dbc0:		outw
		seg	es
		orb	(edi),al
		inc	edi
|		outw
		seg	es
		orb	(edi),al
		add	edi,#BYTE_PER_LINE - 1
		loop	d_dbc0

d_dbc1:		mov	ebx,12(ebp)
		movzx	edi,word TOP_OFS(ebx)
		add	edi,vid_ptr
		movzx	ecx,word CH_High(ebx)
		push	ds
		mov	ax,#FLAT_DS_SELECTOR
		mov	ds,ax
		mov	esi,16(ebp)
		movb	ah,8(ebp)
		xorb	al,al
		outw
		movb	al,#0x08
d_dbc2:		movb	ah,(esi)
		outw
		seg	es
		orb	(edi),al
		inc	esi
		movb	ah,(esi)
		outw
		inc	edi
		seg	es
		orb	(edi),al
		add	edi,#BYTE_PER_LINE - 1
		inc	esi
		loop	d_dbc2
		pop	ds

		test	_disp_stat,#UNDER_LINE_BIT
		jz	d_dbc3
		sub	edi,#BYTE_PER_LINE
		movb	ah,#0xff
		outw
		seg	es
		orb	(edi),al
|		outw
		inc	edi
		seg	es
		orb	(edi),al
d_dbc3:
		mov	ebx,img_ptr
		mov	eax,8(ebp)
		movb	ah,al
		orb	al,#0x80
		mov	(ebx),ax
		mov	eax,#2
		jmp	def_mode


|		scr_down()
_scr_down:	cmp	_softscroll,#0
		jz	hw_scrdwn
		jmp	mov_down

hw_scrdwn:	mov	ax,vid_Ytop
		dec	ax
		jns	do_scroll
		mov	ax,#SCR_LINES - 1
		j	do_scroll

|		scr_up()
_scr_up:	cmp	_softscroll,#0
		jz	hw_scrup
		jmp	mov_up

hw_scrup:	mov	ax,vid_Ytop
		inc	ax
		cmp	ax,#SCR_LINES
		jc	do_scroll
		xor	ax,ax

do_scroll:	mov	vid_Ytop,ax
		mov	cx,#CHAR_PER_LINE
		mul	cx
		mov	bx,ax

		mov	dx,#CRT_CTRL_REG
		movb	al,#0x0C
		outw

		movb	ah,bl
		movb	al,#0x0D
		outw

		mov	dx,#CRT_STAT_REG
L_00A:		in
		testb	al,#0x08
		jz	L_00A

		mov	ax,#SCR_LINES
		sub	ax,vid_Ytop
		shl	ax,#4			| movb	cl,#CHAR_HIGH;mulb cl
		dec	ax

		movb	bh,ah
		movb	bl,bh
		and	bx,#0x0201
		shl	bx,#4
		shlb	bh,#1

		mov	dx,#CRT_CTRL_REG
		movb	ah,al
		movb	al,#0x18
		outw

		movb	al,#7
		out
		inc	dx
		in
		dec	dx

		movb	ah,al
		andb	ah,#0xEF
		orb	ah,bl

		movb	al,#7
		outw
		movb	al,#9
		out
		inc	dx
		in
		dec	dx

		movb	ah,al
		andb	ah,#0xBF
		orb	ah,bh
		movb	al,#9
		outw
		ret


|		clr_scr()
_clr_scr:	push	es
		push	edi

		mov	dx,#GRH_CTRL_REG
		mov	ax,#0x0005
		outw
		xor	ax,ax
		outw
		mov	ax,#0x0F01
		outw

		mov	ax,_VIDEO_SEG
		mov	es,ax
		xor	edi,edi
		mov	ecx,#PLANE_SIZE
		xor	ax,ax
		cld
		rep
		stosb
		mov	ax,ds
		mov	es,ax
		mov	edi,#_scr_buf
		mov	ecx,#SCRBUF_SIZE
		movb	al,#BLANK_FG_COLOR
		rep
		stosb
		pop	edi
		pop	es
		xor	ax,ax
		jmp	do_scroll


|		clr_line(x, y, length)
_clr_line:	push	ebp
		mov	ebp,esp
		push	es
		push	edi
		mov	edi,8(ebp)	| x
		mov	eax,12(ebp)	| y
		call	pixeladdr

		mov	dx,#GRH_CTRL_REG
		mov	ax,#0x0005
		outw
		xor	ax,ax
		outw
		mov	ax,#0x0F01
		outw

		mov	ax,_VIDEO_SEG
		mov	es,ax
		mov	ecx,#CHAR_HIGH
		xor	ax,ax
		cld
clr_l0:		push	ecx
		push	edi
		mov	ecx,16(ebp)	| length
		rep
		stosb
		pop	edi
		add	edi,#BYTE_PER_LINE
		pop	ecx
		loop	clr_l0
|		mov	ax,#0x0001
|		outw

		mov	edi,ebx
		push	ds
		pop	es
		mov	ecx,16(ebp)
		movb	al,#BLANK_FG_COLOR
		rep
		stosb

		pop	edi
		pop	es
		pop	ebp
		ret


|		cur_off()
_cur_off:	push	ebp
		push	es
		push	edi
		mov	edi,cur_addr
		movb	bl,cur_attr
		jmp	cur_comm

|		cur_on(x, y)|
_cur_on:	push	ebp
		mov	ebp,esp
		push	es
		push	edi
		mov	edi,8(ebp)		| X
		mov	eax,12(ebp)		| Y
		call	pixeladdr
		mov	cur_addr,edi		| save cursor address
		movb	bl,(ebx)		| screen image
		movb	cur_attr,bl

cur_comm:	mov	ax,_VIDEO_SEG
		mov	es,ax
		mov	dx,#GRH_CTRL_REG
		mov	ax,#0x0A05
		outw
		mov	ax,#0x1803
		outw
		mov	ax,#0x0007
		outw
		mov	ax,#0xff08
		movb	bh,bl
		andb	bh,#0x7f
		mov	ecx,#CHAR_HIGH
		push	edi
putcur01:	outw
		seg	es
		orb	(edi),bh
		add	edi,#BYTE_PER_LINE
		loop	putcur01
		pop	edi
		testb	bl,#0x80
		jz	putcur03
		mov	ecx,#CHAR_HIGH
		inc	edi
putcur02:	outw
		seg	es
		orb	(edi),bh
		add	edi,#BYTE_PER_LINE
		loop	putcur02
putcur03:	mov	ax,#0xff08
		outw
		mov	ax,#0x0005
		outw
		mov	ax,#0x0003
		outw
		mov	ax,#0x0f07
		outw
		pop	edi
		pop	es
		pop	ebp
		ret

|		mov_right(src_x, src_y, dect_x, dest_y, length)
_mov_right:	std
		j	mv_blok

|		mov_left(src_x, src_y, dect_x, dest_y, length)
_mov_left:	cld
mv_blok:	push	ebp
		mov	ebp,esp
		push	esi
		push	edi
		push	es
		push	ds
		mov	edi,8(ebp)	| src-X
		mov	eax,12(ebp)	| src-Y
		call	pixeladdr
		mov	esi,edi
		push	ebx
		mov	edi,16(ebp)	| dest-X
		mov	eax,20(ebp)	| dest-Y
		call	pixeladdr
		push	ebx

		mov	ax,_VIDEO_SEG
		mov	ds,ax
		mov	es,ax
		mov	dx,#GRH_CTRL_REG
		mov	ax,#0x0105
		outw

		movb	al,#CHAR_HIGH - 1
mv_loop:	mov	ecx,24(ebp)
		push	esi
		push	edi
		rep
		movsb
		pop	edi
		pop	esi
		add	edi,#BYTE_PER_LINE
		add	esi,#BYTE_PER_LINE
		decb	al
		jns	mv_loop

		pop	edi
		pop	esi
		pop	ds
		mov	ax,ds
		mov	es,ax
		mov	ecx,24(ebp)
		rep
		movsb
		pop	es
		pop	edi
		pop	esi
		pop	ebp
		ret


|		mov_down()
mov_down:	push	esi
		push	edi
		push	es
		push	ds

		std
		mov	edi,#PLANE_SIZE - 1
		mov	esi,#PLANE_SIZE - CHAR_PER_LINE - 1
		mov	ecx,esi

		mov	eax,#_scr_buf + SCRBUF_SIZE - 1
		push	eax
		mov	eax,#_scr_buf + SCRBUF_SIZE - LINE_WIDTH - 1
		push	eax
		push	eax
		j	mv_scr

|		mov_up()
mov_up:		push	esi
		push	edi
		push	es
		push	ds

		cld
		xor	edi,edi
		mov	esi,#CHAR_PER_LINE
		mov	ecx,#PLANE_SIZE - CHAR_PER_LINE
		mov	eax,#_scr_buf
		push	eax
		add	eax,#LINE_WIDTH
		push	eax
		mov	eax,#SCRBUF_SIZE - LINE_WIDTH
		push	eax
mv_scr:
		mov	ax,_VIDEO_SEG
		mov	ds,ax
		mov	es,ax
		mov	dx,#GRH_CTRL_REG
		mov	ax,#0x0105
		outw
		rep
		movsb
		pop	ecx
		pop	esi
		pop	edi

		pop	ds
		mov	ax,ds
		mov	es,ax
		rep
		movsb

		pop	es
		pop	edi
		pop	esi
		ret

#ifdef GRAPHICS
.define	_gr_dot

|		void gr_dot(int x, int y, int attr)
_gr_dot:	push	ebp
		mov	ebp,esp
		mov	eax,vid_Ytop
		shl	ax,#4			| vid_Ytop * CHAR_HIGH
		mov	cx,#MAX_SCAN_LINE
		sub	ecx,12(ebp)		| Y
		add	ax,cx
		cmp	ax,#MAX_SCAN_LINE
		jle	dot_1
		sub	ax,#MAX_SCAN_LINE
dot_1:
		mov	dx,#BYTE_PER_LINE
		mul	dx
		mov	ebx,8(ebp)		| X
		mov	cx,bx
		shr	bx,#3
		add	bx,ax
		cmp	bx,#GR_BUFF_LEN
		jnc	dot_exit

		andb	cl,#0x07
		xorb	cl,#0x07
		movb	ch,#0x01
		shlb	ch,cl
		push	es
		mov	ax,_VIDEO_SEG
		mov	es,ax
		mov	dx,#GRH_CTRL_REG
		mov	ax,#0x0205
		outw
		movb	ah,ch
		movb	al,#0x08
		outw
		seg	es
		movb	al,(bx)
		mov	eax,16(ebp)		| color
		seg	es
		movb	(bx),al
		mov	ax,#0x0003
		outw
		mov	ax,#0xff08
		outw
		pop	es
dot_exit:	pop	ebp
		ret
#endif


|*============================================================================*
|*				data
|*============================================================================*
		.data

.define		_VIDEO_SEG
.define		_sys_font
.define		_scr_buf
.extern		_ankfont
.extern		_fontbuf
.extern		_disp_stat
.extern		_softscroll

| local value
cur_addr:	.long	0
cur_attr:	.long	0
vid_Ytop:	.long	0
vid_ptr:	.long	0
img_ptr:	.long	0

_VIDEO_SEG:	.long	0xA000
_scr_buf:	.zerow	SCRBUF_SIZE / 2
_sys_font:
rom_ank:				| sys_font[0]
		.long	0		| long ft_base
		.word	0		| short ft_limit
		.word	0		| short fn_size
		.word	0		| short fn_high
		.word	0		| short fn_width
		.word	0		| short top_margin
		.word	0		| short flag

usr_ank:	.zerow	8		| sys_font[1]
dbcs_1font:	.zerow	8		| sys_font[2]
dbcs_2font:	.zerow	8		| sys_font[3]

| end fo SCG386.X
