#include <sys/types.h>
#include <limits.h>
#include <string.h>

#include <minix/config.h>
#include <minix/com.h>
#include <minix/const.h>
#include <minix/type.h>
#include <minix/boot.h>
#include <minix/font.h>
#include "fsparam.h"

#define EM_BASE		0x100000L	/* base of extended memory on AT */
#ifdef INTEL_32BITS
#define	USER_MEMORY	2048
#else
#define USER_MEMORY	0		/* minimam user memory in K bytes */
#endif
#define	SystemDir	"system"
#define ERROR		-1
#define OK		0
#define CHAR_MASK	0x7f

char usr_font[3][15] = {
	"sysfont.ANK\0\0\0",	/* user ANK font */
	"sysfont.STD\0\0\0",	/* user DBCS font #1 */
	"sysfont.OPT\0\0\0" };	/* user DBCS font #2 (option) */

struct font_table sys_font[NR_FONT_TBL] = {
	{ 0L, 4, 16, 16,  8, 0, USABLE_FONT  },	/* ROM font table */
	{ 0L, 0,  0,  0,  0, 0, FONT_DISABLE },	/* system ank font */
	{ 0L, 0,  0,  0,  0, 0, FONT_DISABLE },	/* system dbc font */
	{ 0L, 0,  0,  0,  0, 0, FONT_DISABLE } }; /* optional font */

struct font_header font_h;

extern void printk();
extern int sort();
extern int HD_read();
extern int emxfer();
extern long rom_font_base();
extern void hdparam();

extern char *diskbuf;
extern int errors;
extern u16_t extm_siz;

char inode_buf[BLOCK_SIZE], zone_buf[BLOCK_SIZE];

u16_t start_inode;
u16_t base_node = 0xffff;
int font_bloks, drive, emcount, fnt_drv;
int font_on_mem = -1;
long low_sect, font_mem;
u32_t v1_zone(), v2_zone();

struct fs_param {
	int inod_size;
	int inod_per_block;
	int filemode;
	int filesize;
	int zone0ofs;
	int zone_incr;
	int nr_zones;
	u32_t (*zone_num)();
  } fs_param[2] = {
	{	/* V1-FS parameters */
		V1_INODESIZE,
		BLOCK_SIZE / V1_INODESIZE,
		V1_FMODE,
		V1_FSIZE,
		V1_ZONE0,
		2,
		BLOCK_SIZE / 2,
		v1_zone		},

	{	/* V2-FS parameters */
		V2_INODESIZE,
		BLOCK_SIZE / V2_INODESIZE,
		V2_FMODE,
		V2_FSIZE,
		V2_ZONE0,
		4,
		BLOCK_SIZE / 4,
		v2_zone		}
  };
struct fs_param *fs;

#define INODE_PER_BLOCK	fs->inod_per_block
#define INODE_SIZE	fs->inod_size
#define ZONE_OFS	fs->zone0ofs
#define ZONE_INC	fs->zone_incr
#define FMODE_OFS	fs->filemode
#define FSIZE_OFS	fs->filesize
#define NR_ZONES	fs->nr_zones
#define to_zone_num(x)	(*(fs->zone_num))(x)
#define NR_DIRS		(BLOCK_SIZE / sizeof(struct dir_struct) )
#define between(c,l,u)	((unsigned short)((c) - (l)) <= ((u) - (l)))

u32_t v1_zone(p)	char *p;	{ return( (u32_t)(*(u16_t *)p) ); }
u32_t v2_zone(p)	char *p;	{ return( *(u32_t *)p ); }

u16_t read_inode(node)
u16_t node;
{
    u16_t i;

    --node;
    i = (u16_t)(node / INODE_PER_BLOCK);
    if (base_node != i) {
	base_node = i;
	i += start_inode;
	if (HD_read(drive, inode_buf, low_sect + (u32_t)(i << 1)) != 0) {
		base_node = 0xffff;
		return(ERROR);
	}
    }
    return((node % INODE_PER_BLOCK) * INODE_SIZE);
}

u16_t file_search(zone, fname, f_mode)
char *fname;
u16_t f_mode;
u32_t zone;
{
    struct dir_struct *q;
    char *p;
    int i, j;

    if (HD_read(drive, zone_buf, low_sect + (zone << 1)) != 0)
	return(0);
    q = (struct dir_struct *)zone_buf;
    for(i = 0; i <  NR_DIRS; i++, q++) {
	if (q->d_inum != 0) {
	    if (strncmp(fname, q->d_name, 14) == 0) {
		j = read_inode(q->d_inum);
		if (j == ERROR) return(0);
		p = inode_buf + j;
		return((*(u16_t *)p & f_mode) == f_mode ? q->d_inum: 0);
	    }
	}
    }
    return(0);
}

u16_t search(file, f_mode, inode)
char *file;
u16_t inode, f_mode;
{
    char *p;
    int i, res;

    i = read_inode(inode);
    if (i == ERROR) return(0);
    p = inode_buf + i;
    for (i = 0, p += ZONE_OFS; i < 6; i++, p += ZONE_INC) {
	res = file_search(to_zone_num(p), file, f_mode);
	if (res != 0) return(res);
    }
    return(0);
}

int rd_font_blok(zone)
u32_t zone;
{
    int stat;

    if (zone == 0) return(0);
/*  printk("\n%4d:Read zone #%D and EM_Xfer to %X", emcount, zone, font_mem);*/
    if (HD_read(drive, diskbuf, low_sect + (zone << 1)) != 0)
	return(ERROR);
    if ((stat = emxfer(diskbuf, font_mem)) != 0) {
	printk("\nEM_xfer err(block=%d, status=%x)\n", emcount, stat);
	return(ERROR);
    }
    font_mem += 1024L;
    emcount++;
    return(0);
}

int chkhead()
{
    long csum;
    int i;
    short *ip;
    char *p;

    csum = 0L;
    ip = (short *)&font_h;
    for(i=0; i<(FONT_HEAD_SIZE-4) /2; i++, ip++) csum += (long)*ip;
    if (font_h.sum == csum) {
	putchar('\n');
	for(i=0, p=font_h.memo; *p && i < FH_MEMO_SIZE; i++, p++) putchar(*p);
	/* return(OK); */
    } else {
	/* return(ERROR); */
    }
}

int readfont(node, ftbl)
u16_t node;
struct font_table *ftbl;
{
    char *p, *q, *r;
    int i, j;

    i = read_inode(node);
    if (i == ERROR) return(ERROR);
    p = inode_buf + i;
    font_bloks = (u16_t)((*(u32_t *)(p + FSIZE_OFS) - 1L) / 1024L);

    if (extm_siz < (font_bloks + boot_parameters.bp_ramsize + USER_MEMORY)) {
	printk("\nNo memory to load\n");
	return(ERROR);
    }
    font_mem = EM_BASE + (u32_t)(extm_siz - font_bloks) * 1024L;
    ftbl->ft_base = font_mem;
    ftbl->ft_limit = font_bloks;

    p += ZONE_OFS;
    if (HD_read(drive, &font_h, low_sect + (to_zone_num(p) << 1)) != OK)
	return(ERROR);
    font_bloks--;
    chkhead();
    ftbl->fn_size = font_h.fnt_size;
    ftbl->fn_high = font_h.fnt_high;
    ftbl->fn_width = font_h.fnt_width;
    /*	printk("\nbase= %X, size=%d\n", ftbl->ft_base, ftbl->ft_limit);
	printk("f_size=%d, width=%d, high=%d\n",
		ftbl->fn_size, ftbl->fn_width, ftbl->fn_high); */
    emcount=0;
    p += ZONE_INC;
    for(i = 1; i < 7; i++, p += ZONE_INC) {
	if (rd_font_blok(to_zone_num(p)) == ERROR) return(ERROR);
    }
    if (HD_read(drive, zone_buf, low_sect + (to_zone_num(p) << 1)) != OK)
								return(ERROR);
    for(i = 0, q = zone_buf;
		i < NR_ZONES && emcount <= font_bloks; i++, q += ZONE_INC) {
	if (rd_font_blok(to_zone_num(q)) == ERROR) return(ERROR);
    }
    p += ZONE_INC;
    if (HD_read(drive, inode_buf, low_sect + (to_zone_num(p) << 1)) != OK)
								return(ERROR);
    for(j = 0, q = inode_buf;
		j < NR_ZONES && emcount <= font_bloks; j++, q += ZONE_INC) {
	if (HD_read(drive, zone_buf, low_sect + (to_zone_num(q) << 1)) != OK)
								return(ERROR);
	for(i = 0, r = zone_buf;
		i < NR_ZONES && emcount <= font_bloks; i++, r += ZONE_INC) {
	    if (rd_font_blok(to_zone_num(r)) == ERROR) return(ERROR);
	}
    }
    return(OK);
}

int load_afont(font_file, ftbl)
char *font_file;
struct font_table *ftbl;
{
    struct super_block *spb;
    u16_t inode, res;

    /* if (*font_file == '\0') return(ERROR); */
    if (HD_read(drive, diskbuf, low_sect + (SUPER_BLOCK << 1)) != 0)
								return(ERROR);
    spb = (struct super_block *)diskbuf;
    /* printk("Super Magic = %x\n", spb->s_magic); */
    switch (spb->s_magic) {
	case V1_SUPERMAGIC:	fs = &fs_param[0]; break;
	case V2_SUPERMAGIC:	fs = &fs_param[1]; break;
	default:	printk("\nmagic number mismatched(%x)",spb->s_magic);
			return(ERROR);
    }
    start_inode = spb->s_imap_blocks + spb->s_zmap_blocks + 2;
    base_node = 0xffff;
    inode = search(SystemDir, I_DIRECTORY, ROOT_INODE);
    if (inode == 0) goto NoFile;

    inode = search(font_file, I_REGULAR, inode);
    if (inode == 0) {
NoFile:
	printk("\n/%s/%s not found", SystemDir, font_file);
	return(ERROR);
    }
    printk("\nLoading /%s/%s ...", SystemDir, font_file);
    res = readfont(inode, ftbl);
    if (res == ERROR) {
	ftbl->ft_base = 0L;
	ftbl->ft_limit = 0;
    }
    return(res);
}

int load_font()
{
    int i, k, fonts, part;
    long val[4];

    extm_siz = p_memsize();
    sys_font[0].ft_base = rom_font_base();
    fonts = 1;
    if (extm_siz == 0) return(1);

    drive = (fnt_drv >> 8) & 0xff;
    part = fnt_drv & 0xff;
    if (!(drive & 0x80) || part == 0) return(1);

    hdparam(drive);
    if (HD_read(drive, diskbuf, 0L) != 0) return(fonts);
	for(i = 0, k = 0x1C6; i < 4; k += 16, i++) {
	    val[i] = *(long *)&diskbuf[k];
    }
    (void)sort(val, 0);
    low_sect = val[part - 1];
    /* printk("drive=%x, part=%d, low_sect= %D\n", drive, part, low_sect); */

    for (i = 0, k= 1; i < NR_FONT_TBL; i++, k++) {
	if (usr_font[i][0] != '\0'
			&& load_afont(usr_font[i], &sys_font[k]) == OK) {
	    extm_siz -= sys_font[k].ft_limit;
	    sys_font[k].flag = USABLE_FONT;
	    fonts++;
	    if (i == 0)
		sys_font[0].flag = FONT_ENABLE;
	}
    }
    return(fonts);
}

option_menu()
{
    int command,i,j;

    while (1) {
	printk("\n[Optional menu]    Hit key as follows:\n\n");
	printk("    a  *ANK* Single byte  font file name (");
		if (usr_font[0][0] == '\0') printk("use ROM font)\n");
		else printk("now /%s/%s)\n", SystemDir, usr_font[0]);
	printk("    d  *STD* Double bytes font file name (");
		if (usr_font[1][0] == '\0') printk("unused)");
		else printk("now /%s/%s)\n", SystemDir, usr_font[1]);
	printk("    D  *OPT* Double bytes font file name (");
		if (usr_font[2][0] == '\0') printk("unused)");
		else printk("now /%s/%s)\n", SystemDir, usr_font[2]);
	printk("    l  load font\n");
	printk("    q  Quit, return to main menu.\n\n$ ");

	command = getc() & CHAR_MASK;
	/* printk("%c\n", command); */
	switch (command) {
	    case 'a':
		printk("\nEnter Single byte font name: /%s/", SystemDir);
		if (readln(usr_font[0], 14) > 0) {
				font_on_mem = -1;
				sys_font[1].flag = FONT_DISABLE;
		}
		break;

	    case 'd':
		printk("\nEnter *STD* Double bytes font name: /%s/",SystemDir);
		if (readln(usr_font[1], 14) > 0) {
				font_on_mem = -1;
				sys_font[2].flag = FONT_DISABLE;
		}
		break;

	    case 'D':
		printk("\nEnter *OPT* Double bytes font name: /%s/",SystemDir);
		if (readln(usr_font[2], 14) > 0) {
				font_on_mem = -1;
				sys_font[3].flag = FONT_DISABLE;
		}
		break;

	    case 'L':
		get_num(&i, "Enter HD unit number(0 or 1)");
		get_num(&j, "Enter partition number(1..4)");
		if (between(i, 0, 1) && between(j, 1, 4))
			fnt_drv = ((i | 0x80) << 8) | j;
		else break;

	    case 'l':
		font_on_mem = load_font();
		break;

	    case 'q':
	    case 033:	return;

	    default:
		printk("Illegal command\n");
		break;
	}
	printk("\n");
    }
}

int readln(buf, max)
char *buf;
int max;
{
    int n;
    char c, tmp[40];

    n = 0;
    do {
	c = getch() & CHAR_MASK;
	switch (c) {
	    case '\r':	tmp[n] = 0; break;
	    case '\b':	if (n > 0) { printk("\b \b"); n--; } break;
	    case 0x1b:	return(ERROR);
	    default:
		if (n < max && c > ' ' && c < 0x7f) {
			putc(c);
			tmp[n++] = c;
		}
		break;
	}
    } while (c != '\r');
    strcpy(buf, tmp);
    return(n);
}

#if 0
#define isprint(c)	between(c, ' ', '~')
dump(buf)
char *buf;
{
    int i, j;
    char *p;	

    for(i=0, p=buf; i<16; i++, p+=16) {
	printk("\n%4x:", 16 * i);
	for(j=0; j<16; j++) printk(" %2x", *(p+j) & 0xff);
	printk("    ");
	for(j=0; j<16; j++) printk("%c",
			isprint(*(p+j) & 0xff) ? (*(p+j) & 0xff): '.');
    }
    printk("\nPause...");
    (void)getc();
    printk("\n");
}
#endif
