/* Yacc.c	23-Jan-87 */
/* 25-Jul-87 IBM */
/* 30-Nov-88 ZTC */

/* Copyright 1987,1988,1989 David A. Clunie. All rights reserved.
   PO Box 811, Parkville 3052 AUSTRALIA.
   This program may be freely distributed for non-commercial use. */

/*	Defines:	main()

	Uses:		augment()	init1()		fini1()
			yyparse()	rdstr()		rdsym()
			rdrule()	dump()		mkfirst()
			frfirst()	lr0()		rdtx()
			frtx()		mkgoto()	lookahead()
			rdincon()	frincon()	mkreln()
			frreln()	txsort()	shsort()
			rdprec()	frprec()	conf()
			pack()		oppars()
*/

#include <stdio.h>

#define DEFINE
#define PHASE0

#include "yadefs.h"

#ifdef TIMEHEAD
#include TIMEHEAD
#endif

main(argc,argv)
int argc;
char *argv[];
{
    void augment(),init1(),fini1();
    int yyparse();
    void rdstr(),rdsym(),rdrule();
#ifdef TRACE
    void dumpglbl();
#endif
    void mkfirst(),frfirst();
    void lr0();
    void rdtx(),frtx(),mkgoto();
    void lookahead();
    void rdincon(),frincon();
    void mkreln(),frreln();
    void txsort(),shsort();
    void rdprec(),frprec(),conf(),pack();
    void oppars();
#ifndef MINIX
    clock_t t,f;
#endif

    init1(argc,argv);		/* Phase 1 */
#ifndef MINIX
    if (o_debug) {
	t=clock();
    }
#endif
    if (yyparse() || cnfatal) {
	exit(1);
    }
    augment();
    fini1();
    if (cnfatal) exit(1);
#ifdef TRACE
    dumpglbl();
#endif
    rdstr();			/* Phase 2 */
#ifdef TRACE
    dumpglbl();
#endif
    unlink(nstring);
#ifdef TRACE
    dumpglbl();
#endif
    rdsym();
#ifdef TRACE
    dumpglbl();
#endif
    rdrule();
#ifdef TRACE
    dumpglbl();
#endif
    unlink(nrhs);
#ifdef TRACE
    dumpglbl();
#endif
    mkfirst();
#ifdef TRACE
    dumpglbl();
#endif
    lr0();
#ifdef TRACE
    dumpglbl();
#endif
    frfirst();
    txsort();
    rdtx();
    rdincon();
    mkreln();
    unlink(ntr2);
    lookahead();
    frreln();
    mkgoto();
    frtx();
    rdprec();
    unlink(nsymbol);
    unlink(nrule);
    conf();
    unlink(ntrans);
    unlink(nitem);
    frprec();
    frincon();
    pack();
    unlink(nshift);
    unlink(ngoto);
    oppars();			/* Phase 3 */
    unlink(naction);
#ifndef MINIX
    if (o_debug) {
	f=100/CLK_TCK;	/* make sure we have 1/100ths of a second */
	t=(clock()-t)*f;
	printf("Elapsed time %lu.%02lu seconds \n",
	    (long)(t/100),(long)(t%100));
    }
#endif
    exit(0);
}

#ifdef TRACE

void
dumpglbl()
{
printf("cnwarning\t%d\n",cnwarning);
printf("cnfatal\t%d\n",cnfatal);
printf("cnstr\t%d\n",cnstr);
printf("cnrule\t%d\n",cnrule);
printf("cnrhs\t%d\n",cnrhs);
printf("cnnont\t%d\n",cnnont);
printf("cntok\t%d\n",cntok);
printf("bstok\t%d\n",bstok);
printf("bsnont\t%d\n",bsnont);
printf("start\t%d\n",start);
printf("cnstate\t%d\n",cnstate);
printf("cnitem\t%d\n",cnitem);
printf("cnincon\t%d\n",cnincon);
printf("cncxst\t%d\n",cncxst);
printf("cncxit\t%d\n",cncxit);
printf("cnntx\t%d\n",cnntx);
printf("cnttx\t%d\n",cnttx);
printf("cnrtx\t%d\n",cnrtx);
printf("cnshift\t%d\n",cnshift);
printf("cngo\t%d\n",cngo);
}

#endif /* TRACE */

