/* Yaincon.c	06-Nov-86	Read complete items of inconsistent states */
/* 25-Jul-87 IBM */
/* 30-Nov-88 ZTC */

/* Copyright 1987,1988,1989 David A. Clunie. All rights reserved.
   PO Box 811, Parkville 3052 AUSTRALIA.
   This program may be freely distributed for non-commercial use. */

/*	Defines:	rdincon()
*/

#include <stdio.h>

#define PHASE2

#include "yadefs.h"

void
rdincon()
{
    int v3,dposn,st,basest,ibase,i,n;

    message("rdincon:");

    trace(("rdincon: allocating irule size cnincon %u * sizeof(int) %u = %u\n",
	cnincon,sizeof(int),cnincon*sizeof(int)));
    irule=(int *)xalloc(cnincon*sizeof(int));
    trace(("rdincon: allocating ist size cnincon %u * sizeof(int) %u = %u\n",
	cnincon,sizeof(int),cnincon*sizeof(int)));
    ist=(int *)xalloc(cnincon*sizeof(int));

    fitem=xopen(nitem,READ_BINARY);

    n=basest=ibase=i=0;		/* fitem file sorted by state number */
    for (;;) {
	trace(("rdincon: state=%u ibase=%u i=%u\n",basest,ibase,i));
	st=getw(fitem);		/* Item state number */
	if (st != basest) {

/* 	consider situation at end :
	- eof - incon table MUST be full hence will exit on i>=incon
	      - must have inconsistent last state to get to eof, with
		a complete item as last
	- i>=cnincon
	      - i can only be ++ on complete items so last table entry
		will be a complete item
	      - if it is a complete item of a simple (consistent) state
		then the next state value will be different, the inconsistent
		test will be applied and i set down to ibase to go around
		again
	      - if it is a complete item of an inconsistent state, it MUST
		be the last complete item (else i<cnincon), hence we don't
		want to go any further. We test for i>=incon here as well
		so that trace will put out the inconsistent message for the
		last complete item, even if it is followed by other items
		of the same state (incomplete of course), because we will
		break on i>=incon whether we have read the rest of the state
		or not.
	- hence it is never possible to allow looping with i>= cnincon
	(which would lead to scrunging outside allocated bounds)
*/
	    if (i != ibase && n>1) {
		ibase=i;
		trace(("rdincon: inconsistent\n"));
	    }
	    else {
		i=ibase;
	    }
	    if (i >= cnincon)
		break;
	    basest=st;
	    n=0;
	}

	(void)getw(fitem);		/* Item lhs symbol - can get from v3 */
	v3=getw(fitem);			/* Item rule */
	dposn=getw(fitem);		/* Item distinguished posn */
	trace(("rdincon: %u: st=%u lhs=%s rule=%u dposn=%u\n",
		i,st,namesym(rulesym[v3]),v3,dposn));
	++n;				/* Count items in THIS state */
	if (dposn == 0) {
	    ist[i]=st;
	    irule[i]=v3;
	    ++i;			/* Record complete items only */
	}
    }
    xclose(fitem,nitem);
}

