/* Yalook.c	06-Nov-86	Compute lookahead sets */
/* 25-Mar-88 VAXVMS */
/* 09-Jul-89 ZTC */

/* Copyright 1987,1988,1989 David A. Clunie. All rights reserved.
   PO Box 811, Parkville 3052 AUSTRALIA.
   This program may be freely distributed for non-commercial use. */

/*	Defines:	lookahead()	dialloc()	difree()
			diclear()	fwreln()	rereln()
			recopy()	reunion()

	Statics:	traverse()	[dpila(),dpwork() - TRACE]
*/

#include <stdio.h>

#define PHASE2

#include "yadefs.h"

static int *stkend;			/* End of stack */

void
lookahead()
{
    void dialloc(),difree(),diclear(),traverse();
    void dpwork(),dpila();
    void recopy(),reunion();
    int rereln(),fwreln();
    int spells();
    int i,ntx;

    message("lookahead:");

    dmax=cnntx;
    dialloc();
    diclear();

    dicopy=recopy;
    diunion=reunion;
    direln=rereln;		/* Relation is reads */

    for (ntx=0; ntx<cnntx; ++ntx) {
	traverse(ntx);
    }
#ifdef TRACE
    dpwork("Read");
#endif
    diclear();
    direln=fwreln;

    ila=(BITSTR **)xalloc(cnincon*sizeof(BITSTR *));

    for (i=0; i<cnincon; ++i) {
	ila[i]=alcbit(cntok);
	zerobit(ila[i],cntok);
	for (ntx=0; ntx<cnntx; ++ntx) {
	    if (isbit(lback[i],ntx)) {
		trace(("lookahead: ntx %u in lookback item %u\n",ntx,i));
		traverse(ntx);
		if (work[ntx]) {
		    trace(("lookahead: work allocated\n"));
		    orbit(ila[i],work[ntx],cntok);
		}
		else {
		    trace(("lookahead: no work - or with dread\n"));
		    orbit(ila[i],dread[ntxtab[ntx].to],cntok);
		}
	    }
	}
    }
#ifdef TRACE
    dpwork("Follow");
    dpila();
#endif
    difree();
}

void
traverse(x)
int x;
{
    int d,y;

    trace(("traverse: enter %u\n",x));

    if (din[x]) {
	trace(("traverse: already done\n"));
	return;
    }

/*    *++sp=x; */

    if (sp < stkend) {
	*++sp=x;
    }
    else {
	bug("traverse: stack overflow");
    }
    din[x]=d= ++depth;			/* Record depth (which may change) */
					/* "= ++" avoids old assignment op */
#ifdef TRACE
    printf("traverse: din=");
    for (y=0; y<dmax; ++y) printf("%u ",din[y]);
    printf("\n");
#endif
    for (y=0; y<dmax; ++y) {
	if ( (*direln)(x,y) ) {
	    trace(("traverse: %u reln %u\n",x,y));
	    if (din[y] == 0) {
		trace(("traverse: recursive call for %u\n",y));
		traverse(y);
	    }
	    trace(("traverse: Nx=%u Ny=%u\n",din[x],din[y]));
	    if (din[x] > din[y]) {	/* Nx = min (Nx,Ny) */
		trace(("traverse: so set x to min\n"));
		din[x]=din[y];
	    }
	    (*diunion)(x,y);
	}
    }
    if (din[x] == d) {			/* NOT depth or will never do it ! */
	trace(("traverse: = original depth\n"));
	do {
	    trace(("traverse: popping %u\n",*sp));
	    din[*sp]=INFINITY;
	    if (*sp != x) {
		(*dicopy)(*sp,x);
	    }
	} while (--depth, *sp-- != x);	/* pop(top of stack) != x */
    }
    trace(("traverse: exit %u\n",x));
}

#ifdef TRACE
static void
dpila()
{
    int i,j;

    for (j=0; j<cnincon; ++j) {
	printf("item %u reduce to %s on lookahead = ",
	    j,namesym(rulesym[irule[j]]));
	if (ila[j]) {
	    for (i=0; i<cntok; ++i) {
		if (isbit(ila[j],i)) {
		    printf("%s ",nametok(i));
		}
	    }
	    printf("\n");
	}
	else {
	    printf("not allocated\n");
	}
    }
}

static void
dpwork(desc)
char *desc;
{
    int i,ntx;

    for (ntx=0; ntx<cnntx; ++ntx) {
	printf("%u(%u->%u on %s)\t%s = ",
		ntx,ntxtab[ntx].from,ntxtab[ntx].to,
		namenont(ntxtab[ntx].nont),desc);
	if (work[ntx]) {
	    for (i=0; i<cntok; ++i) {
		if (isbit(work[ntx],i)) {
		    printf("%s ",nametok(i));
		}
	    }
	    printf("\n");
	}
	else {
	    printf("not allocated\n");
	}
    }
}
#endif

void
dialloc()
{
    int i;

    work=(BITSTR **)xalloc(dmax*sizeof(BITSTR *));
    din=(int *)xalloc(dmax*sizeof(int));
    stack=(int *)xalloc(DISTACKSIZE);
    stkend=stack+DISTACKSIZE-1;	/* Points to last entry */

    for (i=0; i<dmax; ++i){
	work[i]=0;		/* Work bit strings initially empty */
    }
}

void
difree()
{
    int i;

    for (i=0; i<dmax; ++i){
	if (work[i]) {
	    xfree((char *)work[i]);
	}
    }
    xfree((char *)work);
    xfree((char *)din);
    xfree((char *)stack);
}

void
diclear()
{
    int i;

    for (i=0; i<dmax; ++i) {
	din[i]=0;		/* Array used by traverse */
    }

    sp=stack-1;
    depth=0;
}

int
fwreln(ntx,nty)				/* Relation: ntx includes nty */
int ntx,nty;
{
    return isbit(incl[ntx],nty);
}

int
rereln(ntx,nty)			/* Reads relation between nonterminal tx */
int ntx,nty;
{
    return (isbit(nullable,ntxtab[nty].nont)
	    && ntxtab[ntx].to == ntxtab[nty].from);
}

void
recopy(ntx,nty)			/* x = y */
int ntx,nty;
{
    trace(("recopy: %u from %u\n",ntx,nty));

    if (work[nty]) {
	if (work[ntx]) {
	    copybit(work[ntx],work[nty],cntok);
	}
	else {
	    bug("recopy: destination not assigned");
	}
    }
    else {
	if (work[ntx]) {
	    bug("recopy: source not assigned");
	}
    }
}

void
reunion(ntx,nty)		/* x = x U y */
int ntx,nty;
{
    trace(("reunion: %u from %u\n",ntx,nty));

    if (!work[ntx]) {
	trace(("reunion: allocate %u to dread\n",ntx));
	work[ntx]=alcbit(cntok);
	copybit(work[ntx],dread[ntxtab[ntx].to],cntok);
    }

    if (work[nty]) {
	orbit(work[ntx],work[nty],cntok);
    }
    else {
	trace(("reunion: union with dread %u\n",nty));
	orbit(work[ntx],dread[ntxtab[nty].to],cntok);
    }
}

