/* Yalr0.c	20-Oct-86	Compute lr(0) sets of items */
/* 30-Oct-86 	States are numbered from 0 not 1 */
/* 05-Nov-86	Arrange addition of states to keep sorted by state number */
/* 12-Nov-86	Optx() - outputs rules/dposn as well */
/* 20-Nov-86	Optx() - add -1 as eof indicator */
/* 27-Nov-86	count complex states and items */
/* 17-Jan-87	Output null items (complete but in closure) as well as kernel*/
/* 25-Jul-87 IBM */
/* 25-Mar-88 VAXVMS */
/* 09-Jul-89 ZTC*/

/* Copyright 1987,1988,1989 David A. Clunie. All rights reserved.
   PO Box 811, Parkville 3052 AUSTRALIA.
   This program may be freely distributed for non-commercial use. */

#define	PTRFMT	"%08lx"

#ifdef	TRACE2				/* Strip off outer parentheses */
#define	trace2(x)	printf x
#else
#define	trace2(x)
#endif	/* TRACE2 */

/*	Defines:	lr0()

	Statics:	gentrans()	mrgtrans()	genclosure()
			addtrans()	addstate()	additem()
			freeitlist()	itemcmp()	optx()
			freestlist()	opstlist()	opstate()
			[dpitem() - TRACE]
*/

#include <stdio.h>

#define PHASE2

#include "yadefs.h"

void
lr0()
{
    STATE *addstate();
    ITEM *additem();
    void gentrans();
    void mrgtrans();
    void opstlist();
    void freestlist();

    STATE *st,*stlist,*stlast;
    TRANS *trlist;

    message("lr0:");

    cnstate=0;
    cnrtx=cnntx=cnttx=0;
    ftrans=xopen(ntrans,WRITE_BINARY);

    stlast=NULL;				/* None added yet */

    /* First state is  start : _ .... */

    st=stlist=addstate(&stlast,
	additem((ITEM **)NULL,nontrule[valnont(start)],1));
	/* (ZTC 14-Nov-88: cast shuts up compiler without using prototypes) */

    do {
	trace(("lr0: st=%u\n",st->num));
	gentrans(&trlist,st);			/* Generate transitions */
	mrgtrans(&stlist,&stlast,st,&trlist);	/* Merge trans with states */
	st=st->next;
    } while (st);				/* Until no states added */

    putw(-1,ftrans);				/* Eof indicator */
    xclose(ftrans,ntrans);
    opstlist(stlist);
    freestlist(stlist);
}

static void
gentrans(atrlist,st)
TRANS **atrlist;
STATE *st;
{
    void dpitem();
    void genclosure();
    TRANS *addtrans();
    ITEM *it;
    int sym;

    trace(("gentrans: st=%u atrlist=%08lx\n",st->num,atrlist));
    it=st->item;
    *atrlist=NULL;
    while (it) {
	trace(("gentrans: item "));
#ifdef TRACE
	dpitem(it);
#endif
	if (!iscomplete(it)) {
	    trace(("gentrans: is not complete\n"));
	    /* sym=dsym(it); */
	    sym=rhs[rulerhs[it->rule]+it->dposn-1];

	    trace(("gentrans: trlist=%08lx\n",*atrlist));
	    (void)addtrans(atrlist,sym,it->rule,it->dposn+1);
	    trace(("gentrans: trlist=%08lx\n",*atrlist));
	    if (isnont(sym)) {
		trace(("gentrans: %s is nont so closure\n",namesym(sym)));
		genclosure(atrlist,st,sym);
	    }
	    trace(("gentrans: trlist=%08lx\n",*atrlist));
	}
	it=it->next;
    }
    trace(("gentrans: leaving with trlist=%08lx\n",*atrlist));
}

static void
mrgtrans(astlist,astlast,fromst,atrlist)
STATE **astlist,**astlast,*fromst;
TRANS **atrlist;
{
    void optx();
    void freeitlist();
    STATE *st,*addstate();
    TRANS *tr;
    int itemcmp();

    trace2(("mrgtrans: entering atrlist=%08lx trlist=%08lx\n",atrlist,*atrlist));

    while (tr= *atrlist) {		/* "= *" avoids old assignment op */
	trace2(("mrgtrans: transition on %s from state number %d\n",
		namesym(tr->sym),fromst->num));
#ifdef TRACE2
	dpitem(tr->item);
#endif
	for (st= *astlist; st && !itemcmp(st->item,tr->item); st=st->next);
					/* "= *" avoids old assignment op */
	if (st) {			/* If we found a match */
	    trace2(("mrgtrans: matching state is number %d\n",st->num));
	    freeitlist(tr->item);
	}
	else {				/* Else need a new state */
	    trace2(("mrgtrans: no matching state - get new one\n"));
	    st=addstate(astlast,tr->item);
	}
	optx(tr->sym,fromst->num,st->num,st->item);
	*atrlist=tr->next;		/* Next entry to test */
	xfree((char *)tr);		/* And release storage */
    }

    trace2(("mrgtrans: leaving trlist=%08lx\n",*atrlist));
}

static void
genclosure(atrlist,st,sym)
TRANS **atrlist;
STATE *st;
int sym;				/* Sym will only ever be a nont */
{
    ITEM *additem();
    TRANS *addtrans();
    int nont,n,r,x;

    nont=valnont(sym);
    trace(("genclosure: of %s\n",namenont(nont)));
    for (n=0; n<cnnont; ++n) {		/* For all nonterminals, n */
	if (isbit(first[nont],n)) {	/* If n is in nont's first list */
	    trace(("genclosure: %s is in first list\n",namenont(n)));
	    for (r=nontrule[n]; r<nontrule[n+1]; ++r) {	/* For all n's rules */
		trace(("genclosure: adding rule %u\n",r));
		if (rulerhs[r] < rulerhs[r+1]) {	/* That aren't empty */
		    trace(("genclosure: not empty\n"));
		    x=rhs[rulerhs[r]];	/* Add transition to n : x _ .... */
		    (void)addtrans(atrlist,x,r,2);
		}
		else {			/* Record empty rule in closure */
		    trace(("genclosure: empty - add to empty list\n"));
		    (void)additem(&st->empty,r,0);
		}
	    }
	}
    }
}

static TRANS *
addtrans(atrlist,sym,rule,dposn)	/* Add transition to list */
TRANS **atrlist;
int sym;				/* On which to make transition */
int rule;				/* Rule to go to */
int dposn;				/* And its distinguished position */
{
    ITEM *additem();
    TRANS *tr;

    trace(("addtrans: on %s to rule %u posn %u\n",namesym(sym),rule,dposn));
    trace(("addtrans: atrlist=%08lx\n",atrlist));
    if (atrlist) {			/* If list exists, search it */
	tr= *atrlist;			/* "= *" avoids old assignment op */
	while (tr && tr->sym != sym) {	/* For a transition on sym */
	    tr=tr->next;
	}
    }
    else {
	tr=NULL;
    }

    if (!tr) {				/* If no list, or not in list */
	tr=(TRANS *)xalloc(sizeof(TRANS));	/* Then we need a new one */
	tr->item=NULL;
	tr->sym=sym;
	if (atrlist) {			/* If adding to a list */
	    tr->next= *atrlist;		/* Will be NULL if list empty */
					/* "= *" avoids old assignment op */
	    *atrlist=tr;		/* Link new entry at head of list */
	}
	else {				/* Not adding to list */
	    tr->next=NULL;
	}
    }

    if (dposn > lngrule(rule)) {	/* Check if should be complete */
	dposn=0;
    }
    trace(("addtrans: tr->item was %08lx\n",tr->item));
    (void)additem(&tr->item,rule,dposn);	/* Add new item to trans */
    trace(("addtrans: tr->item is now %08lx\n",tr->item));

    return tr;
}

static STATE *
addstate(astlast,it)			/* Add state to list */
STATE **astlast;			/* Where in list to append/insert */
ITEM *it;
{
    STATE *st;

    st=(STATE *)xalloc(sizeof(STATE));
    st->item=it;
    st->empty=NULL;			/* No empty (complete/closure) items */
    st->num=cnstate++;
    trace(("addstate: adding %u *astlast=%08lx\n",st->num,*astlast));
    if (*astlast) {
	st->next=(*astlast)->next;		/* Insert after *astlast */
	(*astlast)->next=st;
    }
    else {
	st->next=NULL;				/* Append to empty */
    }
    *astlast=st;				/* Advance ptr to last */
    return st;
}

static ITEM *
additem(aitlist,rule,dposn)
ITEM **aitlist;
int rule,dposn;
{
    ITEM *it,*it1,*it2;

    trace(("additem: add rule %u dposn %u\n",rule,dposn));
    trace(("additem: aitlist=%08lx\n",aitlist));

    it1=NULL;				/* Previous entry in list */
    if (aitlist) {			/* If adding to an existing list */
	it2= *aitlist;			/* "= *" avoids old assignment op */
	trace(("additem: list exists %08lx\n",it2));
    }
    else {
	it2=NULL;
    }
    while (it2 && rule > it2->rule) {	/* Find where in list to insert */
	it1=it2;
	it2=it2->next;
    }
    while (it2 && rule == it2->rule && dposn > it2->dposn) {
	it1=it2;
	it2=it2->next;
    }
    trace(("additem: it1=%08lx it2=%08lx\n",it1,it2));
    if (it2 && rule == it2->rule && dposn == it2->dposn) {
	it=it2;			/* Already exists */
	trace(("additem: already exists\n"));
    }
    else {			/* Create new item */
	it=(ITEM *)xalloc(sizeof(ITEM));
	trace(("additem: creating %08lx\n",it));
	it->rule=rule;
	it->dposn=dposn;
	it->next=it2;		/* Will be NULL at end of list, or no list */

	if (it1) {		/* Insert in middle or end of list */
	    it1->next=it;
	    trace(("additem: in middle\n"));
	}
	else {			/* Insert at head of list */
	    if (aitlist) {	/* List actually exists */
		*aitlist=it;	/* So change head */
		trace(("additem: is new head\n"));
	    }
	}
    }
    return it;			/* Return new entry */
}

static void
freeitlist(itlist)
ITEM *itlist;
{
    ITEM *it;

    while (it=itlist) {
	trace(("freeitlist: freeing "));
#ifdef TRACE
	dpitem(it);
#endif /* TRACE */
	itlist=it->next;
	xfree((char *)it);
    }
}

static int
itemcmp(it1,it2)		/* Compare two sorted item lists */
ITEM *it1,*it2;
{
    while (it1 && it2) {
	if (it1->rule != it2->rule || it1->dposn != it2->dposn) {
	    return 0;
	}
	it1=it1->next;
	it2=it2->next;
    }
    if (it1 == it2) {		/* ie. both zero */
	return 1;
    }
    else {			/* Else not same length therefore not same */
	return 0;
    }
}

static void
optx(sym,fromst,tost,it)	/* Output transition from state to state */
int sym;			/* On this symbol */
int fromst;
int tost;
ITEM *it;			/* Items in to state */
{
    int rule,dposn;

    if (isnont(sym))
	++cnntx;
    else
	++cnttx;

    for (; it; it=it->next) {	/* For all items */
	rule=it->rule;
	dposn = it->dposn ? it->dposn-1 : lngrule(rule);
	if (rhs[rulerhs[rule]+dposn-1] == sym) {	/* If tx FROM sym */
	    ++cnrtx;
	    putw(sym,ftrans); putw(fromst,ftrans); putw(tost,ftrans);
	    putw(rule,ftrans); putw(dposn,ftrans);
	    trace2(("optx: transition on %s from %u (rule %u dposn %u) to %u\n",
		namesym(sym),fromst,rule,dposn,tost));
	}
    }
}

static void
freestlist(stlist)
STATE *stlist;
{
    STATE *st;

    while (st=stlist) {
	stlist=st->next;
	freeitlist(st->item);
	xfree((char *)st);
    }
}

static void
opstlist(stlist)
STATE *stlist;
{
    void opstate();
    STATE *st;

    fitem=xopen(nitem,WRITE_BINARY);
    cnincon=0;		/* Count of complete items in inconsistent states */
    cncxst=0;		/* Count of complex states */
    cncxit=0;		/* Count of complete items in complex states */
    cnitem=0;		/* Count of all items */

    for (st=stlist; st ; st=st->next) {
	opstate(st);
    }
    putw(-1,fitem);	/* Eof indicator */
    xclose(fitem,nitem);
}

static void
opstate(st)
STATE *st;
{
    void dpitem();
    ITEM *it;
    int j,n,r;

    trace(("State %u\n",st->num));

    for (it=st->item,n=0,r=0,j=0; it && j <= 1;
		it=(it->next) ? it->next : (++j,st->empty) ) {
	putw(st->num,fitem);		/* Number of state containing item */
	putw(rulesym[it->rule],fitem);	/* LHS Symbol (NB. Not valnont()) */
	putw(it->rule,fitem);		/* Rule number */
	putw(it->dposn,fitem);		/* Distinguished posn (0=complete) */

#ifdef TRACE2
	dpitem(it);
#endif
	++cnitem;			/* Number of items in all states */
	++n;				/* Number of items in this state */
	if (it->dposn == 0)
	    ++r;			/* Complete items in this state */
#ifdef TRACE2
	printf("opstate: st->num=%d rulesym=%d it->rule=%d it->dposn=%d\n",
	    st->num,rulesym[it->rule],it->rule,it->dposn);
	printf("opstate: it=%08lx it->next=%08lx j=%d\n",
		(long)it,(long)it->next,j);
	printf("opstate: empty=%08lx new=%08lx\n",
		(long)st->empty,(long)((it->next)?it->next:st->empty) );
#endif
    }

    if (r && (n > 1)) {	/* Complete & any other items = inconsistent state */
	cnincon+=r;	/* Count complete items in all inconsistent states */
    }
    if (r > 1) {	/* More than one complete item = complex state */
	++cncxst;
	cncxit+=r;
    }
}

#ifdef TRACE2

static void
dpitem(it)
ITEM *it;
{
    int i,end,dposn;

    end=lngrule(it->rule)+1;
    dposn=it->dposn ? it->dposn : end;
    printf("\t%s\t: ",namesym(rulesym[it->rule]));
    for (i=1; i<dposn; ++i) {
	printf("%s ",namesym(rhssym(it,i)));
    }
    printf("_ ");
    for (i=dposn; i<end; ++i) {
	printf("%s ",namesym(rhssym(it,i)));
    }
    printf("\n");
}

#else
#ifdef TRACE

static void
dpitem(it)
ITEM *it;
{
    int i,end,dposn;

    end=lngrule(it->rule)+1;
    dposn=it->dposn ? it->dposn : end;
    printf("\t%s\t: ",namesym(rulesym[it->rule]));
    for (i=1; i<dposn; ++i) {
	printf("%s ",namesym(rhssym(it,i)));
    }
    printf("_ ");
    for (i=dposn; i<end; ++i) {
	printf("%s ",namesym(rhssym(it,i)));
    }
    printf("\n");
}

#endif
#endif
