/* Yaopsym.c	19-Oct-86	Output phase 1 symbol information */
/* 25-Jul-87 IBM */
/* 09-Jul-89 ZTC*/

/* Copyright 1987,1988,1989 David A. Clunie. All rights reserved.
   PO Box 811, Parkville 3052 AUSTRALIA.
   This program may be freely distributed for non-commercial use. */

/*	Defines:	opsym()

	Uses:		enquote()
*/

#include <stdio.h>

#define PHASE1

#include "yadefs.h"

void opsym()				/* Output symbol definitions */
{
    char *enquote();

    SYMBOL *s,*s0,*s1,*s2;
    RULE *r,*r2;
    LIST *l,*l2;
    int i,i2;
    int nontnum;
    int swap;
    char *p,*p2,buf[13],leadch;
    int symseq,stroff,ruleoff,rhsoff;

    message("opsym:");

    nontnum=bsnont;			/* Give all nonterminals a toknum */
    cnstr=0;				/* Find length of string area */
    s=shead;
    while (s) {
	if (s->kind == NONT) {
	    s->toknum=nontnum++;
	}
	if (s->kind == NONT || s->kind == TOKEN) {
	    cnstr+=(strlen(s->name)+1);
	}
	s=s->lsym;
    }

    do {				/* Sort symbols by toknum */
	swap=0;				/* Using bubble sort - yuck ! */
	s0=NULL;
	s1=shead;
	s2=s1->lsym;			/* Assumes s1 != NULL */
	while (s1 && s2) {
	    if (s1->toknum <= s2->toknum) {
		s0=s1;
		s1=s2;
		s2=s2->lsym;
	    }
	    else {
		if (s0) {
		    s0->lsym=s2;
		}
		else {
		    shead=s2;
		}
		s1->lsym=s2->lsym;
		s2->lsym=s1;
		s0=s2;
		s2=s1->lsym;
		swap=1;
	    }
	}
    } while (swap);

    fsymbol=xopen(nsymbol,WRITE_BINARY);
    fstring=xopen(nstring,WRITE_BINARY);

    stroff=0;

    putw(cnstr,fstring);
    putw(cntok,fsymbol);
    putw(cnnont,fsymbol);
    putw(bstok,fsymbol);
    putw(bsnont,fsymbol);

    /* fytabc & fytabh already open */

    fputs("\n",fytabc);
    fputs("typedef struct { char *t_name; int t_val; } yytoktype;\n\n",fytabc);
    fputs("#ifndef YYDEBUG\n#define YYDEBUG ",fytabc);
    if (o_yydebug)
	fputs("1",fytabc);
    else
	fputs("0",fytabc);
    fputs(" /* allow debugging */\n#endif\n\n",fytabc);

    fputs("#if YYDEBUG\n\n",fytabc);
    fputs("yytoktype yytoks[] = {\n",fytabc);
    leadch=' ';
    s=shead;
    while (s) {
	if (s->kind == TOKEN
	  && s->toknum != 0		/* not end of file */
	  && s->toknum != 256		/* not error */
	) {
	    p=enquote(s->name);
	    fprintf(fytabc,"\t%c%s,\t%d\n",leadch,p,s->toknum);
	    xfree((char *)p);
	    leadch=',';
	}
	s=s->lsym;
    }
    fprintf(fytabc,"\t%c\"-unknown-\",\t-1\n};\n",leadch);

#ifdef NONTDESC
    fputs("yytoktype yynonts[] = {\n",fytabc);
    leadch=' ';
    s=shead;
    while (s) {
	if (s->kind == NONT) {
	    /* NB. non-terminals in output are numbered from zero */
	    p=enquote(s->name);
	    fprintf(fytabc,"\t%c%s,\t%d\n",leadch,p,s->toknum-257);
	    xfree((char *)p);
	    leadch=',';
	}
	s=s->lsym;
    }
    fprintf(fytabc,"\t%c\"-unknown-\",\t-1\n};\n",leadch);
#endif

    fputs("char *yyreds[] = {\n",fytabc);

#ifdef RULEFROMONE
    fprintf(fytabc,"\t\"-no such reduction-\"\n");
    leadch=',';
#else
    leadch=' ';
#endif
    for (i=0; i<cnrule; ++i) {
	i2=cnrule;		/* non-existent value */
	s=shead;
	while (s) {
	    if (s->kind == NONT) {
		r=s->rule;
		while (r) {
		    i2=r->seq;
		    if (i2 == i) goto found;
		    r=r->next;
		}
	    }
	    s=s->lsym;
	}
	found:
	if (i2 == i) {		/* found rule sequence number i */
	    p=xalloc(strlen(r->sym->name)+3);
	    strcpy(p,r->sym->name);
	    strcat(p," :");
	    for (l=r->list; l; l=l->next) {
		p=xrealloc(p,strlen(p)+strlen(l->sym->name)+2);
		strcat(p," ");
		strcat(p,l->sym->name);
	    }
	    p2=enquote(p);
	    fprintf(fytabc,"\t%c%s\n",leadch,p2);
	    xfree((char *)p);
	    xfree((char *)p2);
	    leadch=',';
	}
    }
    fprintf(fytabc,"};\n");

    fputs("#endif /* YYDEBUG */\n\n",fytabc);

    s=shead;
    symseq=0;
    while (s) {
	if (s->kind == TOKEN) {
	    p=s->name;
	    do {			/* Output string INCLUDING null */
		wrstrch(*p,fstring);
	    } while (*p++);
	    putw(stroff,fsymbol);
	    stroff+=(strlen(s->name)+1);

	    putw(s->toknum,fsymbol);
	    putw(s->prec,fsymbol);
	    putw(s->assoc,fsymbol);

	    if (s->toknum >= bstok) {
		fprintf(fytabc,"#define %s\t%d\n",s->name,s->toknum);
		if (o_define)
		    fprintf(fytabh,"#define %s\t%d\n",s->name,s->toknum);
	    }
	    s->toknum=symseq++;		/* Replace token number with token */
					/* sequence (used in rules) */
	}
	s=s->lsym;
    }

    fputs("\n",fytabc);
    if (o_define) fputs("\n",fytabh);

    s=shead;				/* Sequence nonterminals for rules */
    while (s) {
	if (s->kind == NONT) {
	    s->toknum=symseq++;
	}
	s=s->lsym;
    }

    /*	At this point toknum for both tokens and nonterminals has been
	changed from the value of the token from the lexical analyzer
	to a sequence number, corresponding to the sequence in the symbol
	file, with:

		tokens       having sequence from 0 to cntok-1
		nonterminals having sequence from cntok onwards
    */

    frule=xopen(nrule,WRITE_BINARY);
    frhs=xopen(nrhs,WRITE_BINARY);
    ruleoff=0;
    rhsoff=0;

    putw(cnrule,frule);
    putw(cntok,frule);			/* Used as sequence offset for nont */
    putw(sstart->toknum,frule);		/* Sequence number of start nont */
    putw(cnrhs,frhs);

    s=shead;
    while (s) {
	if (s->kind == NONT) {
	    p=s->name;
	    do {			/* Output string INCLUDING null */
		wrstrch(*p,fstring);
	    } while (*p++);
	    putw(stroff,fsymbol);
	    stroff+=(strlen(s->name)+1);

	    putw(ruleoff,fsymbol);

	    r=s->rule;

	    if (r == NULL) {
		er2msg(s->name,"not declared as token and has no rule",FATAL);
	    }
	    while (r) {
		++ruleoff;
		putw(r->sym->toknum,frule);	/* Is really sym sequence */
		putw(r->seq,frule);
		putw(r->prec,frule);
		putw(rhsoff,frule);

		l=r->list;
		while (l) {
		    ++rhsoff;
		    putw(l->sym->toknum,frhs);	/* Is really sym sequence */
		    l=l->next;
		}
		r=r->next;
	    }
	}
	s=s->lsym;
    }

    xclose(fsymbol,nsymbol);
    xclose(fstring,nstring);
    xclose(frule,nrule);
    xclose(frhs,nrhs);

#ifdef TRACE
    s=shead;
    while (s) {
	switch (s->kind) {
	    case NONT:
		printf("NONT\tname:<%s> toknum:%u type:<%s>\n",
		    s->name,s->toknum,(s->type) ? s->type : "**none**"
		);
		break;
	    case TOKEN:
		printf("name:<%s> assoc:%u prec:%u toknum:%u type:<%s>\n",
		    s->name,s->assoc,s->prec,s->toknum,
		    (s->type) ? s->type : "**none**"
		);
		break;
	    default:
		printf("kind:%u\tname:<%s>\n",s->kind,s->name);
		break;
	}
	s=s->lsym;
    }
    s=shead;
    while (s) {
	if (s->kind == NONT) {
	    r=s->rule;
	    while (r) {
		printf("prec:%u seq:%u\t%s : ",
			r->prec,r->seq,r->sym->name);
		l=r->list;
		while (l) {
		    printf("%s ",l->sym->name);
		    l=l->next;
		}
		printf("\n");
		r=r->next;
	    }
	}
	s=s->lsym;
    }
    printf("%u tokens, %u nonterminals, %u rules, %u rhs symbols\n",
	cntok,cnnont,cnrule,cnrhs);
    printf("non-literal token base=%u and nonterminal base=%u\n",
	bstok,bsnont);
#endif

    s=shead;
    while (s) {
	s2=s->lsym;
	if (s->kind == NONT) {
	    r=s->rule;
	    while (r) {
		r2=r->next;
		l=r->list;
		while (l) {
		    l2=l->next;
		    xfree((char *) l);
		    l=l2;
		}
		xfree((char *) r);
		r=r2;
	    }
	}
	xfree((char *)s->name);
	/* does not free s->union - not yet in use */
	xfree((char *) s);
	s=s2;
    }
    shead=NULL;
}

