/* Yaread.c	29-Oct-86	Read in files for phase 2 */
/* 25-Jul-87 IBM */
/* 30-Nov-88 ZTC */

/* Copyright 1987,1988,1989 David A. Clunie. All rights reserved.
   PO Box 811, Parkville 3052 AUSTRALIA.
   This program may be freely distributed for non-commercial use. */

/* Defines:	rdstr()		rdsym()		rdtok()
		rdnont()	rdrule()	[dump() - TRACE]
*/

/* 30-Oct-86	Only read in cnstr chars in rdstr() because when using */
/*		getc() (rather than agetc()) feof() doesn't detect CPMEOF */
/*		(ctrl-Z) and hence was reading in beyond the allocated space */
/*		(Can't use agetc() because it ignores '\r' and hence screws */
/*		up the offsets into the table !!! */
/* 09-Jul-89	The last comment is probably of historical significance only */
/*		now that rdstrch() is used & implementation defined but is */
/*		a warning to future fiddlers */


#include <stdio.h>

#define PHASE2

#include "yadefs.h"

void
rdstr()
{
    int i;
    char *p;

    message("rdstr:");

    fstring=xopen(nstring,READ_BINARY);	/* Read string file */
    cnstr=getw(fstring);
    p=strarea=xalloc(cnstr);
    for (i=0; i<cnstr; ++i) {
	*p++=rdstrch(fstring);
    }
    xclose(fstring,nstring);
}

void
rdsym()
{
    void rdtok(),rdnont();

    message("rdsym:");

    fsymbol=xopen(nsymbol,READ_BINARY);	/* Read symbols */

    cntok=getw(fsymbol);
    cnnont=getw(fsymbol);
    bstok=getw(fsymbol);
    bsnont=getw(fsymbol);

    rdtok();
    rdnont();

    xclose(fsymbol,nsymbol);
}

void
rdtok()
{
    int i;

    tokstr=(int *)xalloc(cntok*sizeof(int));
#ifdef FULL
    toknum=(int *)xalloc(cntok*sizeof(int));
    tokprec=(int *)xalloc(cntok*sizeof(int));
    tokassoc=(int *)xalloc(cntok*sizeof(int));
#endif
    for (i=0; i < cntok; ++i) {
	tokstr[i]=getw(fsymbol);
#ifdef FULL
	toknum[i]=getw(fsymbol);
	tokprec[i]=getw(fsymbol);
	tokassoc[i]=getw(fsymbol);
#else
	(void)getw(fsymbol);
	(void)getw(fsymbol);
	(void)getw(fsymbol);
#endif
    }
}

void
rdnont()
{
    int i;

    nontstr=(int *)xalloc(cnnont*sizeof(int));
    nontrule=(int *)xalloc((cnnont+1)*sizeof(int));	/* NB. plus one */

    for (i=0; i < cnnont; ++i) {
	nontstr[i]=getw(fsymbol);
	nontrule[i]=getw(fsymbol);
    }
}

void
rdrule()
{
    int i;

    message("rdrule:");

    frule=xopen(nrule,READ_BINARY);		/* Read rules */

    cnrule=getw(frule);
    cntok=getw(frule);			/* cntok gives offset for nont seq */
    start=getw(frule);			/* seq number of start nont */

    nontrule[cnnont]=cnrule;		/* Note dummy entry to prevent */
					/* special case testing */

    rulesym=(int *)xalloc(cnrule*sizeof(int));
#ifdef FULL
    ruleseq=(int *)xalloc(cnrule*sizeof(int));
    ruleprec=(int *)xalloc(cnrule*sizeof(int));
#endif
    rulerhs=(int *)xalloc((cnrule+1)*sizeof(int));	/* NB. plus one */

    for (i=0; i<cnrule; ++i) {
	rulesym[i]=getw(frule);
#ifdef FULL
	ruleseq[i]=getw(frule);
	ruleprec[i]=getw(frule);
#else
	(void)getw(frule);
	(void)getw(frule);
#endif
	rulerhs[i]=getw(frule);
    }
    xclose(frule,nrule);

    frhs=xopen(nrhs,READ_BINARY);
    cnrhs=getw(frhs);
    rulerhs[cnrule]=cnrhs;			/* Note dummy entry */
    rhs=(int *)xalloc(cnrhs*sizeof(int));
    for (i=0; i<cnrhs; ++i) {
	rhs[i]=getw(frhs);
    }
    xclose(frhs,nrhs);
}

#ifdef TRACE

void
dump()
{
    int i,j,r;

    for (i=0; i<cntok; ++i) {
#ifdef FULL
	printf("token:<%s> assoc:%u prec:%u toknum:%u\n",
		nametok(i),tokassoc[i],tokprec[i],toknum[i]);
#else
	printf("token:<%s>\n",nametok(i));
#endif
    }

    for (i=0; i<cnnont; ++i) {
	for (r=nontrule[i]; r < nontrule[i+1]; ++r) {
#ifdef FULL
	    printf("prec:%u seq:%u\t(%u)%s : ",
		ruleprec[r],ruleseq[r],i+bsnont,
		namenont(i));
#else
	    printf("%s : ",namenont(i));
#endif
	    for (j=rulerhs[r]; j < rulerhs[r+1]; ++j) {
		printf("%s ",namesym(rhs[j]));
	    }
	    printf("\n");
	}
    }

    printf("start is <%s>\n",namesym(start));

    printf("%u tokens, %u nonterminals, %u rules, %u rhs symbols\n",
	cntok,cnnont,cnrule,cnrhs);
    printf("non-literal token base=%u and nonterminal base=%u\n",
	bstok,bsnont);
}

#endif /* TRACE */

