/* Yareln.c	14-Nov-86	Make include and lookback relations */
/* 25-Jul-87 IBM */
/* 25-Mar-88 VAXVMS */
/* 09-Jul-89 ZTC*/

/* Copyright 1987,1988,1989 David A. Clunie. All rights reserved.
   PO Box 811, Parkville 3052 AUSTRALIA.
   This program may be freely distributed for non-commercial use. */

/*	Defines:	mkreln()

	Statics:	addpath()	freepath()	cpsreln()
			addincl()	findend()	finish()
			valntx()	valincon()
			[dpincl(),dplback() - TRACE]
*/

#include <stdio.h>

#define PHASE2

#include "yadefs.h"

typedef struct path {
    struct path *next;
    int hdntx;			/* Ntx from head of path (ie. hdst,rule nont)*/
    int hdst;			/* State at head of path */
    int tost;			/* Current transition is to this state */
} PATH;

static PATH *path;

void
mkreln()
{
    void addpath(),freepath();
    void dplback(),dpincl();
    void addincl(),finish();
    void cpsreln();
    int findend(),valntx();
    int i,j,n,r,nont,st,nmax,sym,from,to,rule,lastrule,dposn,nullposn;
    BITSTR *l;
    PATH *p;

    message("mkreln:");

    incl=(BITSTR **)xalloc(cnntx*sizeof(BITSTR *));
    for (i=0; i <cnntx; ++i) {
	incl[i]=alcbit(cnntx);
	zerobit(incl[i],cnntx);
    }
    lback=(BITSTR **)xalloc(cnincon*sizeof(BITSTR *));
    for (i=0; i <cnincon; ++i) {
	lback[i]=alcbit(cnntx);
	zerobit(lback[i],cnntx);

	/* Spelling of transitions detects lookback relation only if */
	/* there is a transition, and misses the case when the complete */
	/* item is EMPTY (and hence no transitions); so we initialize lback */
	/* when	1. same state 2. same nont 3. incon complete item is empty */

	r=irule[i];
	trace(("mkreln: incon %d rule %d\n",i,r));
	if (rulerhs[r] == rulerhs[r+1]) {	/* Empty */
	    nont=valnont(rulesym[r]);
	    st=ist[i];
	    l=lback[i];
	    trace(("mkreln: empty st %d nont <%s> lback at %04x\n",
		st,namenont(nont),l));
	    for (n=0; n < cnntx; ++n) {
		if (st == ntxtab[n].from && nont == ntxtab[n].nont) {
		    trace(("mkreln: set lback ntx %d\n",n));
		    setbit(l,n);
		}
	    }
	}
    }

    ftr2=xopen(ntr2,READ_BINARY);

    lastrule=-1;			/* For first time through */
					/* Don't finish off rule -1 ! */
    path=NULL;

    for (j=0; j<cnrtx; ++j) {		/* Transitions sorted by rule/dposn */
	sym=getw(ftr2);
	from=getw(ftr2);
	to=getw(ftr2);
	rule=getw(ftr2);
	dposn=getw(ftr2);
	trace(("mkreln: sym=%s\tfrom=%u (rule=%u dposn %u) to=%u\n",
		namesym(sym),from,rule,dposn,to));
	if (rule != lastrule) {
	    trace(("mkreln: different rule\n"));
	    finish(lastrule);
	    nullposn=findend(rule);
	    freepath(&path);			/* Start new rule */
	    lastrule=rule;
	}
	if (dposn == 1) {		/* For all tx at beginning of rule */
	    trace(("mkreln: at beginning\n"));
	    addpath(&path,valntx(from,valnont(rulesym[rule])),from,from);
	}

	for (p=path; p; p=p->next) {		/* Follow transition */
	    trace(("mkreln: test tost=%u from=%u\n",p->tost,from));
	    if (p->tost == from) {		/* Converge ALL entries */
		trace(("mkreln: make tost %u\n",to));
		p->tost=to;			/* Advance transition */
		if (dposn >= nullposn) {	/* Is rest of rule nullable */
		    addincl(from,sym,p);	/* Add to includes list */
		}
 	    }
	}
    }

    finish(rule);			/* Finish the last rule */
    freepath(&path);

    xclose(ftr2,ntr2);

#ifdef TRACE
    dpincl();
    dplback();
#endif
#ifdef COMPRESS
    cpsreln(incl,cnntx,cnntx);
    cpsreln(lback,cnincon,cnntx);
#ifdef TRACE
    dpincl();
    dplback();
#endif
#endif
}

static void
addpath(apath,hdntx,hdst,tost)		/* Add a new spelling path */
PATH **apath;
int hdntx;
int hdst;
int tost;
 {
    PATH *p;

    p=(PATH *)xalloc(sizeof(PATH));
    p->hdntx=hdntx;
    p->hdst=hdst;
    p->tost=tost;
    p->next= *apath;			/* "= *" avoids old assignment op */
    *apath=p;
}

static void
freepath(apath)				/* Free all paths */
PATH **apath;
{
    PATH *p,*p2;

    p= *apath;				/* "= *" avoids old assignment op */
    while (p) {
	p2=p->next;
	xfree((char *)p);
	p=p2;
    }
    *apath=NULL;
}

static void				/* Compress relations */
cpsreln(array,size,width)
BITSTR **array;				/* array of bit vectors */
int size;				/* length of array */
int width;				/* length of bit vector */
{
    int i,n;

    message("cpsreln:");

    for (n=0; n<size; ++n) {
	trace(("cpsreln: major %u\n",n));
	for (i=0; i<n; ++i) {
	    trace(("cpsreln: minor %u (%04x cf %04x)\n",
		i,array[n],array[i]));
	    if (eqbit(array[n],array[i],width)) {
		trace(("cpsreln:equal\n"));
		xfree((char *)array[n]);
		array[n]=array[i];
		break;
	    }
	}
    }
}

static void				/* Add head ntx to includes of ntx */
addincl(from,sym,p)
int from;				/* List ntx from state */
int sym;				/* List ntx symbol */
PATH *p;				/* Table index of head ntx to add */
{
    int ntx;

    if (isnont(sym)) {
	ntx=valntx(from,valnont(sym));
	trace(("addincl: add %u to include of %u\n",
		p->hdntx,ntx));
	if (ntx != -1 && p->hdntx != -1) {
	    setbit(incl[ntx],p->hdntx);
	}
    }
}

static int
findend(rule)
int rule;
{
    int s,nullposn;

    for (nullposn=lngrule(rule); nullposn > 0; --nullposn) {
	s=rhs[rulerhs[rule]+nullposn-1];
	if (istok(s) || !isbit(nullable,valnont(s))) {
	    break;
	}
    }
    trace(("mkreln: rule %u nullposn %u\n",rule,nullposn));
    return nullposn;

/*	    nullposn is dposn AFTER which rest of rule is nullable
	    ie. symbol at dposn itself is not nullable
	    eg.
		- no nullable symbols - nullposn=lngrule - ie. the last posn
		- all nullable symbols - nullposn=0
		- empty rule - nullposn=0
*/
}

static void
finish(r)
int r;					/* Rule */
{
    int valincon();
    int k;
    PATH *p;

    for (p=path; p; p=p->next) {
	trace(("finish: add lookback ntx %u\n",p->hdntx));
	if (p->hdntx != -1) {
	    trace(("finish: to incon st %u rule %u\n",
		p->tost,r));
	    if ((k=valincon(p->tost,r)) != -1) {
		setbit(lback[k],p->hdntx);
	    }
	}
    }
}

static int
valntx(st,nont)
int st,nont;
{
    int i;

    trace(("valntx: from st %u on %s\n",st,namenont(nont)));
    for (i=0; i<cnntx; ++i) {
	if (ntxtab[i].from == st && ntxtab[i].nont == nont) {
	    return i;
	}
    }
    trace(("valntx: can't find\n"));
    return -1;
}

static int
valincon(st,rule)
int st,rule;
{
    int i;

    trace(("valincon: st %u rule %u\n",st,rule));
    for (i=0; i<cnincon; ++i) {
	if (ist[i] == st && irule[i] == rule) {
	    return i;
	}
    }
    trace(("valincon: can't find\n"));
    return -1;
}

#ifdef TRACE

static void
dpincl()
{
    int i,n;

    for (i=0; i < cnntx; ++i) {			/* For all ntx */
	printf("%u:(from %u to %u on %s)\tincludes(%04x)=> ",
		i,ntxtab[i].from,ntxtab[i].to,namenont(ntxtab[i].nont),
		incl[i]);
	for (n=0; n<cnntx; ++n) {
	    if (isbit(incl[i],n)) {
		printf("%u ",n);
	    }
        }
	printf("\n");
    }
}

static void
dplback()
{
    int i,n;

    for (i=0; i < cnincon; ++i) {	/* For all items */
	printf("%u:(state %u rule %u)\tlookback(%04x)=> ",
		i,ist[i],irule[i],lback[i]);
	for (n=0; n<cnntx; ++n) {
	    if (isbit(lback[i],n)) {
		printf("%u ",n);
	    }
        }
	printf("\n");
    }
}

#endif

