/* Yasort.c	04-Dec-86	General sort/merge for yacc */
/* 20-Jul-87 IBM */
/* 25-Nov-88 ZTC */

/* Copyright 1987,1988,1989 David A. Clunie. All rights reserved.
   PO Box 811, Parkville 3052 AUSTRALIA.
   This program may be freely distributed for non-commercial use. */

/*	Defines:	sort()

	Statics:	makfil()	gname()		itoa()
			gopen()		gremov()	merge()
			reheap()	gwrite()	gread()

	Uses:		qsort()
*/

#include <stdio.h>

#include "yadefs.h"

#define	MERGEORDER	4

static namesize;
static char *name;
static char *prefix = "sort";
static char *suffix = ".$$$";
static char *namepath;

static char *(*rd)();
static FILE *(*rop)();
static void (*rcl)();
static void (*wr)();
static FILE *(*wop)();
static void (*wcl)();
static int (*cmp)();

int
sort(inname,outname,tmppath,maxptr,prd,prop,prcl,pwr,pwop,pwcl,pcmp)
char *inname,*outname,*tmppath;
char *(*prd)();
FILE *(*prop)();
void (*prcl)();
void (*pwr)();
FILE *(*pwop)();
void (*pwcl)();
int (*pcmp)();
{
    FILE *makfil();
    int gread();
    int gsetname();
    void qsort(),merge(),gwrite(),gopen(),gname(),gremov();
    int low,high,lim,nlines;
    FILE *outfil,*infil[MERGEORDER];
    char **linptr;
    char *holdbuf;

    message("sort:");

    namepath=tmppath;
    if (gsetname() == -1) return -1;

    rd=prd;
    rop=prop;
    rcl=prcl;
    wr=pwr;
    wop=pwop;
    wcl=pwcl;
    cmp=pcmp;

    high=0;
    infil[0]=(*rop)(inname);
    if ((linptr=(char **)malloc(maxptr*sizeof(char *))) == NULL) {
	errmsg("sort: out of memory allocating pointer array",ABORT);
	return -1;
    }
    holdbuf=malloc(BUFSIZ);		/* Reserve buffer BEFORE filling mem */
					/* If no room, just have to use char */
    while (nlines=gread(linptr,maxptr,infil[0])) {
	qsort(linptr,nlines,sizeof(char *),cmp);
	++high;
	outfil=makfil(high);
	setbuf(outfil,holdbuf);
	gwrite(linptr,nlines,outfil);
	(*wcl)(outfil);
    }
    (*rcl)(infil[0]);
    free(linptr);
    free(holdbuf);

    for (low=1; low<high; low+=MERGEORDER) {
	if ((lim=low+MERGEORDER-1) > high) {
	    lim=high;
	}
	gopen(infil,low,lim);
	++high;
	outfil=makfil(high);
	merge(infil,lim-low+1,outfil);
	(*wcl)(outfil);
	gremov(infil,low,lim);
    }

    gname(high);
    unlink(outname);
#ifdef MINIX
    if (link(name,outname))
	 	perror("sort() : error returned from link");
	 if (unlink(name))
	 	perror("sort() : error returned from unlink");
#else
    rename(name,outname);
#endif
    return 0;
}

static FILE *
makfil(n)
int n;
{
    void gname();

    trace(("makfil:\n"));
    gname(n);
    return (*wop)(name);
}

static int
gsetname()
{
    namesize=strlen(namepath)+strlen(prefix)+strlen(suffix)
	+sizeof(int)*3+1;
    if ((name=malloc(namesize)) == NULL) {
	errmsg("sort: out of memory allocating name buffer",ABORT);
	return -1;
    }
    trace(("gsetname: length %d\n",namesize));
    return 0;
}

static void
gname(n)
int n;
{
    char *itoa();

    strcpy(name,namepath);
    strcat(name,prefix);
#ifdef MINIX
	 strcat(name,itoa(n));		/* #$%@!   MINIX itoa() is screwy! */
#else
    (void)itoa(n,name+strlen(name),10);
#endif
    strcat(name,suffix);
    trace(("gname: <%s>\n",name));
}

static void			/* Open group of files low ... lim (incl) */
gopen(infil,low,lim)
FILE **infil;
int low;
int lim;
{
    int i;

    trace(("gopen:\n"));

    for (i=0; i<lim-low+1; ++i) {
	gname(low+i);
	infil[i]=(*rop)(name);
    }
}

static void
gremov(infil,low,lim)
FILE **infil;
int low;
int lim;
{
    int i;

    trace(("gremov:\n"));

    for (i=0; i<lim-low+1; ++i) {
	(*rcl)(infil[i]);
	gname(low+i);
	unlink(name);
    }
}

static void
merge(infil,nfiles,outfil)
FILE **infil;
int nfiles;
FILE *outfil;
{
    void reheap();
    int i,base;
    char **linptr,*p;
    FILE **linfil;

    trace(("merge:\n"));

    linptr=(char **)malloc(nfiles*sizeof(char *));
    linfil=(FILE **)malloc(nfiles*sizeof(FILE *));
    base=nfiles;
    for (i=0; i<nfiles; ++i) {
	if (p=(*rd)(infil[i])) {			/* !eof */
	    linptr[--base]=p;
	    linfil[base]=infil[i];
	    reheap(linptr+base,linfil+base,nfiles-base);
	}
    }

    while (base < nfiles) {
	(*wr)(linptr[base],outfil);
	if ((linptr[base]=(*rd)(linfil[base])) == NULL) {	/* eof */
	    ++base;
	}
	reheap(linptr+base,linfil+base,nfiles-base);
    }
    free(linptr);
    free(linfil);
}

static void
reheap(linptr,linfil,nf)
char **linptr;
FILE **linfil;
{
    int i,j;
    char *tptr;
    FILE *tfil;

#ifdef HEAPTRACE
    for (i=0; i<nf; ++i) {
	printf("reheap: start %u <%s>\n",i,linptr[i]);
    }
#endif
    for (i=1; 2*i <= nf; i=j) {
	j=2*i;
#ifdef HEAPTRACE
	printf("reheap: i=%u j=%u\n",i,j);
#endif
	if (j < nf) {			/* Are two children */
	    if ((*cmp)(linptr+j-1,linptr+j) > 0) {
		++j;
#ifdef HEAPTRACE
		printf("reheap: 2nd child smaller j=%u\n",j);
#endif
	    }
	}
	if ((*cmp)(linptr+i-1,linptr+j-1) <= 0) {
#ifdef HEAPTRACE
	    printf("reheap: parent <= child - done\n");
#endif
	    break;
	}
	tptr=linptr[i-1];
	tfil=linfil[i-1];
	linptr[i-1]=linptr[j-1];
	linfil[i-1]=linfil[j-1];
	linptr[j-1]=tptr;
	linfil[j-1]=tfil;
    }
#ifdef HEAPTRACE
    for (i=0; i<nf; ++i) {
	printf("reheap: finish %u <%s>\n",i,linptr[i]);
    }
#endif
}

static void
gwrite(linptr,nmax,file)
char **linptr;
int nmax;
FILE *file;
{
    int i;

    trace(("gwrite:\n"));

    for (i=0; i<nmax; ++i) {
	(*wr)(linptr[i],file);
    }
}

static int
gread(linptr,nmax,file)
char **linptr;
int nmax;
FILE *file;
{
    int i;

    trace(("gread:\n"));

    for (i=0; i<nmax; ++i) {
	if ((linptr[i]=(*rd)(file)) == NULL) {		/* eof or out of mem */
	    return i;
	}
    }
    return nmax;
}

