/* yapcdos.h 08-Jul-89 Implementation dependent things for IBM PC DOS */

/* Copyright 1987,1988,1989 David A. Clunie. All rights reserved.
   PO Box 811, Parkville 3052 AUSTRALIA.
   This program may be freely distributed for non-commercial use. */

#define MINIX
/* defined for debugging */
/* #define TRACE */

#ifdef __ZTC__
#define SYSTEM	 "PC-DOS ZTC (file)"
#else
#ifdef MINIX
#define SYSTEM   "MINIX"
#else
#define SYSTEM	 "PC-DOS (file)"
#endif
#endif

/* #define PCDOS */

#ifdef __ZTC__

#define STDLIBHEAD	<stdlib.h>	/* define if stdlib.h needed */
#define	STRINGHEAD	<string.h>	/* define if string.h needed */
#define	TIMEHEAD	<time.h>	/* define if time.h needed */

#else	/* assume Aztec C */

char *malloc();
char *realloc();

typedef long clock_t;
#define	clock()		(0l)

#endif

#ifdef __ZTC__
#define TTYHEAD	<io.h>		/* define only if isatty() needs io.h */
#else	/* assume Aztec C */
#define TTYHEAD	<sgtty.h>	/* define only if isatty() needs sgtty.h */
#endif

#ifdef MINIX
#define iseofchar(c)    ( (c) == EOF || (c) == 0x04 )	/* ctrl-D? */
#else
#define	iseofchar(c)	( c == EOF || c == 0x1a )	/* ctrl-Z */
#endif

#define BITSTR	unsigned int	/* Type of word used for bit strings */

#define SORTTABLE	3000	/* size of pointer table in txsort() */
				/* larger -> longer runs */
#ifdef __ZTC__
#define	NEEDGETW		/* include x...w() in yautil.c */
#define	getw(f)		xgetw(f)
#define	putw(u,f)	xputw(u,f)
#define	rdstrch(f)	xgetw(f)
#define	wrstrch(u,f)	xputw(u,f)
#else	/* assume Aztec C */
#ifdef MINIX
#define	NEEDGETW		/* include x...w() in yautil.c */
#define	getw(f)		xgetw(f)
#define	putw(u,f)	xputw(u,f)
#define	rdstrch(f)	xgetw(f)
#define	wrstrch(u,f)	xputw(u,f)
#else
#define	rdstrch(f)	getc(f)
#define	wrstrch(u,f)	putc(u,f)
#endif
#endif

/* set PATHSEPARATOR to null string "" if paths not implemented */
#ifndef PATHSEPARATOR
#ifdef MINIX
#define PATHSEPARATOR	"/"
#else
#define	PATHSEPARATOR	"\\"
#endif
#endif

/* leave TMPENVPATH undefined if compiler can't access environment */
#ifndef TMPENVPATH			/* if not defined on compile line */
#define	TMPENVPATH	"TMP"		/* where to find path for temp files */
#endif
/* set TMPDEFPATH to null string "" (current directory) if no paths */
#ifndef TMPDEFPATH			/* if not defined on compile line */
#ifdef MINIX
#define TMPDEFPATH	"/tmp"
#else
#define TMPDEFPATH	""		/* path to use if not in environment */
#endif
#endif

/* leave SKELENVPATH undefined if compiler can't access environment */
#ifndef SKELENVPATH			/* if not defined on compile line */
#define	SKELENVPATH	"YYSKELETON"	/* where to find path for skeleton */
#endif
/* set SKELDEFPATH to null string "" (current directory) if no paths */
#ifndef SKELDEFPATH			/* if not defined on compile line */
#ifdef MINIX
#define SKELDEFPATH	"/usr/lib"
#else
#define SKELDEFPATH	"c:\\util"	/* path to use if not in environment */
#endif
#endif
#ifndef SKELDEFNAME			/* if not defined on compile line */
#define SKELDEFNAME	"yaccpar"	/* path to use if not in environment */
#endif

#ifndef YTABHDEFNAME			/* if not defined on compile line */
#define	YTABHDEFNAME	"y.tab.h"
#endif
#ifndef YTABCDEFNAME			/* if not defined on compile line */
#define	YTABCDEFNAME	"y.tab.c"
#endif
#ifndef YOUTDEFNAME			/* if not defined on compile line */
#define	YOUTDEFNAME	"youtput"
#endif

#ifdef MINIX
#define READ_BINARY	"r"
#define WRITE_BINARY	"w"
#else
#define READ_BINARY	"rb"
#define WRITE_BINARY	"wb"
#endif

