/* Yatxsort.c	12-Nov-86	Sort transitions by rule for relations */
/* 20-Nov-86	Use sort/merge package - terminate trans files with -1 */
/* 25-Jul-87 IBM */
/* 25-Mar-88 VAXVMS */
/* 30-Nov-88 ZTC */

/* Copyright 1987,1988,1989 David A. Clunie. All rights reserved.
   PO Box 811, Parkville 3052 AUSTRALIA.
   This program may be freely distributed for non-commercial use. */

/* 09-Jul-89	Historical note - I had heaps of trouble with the end-of-file
		handling when moving between machines. Seems silly I know.
		Be warned. I hope I haven't messed up the old behaviour under
		CPM in recent years - I haven't tested it for a while */

/*	Defines:	txsort()

	Statics:	rtxrop()	rtxwop()	rtxrcl()
			rtxwcl()	rtxrd()		rtxwr()
			rtxcmp()
*/

#include <stdio.h>

#define PHASE2

#include "yadefs.h"

typedef struct rtx {
    int sym;
    int from;
    int to;
    int rule;
    int dposn;
} RTX;

void
txsort()				/* Sort transitions */
{
    int sort();
    RTX *rtxrd();
    int rtxcmp();
    void rtxwr(),rtxrcl(),rtxwcl();
    FILE *rtxrop(),*rtxwop();

    message("txsort:");

    sort(ntrans,ntr2,g_tmppath,
	SORTTABLE,rtxrd,rtxrop,rtxrcl,rtxwr,rtxwop,rtxwcl,rtxcmp);
}

static FILE *
rtxrop(name)
char *name;
{
    return xopen(name,READ_BINARY);
}

static FILE *
rtxwop(name)
char *name;
{
    return xopen(name,WRITE_BINARY);
}

static void
rtxrcl(file)
FILE *file;
{
    xclose(file,"???");
}

static void
rtxwcl(file)
FILE *file;
{
    putw(-1,file);
    xclose(file,"???");
}

static RTX *
rtxrd(file)
FILE *file;
{
    static int outofmem=0;
    RTX *rtx;

    if (rtx=(RTX *)malloc(sizeof(RTX))) {
	outofmem=0;
	if ((rtx->sym=getw(file)) == -1 || feof(file)) {
	    free(rtx);
	    rtx=0;
#ifdef TRACE
	    printf("rtxrd: eof\n");
#endif
	}
	else {
	    rtx->from=getw(file);	/* From state */
	    rtx->to=getw(file);		/* To state */
	    rtx->rule=getw(file);	/* Rule */
	    rtx->dposn=getw(file);	/* Distinguished posn (from) */
#ifdef TRACE
	    printf("rtxrd: sym=%s\tfrom=%u to=%u rule=%u dposn=%u\n",
		namesym(rtx->sym),rtx->from,rtx->to,rtx->rule,rtx->dposn);
#endif
	}
    }
    else {				/* Out of memory */
	if (outofmem) {			/* Twice in a row */
	    fputs("rtxrd: out of memory\n",stderr);
	    exit(1);
	}
	outofmem=1;
    }
    return rtx;
}

static void
rtxwr(rtx,file)
RTX *rtx;
FILE *file;
{
    putw(rtx->sym,file);
    putw(rtx->from,file);
    putw(rtx->to,file);
    putw(rtx->rule,file);
    putw(rtx->dposn,file);
    free(rtx);
}

static int
rtxcmp(a,b)
RTX **a,**b;
{
    int i;

    if ((i=(*a)->rule-(*b)->rule) == 0) {
	i=(*a)->dposn-(*b)->dposn;
    }
#ifdef TRACE
    printf("cmprtx: a(%u,%u) - b(%u,%u) = %u\n",(*a)->rule,(*a)->dposn,
	(*b)->rule,(*b)->dposn,i);
#endif
    return i;
}

