/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;

public class IrcDccChatSocket
extends Thread {
    private ServerSocket ss;
    private boolean isServer;
    private BufferedReader br = null;
    private PrintWriter pw = null;
    private IrcDccListener il;
    private String nick;
    private InetAddress addr;
    private short port;
    private boolean connected;
    private Object connectionWaitSemaphore = new Object();

    public boolean isConnected() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void waitUntilConnected() throws InterruptedException {
        Object object = this.connectionWaitSemaphore;
        synchronized (object) {
            System.out.println("Connected value " + this.connected);
            if (this.connected) {
                return;
            }
            while (true) {
                if (this.connected) {
                    return;
                }
                this.connectionWaitSemaphore.wait();
                System.out.println("Connected value " + this.connected);
            }
        }
    }

    public IrcDccChatSocket(ServerSocket ss, IrcDccListener il, String nick) throws IOException {
        this.il = il;
        this.nick = nick;
        this.ss = ss;
        this.isServer = true;
        this.setPriority(1);
        System.out.println("Gonna start IRC/DCC chat socket");
        this.start();
    }

    public IrcDccChatSocket(InetAddress addr, short port, IrcDccListener il, String nick) throws IOException {
        this.il = il;
        this.nick = nick;
        this.port = port;
        this.addr = addr;
        this.isServer = false;
        this.setPriority(1);
        System.out.println("Gonna start IRC/DCC chat socket");
        this.start();
    }

    public void setDccListener(IrcDccListener idcl) {
        this.il = idcl;
    }

    public void run() {
        System.out.println("Entering try.");
        try {
            Socket s;
            System.out.println("Entering if-else part.");
            if (this.isServer) {
                System.out.println("Entering socket-synchronized block");
                System.out.println("Accepting");
                s = this.ss.accept();
                System.out.println("Accepted");
            } else {
                System.out.println("Connecting");
                s = new Socket(this.addr, (int)this.port);
                System.out.println("Connected");
            }
            if (s == null) {
                this.il.dccDisconnection(this.nick);
                IrcDccChatSocket ircDccChatSocket = this;
                synchronized (ircDccChatSocket) {
                    this.connected = false;
                }
                return;
            }
            System.out.println("DCC connection established.\n");
            this.il.dccConnection(this.nick);
            this.br = new BufferedReader(new InputStreamReader(s.getInputStream()));
            this.pw = new PrintWriter(new OutputStreamWriter(s.getOutputStream()));
            Object object = this.connectionWaitSemaphore;
            synchronized (object) {
                this.connectionWaitSemaphore.notifyAll();
                this.connected = true;
            }
        }
        catch (Exception e) {
            this.il.dccDisconnection(this.nick);
            return;
        }
        while (true) {
            try {
                String received = this.br.readLine();
                if (received == null) break;
                if (this.il == null) continue;
                this.il.dccMsg(this.nick, received);
            }
            catch (Exception e) {
                break;
            }
        }
        this.il.dccDisconnection(this.nick);
    }

    public void sendMessage(String mesg) {
        System.out.println("Message to send: " + mesg);
        IrcDccChatSocket ircDccChatSocket = this;
        synchronized (ircDccChatSocket) {
            if (this.pw != null) {
                this.pw.print(mesg);
                if (mesg.charAt(mesg.length() - 1) != '\n' && mesg.charAt(mesg.length() - 1) != '\r') {
                    this.pw.print("\n");
                }
                this.pw.flush();
            }
        }
        System.out.println("Message sent: " + mesg);
    }
}

