/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.FileInputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class VisualConfiguration {
    private Hashtable colorCodesTable = new Hashtable();
    private Color background;
    private Color foreground;
    private String fontName;
    private float fontSize;
    private String fontFileName;
    private Font laFuente;

    public VisualConfiguration() {
        this.colorCodesTable.put("description", "%00CC00%");
        this.colorCodesTable.put("important", "%FFFF00%");
        this.colorCodesTable.put("information", "%FFFF00%");
        this.colorCodesTable.put("action", "%9999FF%");
        this.colorCodesTable.put("denial", "%CC0000%");
        this.colorCodesTable.put("error", "%FF0000%");
        this.colorCodesTable.put("story", "%FFFFFF%");
        this.colorCodesTable.put("default", "%FFFFFF%");
        this.colorCodesTable.put("input", "%AAAAAA%");
        this.colorCodesTable.put("reset", "% %");
        this.background = Color.black;
        this.foreground = Color.white;
        this.laFuente = SwingAetheriaGameLoaderInterface.font;
    }

    public String getColorCode(String colorType) {
        String code = (String)this.colorCodesTable.get(colorType.toLowerCase());
        if (code == null) {
            return "";
        }
        return code;
    }

    public Enumeration getColorKeys() {
        return this.colorCodesTable.keys();
    }

    public Element getXMLRepresentation(Document doc) {
        Element suElemento = doc.createElement("VisualConfiguration");
        Element colorsElt = doc.createElement("Colors");
        Enumeration en = this.colorCodesTable.keys();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            Element eltCol = doc.createElement(String.valueOf(Character.toUpperCase(key.charAt(0))) + key.substring(1));
            eltCol.setAttribute("color", this.getColorCode(key));
            colorsElt.appendChild(eltCol);
        }
        Element forCol = doc.createElement("Foreground");
        Element bacCol = doc.createElement("Background");
        forCol.setAttribute("color", ColoredSwingClient.colorToString(this.foreground));
        bacCol.setAttribute("color", ColoredSwingClient.colorToString(this.background));
        colorsElt.appendChild(forCol);
        colorsElt.appendChild(bacCol);
        Element fontElt = doc.createElement("Font");
        fontElt.setAttribute("name", this.fontName);
        fontElt.setAttribute("size", String.valueOf(this.fontSize));
        fontElt.setAttribute("filename", this.fontFileName);
        suElemento.appendChild(colorsElt);
        suElemento.appendChild(fontElt);
        return suElemento;
    }

    public VisualConfiguration(Node n, String fontDir) throws XMLtoWorldException {
        this();
        Element el;
        if (!(n instanceof Element)) {
            throw new XMLtoWorldException("VisualConfiguration node not Element");
        }
        Element e = (Element)n;
        if (!e.getTagName().equalsIgnoreCase("VisualConfiguration")) {
            throw new XMLtoWorldException("Element not named VisualConfiguration as expected");
        }
        NodeList nl = e.getElementsByTagName("Colors");
        if (nl.getLength() > 0) {
            Color c;
            Element elt1;
            el = (Element)nl.item(0);
            NodeList nl1 = el.getElementsByTagName("Description");
            if (nl1.getLength() > 0 && (elt1 = (Element)nl1.item(0)).hasAttribute("color")) {
                if (elt1.getAttribute("color").charAt(0) == '%') {
                    this.colorCodesTable.put("description", elt1.getAttribute("color"));
                } else {
                    this.colorCodesTable.put("description", "%" + elt1.getAttribute("color") + "%");
                }
            }
            if ((nl1 = el.getElementsByTagName("Important")).getLength() > 0 && (elt1 = (Element)nl1.item(0)).hasAttribute("color")) {
                if (elt1.getAttribute("color").charAt(0) == '%') {
                    this.colorCodesTable.put("important", elt1.getAttribute("color"));
                } else {
                    this.colorCodesTable.put("important", "%" + elt1.getAttribute("color") + "%");
                }
            }
            if ((nl1 = el.getElementsByTagName("Action")).getLength() > 0 && (elt1 = (Element)nl1.item(0)).hasAttribute("color")) {
                if (elt1.getAttribute("color").charAt(0) == '%') {
                    this.colorCodesTable.put("action", elt1.getAttribute("color"));
                } else {
                    this.colorCodesTable.put("action", "%" + elt1.getAttribute("color") + "%");
                }
            }
            if ((nl1 = el.getElementsByTagName("Information")).getLength() > 0 && (elt1 = (Element)nl1.item(0)).hasAttribute("color")) {
                if (elt1.getAttribute("color").charAt(0) == '%') {
                    this.colorCodesTable.put("information", elt1.getAttribute("color"));
                } else {
                    this.colorCodesTable.put("information", "%" + elt1.getAttribute("color") + "%");
                }
            }
            if ((nl1 = el.getElementsByTagName("Denial")).getLength() > 0 && (elt1 = (Element)nl1.item(0)).hasAttribute("color")) {
                if (elt1.getAttribute("color").charAt(0) == '%') {
                    this.colorCodesTable.put("denial", elt1.getAttribute("color"));
                } else {
                    this.colorCodesTable.put("denial", "%" + elt1.getAttribute("color") + "%");
                }
            }
            if ((nl1 = el.getElementsByTagName("Error")).getLength() > 0 && (elt1 = (Element)nl1.item(0)).hasAttribute("color")) {
                if (elt1.getAttribute("color").charAt(0) == '%') {
                    this.colorCodesTable.put("error", elt1.getAttribute("color"));
                } else {
                    this.colorCodesTable.put("error", "%" + elt1.getAttribute("color") + "%");
                }
            }
            if ((nl1 = el.getElementsByTagName("Story")).getLength() > 0 && (elt1 = (Element)nl1.item(0)).hasAttribute("color")) {
                if (elt1.getAttribute("color").charAt(0) == '%') {
                    this.colorCodesTable.put("story", elt1.getAttribute("color"));
                } else {
                    this.colorCodesTable.put("story", "%" + elt1.getAttribute("color") + "%");
                }
            }
            if ((nl1 = el.getElementsByTagName("Default")).getLength() > 0 && (elt1 = (Element)nl1.item(0)).hasAttribute("color")) {
                if (elt1.getAttribute("color").charAt(0) == '%') {
                    this.colorCodesTable.put("default", elt1.getAttribute("color"));
                } else {
                    this.colorCodesTable.put("default", "%" + elt1.getAttribute("color") + "%");
                }
            }
            if ((nl1 = el.getElementsByTagName("Input")).getLength() > 0 && (elt1 = (Element)nl1.item(0)).hasAttribute("color")) {
                System.out.println("Element:" + elt1);
                if (elt1.hasAttribute("color")) {
                    if (elt1.getAttribute("color").charAt(0) == '%') {
                        this.colorCodesTable.put("input", elt1.getAttribute("color"));
                    } else {
                        this.colorCodesTable.put("input", "%" + elt1.getAttribute("color") + "%");
                    }
                }
                System.out.println("Visconf init with input color" + this.colorCodesTable.get("input"));
            }
            if ((nl1 = el.getElementsByTagName("Foreground")).getLength() > 0 && (elt1 = (Element)nl1.item(0)).hasAttribute("color") && (c = VisualConfiguration.stringToColor(elt1.getAttribute("color"))) != null) {
                this.foreground = c;
            }
            if ((nl1 = el.getElementsByTagName("Background")).getLength() > 0 && (elt1 = (Element)nl1.item(0)).hasAttribute("color") && (c = VisualConfiguration.stringToColor(elt1.getAttribute("color"))) != null) {
                this.background = c;
            }
        }
        if ((nl = e.getElementsByTagName("Font")).getLength() > 0) {
            this.fontName = "Courier New";
            this.fontSize = 12.0f;
            el = (Element)nl.item(0);
            if (el.hasAttribute("name")) {
                this.fontName = el.getAttribute("name");
            }
            if (el.hasAttribute("size")) {
                this.fontSize = Float.valueOf(el.getAttribute("size")).floatValue();
            }
            Font[] fuentes = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
            int f = 0;
            while (f < fuentes.length) {
                if (fuentes[f].getFontName().equalsIgnoreCase(this.fontName)) {
                    this.laFuente = fuentes[f].deriveFont(this.fontSize);
                    break;
                }
                ++f;
            }
            if (el.hasAttribute("filename")) {
                try {
                    this.fontFileName = el.getAttribute("filename");
                    File f2 = fontDir != null ? new File(String.valueOf(fontDir) + this.fontFileName) : new File(this.fontFileName);
                    FileInputStream is = new FileInputStream(f2);
                    Font fuente = Font.createFont(0, is);
                    this.laFuente = fuente.deriveFont(this.fontSize);
                }
                catch (Exception ex) {
                    System.out.println(ex);
                }
            }
        }
    }

    public static Color stringToColor(String colorString) {
        try {
            String colorClean = colorString;
            if (colorClean.charAt(0) == '%') {
                colorClean = colorClean.substring(1, colorClean.length() - 1);
            }
            if (colorClean.length() > 0 && colorClean.charAt(0) == '#') {
                colorClean = colorClean.substring(1);
            }
            int ncolor = Integer.parseInt(colorClean, 16);
            return new Color(ncolor);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    public Color getBackgroundColor() {
        return this.background;
    }

    public Color getForegroundColor() {
        return this.foreground;
    }

    public Font getFont() {
        return this.laFuente;
    }
}

