/*
 * Decompiled with CFR 0.152.
 */
import bsh.TargetError;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class Room
extends Entity
implements Descriptible,
SupportingCode {
    private int idnumber;
    private int inheritsFrom;
    protected String title;
    protected Description[] descriptionList;
    protected Path[] standardExits;
    protected Path[] otherExits;
    protected Inventory itemsInRoom;
    protected MobileList mobsInRoom;
    protected String extraDescriptions;
    protected List extraDescriptionArrays;
    protected List extraDescriptionNameArrays;
    protected Vector onlyRestrictions;
    protected ObjectCode itsCode;
    private NaturalLanguage lenguaje;
    private Random aleat;
    transient boolean getDescription_bsh_call = false;

    public Room(World mundo, String roomfile) throws IOException, FileNotFoundException {
        this.constructRoom(mundo, roomfile);
    }

    public Room(World mundo, Node n) throws XMLtoWorldException {
        this.constructRoom(mundo, n, true);
    }

    public void constructRoom(World mundo, String roomfile) throws IOException, FileNotFoundException {
        boolean inheritance_done = false;
        this.lenguaje = mundo.getLang();
        FileInputStream fp = new FileInputStream(roomfile);
        BufferedReader filein = new BufferedReader(Utility.getBestInputStreamReader(fp));
        int line = 1;
        while (line < 100) {
            String linea = filein.readLine();
            String id_linea = StringMethods.getTok(linea, 1, ' ');
            linea = StringMethods.getToks(linea, 2, StringMethods.numToks(linea, ' '), ' ');
            if (id_linea != null) {
                switch (Integer.valueOf(id_linea)) {
                    case 1: {
                        this.idnumber = Integer.valueOf(linea);
                        break;
                    }
                    case 2: {
                        this.inheritsFrom = Integer.valueOf(linea);
                        if (this.inheritsFrom >= this.idnumber || inheritance_done) break;
                        this.constructRoom(mundo, Utility.roomFile(mundo, this.inheritsFrom));
                        inheritance_done = true;
                        this.constructRoom(mundo, roomfile);
                        return;
                    }
                    case 3: {
                        this.setNewState(Integer.valueOf(linea));
                        break;
                    }
                    case 4: {
                        this.title = linea;
                        break;
                    }
                    case 10: {
                        this.descriptionList = Utility.loadDescriptionListFromString(linea);
                        break;
                    }
                    case 11: {
                        this.standardExits = new Path[10];
                        if (StringMethods.numToks(linea, '@') < 10) {
                            System.out.println("[SINTAXIS] l\u00ednea 10 (" + roomfile + ") insuficientes tokens con @");
                        }
                        int i = 0;
                        while (i < 10) {
                            String curToken = StringMethods.getTok(linea, i + 1, '@');
                            this.standardExits[i] = new Path(mundo, true, curToken);
                            ++i;
                        }
                        break;
                    }
                    case 12: {
                        this.otherExits = new Path[StringMethods.numToks(linea, '@')];
                        int i = 0;
                        while (i < this.otherExits.length) {
                            String curToken = StringMethods.getTok(linea, i + 1, '@');
                            this.otherExits[i] = new Path(mundo, false, curToken);
                            ++i;
                        }
                        break;
                    }
                    case 20: {
                        int nObjects = StringMethods.numToks(linea, '$');
                        this.itemsInRoom = new Inventory(1000000, 1000000, nObjects);
                        int i = 0;
                        while (i < nObjects) {
                            try {
                                this.itemsInRoom.addItem(mundo.getItem(StringMethods.getTok(linea, i + 1, '$')));
                            }
                            catch (WeightLimitExceededException exc) {
                                mundo.escribir("Item too heavy for room");
                            }
                            catch (VolumeLimitExceededException exc2) {
                                mundo.escribir("Item too big for room");
                            }
                            ++i;
                        }
                        break;
                    }
                    case 21: {
                        int nObjects = StringMethods.numToks(linea, '$');
                        this.mobsInRoom = new MobileList();
                        int i = 0;
                        while (i < nObjects) {
                            Mobile ourMob = mundo.getMob(StringMethods.getTok(linea, i + 1, '$'));
                            this.mobsInRoom.addElement(ourMob);
                            ourMob.setRoom(this);
                            ourMob.setRoom(this);
                            ++i;
                        }
                        break;
                    }
                    case 30: {
                        this.extraDescriptions = linea;
                        break;
                    }
                    case 80: {
                        String EVACodeString = linea;
                        boolean terminamos = false;
                        while (!terminamos) {
                            int intval;
                            linea = filein.readLine();
                            id_linea = StringMethods.getTok(linea, 1, ' ');
                            try {
                                intval = Integer.valueOf(id_linea);
                            }
                            catch (NumberFormatException e) {
                                intval = 0;
                            }
                            if (intval == 81) {
                                terminamos = true;
                                continue;
                            }
                            EVACodeString = String.valueOf(EVACodeString) + "\n";
                            EVACodeString = String.valueOf(EVACodeString) + linea;
                        }
                        this.itsCode = new ObjectCode(EVACodeString, "EVA", mundo);
                        break;
                    }
                    case 84: {
                        String bshCodeString = linea;
                        boolean terminamos = false;
                        while (!terminamos) {
                            int intval;
                            linea = filein.readLine();
                            id_linea = StringMethods.getTok(linea, 1, ' ');
                            try {
                                intval = Integer.valueOf(id_linea);
                            }
                            catch (NumberFormatException e) {
                                intval = 0;
                            }
                            if (intval == 85) {
                                terminamos = true;
                                continue;
                            }
                            bshCodeString = String.valueOf(bshCodeString) + "\n";
                            bshCodeString = String.valueOf(bshCodeString) + linea;
                        }
                        this.itsCode = new ObjectCode(bshCodeString, "BeanShell", mundo);
                    }
                }
            }
            ++line;
        }
        if (this.getID() < 10000000) {
            this.idnumber += 10000000;
        }
    }

    public void constructRoom(World mundo, Node n, boolean allowInheritance) throws XMLtoWorldException {
        NodeList moblistNodes;
        int i;
        this.lenguaje = mundo.getLang();
        if (!(n instanceof Element)) {
            throw new XMLtoWorldException("Room node not Element");
        }
        Element e = (Element)n;
        if (e.hasAttribute("extends") && !e.getAttribute("extends").equals("0") && allowInheritance) {
            this.constructRoom(mundo, mundo.getRoomNode(e.getAttribute("extends")), true);
            this.constructRoom(mundo, n, false);
        }
        if (!e.hasAttribute("name")) {
            throw new XMLtoWorldException("Room node lacks attribute name");
        }
        try {
            if (e.hasAttribute("id")) {
                this.idnumber = Integer.valueOf(e.getAttribute("id"));
            }
        }
        catch (NumberFormatException nfe) {
            throw new XMLtoWorldException("Bad number format at attribute id in mobile node");
        }
        this.title = e.getAttribute("name");
        this.readPropListFromXML(mundo, n);
        this.descriptionList = Utility.loadDescriptionListFromXML(mundo, e, "DescriptionList", true);
        NodeList pathListNodes = e.getElementsByTagName("PathList");
        if (pathListNodes.getLength() > 0) {
            Element pathListNode = (Element)pathListNodes.item(0);
            NodeList pathNodes = pathListNode.getElementsByTagName("Path");
            int nNonStandard = 0;
            int i2 = 0;
            while (i2 < pathNodes.getLength()) {
                Element curNode = (Element)pathNodes.item(i2);
                if (!Boolean.valueOf(curNode.getAttribute("standard")).booleanValue() || curNode.getElementsByTagName("CommandList").getLength() > 0) {
                    ++nNonStandard;
                }
                ++i2;
            }
            this.standardExits = new Path[10];
            this.otherExits = new Path[nNonStandard];
            int nonStandardExitCounter = 0;
            i = 0;
            while (i < pathNodes.getLength()) {
                Element curNode = (Element)pathNodes.item(i);
                Path p = new Path(mundo, curNode);
                System.out.println("Path " + i + " for room " + this.getID());
                if (p.isStandard()) {
                    int direccion = Path.nameToDirection(curNode.getAttribute("direction"));
                    this.standardExits[direccion] = p;
                    if (p.isExtended()) {
                        this.otherExits[nonStandardExitCounter] = p;
                        ++nonStandardExitCounter;
                    }
                } else {
                    this.otherExits[nonStandardExitCounter] = p;
                    ++nonStandardExitCounter;
                }
                ++i;
            }
        } else {
            this.standardExits = new Path[10];
            this.otherExits = new Path[0];
        }
        int i3 = 0;
        while (i3 < this.standardExits.length) {
            if (this.standardExits[i3] == null) {
                this.standardExits[i3] = new Path(mundo, true, "0");
            }
            ++i3;
        }
        NodeList inventoryNodes = e.getElementsByTagName("Inventory");
        ArrayList<Node> realInventoryNodes = new ArrayList<Node>();
        int i4 = 0;
        while (i4 < inventoryNodes.getLength()) {
            if (inventoryNodes.item(i4).getParentNode() == e) {
                realInventoryNodes.add(inventoryNodes.item(i4));
            }
            ++i4;
        }
        this.itemsInRoom = realInventoryNodes.size() < 1 ? null : new Inventory(mundo, (Node)realInventoryNodes.get(0));
        if (this.itemsInRoom != null) {
            i4 = 0;
            while (i4 < this.itemsInRoom.size()) {
                Item cur = this.itemsInRoom.elementAt(i4);
                cur.addRoomReference(this);
                ++i4;
            }
        }
        if ((moblistNodes = e.getElementsByTagName("MobileList")).getLength() < 1) {
            this.mobsInRoom = new MobileList();
        } else {
            this.mobsInRoom = new MobileList(mundo, moblistNodes.item(0));
            if (this.mobsInRoom == null) {
                this.mobsInRoom = new MobileList();
            }
            MobileList copiaMobsInRoom = new MobileList(mundo, moblistNodes.item(0));
            i = 0;
            while (i < copiaMobsInRoom.size()) {
                Mobile ourMob = copiaMobsInRoom.elementAt(i);
                System.out.println("i= " + i + ": Setting room on mob " + ourMob + " to " + this);
                ourMob.setRoom(this);
                ourMob.setRoom(this);
                ++i;
            }
        }
        List temp = Utility.loadExtraDescriptionsFromXML(mundo, e, "ExtraDescriptionList", true);
        if (temp == null || temp.size() < 2) {
            this.extraDescriptionArrays = new ArrayList();
            this.extraDescriptionNameArrays = new ArrayList();
        } else {
            this.extraDescriptionArrays = (List)temp.get(1);
            this.extraDescriptionNameArrays = (List)temp.get(0);
        }
        NodeList codeNodes = e.getElementsByTagName("Code");
        if (codeNodes.getLength() > 0) {
            try {
                this.itsCode = new ObjectCode(mundo, codeNodes.item(0));
            }
            catch (XMLtoWorldException ex) {
                throw new XMLtoWorldException("Exception at Code node: " + ex.getMessage());
            }
        }
        if (this.getID() != 0 && this.getID() < 10000000) {
            this.idnumber += 10000000;
        }
        try {
            boolean ejecutado = this.execCode("onInit", new Object[0]);
        }
        catch (TargetError te) {
            te.printStackTrace();
        }
    }

    public void setID(int newid) {
        this.idnumber = newid < 10000000 ? newid + 10000000 : newid;
    }

    public boolean isValidExit(boolean isStandard, int exitn) {
        if (isStandard) {
            return this.standardExits[exitn].isValid();
        }
        System.out.println("Other Exits: " + this.otherExits);
        System.out.println("" + exitn);
        int i = 0;
        while (i < this.otherExits.length) {
            System.out.println(this.otherExits[i]);
            ++i;
        }
        return this.otherExits[exitn].isValid();
    }

    public Path[] getValidExits() {
        ArrayList<Path> caminos = new ArrayList<Path>();
        int i = 0;
        while (i < this.standardExits.length) {
            if (this.standardExits[i].isValid()) {
                caminos.add(this.standardExits[i]);
            }
            ++i;
        }
        i = 0;
        while (i < this.otherExits.length) {
            if (this.otherExits[i].isValid()) {
                caminos.add(this.otherExits[i]);
            }
            ++i;
        }
        Path[] caminos_ar = new Path[caminos.size()];
        int i2 = 0;
        while (i2 < caminos_ar.length) {
            caminos_ar[i2] = (Path)caminos.get(i2);
            ++i2;
        }
        return caminos_ar;
    }

    public Path getExit(boolean isStandard, int exitn) {
        if (isStandard) {
            return this.standardExits[exitn];
        }
        return this.otherExits[exitn];
    }

    public Path getPath(boolean isStandard, int exitn) {
        return this.getExit(isStandard, exitn);
    }

    public Path[] getStandardExits() {
        return this.standardExits;
    }

    public Path[] getNonStandardExits() {
        return this.otherExits;
    }

    public int getRandomValidExitAsNumber() {
        int nvalid_standard = 0;
        int nvalid_nonstandard = 0;
        int i = 0;
        while (i < this.standardExits.length) {
            if (this.isValidExit(true, i)) {
                ++nvalid_standard;
            }
            ++i;
        }
        i = 0;
        while (i < this.otherExits.length) {
            if (this.isValidExit(false, i)) {
                ++nvalid_nonstandard;
            }
            ++i;
        }
        if (nvalid_standard + nvalid_nonstandard < 1) {
            return -1;
        }
        int numsalida = this.aleat.nextInt(nvalid_standard + nvalid_nonstandard);
        int i2 = 0;
        while (i2 < this.standardExits.length && i2 < numsalida) {
            if (!this.isValidExit(true, i2)) continue;
            ++i2;
        }
        if (i2 == numsalida) {
            return i2 - 1;
        }
        int j = i2;
        while (j - i2 < this.otherExits.length && j < numsalida) {
            if (!this.isValidExit(false, j - i2)) continue;
            ++j;
        }
        return 10 + j - i2 - 1;
    }

    public Path getRandomValidExit() {
        int nsal = this.getRandomValidExitAsNumber();
        if (nsal < 0) {
            return null;
        }
        if (nsal < 10) {
            return this.standardExits[nsal];
        }
        return this.otherExits[10 - nsal];
    }

    public String getExitName(boolean isStandard, int exitn) {
        if (isStandard) {
            switch (exitn) {
                case 0: {
                    return "el norte";
                }
                case 1: {
                    return "el sur";
                }
                case 3: {
                    return "el este";
                }
                case 2: {
                    return "el oeste";
                }
            }
            return "alg\u00fan lado";
        }
        return this.otherExits[exitn].getNonStandardName();
    }

    public String getExitName(Path p) {
        if (p.isStandard()) {
            int exitn = 0;
            while (exitn < this.standardExits.length) {
                if (this.standardExits[exitn] == p) break;
                ++exitn;
            }
            return this.getExitName(true, exitn);
        }
        return p.getNonStandardName();
    }

    public int getID() {
        return this.idnumber;
    }

    public int getItsID() {
        return this.idnumber;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription(long comparand) {
        String desString = "";
        int i = 0;
        while (i < this.descriptionList.length) {
            if (this.descriptionList[i].matches(comparand)) {
                desString = String.valueOf(desString) + this.descriptionList[i].getText();
            }
            ++i;
        }
        if (this.itemsInRoom != null && !this.itemsInRoom.isEmpty() && !this.itemsInRoom.toString().equals("nada.")) {
            desString = String.valueOf(desString) + "\nAqu\u00ed hay ";
            desString = String.valueOf(desString) + this.itemsInRoom.toString();
        }
        if (this.mobsInRoom != null && !this.mobsInRoom.isEmpty() && !this.mobsInRoom.toString().equals("nada.")) {
            desString = this.mobsInRoom.size() > 1 ? String.valueOf(desString) + "\nAqu\u00ed est\u00e1n " : String.valueOf(desString) + "\nAqu\u00ed est\u00e1 ";
            desString = String.valueOf(desString) + this.mobsInRoom.toString();
        }
        return desString;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getDescription(Entity viewer) {
        boolean quitado;
        String desString;
        block15: {
            if (!this.getDescription_bsh_call) {
                boolean ejecutado;
                block14: {
                    ejecutado = false;
                    ReturnValue retval = new ReturnValue(null);
                    try {
                        try {
                            this.getDescription_bsh_call = true;
                            ejecutado = this.execCode("getDescription", new Object[]{viewer}, retval);
                        }
                        catch (TargetError te) {
                            te.printStackTrace();
                        }
                    }
                    catch (Throwable throwable) {
                        Object var5_9 = null;
                        this.getDescription_bsh_call = false;
                        throw throwable;
                    }
                    {
                        Object var5_10 = null;
                        this.getDescription_bsh_call = false;
                        if (retval.getRetVal() == null) break block14;
                    }
                    return (String)retval.getRetVal();
                }
                if (ejecutado) {
                    return null;
                }
            }
            desString = "";
            quitado = false;
            int i = 0;
            while (true) {
                if (i >= this.descriptionList.length) {
                    if (this.itemsInRoom != null && !this.itemsInRoom.isEmpty() && !this.itemsInRoom.toString(viewer).equals("nada.")) {
                        desString = String.valueOf(desString) + "\nAqu\u00ed hay ";
                        desString = String.valueOf(desString) + this.itemsInRoom.toString(viewer);
                    }
                    if (this.mobsInRoom != null && viewer instanceof Mobile) {
                        quitado = this.mobsInRoom.removeElement((Mobile)viewer);
                    }
                    if (this.mobsInRoom != null && !this.mobsInRoom.isEmpty() && !this.mobsInRoom.toString(viewer).equals("nada.")) {
                        desString = this.mobsInRoom.size() > 1 ? String.valueOf(desString) + "\nAqu\u00ed est\u00e1n " : String.valueOf(desString) + "\nAqu\u00ed est\u00e1 ";
                    }
                    break block15;
                }
                if (this.descriptionList[i].matchesConditions(this, viewer)) {
                    desString = String.valueOf(desString) + this.descriptionList[i].getText();
                }
                ++i;
            }
            desString = String.valueOf(desString) + this.mobsInRoom.toString(viewer);
        }
        if (quitado) {
            this.mobsInRoom.addElement((Mobile)viewer);
        }
        return desString;
    }

    public String getDescription(long comparand, Mobile toExclude) {
        String desString = "";
        int i = 0;
        while (i < this.descriptionList.length) {
            if (this.descriptionList[i].matches(comparand)) {
                desString = String.valueOf(desString) + this.descriptionList[i].getText();
            }
            ++i;
        }
        if (this.itemsInRoom != null && !this.itemsInRoom.isEmpty() && !this.itemsInRoom.toString().equals("nada.")) {
            desString = String.valueOf(desString) + "\nAqu\u00ed hay ";
            desString = String.valueOf(desString) + this.itemsInRoom.toString();
        }
        boolean quitado = false;
        if (this.mobsInRoom != null) {
            quitado = this.mobsInRoom.removeElement(toExclude);
        }
        if (this.mobsInRoom != null && !this.mobsInRoom.isEmpty() && !this.mobsInRoom.toString().equals("nada.")) {
            desString = this.mobsInRoom.size() > 1 ? String.valueOf(desString) + "\nAqu\u00ed est\u00e1n " : String.valueOf(desString) + "\nAqu\u00ed est\u00e1 ";
            desString = String.valueOf(desString) + this.mobsInRoom.toString();
        }
        if (quitado) {
            this.mobsInRoom.addElement(toExclude);
        }
        return desString;
    }

    public String getExtraDescription(String thingieName, Entity viewer) {
        int i = 0;
        while (i < this.extraDescriptionNameArrays.size()) {
            String[] curNameArray = (String[])this.extraDescriptionNameArrays.get(i);
            Description[] curDesArray = (Description[])this.extraDescriptionArrays.get(i);
            int j = 0;
            while (j < curNameArray.length) {
                if (StringMethods.getTok(thingieName, StringMethods.numToks(thingieName, ' '), ' ').equalsIgnoreCase(curNameArray[j])) {
                    String desString = "";
                    int k = 0;
                    while (k < curDesArray.length) {
                        if (curDesArray[k].matchesConditions(this, viewer)) {
                            desString = String.valueOf(desString) + "\n";
                            desString = String.valueOf(desString) + curDesArray[k].getText();
                        }
                        ++k;
                    }
                    if (desString.length() > 0) {
                        return desString.substring(1);
                    }
                    return null;
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    public void changeState(World mundo) {
    }

    public void addItem(Item nuevo) throws WeightLimitExceededException, VolumeLimitExceededException {
        if (this.itemsInRoom == null) {
            this.itemsInRoom = new Inventory(100000, 100000, 1);
        }
        this.itemsInRoom.addItem(nuevo);
        nuevo.addRoomReference(this);
    }

    public boolean removeItem(Item viejo) {
        if (this.itemsInRoom == null) {
            return false;
        }
        viejo.removeRoomReference(this);
        return this.itemsInRoom.removeItem(viejo);
    }

    public void addMob(Mobile nuevo) {
        if (this.mobsInRoom == null) {
            this.mobsInRoom = new MobileList();
        }
        this.mobsInRoom.addElement(nuevo);
        System.out.println("Mobs In Roome After Addendum " + this.mobsInRoom);
    }

    public boolean removeMob(Mobile viejo) {
        if (this.mobsInRoom == null) {
            return false;
        }
        return this.mobsInRoom.removeElement(viejo);
    }

    public boolean execCode(String routine, String dataSegment) throws EVASemanticException {
        if (this.itsCode != null) {
            return this.itsCode.run(routine, dataSegment);
        }
        return false;
    }

    public boolean execCode(String routine, Object[] args) throws TargetError {
        if (this.itsCode != null) {
            return this.itsCode.run(routine, this, args);
        }
        return false;
    }

    public boolean execCode(String routine, Object[] args, ReturnValue retval) throws TargetError {
        if (this.itsCode != null) {
            return this.itsCode.run(routine, this, args, retval);
        }
        return false;
    }

    public String personalizeDescription(String des, Mobile source, Mobile target) {
        String nombre;
        String s = des;
        if (source != null) {
            nombre = source.constructName2(1, null);
            if (nombre == null) {
                nombre = "alguien";
            }
            s = StringMethods.textualSubstitution(s, "$1", nombre);
        }
        if (target != null) {
            nombre = target.constructName2(1, null);
            if (nombre == null) {
                nombre = "alguien";
            }
            s = StringMethods.textualSubstitution(s, "$2", nombre);
        }
        return s;
    }

    public String personalizeDescription(String des, Entity viewer, Nameable[] dollarEntities) {
        String s = des;
        int i = 0;
        while (i < dollarEntities.length) {
            if (dollarEntities[i] != null) {
                String nombre = dollarEntities[i].constructName2(1, viewer);
                if (nombre == null || dollarEntities[i].isInvisible(viewer)) {
                    nombre = dollarEntities[i] instanceof Mobile ? "alguien" : "algo";
                }
                s = StringMethods.textualSubstitution(s, "$" + (i + 1), nombre);
            }
            ++i;
        }
        return this.lenguaje.gramaticalizarSinTrimear(s);
    }

    public void informAction(Entity source, Entity target, Entity[] objects, String thirdPersonDes, String sufferDes, String execDes, boolean self_included) {
        Mobile actual;
        int i;
        Nameable[] dollarEntities = objects == null ? new Nameable[2] : new Nameable[2 + objects.length];
        dollarEntities[0] = (Nameable)((Object)source);
        dollarEntities[1] = (Nameable)((Object)target);
        if (objects != null) {
            i = 0;
            while (i < objects.length) {
                dollarEntities[2 + i] = (Nameable)((Object)objects[i]);
                ++i;
            }
        }
        i = 0;
        while (i < this.mobsInRoom.size()) {
            actual = this.mobsInRoom.elementAt(i);
            if (actual == source && execDes != null && self_included) {
                if (actual instanceof Informador) {
                    actual.escribir(this.personalizeDescription(execDes, (Entity)actual, dollarEntities));
                }
            } else if (actual == target && sufferDes != null) {
                if (actual instanceof Informador) {
                    actual.escribir(this.personalizeDescription(sufferDes, (Entity)actual, dollarEntities));
                }
            } else if (thirdPersonDes != null && actual != source && actual != target && actual instanceof Informador) {
                actual.escribir(this.personalizeDescription(thirdPersonDes, (Entity)actual, dollarEntities));
            }
            ++i;
        }
        i = 0;
        while (i < this.mobsInRoom.size()) {
            actual = this.mobsInRoom.elementAt(i);
            if (actual == source && execDes != null && self_included) {
                actual.reactToRoomText(this.personalizeDescription(execDes, (Entity)actual, dollarEntities));
            } else if (actual == target && sufferDes != null) {
                actual.reactToRoomText(this.personalizeDescription(sufferDes, (Entity)actual, dollarEntities));
            } else if (thirdPersonDes != null) {
                actual.reactToRoomText(this.personalizeDescription(thirdPersonDes, (Entity)actual, dollarEntities));
            }
            ++i;
        }
        try {
            this.execCode("onRoomText", new Object[]{this.personalizeDescription(thirdPersonDes, null, dollarEntities)});
        }
        catch (TargetError te) {
            System.err.println(te);
            te.printStackTrace();
        }
    }

    public void informActionAuto(Entity source, Entity target, Entity[] objects, String thirdPersonDes, boolean self_included) {
        System.out.println("Autoinforming " + thirdPersonDes + " at roome " + this.getID() + ":" + this.getTitle());
        StringTokenizer st = new StringTokenizer(thirdPersonDes, " ", true);
        String execDes = "";
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            if (tok.equals("$1")) {
                if (!st.hasMoreTokens()) continue;
                execDes = String.valueOf(execDes) + st.nextToken();
                if (!st.hasMoreTokens()) continue;
                String posibleVerbo = st.nextToken();
                String segundaPers = this.lenguaje.terceraASegunda(posibleVerbo);
                if (segundaPers != null) {
                    execDes = String.valueOf(execDes) + segundaPers;
                    continue;
                }
                execDes = String.valueOf(execDes) + posibleVerbo;
                continue;
            }
            execDes = String.valueOf(execDes) + tok;
        }
        execDes = String.valueOf(execDes) + "a";
        execDes = execDes.trim();
        execDes = execDes.substring(0, execDes.length() - 1);
        String sufferDes = null;
        System.out.println("Gonna deft'ly call informAction");
        this.informAction(source, target, objects, thirdPersonDes, sufferDes, execDes, self_included);
    }

    public void informAction(Mobile source, Mobile target, String thirdPersonDes, String sufferDes, String execDes, boolean self_included) {
        this.informAction(source, target, null, thirdPersonDes, sufferDes, execDes, self_included);
    }

    public void informActionAuto(Mobile source, Mobile target, String thirdPersonDes, boolean self_included) {
        this.informActionAuto(source, target, null, thirdPersonDes, self_included);
    }

    public void loadNumberGenerator(World mundo) {
        this.aleat = mundo.getRandom();
    }

    public boolean hasItem(Item it) {
        return this.itemsInRoom.contains(it);
    }

    public boolean hasMobile(Mobile m) {
        return this.mobsInRoom.contains(m);
    }

    public Inventory getInventory() {
        if (this.itemsInRoom == null) {
            this.itemsInRoom = new Inventory(10000, 10000);
        }
        return this.itemsInRoom;
    }

    public Inventory getContents() {
        return this.getInventory();
    }

    public MobileList getMobiles() {
        if (this.mobsInRoom == null) {
            this.mobsInRoom = new MobileList();
        }
        return this.mobsInRoom;
    }

    public Node getXMLRepresentation(Document doc) {
        Element suElemento = doc.createElement("Room");
        suElemento.setAttribute("id", String.valueOf(this.idnumber));
        suElemento.setAttribute("name", String.valueOf(this.title));
        suElemento.setAttribute("extends", String.valueOf(this.inheritsFrom));
        suElemento.appendChild(this.getPropListXMLRepresentation(doc));
        suElemento.appendChild(this.getRelationshipListXMLRepresentation(doc));
        Element listaDesc = doc.createElement("DescriptionList");
        int i = 0;
        while (i < this.descriptionList.length) {
            Description nuestraDescripcion = this.descriptionList[i];
            listaDesc.appendChild(nuestraDescripcion.getXMLRepresentation(doc));
            ++i;
        }
        suElemento.appendChild(listaDesc);
        Element listaSal = doc.createElement("PathList");
        if (this.standardExits != null) {
            int i2 = 0;
            while (i2 < this.standardExits.length) {
                if (this.standardExits[i2] != null) {
                    listaSal.appendChild(this.standardExits[i2].getXMLRepresentation(doc, Path.directionName(i2)));
                }
                ++i2;
            }
        }
        if (this.otherExits != null) {
            int i3 = 0;
            while (i3 < this.otherExits.length) {
                if (this.otherExits[i3] != null && !this.otherExits[i3].isExtended()) {
                    listaSal.appendChild(this.otherExits[i3].getXMLRepresentation(doc));
                }
                ++i3;
            }
        }
        suElemento.appendChild(listaSal);
        if (this.itemsInRoom != null) {
            suElemento.appendChild(this.itemsInRoom.getXMLRepresentation(doc));
        }
        if (this.mobsInRoom != null) {
            suElemento.appendChild(this.mobsInRoom.getXMLRepresentation(doc));
        }
        if (this.extraDescriptions != null) {
            Element extraDes = doc.createElement("ExtraDescriptionList");
            StringTokenizer st1 = new StringTokenizer(this.extraDescriptions, "@");
            while (st1.hasMoreTokens()) {
                String desActual = st1.nextToken();
                Element unaDescripcion = doc.createElement("ExtraDescription");
                StringTokenizer st2 = new StringTokenizer(desActual, "$");
                while (st2.hasMoreTokens()) {
                    String wordActual = st2.nextToken();
                    if (st2.hasMoreTokens()) {
                        Element comando = doc.createElement("Name");
                        Text contenido = doc.createTextNode(wordActual);
                        comando.appendChild(contenido);
                        unaDescripcion.appendChild(comando);
                        continue;
                    }
                    Text texto = doc.createTextNode(wordActual);
                    unaDescripcion.appendChild(texto);
                }
                extraDes.appendChild(unaDescripcion);
            }
            suElemento.appendChild(extraDes);
        }
        if (this.itsCode != null) {
            suElemento.appendChild(this.itsCode.getXMLRepresentation(doc));
        }
        return suElemento;
    }

    public Inventory getFlattenedInventory() {
        if (this.itemsInRoom == null) {
            return new Inventory(1, 1);
        }
        Inventory result = new Inventory(this.itemsInRoom.getWeightLimit(), this.itemsInRoom.getVolumeLimit());
        int i = 0;
        while (i < this.itemsInRoom.size()) {
            Item thisPart = this.itemsInRoom.elementAt(i);
            Inventory subInv = thisPart.getFlattenedInventory();
            try {
                result.setVolumeLimit(result.getVolumeLimit() + subInv.getVolumeLimit());
                result.setWeightLimit(result.getWeightLimit() + subInv.getWeightLimit());
            }
            catch (Exception e) {
                System.out.println("Impossible exception thrown: " + e);
                e.printStackTrace();
            }
            int j = 0;
            while (j < subInv.size()) {
                try {
                    result.addItem(subInv.elementAt(j));
                }
                catch (Exception e) {
                    System.out.println("Impossible exception thrown: " + e);
                    e.printStackTrace();
                }
                ++j;
            }
            try {
                result.addItem(thisPart);
            }
            catch (Exception e) {
                System.out.println("Impossible exception thrown: " + e);
                e.printStackTrace();
            }
            ++i;
        }
        return result;
    }

    public void copyRoomFieldsTo(Room r) {
        r.copyEntityFields(this);
        r.aleat = this.getRandom();
        r.extraDescriptions = this.extraDescriptions;
        r.idnumber = this.idnumber;
        r.inheritsFrom = this.inheritsFrom;
        r.itemsInRoom = this.itemsInRoom != null ? (Inventory)this.itemsInRoom.clone() : null;
        r.itsCode = this.itsCode.cloneIfNecessary();
        r.title = this.title;
        r.descriptionList = new Description[this.descriptionList.length];
        int i = 0;
        while (i < r.descriptionList.length) {
            r.descriptionList[i] = (Description)this.descriptionList[i].clone();
            ++i;
        }
        r.lenguaje = this.lenguaje;
        r.mobsInRoom = this.mobsInRoom != null ? (MobileList)this.mobsInRoom.clone() : null;
        r.standardExits = new Path[this.standardExits.length];
        i = 0;
        while (i < this.standardExits.length) {
            r.standardExits[i] = this.standardExits[i] != null ? (Path)this.standardExits[i].clone() : null;
            ++i;
        }
        r.otherExits = new Path[this.otherExits.length];
        i = 0;
        while (i < this.otherExits.length) {
            r.otherExits[i] = this.otherExits[i] != null ? (Path)this.otherExits[i].clone() : null;
            ++i;
        }
        r.extraDescriptionArrays = this.extraDescriptionArrays;
        r.extraDescriptionNameArrays = this.extraDescriptionNameArrays;
    }

    public Random getRandom() {
        return this.aleat;
    }

    public Room createNewInstance(World mundo, boolean cloneContents) {
        Room r = (Room)this.clone();
        r.inheritsFrom = this.idnumber;
        mundo.addRoomAssigningID(r);
        return r;
    }

    public Object clone() {
        Room r = new Room();
        this.copyRoomFieldsTo(r);
        return r;
    }

    public Room() {
    }
}

