#charset "us-ascii"

#include <adv3.h>
#include <en_us.h>
#include <SquareCircle.h>

 /*
  *  books.t contains the code for the three books found in the cell at the start
  *  of the game, and the Book class which defines their common handling.
  */

blueBook : CanRub, Book 'theories crime punishment dark blue spine/book*books' 
  'dark blue book' @bookcase
  "The title on the spine is <i>Modern Theories of Crime and Punishment.</i> "
  readDesc { readBook.doScript;   }
  readBook : CyclicEventList { [
  'You open the book at random and read:\b
  Prisoners who accept their punishment without demur have clearly accepted their guilt. It
  follows that their punishment is just, whatever it may be, for as long as they accept it.
  Prisoners who question their punishment are doubting the wisdom and honesty of their
  judges; they are therefore rebels against society and absolutely deserve to be punished.\b
  This demonstrates one of the foundational theses of modern penal theory: it is not simply
  that crime must lead to punishment, it is that the fact of being punished establishes as
  a matter of certainty that one is guilty of some crime.\b
  Glancing at the back of the book just before you close it, you find that there\'s
  an index, so you could look up specific topics in the book. ',
  
  'It\'s a long book to read all the way through, but there\'s a good index at the
   back that would allow you readily to consult it on particular topics. ',
   
  'You again open the book at random and read:\b
    One major aim of the modern justice and penal system is to reduce the incidence of crime.
    The strategy for bringing this about has three principal elements: first and foremost,
    the great majority of citizens must be continually educated and encouraged in law
    abiding practices (which may be simply defined as obedience to the dictates of reason
    -- as defined by state officials, of course); second, punishment must be painful
    enough to be a genuine deterrent; third, the re-offending rate is to be reduced to
    zero by ensuring that criminals are given no opportunity to re-offend. '  
   
   ]
  }  
  willNotLetGoMsg(holder, obj)
  {
    gMessageParams(obj);
    if(holder == receptionist)
      return 'You\'ve only just given {the obj/him} to {the receptionist/her} -- it would
        be rude to snatch it back. ';
    else
      return inherited(holder, obj);
  }
  
  sightSize = small
;

+ blueIndex : BookIndex '(blue) book\'s (book) index/contents' 'blue book\'s index'
  "The index lists a number of topics you can look up in the blue book, including:
  Crime, Evidence, Guilt, the New Enlightenment, Judge, Jury, Justice, Law, Lawyer, Prevention, 
  Prison, Prisoners, Punishment, Reason, Trial, and Witness."   
;

+ ConsultTopic @t_prison
  "Prison has two enormous benefits in any system of rational justice: first, it removes
   criminals from circulation and thus protects society from their pernicious influence,
   and second, it provides an extended period of time during which criminals may be
   made to suffer for their crimes. A prison sentence may be of indefinite duration,
   thus keeping the prisoner in a state of helpful uncertainty. Incarceration -- the
   denial of liberty and the imposition of uncomfortable or painful conditions -- is not
   only useful as a punishment in itself, but it also allows criminals to be punished
   away from the public eye, thereby avoiding any misplaced distress at or sympathy
   for their suffering. "
;

+ ConsultTopic @t_prisoner
  "It is sometimes said that the previous regime made far too much of prisoners'
   rights while we have now rightfully abolished them. This is an oversimplification.
   All prisoners retain the right to suffer, which is the right to take moral
   responsibility for their actions, and hence to be taken seriously as a human
   being. By granting prisoners the right to suffer fully for their crimes, the
   modern theory of justice thus takes their rights <i>more</i> seriously than
   before. Previous theories simply mistook sentimentality for justice, and 
   feeble indulgence for human rights. "
;

+ ConsultTopic @t_punishment
  "Previous penal theories have supposed that the punishment should be proportionate to
   the crime. This is erroneous, since it overlooks the fact that what is being punished
   is not the crime, but the person, and that the person is being punished not simply
   for having committed this or that crime, but for being a criminal. For as long as
   one is a criminal, one deserves to be punished -- there is therefore no limit to the
   punishment that may justly be applied.\b
   A further error of many penal theories was to suppose that the primary purpose of
   punishment was either deterrence or correction. This is not so -- such theories of
   punishment are inherently manipulative and deny the dignity of the human person. The
   purpose of punishment is simply to punish, that is to make criminals suffer for what
   they are. If in practice the punishments our society inflicts are finite in intensity
   and duration, that is because we are a fundamentally humane society and prefer to 
   temper justice with mercy. "   
;

+ ConsultTopic @t_mercy
  "At first sight there should be no place for <i>mercy</i> in the New Enlightenment
   dispensation, since the concept would seem to be irrational. By definition, <i>mercy</i>
   connotes treating someone more generously, or less harshly, than they deserve, and
   such disproportionality between desert and reward appears to offend against basic rational
   principles. But this is to ignore the psychological manipulation of the criminal that
   the promise -- or at least hope -- of mercy can allow. Since such manipulation can
   be in the interests of society, it would, in fact, be irrational for the penal 
   authorities to deny themselves the use of it. "
;

+ ConsultTopic @t_crime
  "Before the New Enlightenment that has recently revolutionised our society, it used to
   be held that a crime had to be defined in terms of a provable infraction of some
   law or other. We have now come to see the obvious fallacy in this; it is not that
   crimes defined under the old way of seeing things were excusable, it is that such
   a legalistic way of looking at things disguises the fact that the <i>real</i> crime
   is that of being a criminal person.\bThe commission of individual criminal acts is clearly
   a sufficient condition for being such a person, but it is not a necessary condition,
   since there is always a first criminal act for everyone, and yet the person who
   intended the criminal act was already a criminal in thought before their first criminal act
   was actually committed in deed. It has thus now become clear that the <i>real</i>
   crime is the possibility that one might plan to commit some specific act in the future.
   It is <i>this</i> crime that our new penal regime aims to stamp out.\b
   By these means we can often detain and punish criminals before they can inflict any
   actual criminal acts on our society. The system is new but the underlying idea is
   old: <q>Prevention is better than cure.</q><.reveal new-enlightenment>"
;

+ ConsultTopic @t_justice
  "Old fashioned theories of justice used to suppose that a <q>fair trial</q> had
   to involve costly, time-wasting procedures such as the examining of witnesses, the weighing 
   of evidence, and the employment of overpaid advocates using their rhetorical
   skills on gullible juries. Not only was this system expensive and cumbersome to run, but
   it often produced miscarriages of justice, and was manifestly unfair to those who could
   not afford the best legal representation.\b
   Matters are now much improved under the New Enlightenment. All accused persons are treated
   exactly the same, and all trials are swift, cheap, and just. In each trial the judge simply
   asks <q>Are you innocent?</q> If the accused answers <q>No</q> the judge accepts the confession
   of guilt and pronounces the sentence due to any self-confessed criminal. If the accused
   answers <q>Yes</q> then the judge passes sentence for perjury, since it is clear that there
   is no such thing as a wholly innocent person. If the person declines to answer either <q>Yes</q>
   or <q>No</q> they are convicted and sentenced for contempt of court. Since equality of
   outcome is assured, there can be no question of the accused being placed under duress to
   give one response in preference to another, with the result that justice is not only done,
   but seen to be done.<.reveal new-enlightenment>"
;

+ ConsultTopic @t_law
  "The New Enlightenment has radically simplified the law and done away with the parasitical
   profession of lawyers. This radical streamlining has allowed the small team of judges
   that remain to handle cases swiftly and efficiently, without the pettifogging arguments
   of overpaid defense barristers being allowed to impede the course of justice, or any
   fear that criminal elements might attempt to intimidate members of that desperately
   outmoded institution, the jury.\b
   Before the reforms, criminal law was becoming so convoluted that no one could understand
   it; now everyone can. All previous statutes and precedents have been swept away to be
   replaced by one simple statute that everyone can understand; from now on our entire
   criminal justice system can be summed up in this one simple sentence:\b
   <q>Whoever society considers to be a criminal is a criminal.</q>\b
   It is, of course, the task of our judges to perform the relevant considering on
   society's behalf.<.reveal new-enlightenment> "
;

+ ConsultTopic @t_lawyer
  "Lawyers were a useless breed of parasites who enriched themselves at the expense of
   society by obfuscating legal processes, overcharging everyone, and generally
   impeding the course of justice. Happily, they have now been abolished (judges
   remain, but they are quite a different category). "
;

+ ConsultTopic @t_judge
  "Freed from the impediments of a legal system that had become over-complicated (for
   the sole benefit of parasitic lawyers), our judges our now able to dispense fair and 
   rapid justice. Under our radically simplified system of law (only one law remains)
   all a judge has to do is to establish the guilt of the accused (no accused person is
   ever innocent) by means of one simple question, and then impose the appropriate
   sentence. All the judges appointed for this task are loyal servants of society; to
   question their judgement is to rebel against society and make oneself a criminal
   <i>ipso facto</i>. That there are a few perverse individuals who nevertheless do 
   persist in questioning what our judges do shows that, sadly, even in these enlightened
   times we have not entirely succeeded in eliminating criminal tendencies from human
   nature; but our loyal judges are steadfastly working on it."
;

+ ConsultTopic @t_guilt
  "On old-fashioned theories of criminal justice, guilt was something that had to
   be established on the basis of evidence, presented in a time-consuming process
   known as a trial, intended to convince a panel of untrained and frequently
   ill-equipped
   persons known as a jury that the prosecution has established its case beyond
   all reasonable doubt. Not only did this necessitate an unnecessarily time-consuming
   and unreliable procedure, it was fundamentally illogical. In the first case it
   involved a presumption of innocence, whereas the accused was being tried because
   believed guilty (thus introducing an inherent self-contradiction into the 
   procedure), it also made guilt rest on the purely contingent outcome of 
   a complex and uncertain process of weighing empirical evidence, instead of
   a tidy matter of logical definition.\b
   Fortunately, these inefficient illogicalities have now been swept away by the
   new enlightened recognition that guilt is a matter of definition; if the judge
   declares someone guilty, then he or she is so by virtue of the judge's
   declaration. This is simple, efficient, logical, and fair. Above all
   miscarriages of justice become logically impossible. "
;

+ ConsultTopic @t_prevention
  "The prevention of crime is a clear desideratum of any rational criminal justice
   system. Under the New Enlightenment it is regularly achieved by arrest, trial and
   detention of criminals before they actually manage to commit a crime. Unfortunately
   the system is not yet foolproof, and it must be admitted that some criminals 
   continue to escape detection until they actually commit a criminal act. "
;

+ ConsultTopic @t_trial
  "In pre-enlightenment times a <i>trial</i> used to be a costly and time-wasting
   process in which the guilt of the accused was meant to be established <q>beyond
   reasonable doubt</q> on purely probabilistic grounds. This dubious procedure
   has fortunately been replaced by a hearing before a judge that is always
   guaranteed to produce certain results; whoever a judge judges to be guilty
   <i>is</i> then guilty by definition, ensuring that the verdict is analytically
   correct."
;

+ ConsultTopic @t_jury
  "Prior to the New Enlightenment trials were often included a panel of twelve
   untrained persons known as a <i>jury</i>, who were meant to decide on the guilt
   or innocence of the accused. A more irrational arrangement can hardly be imagined,
   since such persons had no professional training in the weighing of evidence, and
   were in effect simply voting on the basis of their uninformed opinion of the 
   rhetorical skills of the lawyers and witnesses involved in the trial. "
;

+ ConsultTopic @t_witness
  "The examination and cross-examination of witnesses used to be a fashionable
   way of determining what was risibly known as the <q>truth</q> in criminal trials.
   The shortcomings of this method should be obvious to all rational persons: first,
   human memory is unreliable, and people, even when trying to be honest, frequently
   recount what they believe <i>must</i> have happened in the light of later 
   reflection, not what actually happened. Secondly, what was perceived at the time
   is frequently a subjective impression, not objective truth. Thirdly, strong witnesses
   could often use their rhetorical skills to mislead the jury, while weak ones could
   easily be led and browbeaten by the examining lawyers. It should be apparent, 
   therefore, that the questioning of witnesses at a trial was a method almost
   guaranteed to distort and obscure the truth. "
;

+ ConsultTopic @t_evidence
  "<i>Evidence</i> is one of those concepts that has a perfectly proper place in 
   the empirical sciences, where it refers to the outcome of repeatable and
   verifiable experiment, but which only causes confusion and misunderstanding
   when transferred into the realm of jurisprudence. It should be quite apparent
   to even the most meagre intellect that the evidence supplied by witnesses is
   not of a kind that can checked and verified under controlled conditions; in
   fact, it is not strictly evidence at all, but merely an amalgan of hearsay, rumour, 
   opinion, faulty recollection and disguised prejudice.\b
   This should not however be taken as meaning that the concept of evidence has
   been banished from the criminal justice system altogether. On the contrary,
   the verdict pronounced by the judge is conclusive evidence of guilt (or, if
   it should be, innocence), since the judge's verdict is correct by definition. "
;

+ ConsultTopic @t_reason
  "One of the great benefits of the New Enlightenment has been the introduction of
   reason into the criminal justice system. The aim -- and the achievement -- has been
   to base criminal justice on reasoning that is as sound as geometry. This has proved
   possible by realizing that the whole of criminal justice can be based on the simple
   and self-evident axiom that whoever society considers to be guilty of a crime is
   guilty of a crime. From there it is but a short step to the appointment of a team
   of highly trained, skillful and rational judges who are qualified to speak on
   society's behalf on such matters, and the rationalization of criminal justice
   is complete. "
;

+ ConsultTopic @t_newEnlightenment
  "The principal achievement of the New Enlightenment is the insight that irrationality
   has been the bane of human existence throughout human history, and the realization 
   that by taking a radical new approach, unfettered by the mistakes and fetters of 
   the past, it <i>is</i> actually possible to govern all human affairs by reason.\b
   In respect of crime and punishment, the New Enlightenment is simply the radical
   application of reason in the realm of criminal justice. At first it may not seem
   so simple, on account of the sheer complexity of the irrational accretions that have
   had to be swept away to achieve this, and the change in habits of thought this has
   required. The aim -- and the achievement -- of New Enlightenment justice has been to
   give to the judicial process the same kind of certainty that was once reserved for
   geometry. "
;

+ ConsultTopic @blueIndex
  "<<blueIndex.desc>>"
;


+ DefaultConsultTopic
  "That doesn't seem to be in the index, so you can't find any references to it. "
;


greenBook : CanRub, Book 'elements geometry green hefty volume/book/elements/geometry*books' 
   'green book' @bookcase
  "It's a hefty volume titled: <i>Elements of Geometry</i>. "
  readDesc = "When you open the book it turns out to be a textbook of some sort, 
    containing definitions
   of basic geometrical concepts, derivations of theorems, and that kind of thing.
   You don't have the patience to read it from cover to cover, but you could try looking
   up what it has to say on specific topics. " 
  sightSize = small
;

+ greenIndex : BookIndex '(green) book\'s (book) index/contents' 'green book\'s index'
  "The index contains a list of a number of things you can look up in the green book,
  such as: Angle, Arc, Centre, Circle, Circumference, Great Circle, Hexagon, Line, Plane, 
  Point, Polygon, Quadrilateral, Rectangle, Sphere, Square, Surface, and Triangle."  
;

+ ConsultTopic @t_line
  "<i>Straight Line: </i> A one-dimensional figure forming the shortest path between two points. "
;

+ ConsultTopic @t_greatCircle
  "<i>Great Circle:</i> A Great Circle is a circle drawn on the surface of a sphere
   such that a plane containing the circle also contains the centre of the sphere. Note
   that the shortest distance between two points on the surface of a sphere (within that
   surface) always lies along the arc of a Great Circle. "
;

+ ConsultTopic @t_arc
  "<1>Arc:</i> part of the circumference of a circle or of some other curve. "
;

+ ConsultTopic +110 @t_circle
  "<i>Circle: </i> A figure bounded by a circumference every point of which is
   equidistant from a certain point in the same surface, this point being the centre
   of the circle. ";
;

+ ConsultTopic @t_square
  "<i>Square: </i> A figure bounded by four equal straight lines, each of equal length, such
   that the four angles between adjacent sides are also equal. "
;

+ ConsultTopic @t_triangle
  "<i>Triangle: </i> A figure bounded by three straight lines; if all the lines are of equal
   length the triangle is said to be <i>equilateral</i>; if only two of the lines are of equal
   length the triangle is said to be <i>isosceles</i>; otherwise the triangle is <i>scalene</i>
   \nIf a triangle is drawn on a Euclidean plane its three angles add up to two right-angles;
   but this sum cannot be generalized to non-Euclidean spaces. "
;

+ ConsultTopic @t_hexagon
  "<i>Hexagon: </i> A figure bounded by six straight lines. A regular hexagon shares with
   the square and the equilateral triangle (q.v.) the property of being able to tessellate
   on a Euclidean plane. "
;

+ ConsultTopic @t_point
  "<i>Point: </i> The intersection of two lines <i>or</i> a zero-dimensional geometrical
   object having location but no extension. "
;

+ ConsultTopic [t_squareCircle, t_roundSquare]
  "<i>Square circle:</i> Although long used as a stock example of a geometrical impossibility,
   it is of course immediately apparent from the definitions of square and circle that a
   square circle is nothing of the sort; far from being an impossibility, a square circle
   is a figure which any person of even the most modest intelligence can readily construct;
   we shall, of course, not insult our readers' intelligence by spelling out how. "
;

+ ConsultTopic @t_geometry
  "The whole book is about geometry -- you'll need to be more specific about what particular
   geometrical topic you want to look up in it. "
;

+ ConsultTopic @t_theorems
  "The books is full of theorems -- for example the well known theorem of Pythagoras
   about the square on the hypoteneuse of a right-angle triangle (which, as the book
   is nevertheless careful to explain, is valid only in Euclidean space). "

;

+ ConsultTopic +110 @t_euclidean
  "<i>Euclidean Space:</i> Roughly speaking, a space in which the geometry of the flat
  plane (or its three-dimensional equivalent) obtains. A Euclidean space is one in which
  parallel lines never meet, in which given a line and a point not on that line, only
  one line may be drawn through the point parallel to the first line, in which the
  angles of a triangle add up to 180 degrees, and so forth. Many figures such as lines,
  circles, squares, and triangles may exist in non-Euclidean spaces as well as Euclidean
  ones, but their properties may then become subtly different. "
;

+ ConsultTopic @t_nonEuclidean
  "<i>Non-Euclidean Space:</i> Any space exhibiting a geometry other than that of a 
   Euclidean space (q.v.). In a non-Euclidean space the angles of a triangle will add
   up to something other than 180 degrees, and given a point and a line it may be possible
   to construct more than one line through the point parallel to the first line, or else
   no line at all parallel to the first line. One common example of a non-Euclidean
   (or 'curved') space might be the surface of a sphere.\b
   The most important thing to bear in mind when dealing with non-Euclidean spaces
   is that geometrical figures that meet the same formal definitions as their
   Euclidean counterparts may nevertheless have properties that seem quite
   counter-intuitive on Euclidean presuppositions. "
;

+ ConsultTopic @t_sphere
  "<i>Sphere:</i> A three dimensional figure, every point on the surface of which
   is equidistant from its centre.\b
   Note that the surface of a sphere is curved; figures drawn on the surface of
   a sphere will thus exhibit the features of a non-Euclidean space (q.v.). "
;

+ ConsultTopic @t_concepts
  "The basic geometrical concepts covered in the book include such basic elements
   as lines, points and simple geometrical figures, and the notions of different
   kinds of geometrical space. "
;

+ ConsultTopic @t_geometricalSpace
  "Euclidean space is only one kind of space, and not necessarily the most
   interesting kind. To gain a full understanding of geometry it is also 
   necessary to consider the various kinds of non-Euclidean space. "
;

+ ConsultTopic @t_angle
  "<i>Angle:</i> The degree of inclination of two lines to each other.\b
  A <i>right angle</i> is a quarter of a full turn, i.e. 90 degrees.\n
  An <i>acute angle</i> is as an angle less than 90 degrees.\n
  An <i>obtuse angle</i> is an angle between 90 and 180 degrees.\n
  A <i>reflex angle</i> is an angle between 180 and 360 degrees. "
;

+ ConsultTopic @t_rectangle
  "<i>Rectangle:</i> A quadrilateral the four internal angles of which are all
  equal to one another. If the four sides are also equal, the rectangle is
  also a square. "
;

+ ConsultTopic @t_quadrilateral
  "<i>Quadrilateral:</i> A four-sided plane figure. "
;

+ ConsultTopic @t_plane
  "<i>Plane:</i> A (two-dimensional) surface in which every straight line that 
   joins two points within the surface also lies within the surface, or such 
   that the intersection of two such surfaces is always a straight line. "   
;

+ ConsultTopic @t_centre
  "<i>Centre:</i> The middle point of a circle or sphere, such that each point
   on the circumference of the circle or sphere is equidistant from it. In the
   case of a circle the centre must lie in the same surface at the circumference. "
;

+ ConsultTopic @t_circumference
  "<i>Circumference:</i> The curve that forms the enclosing boundary of
  a circle or other closed figure. "
;

+ ConsultTopic @t_surface
  "<i>Surface:</i> A continuous extent possessing only two dimensions,
  typically forming the boundary of a three-dimensional object or
  the boundary between two regions of three-dimensional space. "
;

+ ConsultTopic @t_polygon
  "<i>Polygon:</i> A many-sided figure; the term is usually used of a plain
   enclosed figure having more than four angles (and hence sides). From
   <<!gTextOnly ? '&pi;&omicron;&lambda;&upsilon;&sigmaf;'
     : 'polus'>> (many) + <<!gTextOnly ? 
     '&gamma;&omega;&nu;&iota;&alpha;' : 'gonia'>> (angle). "
;

+ ConsultTopic @greenIndex
  "<<greenIndex.desc>>"
;

+ DefaultConsultTopic
  "The green book doesn't seem to have anything interesting to say on that. "
;


redBook : CanRub, Fillable, Readable, ComplexContainer 'red book/cover*books' 'red book'
   @bookcase
  "It's a <<previouslyOpened ? 'large pseudo-' : 'surprisingly large '>>book
   called <<bookName>>" 
  readDesc = "The first few pages look as dull as you imagined they would be
   from the title, all geometrical diagrams and cryptically compressed
   algebraic formulae for the analytically inclined. After scanning the
   first six pages you decide you are not going to learn anything from this 
   book, so you shut it with a sharp snap. "   
  bookName = '<i>Elements of Geometry: Key to Exercises</i>'
  sightSize = small
  
//  descContentsLister = thingDescContentsLister
  previouslyOpened = nil
  
  dobjFor(LookIn) maybeRemapTo(previouslyOpened == nil, Open, self)
  dobjFor(Read)
  {
    preCond = static inherited + objHeld
    verify()
    {     
        if(previouslyOpened) illogicalNow('As you\'ve discovered, it\'s not a real book. ');
        else inherited Readable;  
    }  
    action()
    {
       clearSurface();
       
       if(!triedToRead)
       {
         inherited;
         triedToRead = true;
       }
       else
         replaceAction(Open, self);
    }    
  }
  triedToRead = nil
  
  dobjFor(Open) { 
    preCond = static inherited + objHeld
    verify() 
      { 
        if(isOpen) illogicalAlready('It\'s already open. ');
        if(!previouslyOpened) delegated Book;
      } 
    remap() { }
    action()
    {      
      
      clearSurface();
         
      if(!previouslyOpened)
      {
        reportBefore('Well, well; when you open it in the middle
         it turns out that the inner pages have all been
         hollowed out, so that it\'s not really a book after all, but a 
          box disguised to look like a book. ');
        redIndex.moveInto(nil); 
        previouslyOpened = true;
        initializeVocabWith('(box)*boxes');
        achievement.awardPointsOnce();
      }
      nestedAction(Open, subContainer);
    }
  }    
  
  clearSurface()
  {
      /* The book can't be opened if anythings on top of it
       * So we need to take everything off first
       */
      
      if(subSurface.contents.length > 0)
        foreach(local cur in subSurface.contents)
         tryImplicitAction(TakeFrom, cur, self);
    
  }
  
  dobjFor(ConsultAbout)
  {
    verify() {}
    preCond = [objVisible, touchObj]
    action()
    {
      if(redIndex.isIn(self))
        redIndex.desc;
      else
        "The red book doesn't have an index. ";
    }
  }    
  
  dobjFor(Shake)
  {
    verify() { }
    action() {
      if(subContainer.contents.length() > 0 )
        "You hear a faint rattle inside the book. ";
      else
        "Shaking <<theName>> doesn't achieve much. ";
    }
  }  
  dobjFor(FillWith)
  {    
    preCond = [touchObj, objOpen]
    check() 
    {
      if(subContainer.contents.length > 0)
      {
        "It would be a good idea to take everything out of the book before trying to
          fill it with anything else. ";
        exit;  
      }
    }
  }
  isOpen = (subContainer.isOpen)               
  achievement : Achievement {+1 "finding the small brass key " }  
  subContainer : ComplexComponent, OpenableContainer {
    bulkCapacity = 3
    openStatus()
    {
     if(isOpen) ". It's open";    
    }
    okayOpenMsg = '{You/he} open{s} the red book. '
    okayCloseMsg = '{You/he} close{s} the red book. '
    
  }
  subSurface : ComplexComponent, Surface { bulkCapacity = 3 }
  isObviousContainer = nil
  replacement = redSandBook
  bulkCapacity = (subContainer.bulkCapacity)
  bulk = 4
  dobjFor(Pick) asDobjFor(Take)
;

+ brassKey : Hidden, Key 'small brass key*keys' 'small brass key'
  discovered = true
  subLocation = &subContainer
  dobjFor(Pick) maybeRemapTo(gActor.canSee(ironKey) || gActor.canSee(filedIronKey), Take, self)
  sightSize = small
  inflammable = nil
;

+ Unthing, Component 'red book\'s index' 'red book\'s index'
  notHereMsg = 'The red book doesn\'t have an index. '
;

+ redIndex : Component 'red book\'s index' 'red book\'s index'
  desc()
  {
    "You open the book at the back, and find no index among
     the last few pages, so give up and close the book again. ";
     moveInto(nil);
  }
;

redSandBook : SandFilled, Thing 'red book/cover*books' 'red book'
  "<<redBook.desc>>. <<isOpen ? 'It\'s full of sand. ' : ''>>"      
  altObject = redBook
  verifyDobjRead { illogical('You know it\'s not a real book. '); }
  bulk = 4
  bulkCapacity = 3
;

+ Sand;

+ Unthing, Component 'red book\'s index' 'red book\'s index'
  notHereMsg = 'The red book doesn\'t have an index. '
;

class Book : Readable, Consultable, Surface
  dobjFor(Read)
  {
    verify() { inherited Readable; }
    preCond = static inherited + objHeld
    action()
    { 
      gActor.lastConsulted = self;
      hasBeenOpened = true;
      clearSurface(); 
      inherited;
    }
  }
  hasBeenOpened = nil
  
  dobjFor(ConsultAbout)
  {
     preCond = static inherited + objHeld + objVisible
     action()
     {
       clearSurface();
       hasBeenOpened = true;
       inherited;
     }
  }
  dobjFor(Open) asDobjFor(Read)
  
  clearSurface()
  {
     if(contents.length > 1)
        foreach(local cur in contents)
          if(!cur.ofKind(NonPortable))
            tryImplicitAction(TakeFrom, cur, self);
  }

  dobjFor(Close)
  {
   verify() { 
     if(!hasBeenOpened) illogicalAlready('{The dobj/he} isn\'t open. '); 
     else illogicalAlready( '{You/he} already closed {the dobj/him} after reading it. ');
     }   
  }
  cannotWriteOnMsg = &doNotDefaceMsg
  cannotDrawOnMsg = &doNotDefaceMsg
  dobjFor(WriteOn) {
    verify() {}
    action() { reportFailure(cannotWriteOnMsg); }
  }
  dobjFor(DrawOn) asDobjFor(WriteOn)
  notAWeaponMsg = 'A physical assault would damage {the iobj/him} more than {the dobj/him};
    an intellectual assault would probably prove ineffective. '
  dobjFor(Pick) asDobjFor(Take)  
  bulk = 2
  bulkCapacity = 2
;

class BookIndex: Component
  isKnown = (location.isKnown)
  verifyDobjExamine {
    if(gActor.lastConsulted == location)
      logicalRank(140, 'currently consulted volume');
  }
  dobjFor(Consult) asDobjFor(Examine)   
 bulk = 0
 weight = 0 
;
