/* FIRST THINGS FIRST - Locations - past.t
/*  Copyright (c) 1996, 1997, 1999, 2000 by J. Robinson Wheeler. All Rights Reserved. */

/*
 *					********					 *********
 *					********	THE GAME CODE	 *********
 *					********					 *********
 */

/**************************************************************************
 *					The rooms of the PAST.								  *
 **************************************************************************/
 
Pclearing: room
	sdesc = "Clearing"
	ldesc = "The woods part in a marvelous natural clearing here. Light streams prettily 
			through the canopy of leaves above. The ground is hard and flat and clean. "
	xdesc = 
	{
		if ( not workers.onLunchBreak )
			"You can hear the busy noise of construction work nearby, coming
			through the woods from the northeast. ";
		else
			"You can see a construction site through the woods to the 
			northeast. ";
	}
	listenDesc = 
	{
		if ( not workers.onLunchBreak )
			return( 'You can hear the busy noise of construction work. ' );
		else pass listenDesc;
 	}
	smellDesc = "You smell sawdust in the air. "
	
	ne =
	{
		if ( not self.traveledNE )
		{
			"You push through the trees. Your footpath doesn't seem to 
			exist any more...\n";
			
			self.traveledNE := true;
		}
		return( Pwoods );
	}
	firstseen =
	{
		incscore( 5 );
		global.scoreCard[6] := 1;
	}
;

PdummyClearingItem: locationDesc
	sdesc = "clearing"
	adjective = 'Pclearing'
	location = Pclearing
;

Pwoods: room
	sdesc = "Woods"
	ldesc = "The smell of freshly-sawed wood wafts through this natural grove 
			of cedar and live oak trees. A large rock juts up out of the ground right 
			in your way. "
	xdesc = "A construction site is to the northeast, and a clearing is visible to 
			the southwest. "
	ne = PsouthOfHouse
	sw = Pclearing
	listenDesc = 
	{
		if ( not workers.onLunchBreak )
			return( 'You can hear the busy noise of construction work. ' );
		else pass listenDesc;
 	}
	smellDesc = "You smell sawdust in the air. "
;

Prock: chairitem
	sdesc = "large rock"
	ldesc = "The rock is a five foot grey boulder, almost egg-shaped, 
		a single piece of heavy, textured granite. Polished smooth over
		time, a wedge shape sheared from the top ages ago provides a
		comfortable place to sit. "
	noun = 'rock' 'boulder' 'stone'
	adjective = 'large' 'wedge' 'shape' 'chipped' 'chip' 'top' 'granite'
				'heavy' 'textured'
	location = Pwoods
	ne = { self.getOff; return( self.location.ne ); }
	sw = { self.getOff; return( self.location.sw ); }
	noexit = { self.getOff; return( self.location.noexit ); }
	isdroploc = true
	statusPrep = "on"
	outOfPrep = "off of"
	
	getOff = 
	{
		if ( Me.location = self )
		{
			"You get off the rock.\n ";
			Me.moveInto( self.location );
		}
	}
	verDoStandon( actor ) = { self.verDoSiton( actor ); }
	doStandon( actor ) =
	{
		"You stand up on top of the rock. The view isn't much better, but
		it is very serene and peaceful. ";
		actor.moveInto( self );
	}
	verDoSiton( actor ) = 
	{
		if ( actor.location = self )
			"You are already on the rock. ";
	}
	doSiton( actor ) =
	{
		"You sit down on top of the rock. It is very serene and peaceful. ";
		Me.moveInto( self );
	}
	
	verDoTake( actor ) =
	{
		"The rock is made of solid granite and conservatively weighs
		one and a half tons. You are unable to move it. ";
	}
	verDoMove( actor ) = { self.verDoTake( actor ); }
	verDoPush( actor ) = { self.verDoTake( actor ); }
	verDoPull( actor ) = { self.verDoTake( actor ); }
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"Sometimes it's nice to have a big ol' rock to
				sit on when you need to think.\" ";
				return( true );
			case Laura:
				"Laura says, \"That sounds like a great spot to sit and 
				meditate.\" ";
				return( true );
			case Architect:
				"He says, \"Ah yes, that old rock just down in the woods. I made
				a special point of preserving it. It would have been such a 
				shame to blast it. I've made something of a habit of taking 
				walks down there to clear my head and think.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

workers: NPC, fixedBlock, floatingItem
	isHim = true
	isHer = true
	sdesc = "construction workers"
	thedesc = "the workers"
	adesc = "the workers"
	ldesc = "The workers are skilled in various duties, and all are 
			extremely busy <<self.onLunchBreak ? "eating lunch" :
			"at their jobs">>. "
	listenDesc = 
	{
		if ( not workers.onLunchBreak )
			return( 'You hear the busy noise of construction workers
				doing their jobs. ' );
		else 
			return( 'You hear the workers noshing and sharing bawdy
				stories. ');
 	}
	noun = 'worker'
	plural = 'workers'
	isThem = true
	adjective = 'personnel' 'crew' 'constrction' 'construction' 'technician' 
			'technicians' 'people' 'site'
	responseToThanks = 
	{
		"\^<<self.thedesc>> aren't really paying attention to you. ";
	}
	location = 
	{
		if ( Me.location.constructionArea )
		{
			if ( self.onLunchBreak )
				return( PnorthOfHouse );
			else
				return( Me.location );
		}
		else return( nil );
	}
	onLunchBreak = nil
	
	actorAction( v, d, p, i ) =
	{
		self.disavow( nil );
		exit;
	}
	
	followMsg = { self.disavow( nil ); }
	disavow( it ) = 
	{
		"The workers are all much too busy <<self.onLunchBreak ?
		"eating" : "working">> to pay attention to you. ";	
	}
	
	verIoShowTo( actor ) = { self.disavow( nil ); }
	
	numberOfDaemonsRunning = 0
	messageNum = 0
	actorDaemon =
	{
		local z, v;
		
		if ( not Me.location.constructionArea ) return;
		
		z := rand( 2 );
//		for ( v := 1; v <= z; v++ )
		if ( z = 1 )
		{
			"\b";
			self.messageNum++;
			if ( self.messageNum < 25 )
				sayMessage( self.messageNum );
			else
				sayMessage2( self.messageNum );
		}
	}
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Architect:
				"He says, \"Well, they always seem to be taking a break, but 
				maybe that's just me. I'm something of a workaholic. I skip
				more meals than I should.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

PsouthOfHouse: constructionSite
	sdesc = "South of house"
	ldesc = "You are standing on what will be the south side of your house. 
			The house is currently under construction. The wooden frame has 
			gone up, but apart from that, there's not much to see. The 
			ground slopes down slightly here, and the wall of the house looms an 
			extra story high because of it. "
	xdesc = "A little bare path made by you just now leads southwest into the 
			woods. You can walk around the house to the northwest and northeast. 
			To the east is a dirt road leading to town. "
	
	sw = Pwoods
	nw = PbehindHouse
	ne = PfrontOfHouse
	north = PinsideHouse
;

PdirtRoad: fixedBlock
	sdesc = "dirt road"
	ldesc = { self.location.xdesc; }
	noun = 'road'
	adjective = 'unpaved' 'dirt' 'large' 'treads'
	location = PsouthOfHouse
;

sapling: fixeditem
	isListed = true
	sdesc = "sapling"
	ldesc = "The meter-high sapling looks a little intimidated by all the wood being 
			sawed and splintered nearby, but someone has taken the time to tie a 
			bright ribbon to its slender trunk, as a warning to be careful of 
			harming it. Good thing, because it looks like it's going to be really 
			gigantic one of these days. "
	noun = 'tree' 'sapling'
	location = nil
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"Take care of that little tree.\" ";
				return( true );
			case Laura:
				"Laura says, \"Someday, that little tree will be tall and 
				strong.\" ";
				return( true );
			case Architect:
				"He says, \"I question whether it's safe to plant a tree so
				close to the house. It might fall over during a storm.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

ribbon: fixeditem
	sdesc = "ribbon"
	ldesc = "The ribbon is a reminder to the construction workers to be careful
			of the young tree. "
	noun = 'ribbon'
	adjective = 'bright' 'yellow' 'warning' 'caution'
	location = sapling
	
	verDoTake( actor ) = 
	{
		"If you remove the ribbon, the sapling will be harmed by
		the construction workers. ";
	}
	verDoUntie( actor ) = 
	{
		"If you remove the ribbon, the sapling will be harmed by
		the construction workers. ";
	}
;

houseFrame: staticItem, floatingItem
	sdesc = "frame"
	ldesc = "The wooden frame has gone up, but apart from that, there's not much to see. "
	noun = 'frame' 'house' 'wall'
	adjective = 'wooden'
	location = 
	{
		switch( Me.location )
		{
			case PfrontOfHouse:
			case PsouthOfHouse:
			case PnorthOfHouse:
			case PbehindHouse:
			case PinsideHouse:
			case P2ndFloor:
				return( Me.location );
			default: 
				return( nil );
		}
	}
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Architect:
				if ( blueprint.secretpassage ) 
					"He says, \"This will be a marvellous little house,
					full of secrets.\" He taps a finger to the side of
					his nose winks at you. ";
				else
					"He fidgets with the blueprint for a moment and says, 
					\"It's a nice enough house. I kind of wish -- but no,
					this is what you asked for, and I can only deliver
					what you ask for.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

barepath: block
	sdesc = "little bare path"
	noun = 'path' 'footpath' 'trail'
	adjective = 'little' 'bare'
	location = PsouthOfHouse
;

woodsSouth: block
	sdesc = "woods"
	noun = 'woods'
	isThem = true
	location = PsouthOfHouse
;

PinsideHouse: constructionSite
	sdesc = "Inside house"
	ldesc = "You finally step into your house. Not much of a victory, given the 
			circumstances. Just a lot of planks and rafters. "
	xdesc = "A temporary work ladder is nailed into the structure, and leads up 
			to the second floor. "
	
	up = P2ndFloor
	east = PfrontOfHouse
	south = PsouthOfHouse
	west = PbehindHouse
	north = PnorthOfHouse
	out = "You'll have to specify a direction. "
;

screwdriver: item
	sdesc = "screwdriver"
	ldesc = "All-purpose tool, the humble screwdriver. "
	noun = 'screwdriver' 'screwd' 'screwdr' 'screwdri' 'screwdriv' 'screwdrive'
			'tool' 'philips' 'phillips' 'stanley'
	adjective = 'all-purpose' 'all purpose' 'purpose' 'humble'
	location = PinsideHouse
	
	verIoFixWith( actor ) = {}
	ioFixWith( actor, dobj ) =
	{
		if ( dobj = frontWheel || dobj = wheelbarrow )
		{
			if ( frontWheel.broken ) 
			{
				"Perhaps a wrench would have been better suited for the task, but
				with a little effort you tighten the bolt holding the wheel. 
				The axle is still a little bent, but the wheel should stay on. ";
			
				frontWheel.broken := nil;
				incscore( 2 );
				global.scoreCard[12] := 1;
			}
			else
			{
				"The wheel is already as fixed as it will get. ";
			}
		}
		else
		{
			"I don't know how to do that with "; self.thedesc; ". ";
		}
	}
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"Screwdrivers are pretty useful tools. You can
				fix things with 'em, for example.\" ";
				return( true );
			case Laura:
				"Laura says, \"I can't help you with mechanical things. I'm
				really clueless about that stuff.\" ";
				return( true );
			case Architect:
				"He says, \"Is that one of our screwdrivers? Don't run off
				with it.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

ladder: block
	sdesc = "temporary work ladder"
	noun = 'ladder'
	adjective = 'temporary' 'work'
	location = PinsideHouse
	
	verDoTake( actor ) =
	{
		"It's nailed in place. No, there's no hammer in this game. Don't worry 
		about it. (Just use it to go up and down.) ";
	}
	
	verDoClimb( actor ) = {}
	doClimb( actor ) =
	{
		Me.travelTo( P2ndFloor );
	}
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Architect:
				"He says, \"Of course, we'll soon be putting in the real staircase,
				but it will have to do for now. Just watch your step.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

planks: block
	sdesc = "planks"
	noun = 'plank'
	plural = 'planks'
	isThem = true
	location = PinsideHouse
	
	verDoWalk( actor ) = 
	{
		if ( twobyfour.didPirateJoke )
			"Didn't we do the pirate joke already? ";
	}
	doWalk( actor ) =
	{
		"Aye, aye, ye scurvy knave! Arrrr! ";
	}
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Architect:
				"He says, \"Yes, wooden planks. Made of wood.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

rafters: block
	sdesc = "rafters"
	noun = 'rafter'
	plural = 'rafters'
	isThem = true
	location = PinsideHouse
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Architect:
				"He says, \"I know you're just curious, but asking me about 
				the rafters is merely distracting me from finishing your 
				house properly.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

P2ndFloor: constructionSite
	sdesc = "Second floor"
	ldesc = "The description 'second floor' is misleading, because the floor up here 
		isn't actually finished, so watch your step. From up here you see a nice 
		view of the town square down the road. There is a fancy blueprint of the 
		house sitting on a temporary workdesk. "
	xdesc = "The only exit is down. "
	
	down = PinsideHouse
	
	firstseen = 
	{
		notify( self, &lunchMsg, 0 );
	}
	enterRoom( actor ) =
	{
		if ( Architect.location = self )
			setit( Architect, 1 );
		pass enterRoom;
	}
	
	lunchTimeCounter = 0
	lunchMsg =
	{
		if ( global.timeLoc != 2 ) return;
		
		if ( self.lunchTimeCounter = 1 )
		{
			local i,l;
			
			l := workers.numberOfDaemonsRunning;
			for( i:=1; i<=l; i++ )
				unnotify( workers, &actorDaemon );
		}
		
		if ( self.lunchTimeCounter = 2 )
		{
			"\bThe lunchtime whistle blows shrilly. \b
			All of the workers cry, \"LUNCH!\" They drop what they're doing
			and gather north of the house to start eating. ";
			
			workers.onLunchBreak := true;
		}
		
		self.lunchTimeCounter++;
		
		if ( Me.location = P2ndFloor && Architect.location = P2ndFloor )
		{
			if ( not self.saidArchitectGripe && workers.onLunchBreak )
			{
				"The architect looks up and says, \"Oh sure. They get a 
				lunch break. They always get a lunch break. But me? Do I 
				get one? Noooo...\" \b
				His stomach rumbling, he grimaces and goes back to work. ";
				
				self.saidArchitectGripe := true;
			}
		}
		
		if ( self.lunchTimeCounter = 140 )
		{
			"\bThe lunchtime whistle blows shrilly. \b
			The foreman shouts, \"That's it! Back to work, people!\" Refreshed,
			the workers spring back into action. ";
			
			workers.onLunchBreak := nil;
			unnotify( self, &lunchMsg );
		}
	}
;

workdesk: surface, block
	sdesc = "workdesk"
	noun = 'workdesk' 'desk'
	location = P2ndFloor
	
	verIoPutOn( actor ) = 
	{
		if ( Architect.location = self.location ) 
			"The architect says, \"Kindly refrain from cluttering my
			workdesk with your things.\" ";
	}
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Architect:
				"He says, \"Yes, this is my workdesk. I work here. Or I do, when
				I'm not being asked silly questions. No offense.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

blueprint: staticItem, readable
	sdesc = "blueprint"
	ldesc = "It's a lovely floor plan, rendered impeccably with blue pencil. The 
			name of the architect is stenciled in the top corner. "
	noun = 'blueprint' 'print'
	adjective = 'fancy' 'lovely' 'floor' 'plan' 'blue'
	location = workdesk
	isListed = true
	secretpassage = nil
	
	verDoTake( actor ) =
	{
		if ( Architect.location = P2ndFloor )
			"The architect shoos you away. ";
		else
			"Stealing the blueprint isn't helpful. ";
	}
	
	verDoChange( actor ) = 
	{
		if ( self.secretpassage )
			"You've already changed the blueprint. ";
	}
	
	verDoDrawOnWith( actor, iobj ) = 
	{
		if ( self.secretpassage ) 
			"You've already drawn your changes to the blueprint. ";
		else if ( not iobj.ispencil )
			"You need something appropriate to draw on the blueprint with. ";
		else if ( iobj = pencil )
			"You can't write on a blueprint with a regular school pencil!  
			You need a blue pencil for that. ";
		else if ( Architect.location = P2ndFloor )
		{
			"As you lean in with the blue pencil, the architect harumphs and 
			nudges you back. You might have to wait for him to be somewhere 
			else in order to change the blueprint. ";
		}
	}
	
	verIoDrawOn( actor ) = {}
	ioDrawOn( actor, dobj ) =
	{
		if ( not dobj.isSecret )
			"\^<<dobj.thatdesc>> <<dobj.isntdesc>> something you need 
			to draw on <<self.thedesc>>. ";
		else if ( Architect.location = P2ndFloor )
		{
			"As you lean in to draw <<dobj.adesc>>, the architect harumphs and 
			nudges you back. You might have to wait for him to be somewhere 
			else in order to change the blueprint. ";
		}
		else
			self.doChange( actor );
	}
	
	doChange( actor ) = 
	{
		if ( bluePencil.isIn( Me ) )
		{
			"(with the blue pencil)\b";
			
			if ( Architect.location <> P2ndFloor )
			{
				self.secretpassage := true;
				secretDoor.moveInto( southOfHouse );
				secretSwitch.moveInto( southOfHouse );
				FsecretDoor.moveInto( FsouthOfHouse );
				FsecretSwitch.moveInto( FsouthOfHouse );
				FmasterBedroomSecretDoor.moveInto( FmasterBedroom );
				NFsecretDoor.moveInto( NFsouthOfHouse );
				NFsecretSwitch.moveInto( NFsouthOfHouse );
				
				"You put the blue pencil to the blueprint and sketch a quick 
				hidden passage on the south side of the house. You make a note 
				that it is to be a secret entrance. The architect will probably 
				get the point when he sees it, provided he doesn't blow his
				stack when he sees that you've tampered with his work. ";
			}
			else
			{
				"As you lean in with the blue pencil, the architect harumphs and 
				nudges you back. You might have to wait for him to be somewhere 
				else in order to change the blueprint. ";
			}
		}
		else if ( pencil.isIn( Me ) )
		{
			"(with the pencil)\b";
			
			if ( Architect.location <> P2ndFloor )
			{
				"You can't write on a blueprint with a regular school pencil!  
				You need a blue pencil for that. ";
			}
			else
			{
				"The architect harumphs and nudges you back. You might have to wait 
				for him to be somewhere else in order to change the blueprint. ";
			}
		}
		else
		{
			"You need something to write with if you're going to make a change to 
			the blueprint. ";
		}
	}
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"If you had a blue pencil, you could add 
				whatever you wanted to that blueprint. Er, hopefully 
				when nobody was looking.\" ";
				return( true );
			case Laura:
				"Laura says, \"If you had a blue pencil, you could change
				a blueprint to add whatever you wanted. Although I guess
				it's kind of sneaky to do that behind an architect's back.
				Unless of course he's the type who doesn't listen to you
				when you suggest changes! Not that I'm advocating any 
				wrongdoing, you understand.\" ";
				return( true );
			case Architect:
				if ( blueprint.secretpassage = nil )
					"He frowns at it. \"There's something missing. Ah well, it's
					what you asked for.\" ";
				else
					"He beams. \"Perfect!\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

stencil: fixeditem, readable
	sdesc = "stencilled name"
	ldesc = "\"Peter H.\ Mayhew -- Architect!\" "
	noun = 'stencil' 'name' 'corner'
	adjective = 'stencilled' 'top'
	location = P2ndFloor
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Architect:
				"He says, \"Yes, that's my name. Peter H.\ Mayhew -- 
				Architect!\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

view: fixedBlock, distantItem
	sdesc = "nice view"
	ldesc = "From here you can see the bank, the sandwich shop, and 
			an empty plot where the library ought to be. "
	noun = 'view'
	adjective = 'nice' 'bank' 'library' 'shop' 'town' 'village' 'square' 'road'
		'empty' 'plot'
	location = P2ndFloor
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Architect:
				"He says, \"Yes, it's a very nice view indeed.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

Architect: NPC
	isHim = true
	isfixed = nil
	noun = 'architect' 'arch' 'ar' 'arc' 'archi' 'archit'
	adjective = 'Peter' 'h' 'mayhew'
	sdesc = "architect"
	adesc = "an architect"
	thedesc = "the architect"
	ldesc = "The architect is a brilliant craftsman, in his own way. You can tell just 
			by looking at him. He must be in his early forties, with slightly 
			peppery hair at the sideburns. His eyes are deep and intelligent, and
			his shoulders are already rounded from years of hunching over drafting
			tables. "
	location = P2ndFloor
	sayHello = 
	{
		if ( self.greetedOnce ) 
		{
			"He nods politely at you in greeting. ";
		}
		else
		{
			"He says, \"My goodness, you look ten years older!  You should take 
			better care of yourself.\" ";
			self.greetedOnce := true;
		}
	}
	actorDesc =
	{
		"The architect is here";
		if ( self.location = P2ndFloor )
			", <<blueprint.secretpassage?"smiling":"frowning">> over the blueprint";
		". ";
	}
	giveItemToSomeone( item, someone ) = 
	{
		if ( item.isSecret ) {
			item.askingAboutMe( self );
		}
		else inherited.giveItemToSomeone( item, someone );
	}
	ioShowTo( actor, dobj ) =
	{
		if ( dobj = badShingle )
			self.ioGiveTo( actor, dobj );
		else "He is too busy to look over your things. ";
//		pass ioShowTo;
	}
	verIoGiveTo( actor ) = {}
	ioGiveTo( actor, dobj ) =
	{
		if ( dobj = badShingle )
		{
			if ( global.newRoof )
			{
				self.doAskAbout( actor, badShingle );
				return;
			}
			
			"He takes the bad shingle and then looks at it with alarm. \"Oh my 
			goodness! This is the type of shingle we were planning to use, but 
			it's obvious that we need to use something of better quality. I'll
			make sure to talk to the roofers about this.\" ";
			
			global.newRoof := true;
			badShingle.moveInto( Architect );
			incscore ( 4 );
			global.scoreCard[8] := 1;
			future.state++; 						// update future state
		}
		else if ( dobj = hotSandwich )
		{
			if ( hotSandwich.heat > 4 )
			{
				"He says, \"Why, thank you!  This will just hit the spot with some 
				coffee. I'll be right back.\"  He clambers down the ladder and heads 
				north out of sight. ";
				
				notify( self, &actorDaemon, 0 );
				self.moveInto( nil );
				hotSandwich.moveInto( nil );
				incscore( 5 );
				global.scoreCard[17] := 1;
				notify( PLaura, &actorDaemon, 0 );			// summon Past Laura
			}
			else if ( hotSandwich.heat < 2 )
			{
				"He says, \"Gee, thanks. Just what I was in the mood for.\"  He 
				starts to take a big bite and then looks disgusted. \"It's ice 
				cold!  When did you buy this, last year?\" \b
				
				He hands it back to you and says, \"Sorry to be rude, but I
				can't eat it like this. I don't suppose you can heat it up
				first?\ Thanks.\" ";
			}
			else
			{
				"\"Gee, thanks. Just what I was in the mood for.\"  He starts
				to take a big bite and then stops, looking nauseated. \"Thanks 
				for nothing! What's worse than a lukewarm meatball sandwich?\" \b
				
				He hands it back to you and says, \"Sorry to be rude, but I
				can't eat it like this. I don't suppose you can heat it up
				first?\ Thanks.\" ";
			}
		}
		else if ( dobj = coldSandwich )
		{
			if ( coldSandwich.heat > 0 )
			{
				"He says, \"Hot cold cuts? How revolting!\" \b
				
				He hands it back to you and says, \"Sorry to be rude, but I
				can't eat this. I don't suppose you could find a hot meatball
				sandwich or something? If it's not any trouble, that is.\" ";
			}
			else
			{
				"He says, \"Gee, thanks. What I'm really in the mood for is a 
				hot sandwich, though.\" \b
				
				He hands it back to you and says, \"I don't suppose you could 
				find a hot meatball sandwich or something? If it's not any 
				trouble, that is.\" "; 
			}
		}
		else if ( dobj = lightningRod )
		{
			if ( lightningRod.askedOnce )
			{
				"He says, \"Ah yes. I had nearly forgotten. Thank you.\" ";
			}
			else
			{
				"He says, \"Hmmm. You really have a good memory for
				details. Normally, the installation of a lightning rod
				is more your personal business as the owner of the house
				than it is mine.\" \b
				
				He pauses and rubs his eyes blearily. \"However, I 
				suppose that since you're handing me a lightning rod,
				I will tell the men to attach it after they finish the
				roofing. It is a safety concern";
				
				if ( future.state > 1 )
					", especially when that tree at the south of the
					house grows up. If it gets big enough, it'll be its
					own lightning rod";
				
				", after all.\" \b";
			}
			
			"He takes the lightning rod from you and tosses it down to a 
			passing worker below, hollering a few instructions. Then 
			he settles into his chair and goes back to work. ";
			
			incscore ( 4 );
			global.scoreCard[21] := 1;
			self.attached := true;
			future.state += 4;	// update future state
			lightningRod.moveInto( southRoof );
			
		}
		else
			"He's too busy to notice your offer. ";
	}
	responseToThanks = 
	{
		if ( self.remarkedOnPassage = true )
			"\^<<self.thedesc>> says, \"No, thank you!\" ";
		"\^<<self.thedesc>> says, \"Oh, you're welcome.\" ";
	}
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"I don't know who that is.\" ";
				return( true );
			case Laura:
				"Laura says, \"I don't know him, sorry.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
	
	tellAboutDisavow( it ) =
	{
		"He doesn't seem to be listening. ";
	}
	
	travelPath = [ PnorthOfHouse PnorthOfHouse PfrontOfHouse PinsideHouse P2ndFloor nil ]
	travelCount = 1
	actorDaemon =
	{
		local oldLocation;
		
		oldLocation := self.location;
		self.moveInto( self.travelPath[ self.travelCount ] );
		
		switch ( self.travelCount )
		{
			case 1:
			case 2:
				if ( Me.location = self.location )
					"\bThe architect is here, nursing a hot cup of coffee. ";
				break;
			case 3:
				if ( Me.location = self.location )
					"\bThe architect shows up, nursing a hot cup of coffee. ";
				else if ( Me.location = oldLocation )
					"\bThe architect walks to the front of the house. ";
				break;
			case 4:
				if ( Me.location = self.location )
					"\bThe architect comes in, nursing a hot cup of coffee. ";
				else if ( Me.location = oldLocation )
					"\bThe architect walks inside the house. ";
				break;
			case 5:
				if ( Me.location = self.location )
				{
					"\bThe architect returns, nursing a hot cup of coffee. 
					He immediately gets back to work. ";
					if ( blueprint.secretpassage )
					{
						"Seconds later, he does a blurbling spit-take with
						his coffee. \"What's this? What's this?\" he says,
						peering at the blueprint. He gets up from his desk
						and walks over to you. \b";
						self.remarkOnSecretPassage;
					}
				}
				else if ( Me.location = oldLocation )
				{
					"\bThe architect climbs up the ladder. ";
					if ( blueprint.secretpassage )
					{
						"You hear the architect make some sort of
						exclamation upstairs. ";
						notify( self, &waitForPlayer, 0 );
					}
				}
				unnotify( self, &actorDaemon );
				break;
			default: 
				"[BUG! Architect.travelCount = <<self.travelCount>>] ";
				break;
		}
		self.travelCount++;
	}
	waitForPlayer =
	{
		if ( Me.location = self.location )
		{
			"The architect looks up from his desk. \"There you are!\" he
			says. He walks over to you. \b";
			self.remarkOnSecretPassage;
			unnotify( self, &waitForPlayer );
		}
	}
	remarkOnSecretPassage =
	{
		self.remarkedOnPassage := true;
		"\"Normally,\" he says, \"I would be furious if anyone tampered
		with my blueprint while I was away. In fact, I find the circumstances
		of my getting up to leave to be suspiciously contrived. However! In
		this case, I'll make a very grand exception!\" \b
		
		He pulls you back over to the desk and sits down. He puts his 
		finger on your addition. \b
		
		\"A secret door! A secret passage!\" He grins broadly. \"You don't
		know how long I've wanted to create something like this. People don't
		want creativity, they want the same old thing every time. Do you know
		I once got a failing grade on an architecture school project for 
		putting in secret passages? My instructor was this strict old biddy
		who didn't see the point of it.\" \b
		
		\"Now, we don't have much room in the floor plan to acommodate anything
		but a narrow little hallway, but perhaps it'd be good enough to be at
		least an entrance, and perhaps a small storage area. What do you think?
		You should at least be able to enter the master bedroom through there.
		I'm going to have to give some thought to the secret switch that
		will open it. Oh, what fun! Thank you. Really.\" \b
		
		He shakes your hand and gets to work, scribbling little notes to 
		himself. ";
	}
;

PnorthOfHouse: constructionSite
	sdesc = "North of house"
	ldesc = 
	{
		"You are standing on what will be the north side of your house. 
		The house is currently under construction. The wooden frame has 
		gone up, and the driveway is currently being poured, but apart 
		from that, there's not much to see. ";
		
		if ( workers.onLunchBreak )
			"\bA bunch of workers are here, having a lunch break. ";
	}
	xdesc = "A temporary workshed is to the west, and you can walk around the 
			house to the southeast and southwest. "
	
	south = PinsideHouse
	se = PfrontOfHouse
	sw = PbehindHouse
	west = outsideShed
	east = { "You can't walk across the newly-poured cement driveway. "; }
;

workersLunches: item, floatingItem
	sdesc = "their lunches"
	adesc = { self.sdesc; }
	thedesc = "the workers' lunches"
	ldesc = "Everyone seems to be eating something tasty and refreshing. "
	noun = 'lunch'
	plural = 'lunches'
	isThem = true
	adjective = 'their' 'worker\'s' 'workers\'' 'tasty' 'refreshing' 'yummy'
				'food' 'nosh' 'snack' 'snacks' 'drink' 'drinks' 'beer'
				'coffee' 'sandwich' 'sandwiches' 'stew' 'beef' 'soup'
				'bologna'
	location = 
	{
		if ( workers.onLunchBreak )
			return( workers );
		else return( nil );
	}
	verDoEat( actor ) =
	{
		"The workers say, \"Hey -- get your own lunch!\" ";
	}
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"Sandwiches. Perfect for lunch. Of course, it's
				past dinnertime and getting near midnight-snack time, but 
				still. Good for you. Fill you right up.\" ";
				return( true );
			case Architect:
				"He says, \"Mmmm, lunch would really hit the spot right now,
				but I have to work straight through. I could really go for a 
				nice big sandwich.\" He sighs and goes back to work. ";
				return( true );
			default: 
				return( nil );
		}
	}
;

wetDriveway: fixedBlock, readable, floatingItem
	sdesc = "wet driveway"
	ldesc =
	{
		if ( self.writtenOn )
			"\^<<self.writtenOnDesc>> is written into <<self.thedesc>>	cement. ";
		else if ( self.drawnOn )
			"\^<<self.drawnOnDesc>> is drawn into <<self.thedesc>> cement. ";
		else pass ldesc;
	}
	noun = 'driveway' 'cement' 'concrete' 'paving' 'paved'
	adjective = 'wet' 'fresh' 'freshly' 'poured' 'freshly-poured'
	location = 
	{
		if ( Me.location = PnorthOfHouse || Me.location = PfrontOfHouse )
			return( Me.location );
		else
			return( nil );
	}
	markedWith = Me
	writtenOnDesc = "<<self.markedWith.sdesc>>"
	drawnOnDesc = "a picture of <<self.markedWith.adesc>>"
	smellDesc = "It smells like fresh, wet cement. "
	
	verIoDrawOn( actor ) = 
	{
		if ( self.writtenOn || self.drawnOn )
			"You've already left your mark on the driveway. ";
	}
	ioDrawOn( actor, dobj ) =
	{
		if ( bluePencil.isIn( Me ) )
			"(with the blue pencil) \b";
		else if ( pencil.isIn( Me ) )
			"(with <<pencil.thedesc>>) \b";
		
		self.markedWith := dobj;
		
		if ( dobj = strObj )
		{
			"Okay, you write <<self.writtenOnDesc>> on the wet driveway. ";
			self.writtenOn := true;
			addword( self, &adjective, 'word' );
			addword( self, &adjective, 'words' );
			addword( drivewayDummy, &adjective, 'word' );
			addword( drivewayDummy, &adjective, 'words' );
			addword( FdrivewayDummy, &adjective, 'word' );
			addword( FdrivewayDummy, &adjective, 'words' );
			addword( NFdrivewayDummy, &adjective, 'word' );
			addword( NFdrivewayDummy, &adjective, 'words' );
		}
		else
		{
			"Okay, you draw <<self.drawnOnDesc>> on the wet driveway. ";
			self.drawnOn := true;
			addword( self, &adjective, 'picture' );
			addword( drivewayDummy, &adjective, 'picture' );
			addword( FdrivewayDummy, &adjective, 'picture' );
			addword( NFdrivewayDummy, &adjective, 'picture' );
		}
	}
	verDoDrawOnWith( actor, io ) =
	{
		"You'll have to say what you want to engrave on <<self.thedesc>>. ";
	}
		
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Architect:
				"He says, \"I'm afraid I must ask that you not walk out that way.
				The cement is still wet.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

PfrontOfHouse: constructionSite
	sdesc = "Front of house"
	ldesc =
	{
		"You are standing in what will be the front of your house. The 
		house is currently under construction. The wooden frame has gone 
		up, but apart from that, there's not much to see. A construction 
		blockade is to the northeast, preventing you from stepping on the 
		freshly-poured cement driveway. ";
		
		if ( hugeTruck.location )
			"A huge supply truck sitting on the other side of the 
			driveway, behind the blockade. ";
	}
	xdesc = "You can walk around the house to the northwest and 
			southwest. You can go around the driveway and find the road
			into town to the east. "
	
	sw = PsouthOfHouse
	nw = PnorthOfHouse
	ne = "You can't walk across the newly-poured cement driveway. "
	west = PinsideHouse
	east = Psidewalk
;

hugeTruck: distantItem, fixedBlock
	sdesc = "huge truck"
	ldesc = "A sign on the truck says: Blanc & Lebling Construction Supply 
			Company, Inc. "
	noun = 'truck'
	adjective = 'huge' 'trck' 'marc' 'blanc' 'mark' 'dave' 'david' 'lebling'
			'supply' 'supplies' 'company' 'sign'
	location = PfrontOfHouse
;

blockade: block
	sdesc = "blockade"
	noun = 'blockade' 'block'
	adjective = 'construction'
	location = PfrontOfHouse
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Architect:
				"He says, \"Yes, that's to protect the freshly poured driveway
				cement.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

PbehindHouse: constructionSite
	sdesc = "Behind house"
	ldesc = "You are standing in what will be the back of your house. If you 
			thought it was boring to look at before, you couldn't possibly be 
			less enthusiastic about seeing it now. The wooden frame has gone 
			up, but that is all there is to see. However, there is something 
			new to see, a temporary workshed built by the construction company. "
	xdesc = "The shed sits to the north. You can walk around the house to the 
			northeast and southeast. "
	
	north = outsideShed
	east = PinsideHouse
	se = PsouthOfHouse
	ne = PnorthOfHouse
;

dummyShed: distantItem
	sdesc = "temporary workshed"
	noun = 'shed' 'workshed'
	adjective = 'temporary'
	location = PbehindHouse
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"A workshed. Anything cool in there?\" ";
				return( true );
			case Laura:
				"Laura says, \"I bet some useful stuff gets stored in there.\" ";
				return( true );
			case Architect:
				"He says, \"Yes, that's where we keep extra tools and supplies,
				plant fertilizer, and other items. It's usually open during the
				day and locked every night.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

outsideShed: constructionSite
	sdesc = "Outside workshed"
	ldesc = "The construction company has built a sturdy workshed on your property, 
			apparently for the convenience of storing materials and tools during the 
			job. It is probably locked at night, but right now it is wide open. "
	xdesc = 
	{
		"You can enter the shed to the north. ";
		if ( workers.onLunchBreak )
			"The back of the house is to the south, and you can hear the 
			work crew having lunch up in your driveway to the east. ";
		else
			"The back of the house is to the south, and your driveway 
			is east. ";
	}
	east = PnorthOfHouse
	south = PbehindHouse
	north = insideShed
	in = { return( self.north ); }
;

workshed: staticItem
	sdesc = "workshed"
	ldesc = "It was built for the convenience of storing materials and tools. It is
			probably locked at night, but right now it is wide open. "
	noun = 'workshed' 'shed'
	location = outsideShed
	
	verDoBoard( actor ) = {}
	doBoard( actor ) = { self.doEnter( actor ); }
	
	verDoEnter( actor ) = {}
	doEnter( actor ) = { actor.TravelTo( insideShed ); }
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"A workshed. Anything cool in there?\" ";
				return( true );
			case Laura:
				"Laura says, \"I bet some useful stuff gets stored in there.\" ";
				return( true );
			case Architect:
				"He says, \"Yes, that's where we keep extra tools and supplies,
				plant fertilizer, and other items. It's usually open during the
				day and locked every night.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

insideShed: room
	sdesc = "Inside workshed"
	ldesc = "It's kind of hot and stuffy in here, during the heat of the day. It is also 
			hard for your eyes to adjust to the darkness. The materials that are locked 
			in here at night must all be in use right now, because the shed is basically 
			empty. "
	xdesc = "The only exit is south. "
	listenDesc = 
	{
		if ( not workers.onLunchBreak )
			return( 'You can hear the busy noise of construction work outside. ' );
		else pass listenDesc;
 	}
	smellDesc = "You smell sawdust in the air. "
	
	out = { return( self.south ); }
	south = outsideShed
	firstseen = 
	{
		self.addLeaveList( jug1 );
		self.addLeaveList( jug2 );
		self.addLeaveList( jug3 );
		self.addLeaveList( jug4 );
	}
	threeLeft = 
	{
		local i;
		
		i := length( self.leaveList );
//		"leavelist = <<i>>";
		return ( i = 3 );
	}
	leaveRoom( actor ) = 
	{
		inherited.leaveRoom( actor );
		if ( self.threeLeft )
		{
			local i, len, lst;
			
			lst := insideShed.leaveList;
			len := length(lst);
			
			for (i := 1 ; i <= len ; ++i)			// remove the three jugs 
			{
				lst[i].moveInto( nil );
			}
			
			insideShed.leaveList := [];				// clear the leaveList
			
			"As you step out, a burly landscaper pushes roughly past you. 
			\"Excuse me. I need to use these,\"  he says, and scoops up all 
			three remaining jugs of miracle-grow with ease. He hustles out, 
			whistling a tune. A large black dog trots along beside him, 
			panting and wagging its tail. \b
			
			It occurs to you that you should have taken all of the jugs
			when you had the chance. ";
		}
		return( insideShed );
	}
	
	roomDrop( obj ) =
	{
		if ( Blackie.location = self )
		{
			switch( obj )
			{
				case hotSandwich:
				case coldSandwich: "Before <<obj.thedesc>> even hits the 
					floor, <<Blackie.thedesc>> is all over it, gnawing and
					chewing and slobbering and swallowing. Within seconds,
					nothing is left, and <<Blackie.thedesc>> seems to sigh 
					happily. He wags his tail and woofs at you, having made 
					a new friend. ";
					obj.moveInto( nil );
					Blackie.pacified := true;
					break;
				default: inherited.roomDrop( obj );
					break;
			}
		}
		else pass roomDrop;
	}
;

shed_dummy_interior: fixedBlock
	sdesc = "shed"
	ldesc = { self.location.ldesc; }
	noun = 'shed'
	location = insideShed
	
	ioThrowOut -> shed_exit_door
;

shed_exit_door: fixedBlock
	sdesc = "door"
	ldesc = "Out the door you see the construction site and the woods. "
	noun = 'door'
	adjective = 'open' 'shed'
	location = insideShed
	
	verIoThrowOut( actor ) = {}
	ioThrowOut( actor, dobj ) =
	{
		if ( isclass( dobj, throwable ) )
			dobj.doThrow( actor );
		else
		{
			if ( ( dobj = hotSandwich ) or ( dobj = coldSandwich ) )
			{
				if ( Blackie.location != insideShed ) { 
					"Okay, you throw <<dobj.thedesc>> out the door. ";
					dobj.moveInto( outsideShed );
				}
				"You throw <<dobj.thedesc>> outside the shed. \^<<Blackie.thedesc>> runs
				out after it and wolfs it down. He returns, settled into a pacified 
				state of canine bliss. ";
				
				dobj.moveInto( nil );
				self.pacified := true;
			}
			else 
			{
				"Okay, you throw <<dobj.thedesc>> out the door. ";
				dobj.moveInto( outsideShed );
			}
		}
	}
;

jug1: miracleGrowItem
	pourItem = liquid1
	emptyJug = emptyJug1
	location = insideShed
;
liquid1: liquidItem
	jugItem = jug1
	location = jug1
;
jug2: miracleGrowItem
	pourItem = liquid2
	emptyJug = emptyJug2
	location = insideShed
;
liquid2: liquidItem
	jugItem = jug2
	location = jug2
;
jug3: miracleGrowItem
	pourItem = liquid3
	emptyJug = emptyJug3
	location = insideShed
;
liquid3: liquidItem
	jugItem = jug3
	location = jug3
;
jug4: miracleGrowItem
	pourItem = liquid4
	emptyJug = emptyJug4
	location = insideShed
;
liquid4: liquidItem
	jugItem = jug4
	location = jug4
;
jug5: miracleGrowItem
	pourItem = liquid5
	emptyJug = emptyJug5
	location = nil
	leaving( actor ) = { return( nil ); }
/*	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"It probably sounds like overkill, but I bet
				that acorn could use even more of that fertilizer. Where 
				were you getting it from, anyway?\" ";
				return( true );
			case Laura:
				"Laura says, \"Young plants just gobble that miracle-grow 
				up. I bet you could even pour one more jug on there. Where
				did you find the other jugs of it?\" ";
				return( true );
			case Architect:
				"He says, \"That product is really something. I've seen it turn
				normally slow-growing plants into giant, towering fauna.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
*/
;
liquid5: liquidItem
	jugItem = jug5
	location = jug5
;
emptyJug1: emptyJugItem
;
emptyJug2: emptyJugItem
;
emptyJug3: emptyJugItem
;
emptyJug4: emptyJugItem
;
emptyJug5: emptyJugItem
;

Blackie: NPC
	isfixed = nil
	isHim = true
	sdesc = "<<dog_tag.read ? "Blackie" : "huge dog">>"
	adesc = "<<dog_tag.read ? "Blackie" : "a huge dog">>"
	thedesc = "<<dog_tag.read ? "Blackie" : "the huge dog">>"
	ldesc = "He's some sort of <<self.pacified ? "happy":"vicious">> doberman with 
		greasy black fur. He's wearing a collar with a tag, so he's obviously 
		not a stray. "
	actorDesc = 
	{
		"\^<<self.adesc>> is sitting here. ";
		
		if ( hotSandwich.deepIsIn( Me ) || coldSandwich.deepIsIn( Me ) )
		{
			"He smells that you have food with you and begins 
			salivating and barking. ";
		}
	}
	noun = 'dog' 'blackie' 'cur' 'doberman' 'canine' 'doggie' 'doggie' 'boy'
	adjective = 'vicious' 'snarling' 'greasy' 'black' 'fur' 'happy' 'contented' 
		'pacified' 'playful' 'huge'
	plural = 'dogs'
	location = nil
	pacified = nil
	
	MAX_actions = 33
	action = 0
	actorDaemon = 
	{
		if ( Me.location = self.location )
		{
			if ( self.wasTalkedTo = nil )
			{
				local temp;
				if ( ( self.action > self.MAX_actions ) or ( self.action < 0 ) )
					self.action := 0;
				doBlackieAction( self.action );
				self.action++;
			}
		}
		self.wasTalkedTo := nil;
	}
	retrieveCount = 0
	retrieveItem = nil
	retrieveThrowable =
	{
		self.retrieveCount++;
		if ( self.retrieveCount = 7 )
		{
			if ( Me.location = insideShed )
			{
				"\^<<self.thedesc>> comes bounding back into the shed
				and drops the slobbery <<self.retrieveItem.sdesc>> at
				your feet. From outside, you hear a sharp whistle that
				gets <<self.thedesc>>'s attention. A voice calls out,
				\"Blackie! Here boy!\" \b
				\^<<self.thedesc>> runs off. ";
				self.moveInto( nil );
				self.retrieveItem.moveInto( insideShed );
				self.retrieveItem := nil;
			}
			else if ( ( global.timeLoc != 2 ) || ( Me.location = P2ndFloor ) ||
				( !isclass( Me.location, constructionSite ) ) )
			{
				self.moveInto( insideShed );
				self.pacified := true;
				self.retrieveItem.moveInto( insideShed );
				self.retrieveItem := nil;
			}
			else 
			{
				"\^<<self.thedesc>> comes bounding up to you and deposits
				the slobbery <<self.retrieveItem.sdesc>> at your feet. From 
				somewhere nearby, you hear a sharp whistle that 
				gets <<self.thedesc>>'s attention. A voice calls out,
				\"Blackie! Here boy!\" \b
				\^<<self.thedesc>> runs off. ";
				self.moveInto( nil );
				self.pacified := true;
				self.retrieveItem.moveInto( topLocation( Me ) );
				self.retrieveItem := nil;
			}
			unnotify( self, &retrieveThrowable );
		}	
	}
	
	disavow( it ) =
	{
		if ( self.pacified ) 
			"\n\^<<self.thedesc>> doesn't seem to understand, and cocks his 
			head to one side. ";
		else
			"\n\^<<self.thedesc>> growls at you. ";
	}
	sayHello = 
	{
		"\^<<self.thedesc>> <<self.pacified?"barks and wags his tail":
		"growls at you">>. ";
	}
	talkAboutMyself = 
	{
		self.disavow( nil );
	}
	sayMyJob =
	{
		self.disavow( nil );
	}
	responseToThanks = 
	{
		if ( self.pacified )
			"\^<<self.thedesc>> wags his tail happily. ";
		else
			"\^<<self.thedesc>> growls at you. ";
	}
	actorAction( v, d, p, i ) =
	{
		if ( Me.isIn( self.location ) )
		{
			if ( v = helloVerb )
			{
				self.sayHello;
			}
			else if ( v = followVerb )
			{
				"\n\^<<self.thedesc>> doesn't appear interested in 
				following <<d.fmtYoum>>. ";
			}
			else if ( v = waitVerb || v = singVerb || v = danceVerb || 
				v = smileVerb || v = giveVerb )
			{
				if ( !self.pacified )
					self.disavow( nil );
				else
					"\n\^<<self.thedesc>> looks at you quizzically. ";
			}
			else if ( v = goodVerb )
			{
				if ( !self.pacified )
					self.disavow( nil );
				else
					"\^<<self.thedesc>> woofs and wags his tail. ";
			}
			else if ( v = badVerb )
			{
				if ( !self.pacified )
					self.disavow( nil );
				else
					"\^<<self.thedesc>> whimpers and hangs his tail. ";
			}
			else if ( v = talkToVerb )
			{
				if ( !self.pacified )
					self.disavow( nil );
				else
					"\^<<self.thedesc>> woofs. ";
			}
			else if ( v = standVerb )
			{
				if ( !self.pacified )
					self.disavow( nil );
				else
					"\^<<self.thedesc>> attempts to stand on his hind
					legs, then flops forward, barking and wagging his
					tail. ";
			}
			else if ( v = sitVerb )
			{
				if ( !self.pacified )
					self.disavow( nil );
				else
					"\^<<self.thedesc>> sits up straight and tall. ";
			}
			else if ( v = lieVerb )
			{
				if ( !self.pacified )
					self.disavow( nil );
				else
					"\^<<self.thedesc>> stretches out on all fours. ";
			}
			else if ( v = rollVerb )
			{
				if ( !self.pacified )
					self.disavow( nil );
				else
					"\^<<self.thedesc>> wags his tail and rolls over. ";
			}
			else if ( v = takeVerb )
			{
				if ( isclass( d, throwable ) )
					d.doThrowTo( Me, Blackie );
				else
					self.disavow( nil );
			}
			else
				self.disavow( nil );
		}
		else 
			"\n\^<<self.thedesc>> isn't here. ";
		exit;
	}
	
	ioShowTo( actor, dobj ) =
	{
		if ( not consultWords( dobj, self, 1 ) )
			self.disavow( nil );
		self.wasTalkedTo := true;
	}
	
	verIoGiveTo( actor ) = {}
	ioGiveTo( actor, dobj ) =
	{
		if ( ( dobj = hotSandwich ) or ( dobj = coldSandwich ) )
		{
			"\^<<self.thedesc>> wolfs down <<dobj.thedesc>>, then
			settles into a pacified state. ";
			
			dobj.moveInto( nil );
			self.pacified := true;
		}
		else if ( ( dobj = tennisBall ) or ( dobj = frisbee ) )
		{
			"\^<<self.thedesc>> regards <<dobj.thedesc>> with a keen
			canine interest. He wags his tail aggressively, his eyes
			locked on <<dobj.thedesc>>. ";
			
			dobj.hasBlackiesInterest := true;
		}
		else 
		{
			"That isn't likely to interest <<self.thedesc>>. ";
		}
	}
	verDoBuy( actor ) = { "\^<<self.thedesc>> belongs to someone else and is 
		probably not for sale. "; }
	verDoLaughAt( actor ) = 
	{
		"You laugh at <<self.thedesc>>, perhaps intending to communicate
		that you are not afraid of him. ";
	}
	
	verDoTake( actor ) = 
	{
		if ( self.pacified )
			"\^<<self.thedesc>> is much too big a dog for you to pick up. "; 
		else
			self.disavow( nil );
	}
	
	verDoFollow( actor ) = {}
	doFollow( actor ) = { self.doCatch( actor ); }
	
	verDoGood( actor ) =
	{
		if ( self.pacified )
			"\^<<self.thedesc>> woofs and wags his tail. ";
		else
			self.disavow( nil );
	}
	
	verDoCatch( actor ) = {}
	doCatch( actor ) =
	{
		"\^<<self.thedesc>> doesn't seem to be on the move at the moment. ";
	}
	
	doTouch -> dog_head
	doRub -> dog_belly
	doScratch -> dog_head
	doTickle -> dog_belly
	doTickleWith -> dog_belly
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"Shoot. Just feed it or get it to chase something.\" ";
				return( true );
			case Laura:
				"Laura says, \"I'm more of a cat person.\" ";
				return( true );
			case Architect:
				"He says, \"Oh, Blackie? Yeah, he belongs to someone on
				the crew. A bit of an angry cur, but easily distracted.\" ";
				return( true );
			case workers:
				"Someone says, \"He belongs to that landscaping guy.\"\n
				Someone else says, \"He means the guy with the big jugs,\" to much
				laughter. ";
			default: 
				return( nil );
		}
	}
;

dog_tag: fixeditem, readable
	sdesc = "dog tag"
	ldesc = 
	{
		"The dog's collar tag says that his name is \"Blackie.\" ";
		if ( !self.read )
			self.read := true;
	}
	noun = 'tag'
	adjective = 'blackie\'s' 'his' 'dog\'s' 'collar'
	location = Blackie
;

dog_paws: fixeditem
	sdesc = "<<Blackie.sdesc>>'s paws"
	thedesc = "<<Blackie.thedesc>>'s paws"
	adesc = { self.thedesc; }
	ldesc = "\^<<self.thedesc>> are beefy and full of nasty sharp claws. "
	noun = 'paw' 'claw' 'leg'
	plural = 'paws' 'claws' 'legs'
	isThem = true
	adjective = 'beefy' 'his' 'dog\'s' 'blackie\'s' 'beefy' 'nasty' 'sharp'
	location = Blackie
;

dog_ears: fixeditem
	sdesc = "<<Blackie.sdesc>>'s ears"
	thedesc = "<<Blackie.thedesc>>'s ears"
	adesc = { self.thedesc; }
	ldesc = "\^<<self.thedesc>> are alert and pointy. "
	noun = 'ear' 
	plural = 'ears'
	isThem = true
	adjective = 'his' 'dog\'s' 'blackie\'s' 'alert' 'pointy' 'pointed'
	location = Blackie
	
	verDoTouch( actor ) = 
	{
		if ( !Blackie.pacified )
			"\^<<Blackie.thedesc>> growls as you attempt to pet him. ";
	}
	doTouch( actor ) =
	{
		"You pet <<self.thedesc>>. He woofs. ";
	}
	
	verDoRub( actor ) = 
	{
		if ( !Blackie.pacified )
			"\^<<Blackie.thedesc>> growls as you attempt to pet him. ";
	}
	doRub( actor ) =
	{
		"You rub <<self.thedesc>>, giving him a few moments
		of doggie bliss. ";
	}
	
	verDoScratch( actor ) = 
	{
		if ( !Blackie.pacified )
			"\^<<Blackie.thedesc>> growls as you attempt to touch him. ";
	}
	doScratch( actor ) =
	{
		"You scratch <<self.thedesc>>. He closes his eyes and wags his 
		tail wags happily. ";
	}
	
	verDoTickle( actor ) = 
	{
		if ( !Blackie.pacified )
			"\^<<Blackie.thedesc>> growls as you attempt to touch him. ";
	}
	doTickle( actor ) =
	{
		"You tickle <<self.thedesc>>. He moves his head away and barks at you. ";
	}
	
	verDoTickleWith( actor, io ) = 
	{
		if ( !Blackie.pacified )
			"\^<<Blackie.thedesc>> growls as you attempt to pet him. ";
	}
	doTickleWith( actor, io ) = 
	{
		if ( io = Me )
			self.doTickle( actor );
		else
			"\^<<io.thatdesc>> <<io.isntdesc>> something you should 
			tickle <<self.thedesc>> with. ";
	}
;

dog_belly: fixeditem
	sdesc = "<<Blackie.sdesc>>'s belly"
	thedesc = "<<Blackie.thedesc>>'s belly"
	adesc = { self.thedesc; }
	ldesc = "\^<<self.thedesc>> is covered in black fur. "
	noun = 'belly'
	adjective = 'his' 'dog\'s' 'blackie\'s' 'underbelly' 'tummy' 'stomach'
	location = Blackie
	
	verDoTouch( actor ) = 
	{
		if ( !Blackie.pacified )
			"\^<<Blackie.thedesc>> growls as you attempt to pet him. ";
	}
	doTouch( actor ) =
	{
		"You pet <<self.thedesc>>. He woofs happily. ";
	}
	
	verDoRub( actor ) = 
	{
		if ( !Blackie.pacified )
			"\^<<Blackie.thedesc>> growls as you attempt to pet him. ";
	}
	doRub( actor ) =
	{
		"You rub <<self.thedesc>>, giving him a few moments
		of doggie bliss. ";
	}
	
	verDoScratch( actor ) = 
	{
		if ( !Blackie.pacified )
			"\^<<Blackie.thedesc>> growls as you attempt to touch him. ";
	}
	doScratch( actor ) =
	{
		"You scratch <<self.thedesc>>. He closes his eyes and wags his 
		tail happily. ";
	}
	
	verDoTickle( actor ) = 
	{
		if ( !Blackie.pacified )
			"\^<<Blackie.thedesc>> growls as you attempt to touch him. ";
	}
	doTickle( actor ) =
	{
		"You tickle <<self.thedesc>>. He barks at you. ";
	}
	
	verDoTickleWith( actor, io ) = 
	{
		if ( !Blackie.pacified )
			"\^<<Blackie.thedesc>> growls as you attempt to pet him. ";
	}
	doTickleWith( actor, io ) = 
	{
		if ( io = Me )
			self.doTickle( actor );
		else
			"\^<<io.thatdesc>> <<io.isntdesc>> something you should 
			tickle <<self.thedesc>> with. ";
	}
;

dog_head: fixeditem
	sdesc = "<<Blackie.sdesc>>'s head"
	thedesc = "<<Blackie.thedesc>>'s head"
	adesc = { self.thedesc; }
	ldesc = "\^<<self.thedesc>> is covered in black fur. "
	noun = 'head'
	adjective = 'his' 'dog\'s' 'blackie\'s' 'head'
	location = Blackie
	
	verDoTouch( actor ) = 
	{
		if ( !Blackie.pacified )
			"\^<<Blackie.thedesc>> growls as you attempt to pet him. ";
	}
	doTouch( actor ) =
	{
		"You pet <<self.thedesc>>. He woofs happily. ";
	}
	
	verDoRub( actor ) = 
	{
		if ( !Blackie.pacified )
			"\^<<Blackie.thedesc>> growls as you attempt to pet him. ";
	}
	doRub( actor ) =
	{
		"You rub <<self.thedesc>>, giving him a few moments
		of doggie bliss. ";
	}
	
	verDoScratch( actor ) = 
	{
		if ( !Blackie.pacified )
			"\^<<Blackie.thedesc>> growls as you attempt to touch him. ";
	}
	doScratch( actor ) =
	{
		"You scratch <<self.thedesc>>. He closes his eyes and wags his 
		tail happily. ";
	}
	
	verDoTickle( actor ) = 
	{
		if ( !Blackie.pacified )
			"\^<<Blackie.thedesc>> growls as you attempt to touch him. ";
	}
	doTickle( actor ) =
	{
		"You tickle <<self.thedesc>>. He barks at you. ";
	}
	
	verDoTickleWith( actor, io ) = 
	{
		if ( !Blackie.pacified )
			"\^<<Blackie.thedesc>> growls as you attempt to pet him. ";
	}
	doTickleWith( actor, io ) = 
	{
		if ( io = Me )
			self.doTickle( actor );
		else
			"\^<<io.thatdesc>> <<io.isntdesc>> something you should 
			tickle <<self.thedesc>> with. ";
	}
;

dog_tail: fixeditem
	sdesc = "<<Blackie.sdesc>>'s tail"
	thedesc = "<<Blackie.thedesc>>'s tail"
	adesc = { self.thedesc; }
	ldesc = "\^<<self.thedesc>> is <<self.pacified?"wagging happily":
		"straight and still at the moment">>. "
	noun = 'tail'
	adjective = 'his' 'dog\'s' 'blackie\'s'
	location = Blackie
;

workerMessageStuff1: unimportantItem, floatingItem
	sdesc = { self.thatdesc; }
	thedesc = { self.thatdesc; }
	adesc = { self.thatdesc; }
	noun = 'hammer'
	plural = 'hammers'
	isThem = true
	location = 
	{
		if ( Me.location.constructionArea )
			return( Me.location );
		return( nil );
	}
	adjective = 'covered' 'dust' 'dust-covered' 'strongarms' 'bundle' 'bundles' 
			'copper' 'piping' 'favorite' 'winch' 'pulley' 'manufacturer' 
			'manufacturers' 'wood' 'screw' 'screws' 'flim' 'flanged' 
			'flim-flanged' 'duct' 'ducts' 'trio' 'puffy' 'face' 
			'faces' 'dirty' 'jokes' 'joke' 'round' 'spectacles' 
;

workerMessageStuff2: unimportantItem, floatingItem
	sdesc = { self.thatdesc; }
	thedesc = { self.thatdesc; }
	adesc = { self.thatdesc; }
	noun = 'block'
	plural = 'blocks'
	isThem = true
	location = 
	{
		if ( Me.location.constructionArea )
			return( Me.location );
		return( nil );
	}
	adjective = 'cinder' 'bibble' 'brrrrrr' 'brrrr' 'brr' 'brrr' 'bibble-brrrrrr' 
			'noise' 'noises' 'team' 'idle' 'shingler' 'shinglers'
			'tiles' 'tile' 'slouching' 'plumbers' 'hard' 'hat' 'hats'
			'crossbeams' 'young' 'boys' 'kids' 'nail' 'nails' 
			'lip' 'lips' 'high' 'heel' 'heels' 'electricians' 
			'cartons' 'vain' 'cries' 'protest'
;

workerMessageStuff3: unimportantItem, floatingItem
	sdesc = { self.thatdesc; }
	thedesc = { self.thatdesc; }
	adesc = { self.thatdesc; }
	noun = 'paint'
	location = 
	{
		if ( Me.location.constructionArea )
			return( Me.location );
		return( nil );
	}
	adjective = 'teen' 'teenaged' 'teenager' 'langstrom' '7-inch' 'gangley' 'wrench' 
			'huge' 'mustache' 'trowel' 'bag' 'plaster' 'mix' 'short' 'blue' 
			'foreman' 'crash' 'burst' 'laughter' 'sharp' 'young' 'large' 'box' 
			'sweaty' 'red-faced' 'red' 'faced' 'Ed' 'nervous' 'scruffy' 'chest' 
			'hair' 'beefy' 'blond' 'nose' 'sleeve' 'shirt' 'spectacle' 'wiry' 
			'crashing' 'fat' 'handsome' 'tanned' 'whoop' 'poker' 'gin' 'rummy' 
			'blackjack' 'card' 'game' 'somber' 'length' 'thick' 'cabling' 'set' 
;

workerMessageStuff4: unimportantItem, floatingItem
	sdesc = { self.thatdesc; }
	thedesc = { self.thatdesc; }
	adesc = { self.thatdesc; }
	noun = 'plumber'
	location = 
	{
		if ( Me.location.constructionArea )
			return( Me.location );
		return( nil );
	}
	adjective = 'slouching' 'chewing' 'gum' 'man' 'tall' 'hard' 'hat'
			'crossbeam' 'level' 'smoky' 'exhaust' 'old' 'gent' 
			'young' 'boy' 'kid' 'lip' 'lips' 'selection' 'beautiful' 'cable' 
			'ol' 'ol\'' 'Meretzsky' 'electrician' 'carton' 'someone' 'first' 'voice' 
			'Artie' 'woman' 'brian' 'noisy' 'blast' 'mixer' 'wheeler' 'moriarty'
			'steve' 'steven' 'fooblitzsky' 'infocom' 'zork' 'deadline'
;

noTea: item, floatingItem
	sdesc = "no tea"
	ldesc = 
	{
		"There's no tea to see. ";
		self.jokeOver;
	}
	noun = 'tea'
	adjective = 'no' 'cup' 'cup of'
	location = 
	{
		if ( Me.location.constructionArea && not self.jokeOver )
		{
			return( Me.location );
		}
		return( nil );
	}
	verDoTake( actor ) = 
	{
		"No tea: Taken. ";
	}
;

constructionBudget: fixeditem
	sdesc = "construction budget"
	noun = 'budget'
	adjective = 'construction'
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Architect:
				"He looks at you for a moment without saying anything. \b
				\"Yes, I must admit, we are over budget. Not by much. Twenty
				five hundred dollars, perhaps. ";
				
				if ( global.newRoof )
					"Perhaps thiry or thirty two, with the new roof. ";
				
				"I know you have basically spent all you can, and will have to 
				squeeze every last penny you have to cover it. We are on schedule, 
				if that is any consolation.\" \b
				
				He pats you on the shoulder before settling down in the chair.
				\"I know it's a tough compromise. You'll be living in a nice 
				house, but will barely have enough to keep it over your head.\" ";
				
				Architect.askedAboutBudgetProblem;
				return( true );
			default: 
				return( nil );
		}
	}
;

Psidewalk: room
	sdesc = "Sidewalk"
	ldesc = "The concrete sidewalk that leads away from your house is also recently
			poured. The unpaved dirt road that leads in the direction of the 
			construction site has been crisscrossed by a number of vehicles with 
			large treads. "
	xdesc = "The road takes a bend here to the north. The construction site is back 
			to the west. "
	west = PfrontOfHouse
	north = PlinkRoad
;

PdecorativeSidewalk: fixedBlock
	sdesc = "sidewalk"
	ldesc = "The concrete sidewalk that leads away from your house has been recently
			poured. It is fresh and white and clean. "
	noun = 'sidewalk'
	adjective = 'concrete' 'fresh' 'poured' 'recently' 'white' 'clean'
	location = Psidewalk
;

PdirtRoad2: fixedBlock
	sdesc = "dirt road"
	ldesc = { self.location.xdesc; }
	noun = 'road'
	adjective = 'unpaved' 'dirt' 'large' 'treads'
	location = Psidewalk
;

PlinkRoad: room
	sdesc = "Oakwood drive"
	ldesc = "This pleasant road wanders peacefully through the lush tree growths
			native to the area. In the intervening years, they'll straighten 
			the road and widen it, cutting down dozens of these forty- to 
			ninety-year-old live oaks. "
	xdesc = "The road leads north into the shopping village, and south in 
			the direction of your house. "
	north = Pvillage
	south = Psidewalk
;

PoakTrees: block
	sdesc = "live oak trees"
	ldesc = "The aging live oaks rise to forty or fifty feet in height at their 
			bushiest. "
	location = PlinkRoad
	noun = 'tree' 
	plural = 'trees' 'oaks' 
	isThem = true
	adjective = 'oak' 'live' 'growth' 'lush' 'old' 'native'

	verDoClimb( actor ) =
	{
		"These trees are not suitable for climbing. ";
	}
;

PwindingRoad: fixedBlock
	sdesc = "pleasant road"
	location = PlinkRoad
	noun = 'road' 'street'
	adjective = 'winding' 'pleasant' 'wandering'
;

PdummyPath4: block
	sdesc = "path"
	location = PlinkRoad
	noun = 'path'
;

PdummyForest: fixedBlock
	sdesc = "forest"
	noun = 'forest'
	location = PlinkRoad
;

Pvillage: room
	sdesc = "In the village"
	ldesc = "The little shopping village looks a little different than you're used to 
			seeing it. Colored signs point you to this merchant and that. "
	xdesc = "To the west is the bank, which seems like it's always been 
			here and always will. To the east is an empty plot of land. The 
			sandwich shop is to the north. The road leading back is south. "
	north = "It's lunchtime, and the sandwich shop is crowded with customers. You
			don't feel like fighting your way through the line. "
	in = { askdo; }
	west = Pbank
	east = 
	{
		emptyPlot.ldesc;
		return( nil );
	}
	south = PlinkRoad
;

Psigns: fixedBlock, readable
	sdesc = "colorful signs"
	ldesc = "The colorful signs say \"Bank <-- to your left\", \"Sandwiches 
			straight ahead.\" "
	noun = 'sign'
	plural = 'signs'
	isThem = true
	adjective = 'colorful' 'colourful' 'colored' 'color' 'colour' 'coloured'
	location = Pvillage
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"The signs out in the village there? Yeah, what about
				them? I barely pay attention to them any more, I've seen them so
				many times.\" ";
				return( true );
			case Laura:
				"Laura says, \"The what? What signs? I haven't seen any signs.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

PwindingRoad2: fixedBlock
	sdesc = "pleasant road"
	location = linkRoad
	noun = 'road' 'street'
	adjective = 'winding' 'pleasant' 'wandering'
;

emptyPlot: fixedBlock
	sdesc = "empty plot"
	ldesc = "This plot of razed land <<FPvillage.isseen ? "is where the antique shop 
			used to sit and" : "is">> where the library will someday be. "
	noun = 'plot'
	adjective = 'empty'
	location = Pvillage
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case PLaura:
				"Laura says, \"I think they're going to build a public library
				there.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

Pbank: lockableDoorway
	isopen = true
	islocked = nil
	sdesc = "bank"
	ldesc = "This VistaBank has been here as long as you can remember. In fact, it's been
			around even longer than that, because here it is, and open for business. "
	noun = 'bank'
	doordest = inTheBank
	location = Pvillage
	mykey = PvillageKey
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"I keep my money there. I can't wait for them to 
				build a teller machine so that I can get money whenever I want,
				even when it's closed.\" ";
				return( true );
			case Laura:
				"Laura says, \"This really is a good bank. The interest rates are
				really good, if you keep your money stored for a long term.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

PnewAccounts: room
	sdesc = "New accounts"
	ldesc = "The new accounts area is a clean little area in the corner of the
			bank. No one seems to be here. "
	xdesc = "The lobby is back to the north. "
	north = inTheBank
;

PnewAccountsDesk: unimportantItem
	sdesc = "desk"
	ldesc = "A sign on the desk says, \"Back at 1:30pm.\" It must be a lunch
			break. "
	noun = 'desk'
	adjective = 'new' 'accounts'
	location = PnewAccounts
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Laura:
				"Laura taps the desk. \"Yup, it's my desk. Personally, I kind of
				want to get out from behind it. Just don't tell my boss that.\" ";
				return( true );
			default: 
				return( nil );
		}
	}
;

PdummyShop: lockableDoorway
	isopen = true
	islocked = nil
	sdesc = "sandwich shop"
	ldesc = 
	{
		"This sandwich shop is the only one in the area, so it is 
		heavily frequented by a few dedicated regulars. In fact, you 
		ate here only this morning. The shop is ";

		if ( self.isopen )
			"open for business. ";
		else
			"closed for the night. ";
	}
	noun = 'shop'
	adjective = 'subway' 'sub' 'sandwich' 'hoagie'
	location = Pvillage
	mykey = PvillageKey
	doordest = PsandwichShop
	
	askingAboutMe( who ) =
	{
		switch( who )	 // matches with NPC class objects
		{
			case Fred:
				"Fred says, \"Yep. I've worked here for about six years now.
				It's not too bad a place, if you can stand to go home covered
				in mustard and bread crumbs every day. We use the best all-natural
				ingredients, by the way, and bake our bread fresh in the morning.\" ";
				return( true );
			case Laura:
				"Laura says, \"Oh, I wish there were a sandwich shop near here.\" ";
				return( true );
			case Architect:
				if ( global.scoreCard[17] = 1 )
					"He says, \"That sandwich really hit the spot, all right. 
					Thanks again.\" ";
				else
					"He says, \"I really wish I didn't have to work through 
					lunch today. I could really go for a nice big sandwich.\" ";
				return( true );
			case FFred:
				"\^<<FFred.thedesc>> says, \"Eh? What do you know about it, that damn
				sandwich shop! Ten years of my life I gave that place. I was gonna be
				manager. I knew that place like nobody. Then they tell me -- they 
				tell me that I'm drinking too much. I says to them, I says, 'Hah! My
				problem is I don't drink enough, to put up with what I gotta deal 
				with!\" \b
				
				He goes silent for a minute, lost in thought, or perhaps just simply
				lost. \b
				
				\"They can tear it down for all I care,\" he says finally. \"In fact, 
				I hear that's what's gonna happen.\" \b
				
				\^<<FFred.thedesc>> throws his arm in a wide circle, stifling a
				bout of coughing. \"All this. All this is going to become -- get this,
				this is what I hear -- a parking lot. And a big building. It's all
				going to Hell.\" \b
				
				He looks up at you, looking for a reaction. \"Ah, what am I telling
				you for? You can't do nothin' about it.\" ";
				
				return( true );
			default: 
				return( nil );
	  	}
	}
;

PsandwichShop: room
	indoors = true
	sdesc = "In the sandwich shop"
	ldesc = "The room is painted a gaudy yellow color. On closer inspection, it is 
			merely spattered with mustard stains. That's the kind of shop this is, 
			I guess -- heavily frequented because it's the only one nearby. There's 
			a counter, a menu, a big advertisement, and a row of tables and chairs. "
	xdesc = "The door is to the south. "
	south = Pvillage
	out = Pvillage
;

PvillageKey: keyItem								// no such key exists in the game
	sdesc = "village key"
	location = nil
;

PLaura: NPC
	sdesc = "Laura"
	ldesc = 
	{
		if ( not self.met )
		{
			"You recognize her as Laura, the woman from the bank. In fact, 
			now that she is older, you remember that you met her before, around
			this time -- subjectively speaking. She was a junior manager at the 
			bank, and you talked to her on one or two occasions about the 
			mortgage on the house, and setting up your trust fund to pay for
			it. Since this is one of those occasions, it enters your head that
			you might have to worry about meeting yourself in the past, but
			you're pretty sure you don't remember dropping by the construction
			site on this particular day. \b";
			
			self.met := true;
		}
		
		"Laura is dressed in a knee-length violet skirt and matching shoes, with a
		sleeveless white blouse that's opened a couple of buttons at the 
		top, a concession to the summery weather. She looks tanned and 
		healthy, but there is a distinct pensiveness in her green eyes. ";
	}
	isHer = true
	noun = 'woman'
	adjective = 'past' 'her' 'laura' 'ms' 'miss' 'remick'
	
	buyCommandPending = nil
	buyCommand( dobj ) = 
	{
		if ( !dobj.isStock )
		{
			"That isn't something you can tell Laura to buy stock in. ";
		}
		else if ( self.walkPathCount < 7 )
		{
			"Laura says, \"\^<<dobj.sdesc>>? Hold that thought until we 
			get back to my office.\" ";
			
			self.buyCommandPending := dobj;
		}
		else 
		{
			"Laura says, \"<<self.buyCommandPending.sdesc>>, you think? Let's see.\" ";
			dobj.handleStockPurchase;
		}
		return( true );
	}
	
	disavow( it ) =
	{
		"She doesn't seem to register that you asked a question. You get
		the feeling she has a lot of other things on her mind right now. ";
	}
	
	ioGiveTo( actor, dobj ) = 
	{
		if ( dobj = playerCash || playerCash.location = dobj )
		{
			"Laura's eyes go wide. \"Goodness, I didn't expect you to 
			pay in cash!\" ";
			if ( playerCash.value > 1000 )
				"She eyes the money curiously. \"And I won't ask where
				this came from, either,\" she says with a wry smile. ";
			"She hands it back to you. \"You should deposit this in the bank
			where it's safe, because I'll make the transfers electronically.
			Then tell me if you have an idea what stock you want me to 
			invest in.\" ";
		}
		else if ( dobj = loosePapers )
		{
			"You pick up as many of the papers as you can and hand them
			to Laura. \"Thank you, I'm so sorry about this,\" she says, 
			embarrassed. She crams them all into the briefcase in a hasty
			fashion, then seems to reconsider the wisdom of this and tries
			to start sorting them into their former order. Within moments,
			she gives up. \b
			
			\"Laura Remick, this is not your day,\" she mumbles to herself. ";
			loosePapers.moveInto( nil );
		}
		else if ( dobj = sealedEnvelope )
		{
			"Laura reacts with curious surprise as you hold out the sealed
			envelope to her. \"I'm sorry to be rude, but I don't know why
			you think I want that,\" she says as she folds her arms. ";
		}
		else pass ioGiveTo;
	}
	
	askingAboutMe( who ) =
	{
		return( askingAboutLaura.askingAboutMe( who ) );
	}
	
	talkAboutMyself =
	{
		"Laura says, \"Technically, I'm here to talk about you, but...\" She 
		gazes off for a moment. \"I am what I am, I guess. 12 years into my
		temporary summer job, I guess it's a career now. I'm the associate 
		director now, well, one of five. I don't have much of a life besides
		this. None worth talking about, anyway.\" ";
	}
	responseToThanks = 
	{
		if ( dibbleBitsStock.isOwned ) 
			"\^<<self.thedesc>> says, \"Oh, you're very welcome.\" ";
		else
			"\^<<self.thedesc>> laughs self-consciously and says, \"I can't 
			think what you're thanking me for.\" ";
	}
	
	walkPath = [ PsouthOfHouse PfrontOfHouse Psidewalk PlinkRoad 
			Pvillage inTheBank PLaurasOffice inTheBank ]
	walkPathCount = 0
	daemonCount = 0
	waitForHelp = 0
	actorDaemon =
	{
		if ( not Laura.isSeen ) return;
		
		if ( not self.readyToAppear )
		{
			if ( global.timeLoc != 2 )
				self.readyToAppear := true;
			else return;
		}
		
		if ( Me.location != Pwoods && self.walkPathCount = 0 )
			return;
		
		daemonCount++;
		switch( self.daemonCount )
		{
			case 1:
				"\bYou hear a woman calling your name from the northeast. A vibrant
				young woman in a professional suit is hurrying to catch up to you.
				\"Wait, wait,\" she says. \"The foreman said they'd seen you going
				down this way.\" \b
				
				Paying careful attention to where she is stepping in her heeled 
				shoes, she neglects her hand, which is carrying a dark leather 
				briefcase. When she reaches the bend in the path, she smacks her
				briefcase directly into the rock. It splits open and tumbles out
				of her hand, and paper scatters everywhere. \b
				
				\"Ooh! This is not my day!\"\ she sighs as she kneels and starts
				to pick up her papers. ";
				
				loosePapers.moveInto( Pwoods );
				setit( PLaura, 2 );
				self.moveInto( Pwoods );
				break;
			case 2: 
				if ( loosePapers.location && self.waitForHelp < 3 )
				{
					"\bLaura continues to pick up the loose papers and put
					them hastily back into her briefcase. ";
					
					self.daemonCount--;
					self.waitForHelp++;
				}
				else
				{
					if ( loosePapers.location )
					{
						if ( loosePapers.deepIsIn( Me ) )
							"You hand the loose papers you've collected to Laura. 
							She crams them all into the briefcase in a hasty
							fashion. \b";
						else
							"Laura finishes picking up her loose papers. She 
							crams them all into the briefcase in a hasty 
							fashion. \b";
						
						loosePapers.moveInto( nil );
					}
					
					"\bLaura straightens herself up. \"Thank you. I'm such a 
					spaz these days.\" She looks at you straight on for the
					first time, and a funny look comes over her face. \"You
					look different. Have you suddenly grown older?\" She 
					shakes her head. \"Never mind. That was rude of me, sorry.\" \b
					
					She ruffles through the papers, looking for something. 
					\"I came to talk to you about your trust fund and issues
					concerning construction cost ...\"\ she says, \"Argh, I can't
					find the papers, now, of course.\" ";
				}
				break;
			case 3:
				"\bLaura looks at you soberly. She says, \"I got a call from 
				Mr.\ Mayhew concerning certain improvements to the house that you
				have called for that significantly drive up the cost of 
				construction.\" She continues her fruitless search for the
				right document. \"Something about a better grade of roofing? Well,
				there's good news and bad news about this.\" ";
				
				goodNews.isSeen := true;
				badNews.isSeen := true;
				break;
			case 4:
				if ( goodNews.talkedAbout && badNews.talkedAbout )
				{
					"\b\"I'm sorry, I just can't make head or tails of my
					documents now. Do you have a minute? Why don't you 
					come back to the bank with me so we could chat? Thanks.
					I'm really sorry about this. I'm just a little distracted
					today anyway.\" ";
				}
				else if ( goodNews.talkedAbout )
				{
					"\b"; badNews.ldesc;
					self.daemonCount--;
				}
				else
				{
					"\b"; goodNews.ldesc;
					self.daemonCount--;
				}
				break;
			case 5:
				self.daemonCount--;
				self.walkPathCount++;
				
				if ( self.walkPathCount < 8 )
					self.moveInto( self.walkPath[self.walkPathCount] );
				
				switch ( self.walkPathCount )
				{
					case 1:
						"\bLaura starts walking to the northeast. You follow her. ";
						break;
					case 2:
					case 3:
					case 4:
					case 5:
						"\bLaura continues walking toward the shopping village. You
						follow her. ";
						break;
					case 6:
						"\bLaura enters the bank. You follow her. ";
						break;
					case 7:
						"\bLaura invites you to come with her into her office in the 
						back part of the bank. You follow her. ";
						break;
					case 8:
						"\bLaura sits down at her desk, sighing. ";
						break;
				}
				
				if ( self.walkPathCount < 8 )
					Me.travelTo( self.location );
				
				switch( self.walkPathCount )
				{
					case 1:
						"\bLaura says, \"I'm sorry if I'm not up on all of the
						details of your finances. I only recently accepted a
						promotion, and had to scramble to get up to speed on a
						few dozen client histories. My life is suddenly a lot
						more hectic than I expected. I suddenly have the
						responsibility to make decisions that affect people's
						lives.\" \b
						
						She stares down at the ground as she walks, lost in 
						thought for a minute or two. \"If the money hadn't been
						so good,\" she says, \"If I'd known what I was getting
						into ...\" \b
						
						\"Sorry,\" she says to you. \"You probably have enough
						problems of your own without listening to mine.\" ";
						break;
					case 2:
						"\bLaura says, \"I don't know if anyone ever talked to
						you about what options you have for investing your trust
						fund. I know the stock market can seem confusing when
						you're new to it, but the payoffs can be worth it, even
						within a few years' time frame.\" \b
						
						\"I can tell this isn't very interesting to you. Maybe
						we should forget about all of this for the moment and
						talk about something else.\" ";
						break;
					case 3:
						"\bLaura stares at a bird as it passes overhead. \b
						
						\"I lost my train of thought just now,\" she says,
						distracted by thoughts you can't guess. After a pause,
						she asks, \"Do you ever feel like life is a series of
						decisions, and you never have quite enough information
						to make an informed choice? That only in hindsight can
						you ever see how good or bad a selection you made?\" \b
						
						Laura straightens her posture, which had started to 
						slump. \"Oh well. What's done is done. You can only
						go forward, not backward.\" ";
						break;
					case 4:
						"\bLaura stops for a moment and takes a deep breath. She
						looks at the trees lining the road and says, \"Aren't they
						beautiful? I can see why you wanted to build out here.\" \b
						
						She resumes walking, slowly. \"I live on the north end of
						town, so I don't get out into these older areas much. I
						probably should. I always tell myself I should take walks
						out here during lunch. I guess today was my excuse. I just
						wish I'd planned ahead and brought walking shoes.\" She
						smiles and winces. \"I'm all right. We're almost there.\" ";
						break;
					case 5:
						"\bLaura looks at the sandwich shop. \"Geez, I missed lunch
						again. That's another thing about being promoted -- it's
						the best diet I've ever been on. Eight pounds so far.\" \b
						
						She looks at her watch. \"If I weren't running late, I'd
						buy you lunch. But I guess I don't have time for that. I
						guess I won't have time for that for a long time.\" She
						goes silent again, gazing into the distance. \"I keep
						thinking that if I just keep moving onward and upward,
						into the big office with the big chair and the big desk,
						I won't have to worry about money any more. I won't have
						to worry about anything. That's the big thing, right? Not
						having to worry? I guess that was your plan with the house.
						Oops, sore subject, sorry.\" \b
						
						\"But sometimes I lie awake wondering, does that make 
						any sense? Doesn't the bigger office just come with 
						bigger worries? And then I see guys who have made it,
						women in business whom I admire, and they look happy.
						I sound like a sap. 'I just want to be happy! I just
						want to be loved!' My boss tells me that he gave me the
						promotion so I could toughen up. He says I'm too 
						compassionate, too lenient on the bank's debtors, too
						open-hearted about people in need.\" \b
						
						\"In fact, if he finds out I made this trip out to see
						you, he's not going to be happy. And he wants to be 
						happy, too, just like ... everyone.\" ";
						break;
					case 6:
						"\bLaura almost walks toward the new accounts desk, but
						stops herself. \"Bad habit,\" she says, grinning. \"I have
						an office now, in the back. It used to be a closet or 
						something. I remember thinking, 'Wow, my own office? 
						Cool.' And then I saw it for the first time, and -- oh
						well. It'll only be for a year or so, and then I'll get
						promoted again, to one with a window. Maybe I'll be able
						to see the trees from there. Provided they don't cut the
						trees down to build something, which is the way things
						look like they're going.\" \b
						
						\"You're a good listener, I have to give you that. I don't
						know why you bother with basket cases like me.\" ";
						break;
					case 7:
						"\bA paunchy man with a bald head and a brown suit appears
						in the doorway. \"Laura!\"\ he says, and then casts a 
						judgmental glance at you. \"We're holding the meeting for
						you. Are you ready? Where's your report?\" \b
						
						Laura puts her briefcase on the desk. \"Right here, I'm
						coming,\" she says. The man clicks a ballpoint pen a few
						times, nods sternly, and exits. You hear the clicking 
						noise disappear down the hall. ";
						break;
					case 8:
						"\bLaura dumps her papers onto the desk and begins picking
						out pieces of her report. ";
						
						if ( self.buyCommandPending )
						{
							"\"Oh, wait, that's right. <<self.buyCommandPending.sdesc>>, you
							said? Let's see.\" ";
							buyCommandPending.handleStockPurchase;
						}
						
						if ( sealedEnvelope.location = LaurasBriefcase )
						{
							"\bLaura sighs. \"Thanks for the walk -- and the 
							conversation. And for the -- \" She takes a long 
							pause. \"For the letter you delivered to me. I 
							can't promise I'll be in touch with you from now 
							on, because I think I'm going to quit my job in 
							about 2 minutes.\" She stuffs her report into the 
							trash can and ushers you back into the lobby. \b";
							self.moveInto( nil );
						}
						else
						{
							"\bLaura sighs. \"I'm sorry, I guess I need to get 
							back to work. Thanks for the walk -- and the 
							conversation. If you need anything else, come back 
							and see me. My door's open.\" She manages 
							to get her report put back together and ushers you 
							back into the lobby. \b";
							self.moveInto( PLaurasOffice );
						}
						Me.travelTo( inTheBank );
						
						"\bLaura shakes your hand, smooths back her hair, and 
						disappears into the back rooms of the bank. ";
						
						self.daemonCount := 0;
						self.walkPathCount := 0;
						unnotify( self, &actorDaemon );
						break;
				}
				break;
		}
	}
;

PLauras_skirt: clothingItem
	sdesc = "violet skirt"
	noun = 'skirt'
	adjective = 'knee-length' 'violet' 'purple'
	isworn = true
	location = PLaura
;

PLauras_shoes: clothingItem
	sdesc = "shoes"
	noun = 'shoe'
	plural = 'shoes'
	isThem = true
	adjective = 'matching' 'laura\'s' 'her'
	isworn = true
	location = PLaura
;

PLauras_blouse: clothingItem
	sdesc = "white blouse"
	noun = 'blouse'
	adjective = 'sleeveless' 'buttons' 'laura\'s' 'her'
	isworn = true
	location = PLaura
;

PLauras_tan: fixeditem
	sdesc = "Laura's tan"
	noun = 'tan' 'skin'
	adjective = 'laura\'s' 'her' 'tanned'
	location = PLaura
;

PLauras_eyes: fixeditem
	sdesc = "Laura's green eyes"
	noun = 'eye'
	plural = 'eyes'
	isThem = true
	adjective = 'green' 'laura\'s' 'her'
	location = PLaura
;

loosePapers: item
	sdesc = "loose papers"
	adesc = "some loose papers"
	ldesc = "The loose papers are various boring bank documents of no relevance
			to you. "
	noun = 'paper'
	plural = 'papers'
	isThem = true
	adjective = 'loose' 'document' 'documents'
	
	askingAboutMe( who ) =
	{
		if ( who = PLaura )
		{
			"Laura says, \"Oh, don't worry about it. They're just papers I need
			for a meeting, my report on a possible VistaBank merger, letters to
			my boyfriend, nothing important.\" She smiles ruefully. \"The only
			ones you need to be concerned about are the ones I brought for you,
			but I have copies of them back at the bank.\" ";
			
			return( true );
		}
		else return( nil );
	}
;

LaurasBriefcase: item
	sdesc = "dark leather briefcase"
	ldesc = "It's a briefcase made of dark leather. "
	noun = 'briefcase'
	adjective = 'dark' 'leather'
	location = PLaura
	
	verIoPutIn( actor ) = {}
	ioPutIn( actor, dobj ) =
	{
		if ( dobj = loosePapers )
		{
			PLaura.ioGiveTo( actor, dobj );
		}
		else
			"You can't put <<dobj.thatdesc>> into Laura's briefcase. ";
	}
	
	askingAboutMe( who ) =
	{
		if ( who = PLaura )
		{
			"Laura says, \"I can't believe I didn't see that rock. I mean,
			who couldn't miss that?\" ";
			return( true );
		}
		else return( nil );
	}
;

goodNews: fixeditem
	sdesc = "good news"
	ldesc = 
	{
		"\"The good news is, it will lower your insurance significantly, as it
		significantly reduces the risk of fire damage.\" She rummages in her 
		briefcase a bit. ";
		
		self.talkedAbout := true;
	}
	noun = 'news'
	adjective = 'good'
	location = nowhereRoom
	
	doWhatIs( actor ) = { self.ldesc; }
	
	askingAboutMe( who ) = 
	{
		if ( who = PLaura )
		{
			self.ldesc;
			return( true );
		}
		else return( nil );
	}
;

badNews: fixeditem
	sdesc = "bad news"
	ldesc = 
	{
		"\"The bad news is, I don't know how you're going to afford this particular
		modification. You were cutting it close already. Accounting for cost of 
		living increases, I think you're going to run out of money just fifteen
		years into your thirty year mortgage. If things go in your favor, maybe
		twenty.\" She looks at you sympathetically. ";
		
		self.talkedAbout := true;
	}
	noun = 'news'
	adjective = 'bad'
	location = nowhereRoom
	
	doWhatIs( actor ) = { self.ldesc; }
	
	askingAboutMe( who ) = 
	{
		if ( who = PLaura )
		{
			self.ldesc;
			return( true );
		}
		else return( nil );
	}
;

PLaurasOffice: room
	sdesc = "Laura's office"
	ldesc = "Laura's office is a small, windowless room with a file cabinet and 
			a plain white desk. "
	xdesc = "The only exit is to the east. "
	east = inTheBank
;

PLaurasDesk: staticItem, surface
	sdesc = "desk"
	ldesc = { surface.ldesc; }
	noun = 'desk'
	adjective = 'plain' 'white' 'her' 'laura\'s'
	location = PLaurasOffice
	
	verDoOpen( actor ) = 
	{
		"It's Laura's desk, not yours. You can't just rifle through it. ";
	}
	doSynonym( 'Open' ) = 'Search'
	verDoBoard( actor ) = 
	{
		"It would be impolite to sit on Laura's desk. ";
	}
	doSynonym( 'Board' ) = 'SitOn'
	verDoStandon( actor ) = 
	{
		"It would be startlingly impolite to stand on Laura's desk. ";
	}
;

PLaurasChair: staticItem, chairitem
	sdesc = "Laura's chair"
	ldesc = { surface.ldesc; }
	noun = 'chair'
	adjective = 'her' 'laura\'s'
	location = PLaurasOffice
	
	verDoSitOn( actor ) = 
	{
		if ( PLaura.walkPathCount > 6 )
			"Laura is already sitting in her chair. ";
		"It would be impolite for you to sit in Laura's chair. ";
	}
	doSynonym( 'SitOn' ) = 'Board'
	verDoStandon( actor ) = 
	{
		if ( PLaura.walkPathCount > 6 )
			"Laura is already sitting in her chair. Besides, it 
			would be startlingly impolite for you to stand on it. ";
		"It would be startlingly impolite to stand on Laura's chair. ";
	}
;

PLaurasFileCabinet: unimportantItem
	sdesc = "file cabinet"
	ldesc = "It's just a file cabinet. "
	noun = 'cabinet'
	adjective = 'file' 'files' 'laura\'s' 'her'
	location = PLaurasOffice
;

brokenCavern: caveRoom
	sdesc = "Broken cavern"
	ldesc = "You are in a large cavern that seems to have once been an enormous natural
			geode, with crystals as big as your head growing in splints
			and shafts from every direction. What you see now are shattered
			shards. The rock ceiling from which the crystals grew overhead
			has crumbled, sending a half-ton of debris smashing down, burying
			what has not destroyed. \b
			
			Whether by accident or design you cannot guess, but the time 
			machine has arrived in perhaps the only clear area amid the rubble. 
			Still, it doesn't feel safe here. You hear the pounding and trampling 
			of construction work going on directly overhead, and with each thump 
			more rock clatters down from above. If you stay long, you will
			probably take a large stone to the head. "
	xdesc = "There are no exits from this cavern. "
	listenDesc = 'You hear the pounding and tramping of construction going on 
				directly overhead. '
	noexit = 
	{
		"The rubble has sealed off all exits from the cavern. ";
		return( nil );
	}
;

rubble: unimportantItem
	sdesc = "rubble"
	ldesc = "The rock ceiling from which the crystals grew overhead
			has crumbled, sending a half-ton of debris smashing down, burying
			what has not destroyed. "
	noun = 'rubble'
	adjective = 'stones' 'rock' 'crumble' 'crumbled' 'debris' 'half-ton' 'half'
			'ton' 'ceiling'
	location = brokenCavern
;

shatteredCrystals: unimportantItem
	sdesc = "shattered crystals"
	ldesc = "What you see now are shattered shards buried in rubble. "
	noun = 'crystal' 'shard'
	plural = 'shards' 'shards'
	isThem = true
	adjective = 'shattered' 'shatter' 'geode' 'enormous' 'natural'
	location = brokenCavern
;

/* eof */
