#include "cyoa_lib.t"

/* Here's the introduction to the game. */
modify intro
	desc = "<<aboutTheCYOAGame.sdesc>> \b\b\b"
;

CYOA_title: object
	sdesc = "On the Trail of the XXX Gang"
;

/* And here's the version information */
modify CYOA_version
	desc = "\(<<CYOA_title.sdesc>>\)\n
		A Choose Your Own Adventure story\b
		by Colin Polsky, Rob Wheeler, and Mike Benedict\n
		Story and Text Copyright 1981 by Colin Polsky, Rob Wheeler, and Mike Benedict\n
		TADS CYOA translation Copyright 1999 by J.\ Robinson Wheeler\n
		TADS CYOA module by Mark Musante.\n
		All rights reserved.\b";
/*
		Developed with TADS, the Text Adventure Development System\n
		Type 'about' for more information. Type 'credits' for acknowledgments."
*/
;

replace CYOA_die: function
{
	local response;

	if ( CYOA_Me.location = p_33 )
		"\b\t\(* * * THE (glitch) END * * *\)\b";
	else
		"\b\t\(* * * THE END * * *\)\b";

	while( 1 ) {
		"Would you like to (R)estart, Re(s)tore, (U)ndo, or (Q)uit? ";

		response := lower(input());
		if ( response = 's' || response = 'restore' ) {
			response := askfile( 'File to restore' );
			if ( response = nil )
				"Restore failed. ";
			else if ( restore( response ) )
				"Restore failed. ";
			else
				return;
		} else if ( response = 'r' || response = 'restart' ) {
			"\b";
			CYOA_Me.location := startplace;
			CYOA_Me.location.desc;
			return;
		} else if ( response = 'u' || response = 'undo' ) {
			if ( undo() ) {
				"(Undoing one command)\b\t";
				Me.location.desc;
				return;
			} else {
				"No undo information available. ";
			}
		} else {
			endgame.desc;
			CYOA_quit();
			return;
		}
	}
}

aboutTheCYOAGame: object
	sdesc = {
		"\tThis game was written as a Choose Your Own Adventure book in 
		1981, when my friends and I were in sixth grade (11 years old).
		Colin Polsky was the chief force behind it at the beginning and
		throughout most of the work, pounding out pages on his typewriter
		and assigning branches to Mike Benedict and me. At some point,
		Colin got tired of the project and gave me the only manuscript.
		I finished the last section of the book on my own, and then put
		it on the shelf.\n
		\tA few years later, I called Colin to ask his permission to 
		do something about publishing the book. He was surprised and 
		verbally gave me all rights. Thus, I feel safe about making this 
		conversion available now.\n
		\tThe text was written by three creative kids, and holds up pretty
		well in terms of humor. As with all archival missions like this,
		a few lines had to be updated to make sense, but in general the
		original text has been preserved, oddities and all.\n
		\tThe first three pages of the story, long believed lost forever, 
		were preserved by a time capsule and rediscovered in December 2006.
		There are one hundred pages, see if you can find all of them.\n
		\tHave fun! I hope you enjoy it. ";
	}
;

CYOA_credits: object
	sdesc = {
		"The CYOA library used in the creation of this game is
		Copyright 1998 by Mark J.\ Musante. All rights
		reserved. Respect and thanks to Colin Polsky and Mike
		Benedict for the good memories and fun storytelling.";
	}
;

/* Every cyoa_lib game starts at 'startplace' and goes from there */
startplace: Place
	statusRoot = "Introduction"
	author = "Colin"
	desc = "You are an agent in the Intergalactic Space Patrol. For as 
		long as you can remember, you have been serving the Patrol 
		because your parents were part of it. Unfortunately, your name 
		has been classified for so long that you have forgotten it. 
		You are given a new code name every five months in order to 
		keep your identity hidden. Today, you recieved a data transmission 
		from Inspector Zornack, your commander, with your new designation: Z-12. 
		Suddenly you hear a noise coming from your computer room."
	choices = "\t1) TURN TO p.1"
	choice1 = p_1
;

p_1: Place
	statusRoot = "p.1"
	author = "Colin"
	desc = "\"Beep, beep, beep!\"\n
		\tIt's Inspector Zornack with some news about a case concerning 
		some space pirates who stole valuable space crystals containing 
		secret powers.\n
		\t\"Do you have any leads, Inspector?\" you ask.\n
		\t\"No, but if you hurry you might get some,\" Zornack replies, 
		signing off.\n
		\tYou go to bed that night, still thinking about the case. 
		The next day, while deciding whether or not to take it, you 
		receive a piece of mail, which is unusual because mail isn't 
		usually sent anymore, except on computer. You open it:\b
		\t\tIf you want to live any longer, drop the case !\n
		\t\tAnd don't let us catch you around the astro-city\n
		\t\tof Naberfas!\ !\ !\ !\ !\ !\ !\b
		\t\t\t\t\t\t\tXXX\b
		\tWow!\ That does it!\ That pushed you over the edge and you 
		just can't wait to start your investigation. You think that 
		Naberfas will be a good place to search, since you were specifically 
		warned not to go there. Then again, maybe they warned you to stay 
		away just to lure you in by your curiosity. Perhaps you should 
		talk to Zornack again."

	choices = "\t1) IF YOU GO TO NABERFAS, TURN TO p.3\n
			\t2) IF YOU WANT TO CONSULT WITH ZORNACK, TURN TO p.2"
	choice1 = p_3
	choice2 = p_2
;

p_2: Place
	statusRoot = "p.2"
	author = "Rob"
	desc = "You call up Zornack.\n
		\t\"Actually, Z-12, I do have some information. I received some 
		written mail this morning, telling me to stay away from someplace 
		called Naberfas, and to drop the case. Oh, yeah, it was signed XXX.\"\n
		\t\"Thanks,\" you say dejectedly.\n
		\t\"Always trying to be of some service,\" Zornack says.\b
		\tYou click off the telecom, thinking about what a big help Zornack was. 
		You decide to do some research on Naberfas. It is located on the planet 
		Daldor, and is close enough to fly there in your one-man craft. 
		Maybe Zornack has come up with something while you were researching. 
		You could call him up again, or maybe just sit around and try to sort 
		something out.\n
		\tYour telecom sounds. It's Zornack, and he says that he might have 
		something useful for you."
	choices = "\t1) IF YOU WANT TO INVESTIGATE DALDOR, TURN TO p.5\n
			\t2) IF YOU FEEL LIKE SITTING AND THINKING IT ALL OUT, GO TO p.6\n
			\t3) OR, IF YOU LISTEN TO ZORNACK, TURN TO p.4"
	choice1 = p_5
	choice2 = p_6
	choice3 = p_4
;

p_3: Place
	statusRoot = "p.3"
	author = "Colin"
	desc = "Naberfas is a place of glory, beauty, and quality. Everything 
		that you always wanted is there. Well, almost everythlng. When you get 
		to the southern part of the city, you run into slums, pollution, and
		everything that you never wanted is there. Well, almost nothing. You 
		have a hunch that the XXX Gang is somewhere over there. After doing 
		some snooping, you deduce that they had to be ready to take off to 
		another hiding place. But where?\n
		\tYou look up this place called \"Shipping INC.\" You decide to go 
		there. As you peek in, you see this guy with a little XXX on his 
		shirt carrying a box of something. You don't know what's in it, 
		but it seems pretty heavy. You try to eavesdrop, but all you can 
		make out are the words \"carry,\" \"junk,\" and the only one useful 
		at all, \"--ace gems.\"\n
		\tNot bad, but this made you sure it was them. After a while 
		they leave, and you cautiously go in. You find nothing but a 
		communicator with someone on the other end saying \"Hello? Hello?\", 
		and on the other side of the spaceship, a map of where the gang 
		is going. But you must hurry, because you don't have much time 
		to waste before the gang gets back."
	choices = "\t1) IF YOU TAKE THE MAP, GO TO p.8\n
				\t2) IF YOU ANSWER THE CALL, GO TO p.7"
	choice1 = p_8
	choice2 = p_7
;

p_4: Place
	statusRoot = "p.4"
	author = "Colin"
	desc = "You think that Zornack might have something good, or just 
		something better than what you already have (which isn't much). 
		Anyway, what have you got to lose?\n
		\tHe says that after some research, he found this place on the 
		astro-city, Naberfas, called \"Shipping INC.\" He thinks that's 
		where they are, but you're not so sure. You ask the manager if 
		there are any rush departures leaving today. He looks down his
		schedule, and reluctantly replies, \"Well, I -- I guess so, um, 
		they're leaving at about 3:45, which is about 40 minutes from 
		now.\" You halfway believe him, but you've got to check it out.\n
		\t\"Crreeaaakk...\" It's the door to the warehouse, and you can 
		barely see through it, though good enough. Seeing a big, husky 
		man go right by your hiding place is enough for you, so you decide 
		to go just behind the door and listen for a while. Your eavesdropping 
		isn't too good, but you understand one word, which is enough. You 
		presume that the leader, probably the husky one, said, \"--ace 
		gems.\" It's obviously them.\n
		\tYou hear a trooping coming down the hall, and it might be the 
		manager of \"Shipping INC.\", but maybe not. You could rush in 
		and try to hide among the boxes, etc., or you could try to meet 
		the person coming down the hall. It doesn't sound like the short, 
		stout man that the manager is. It's risky, but it's all you can do."
	choices = "\t1) IF YOU FLEE INTO THE STORAGE ROOM, GO TO p.9\n
		\t2) IF YOU TAKE A CHANCE, AND GO TO THE PERSON IN THE HALLWAY, 
		GO TO p.10"
	choice1 = p_9
	choice2 = p_10
;

p_5: Place
	statusRoot = "p.5"
	author = "Mike"
	desc = "You sit in the swivel chair of your spaceship, and flip the 
		switch marked \"Automatic pilot.\" Suddenly space becomes flashes of 
		light and many different colors, and the only noticeable sound is the hum 
		of your Ion Drive.\n
		\tSuddenly, you hear a loud \"Thwa-clanggg!\", and the ship starts to
		lurch and shake for a second, but that's it. You flip on the magnetic 
		repulsar engines and you slowly come out of hyperspace. You wonder what 
		the noise is, \"Probably a big an asteroid or something,\" you say to 
		yourself. You're not so sure, maybe you should check..."
	choices = "\t1) IF YOU INVESTIGATE WHAT THE NOISE WAS, TURN TO p.11\n
			\t2) IF YOU CONTINUE ON YOUR JOURNEY, TURN TO p.12"
	choice1 = p_11
	choice2 = p_12
;

p_6: Place
	statusRoot = "p.6"
	author = "Colin"
	desc = "You decide to just sit there, after all, what else can you do? 
		After a lot of pacing, you decide to go to sleep, since nothing 
		exciting has happened that day. After your rest, you go and get the 
		evening news. As you're picking up the paper, out of your peripheral
		vision, you see a man decked out in a three-piece suit, all black, 
		and a white cap. Unfortunately, it's nothing big at all, just an 
		innocent bystander. Suddenly, a communicator rings, bringing you a
		spaceship with a map."
	choices = "\t1) GO TO p.7"
	choice1 = p_7
;

p_7: Place
	statusRoot = "p.7"
	author = "Mike"
	desc = "You pick up the communicator and wearily reply, \"Yeah, who is 
		it?\" A gruffy voice answers, \"Agent X-1? This is the Big X, have 
		you loaded the space gems yet?\" You can't believe it, you're 
		actually speaking to the leader of the XXX Gang!\n
		\t\"Uhh... mmm... y-yeah!\" you reply in a tough voice.\n
		\t\"Good, I'll meet you in the warehouse for your pay!\" The 
		communicator clicks off and the room is once again silent.\n
		\tAn eerie silence."
	choices = "\t1) IF YOU GO TO THE WAREHOUSE, TURN TO p.13\n
				\t2) IF YOU STAY AND SEARCH FOR CLUES, GO TO p.14"
	choice1 = p_13
	choice2 = p_14
;

p_8: Place
	statusRoot = "p.8"
	author = "Rob"
	desc = 
	{
		"You pick up the map. It takes you a few minutes, but you finally 
		figure it out. It's a map showing where the XXX Gang is. You turn to 
		leave, but suddenly a small figure darts out from behind a small box.\n
		\t\"You're never going to get that box of crystals!\" he shouts, 
		firing a laser at you. You manage to escape the deadly beam, but the 
		laser disintegrates the map.\n
		\tYou pull out your own laser and get him in the chest.  You run to 
		your own spaceship and take off. Hoping you memorized the map enough, 
		you take off in search of the crooks.\n
		\tYou find that you didn't remember anything. You guess your way for 
		the first ten million miles. You get tired and bored of this and fall 
		into an exhausted and well-deserved sleep. Suddenly you wake with a 
		start. You find that your controls register that you are going to 
		run into something.  You swivel in your chair and turn on the 
		visi-screen.\n
		\tYou find that the object is actually a docking bay.  You manage to 
		pull out and dock just in time. You open the airlock and walk out 
		to find three shuttle-crafts each pointing a different direction and 
		each labeled something different. The one on the left is No. 632L, 
		AA04, is the number for the one on the right, and the one in the 
		center has a number D704. It looks risky, so... which one will it be?";
		
		if (CYOA_global.html_mode) {
			"<center><p><img src=\"images/ships.png\"></p></center>";
		}
	}
	choices = "\t1) IF YOU GO TO THE ONE ON THE RIGHT, GO TO p.16\n
				\t2) ...THE LEFT, p.15\n
				\t3) ...THE CENTER, p.21"
	choice1 = p_16
	choice2 = p_15
	choice3 = p_21
;

p_9: Place
	statusRoot = "p.9"
	author = "Mike"
	desc = "You open the door and noiselessly creep in behind a conveniently 
		located box. Suddenly, you hear a deep, hoarse, voice say, \"O.K., 
		buster, don't turn around.\""
	choices = "\t1) QUICK, GO TO p.18!"
	choice1 = p_18
;

p_10: Place
	statusRoot = "p.10"
	author = "Colin"
	desc = "It turns out ot be the manager and he very politely asks, 
		\t\"Did you find what you wanted?\" with a sly grin.\n
		\t\"Actually, I, uh, well, did, but it's confidential and...\" 
		You're speechless because of the gun aiming right at you. 
		Revealing the XXX on his shirt, he says, \"What's de madder wit 
		you, kid, anyway, just move on in to the warehouse, and you'll be 
		just fine.\" Cautiously you walk in and find the XXX Gang waiting 
		for you, with the exception of the one still loading the gems. The 
		first thing you were taught at the academy is when you get caught, 
		not to speak, or to answer ignorantly.\n
		\"All right, kid, what's your name?\" the man asks. With a stupid 
		and spaced-out look, you reply, \"Gee, mister, I really just plum 
		forgot. You know, my mom always used to say, If you--\"\n
		\t\"Ugggh! O.K., smart-alec, how did you get here?\" he asks with 
		a frown.\n
		\t\"Well, sir, I flew -- Hee-hee, ho-ho, ha, y'know, guys, this 
		reminds me of the time whe--\"
		\t\"Oh, my God! How did you ever get in the academy??? Hey, X-12, 
		what do you think we should do with this guy?! He's a nut, a real 
		nut.\"\n
		\t\"Ah, leave him alone, he's so crazy, he couldn't know a 
		thing,\" X-12 replies. You want to say something, but you can't. 
		They let you walk away and be alone, but you could quickly whip 
		around and draw your laser and see what happens. Unfortunately, 
		it's risky. On the other hand, you could walk away unharmed, and 
		come back with reinforcements and try to get them then. Alas, 
		you're tired, and you think it might just be better to go home 
		and think for a while."
	choices = "\t1) IF YOU GO GET REINFORCEMENTS, GO TO p.26\n
			\t2) IF YOU GO HOME TO THINK, GO TO p.6\n
			\t3) IF YOU TURN AROUND IMMEDIATELY, GO TO p.24"
	choice1 = p_26
	choice2 = p_6
	choice3 = p_24
;

p_11: Place
	statusRoot = "p.11"
	author = "Mike"
	desc = 
	{
		"You decide to investigate the noise and soon find out that 
		it's a space parasite. You easily knock it off, but it made a 
		partial dent in your hull, and that's okay. As you return, though, 
		you find that there are two big blips on your radar, and through 
		the use of the computer, you find the objects are exactly 
		identical. There is one on the right and one on pretty much 
		the far left of your screen. Suddenly you remember that you're 
		going to Daldor, and this has to be it! You know you're on the 
		right track, but which one should you take?";

		if (CYOA_global.html_mode) {
			"<center><p><img src=\"images/cyoa.png\"></p></center>";
		}
	}
	choices = "\t1) IF YOU TAKE THE ONE ON THE RIGHT, GO TO p.39\n
			\t2) IF YOU TAKE THE ONE ON THE LEFT, GO TO p.36"
	choice1 = p_39
	choice2 = p_36
;

p_12: Place
	statusRoot = "p.12" 
	author = "Mike"
	desc = 
	{
		"You hear a noise, and see a big space parasite has just 
		penetrated through the steel. That must have been the noise, 
		you say to yourself, and those are the last words you ever 
		say again... ";
		CYOA_die();
	}
;

p_13: Place
	statusRoot = "p.13"
	author = "Colin"
	desc = 
	{
		"You go to the warehouse and it's not too hard for him to 
		notice that you are not one of his agents. He quickly draws his 
		laser, but you came in with yours already drawn and took aim and 
		hit him. He immediately drops dead and you go up to him and search 
		him. You find nothing but a wallet, a rolled up piece of paper, his
		glasses, a ring, and a wristwatch. There aren't but two things to do,
		either you inspect the items you found, or you take the items to 
		the local lab downtown, which takes up time.";

		if (CYOA_global.html_mode) {
			"<center><p><img src=\"images/cyoa.png\"></p></center>";
		}
	}
	choices = "\t1) IF YOU GO TO THE LOCAL LAB, GO TO p.43\n
			\t2) IF YOU INSPECT THE ITEMS RIGHT THEN AND THERE, GO TO p.37"
	choice1 = p_43
	choice2 = p_37
;

p_14: Place
	statusRoot = "p.14"
	author = "Colin"
	desc = "You decide that if you go to the warehouse you might get 
		killed, so you come to the conclusion that searching the spaceship 
		would be better for your health. Looking for other stuff isn't 
		much help, because you don't find anything. As you are searching 
		the spaceship, you suddenly remember about the map. You also 
		suddenly hear footsteps coming closer and closer to the spaceship. 
		As you extend your hand out..."
	choices = "\t1) GO TO P.8"
	choice1 = p_8
;

p_15: Place
	statusRoot = "p.15"
	author = "Rob"
	desc = "You decide to take the shuttle-craft marked 632L, because, as 
		it turns out,  632 is your favorite number. As you board the craft 
		and strap yourself in, you notice that the systems are already 
		operating. Suddenly the hatch closes,  the main engine roars into 
		action, the rear rocket blasters turn on, and the turbo-thrust 
		engines fire. Before you know it, you're hurtling through space.\n
		\tYou try to steer the ship, but it's no use. The controls and 
		steering mechanisms are locked to go specific coordinates. Even 
		though it seems that things are really going against you, you don't 
		worry. You feel as if something good will happen.\n
		\tThe computer begins to speak. \"STAND-BY-FOR-MANUAL-CONTROL...\" 
		it bleeps.\n
		\tA green light flashes which you think means O.K., which it does. 
		No sooner than you take over the controls, the sensors indicate 
		certain levels of radioactivity. Radioactivity! There is a good 
		chance the radioactivity is from the space-crystals! Placing your 
		luck on this fact, you rocket off in the direction of the 
		radioactivity.\n
		\tThe level of radioactivity steadily increases in the direction 
		you're heading. Suddenly a tremendous jolt from outside knocks 
		your shuttle-craft from its flight path and sends it spinning.\n
		\tYou stabilize the craft then set the scanner on whatever it was 
		that knocked your ship. A picture forms on the screen and you see 
		a huge, glowing monster composed of radioactive energy. You have 
		to think fast. You can either fire at the creature, or try to make 
		it back to the docking bay."
	choices = "\t1) IF YOU DECIDE TO FIRE AT IT, GO TO p.17\n
				\t2) BUT, IF YOU TRY TO GO BACK TO THE DOCKING BAY, GO TO p.29"
	choice1 = p_17
	choice2 = p_29
;

p_16: Place
	statusRoot = "p.16"
	author = "Rob"
	desc = "No sooner than you decide, you are picked up into an alien 
		ship via an strange beam. You look around and see strange 
		creatures with huge heads and eight arms.\n
		\tOne walks up to you and says, \"Blibble blubble glort gleem, 
		blib glub glibble.\"\n
		\tHow strange. Another one comes up to you and repeats it. Soon 
		you are In a room full of strange creatures saying the same things.\n
		\tYou feel you must answer. What do you say?"
	choices = "\t1) IF YOU TRY TO SAY SOMETHING, GO TO p.23\n
				\t2) IF YOU DEMAND TO BE RELEASED (in your own language), 
				TURN TO p.28"
	choice1 = p_23
	choice2 = p_28
;

p_17: Place
	statusRoot = "p.17 [picture]"
	author = "Rob"
	desc = 
	{
		if (CYOA_global.html_mode) {
			"<center><p><img src=\"images/cyoa.png\"></p></center>";
		}
		
		"You switch the laser controls to automatic and fire the 
		laser directly at the creature's eye. A direct hit, but no harm 
		comes to the monster.\n
		\tThe creature flails in anger, almost catching the ship in its 
		swing.\n
		\tYou fire three more times with similar results. The heat from 
		the creature is beginning to melt down the ship. The creature 
		fires one of his own lasers, hitting the outside laser of the ship.\n 
		\tSince you have no defense, you must take hyperspace. You feel 
		sick for a moment and your vision blurs. As you reach for the 
		controls, a sharp pain erupts in your stomach and you keel 
		over, burning with fever. It's too late, you're dying of 
		radiation poisoning. You should have left when you had 
		the chance.";
		CYOA_die();
	}
;

p_18: Place
	statusRoot = "p.18"
	author = "Mike"
	desc = 
	{
		"You feel a piercing pain in your back. That is the last 
		you're heard from again...";
		CYOA_die();
	}
;

p_19: Place
	statusRoot = "p.19"
	author = "Colin"
	desc = 
	{
		"You try to dodge the beam, because that seems to be the only 
		logical thing to do, unless you want to get your head blown ouff. 
		Because of the limited time you have, you trip and fall, breaking 
		your head. Slowly but surely, you get up, and stagger halfway 
		across the room, before, \"Crash!\", you drop to the floor, DEAD.";
		CYOA_die();
	}
;

p_20: Place
	statusRoot = "p.20"
	author = "Rob"
	desc = "You'd rather not try to defuse a bomb -- especially a 
		delicate electronium bomb. Your best choice is to jettison it 
		out the hatch. You slip on your space-suit as not to be affected 
		by the vacuum of space. You take the ticking electronium bomb to 
		the cargo door and attemp to open it. The door seems stuck, so 
		you pull harder. Finally you succeed and you reach for the bomb. 
		Suddenly, the ticking stops and begins to emit a whine. It's 
		about to go off!"
	choices = "\t1) IF YOU STRAP ON YOUR JET-PACK AND BLAST OUT, GO 
				TO p.50\n
				\t\2) IF NOT, BAAROOM!!!!! THE END"
	choice1 = p_50
	choice2 = baaroom
;

baaroom: Place
	statusRoot = "THE END"
	desc =
	{
		if ( CYOA_global.html_mode ) 
		{
			"<font size=+3><b>";
			"BAAROOM!!!!!\n";
			"</b></font>";
		}
		else
		{
			"\(BAAROOM!!!!!\)\n";
		}
		CYOA_die();
	}
;

p_21: Place
	statusRoot = "p.21"
	author = "Rob"
	desc = "You decide quickly enough. You take the one labeled D-704. 
		You hop inside and take a moment to study the controls. They're 
		similar to the ones in your ship, so you quickly figure out how 
		they operate. In a moment, you're roaring into outer space.\n
		\tThe telecommunicator light flashes. Who could possibly be 
		contacting you? You flip on the visuals to see who it is. It's the
		Inspector.\n
		\t\"Inspector! How nice to see someone's face again! How'd you 
		manage to reach me?\" you ask.\n
		\t\"It wasn't easy!\" barks the Inspector, \"Anyway, I called to 
		tell you that we have a new lead on the case of the stolen space 
		crystals. The XXX gang's hidden on the planet Kcops, around the 
		area of Krik, Kcops's main city.\""
	choices = "\t1) IF YOU SAY, \"I'M ON MY WAY\" THEN GO TO P.33\n
				\t2) IF YOU WANT TO TALK TO THE INSPECTOR IN PERSON TO 
				FIND OUT MORE, GO TO p.30"
	choice1 = p_33
	choice2 = p_30
;

p_22: Place
	statusRoot = "p.22"
	author = "Rob"
	desc = "You struggle to get in view of the ship. Waving your arms 
		wildly, you try to attract the crew's attention. You succeed, but 
		not as you expected. You notice the ship to be a garbage patrol, 
		and it lifts its disintegrator to blast you away.\n
		\tQuickly, you draw your gun, and blow their gun away, so nothing 
		can happen to upset your molecular structure. Unfortunately, the 
		force of the gun pushed you back, as there is no gravity. The 
		captain of the ship speeds to pick you up, seeing that you are 
		much more than garbage. As you take off your space helmet inside, 
		you see the captain eyeing you strangely, but eventually he smiles.\n
		\t\"What were you doing out there, anyway?\" he questions.\n
		\t\"Well, you see, I was after the gang that stole Daldor's space
		crystals, and...\"\n
		\t\"Ahh! I see. Well, your search is over, they've been captured,\" 
		says the captain and you jump back in surprise. Then, above his 
		suit's insignia, you see a faint XXX.\n
		\tThe captain reaches for something in his pocket, but you gun 
		him before he does.\n
		\t\"He was an undercover for the XXX!\" you exclaim.\n
		\t\"The swine!\" shouts the captain's assistant. Some people 
		glance at you with strange stares, like the captain's, and arouse 
		your suspicion."
	choices = "\t1) IF YOU THINK THEY'RE XXX MEMBERS, GO TO p.32\n
				\t2) IF NOT, GO TO p.56"
	choice1 = p_32
	choice2 = p_56
;

p_23: Place
	statusRoot = "p.23"
	author = "Rob"
	desc = 
	{
		"You pause for a moment, take a deep breath, then loud and 
		clear say, \"Glibble glubble bleep blork, blibble gluggle 
		glibble.\"\n
		\tYou then realize what a mistake you've made. Suppose you said 
		something in their language? You might be executed!\n
		\tAn icy hand grabs your shoulder and you shudder in fear. 
		Cautiously, you glance around. Everyone is frowning.\n
		\tYou are led into a large room and it is empty except for a 
		table full of mouth-watering food. You realize suddenly that 
		you haven't eaten all day. As you reach for the food, it 
		slides forward through a doorway into another room.\n
		\tLaser bars slice down from the top of the doorway down to the 
		floor, cutting you off from the food. Whirling around, you find an
		indestructable wall sliding down, cutting you off there.\n
		\tSo now you are trapped, alone and hungry in an indestructable cell 
		with delicious gourmet food constantly out of your reach. What a way 
		to go.";
		CYOA_die();
	}
;

p_24: Place
	statusRoot = "p.24"
	author = "Colin"
	desc = "Maybe you should try to whip around and hit them with your 
		laser. After slowly drawing your gun while walking in the 
		creme-colored warehouse, you whip around and shoot. The effect 
		of your extremely fast motion makes your laser beam hit and 
		ricochet off their spaceship, which is on the left, while the 
		crooks are on the right."
	choices = "\t1) IF YOU TRY TO DODGE THE BEAM, GO TO p.19\n
				\t2) IF YOU TRY TO VERY SLOWLY ADVANCE FORWARD, GO TO p.34"
	choice1 = p_19
	choice2 = p_34
;

p_25: Place
	statusRoot = "p.25"
	author = "Rob"
	desc = 
	{
		"You've studied how to defuse bombs, in case of an emergency 
		such as this. Bringing out your special tools you set the 
		auto-pilot, so you won't run through black hole accidentally.\n
		\tCarefully you open the front part of the bomb. Taking a deep 
		breath, you begin defusing the bomb. Slowly, you begin connecting 
		and disconnecting different fuses and wires. As you reach a crucial 
		point in your defusing act, the computer informs you that you are 
		heading into an asteroid belt. Suddenly a threating jolt rocks the 
		ship, and an instrument you were holding drops into the bomb and 
		snips one of the wires, and the ticking stops. Breathlng a sigh 
		of relief, you once again take the controls, and blast all the 
		asteroids away.\n
		\tFrom the bomb comes a high-pitched whine, and strange popping. 
		You wonder what it's doing now. A voice follows the popping.\n
		\t\"So, I see you've deactivated our little surprise. By the way, 
		this is the Big X, head of everything in our little plan. You 
		should quit now, or you may not get a chance. If you you still 
		wanna try, I'll drop'ya a clue. Find the secret of Daldor!\"\n
		\tThe secret of Daldor? What kind of clue is that, if it even 
		is a clue? Is it worth investigating?";
		
		if (CYOA_global.html_mode) {
			"<center><p><img src=\"images/cyoa.png\"></p></center>";
		}
	}
	choices = "\t1) IF YOU THINK IT IS, GO TO p.48\n
				\t2) IF YOU DON'T, AND THINK OF IT AS A HOAX TO THROW 
				YOU OFF COURSE, THEN GO TO p.42"
	choice1 = p_48
	choice2 = p_42
;

p_26: Place
	statusRoot = "p.26"
	author = "Colin"
	desc = "After about 20 minutes of flight, you get caught in a fierce, 
		raging storm, and get thrown way, way off course. Finding 
		no control over your spaceship, you just sit back and hope 
		for the best. Suddenly you see a great big blip on your radar 
		screen, and also find that your ship is rocking back and forth 
		fiercely. Looking at the radar screen closer, you see something 
		familiar, but you just can't recall it."
	choices = "\t1) GO TO p.35"
	choice1 = p_35
;

p_27: Place
	statusRoot = "p.27"
	author = "Mike"
	desc = 
	{
		"As you land, you start to feel a chilling cold sensation spread 
		all over your body. You think it's the dreaded \"Gronk\" that goes 
		around killing people, with its enormous size and weight. Is this 
		the end for you? Unfortunately, it is.";
		
		if (CYOA_global.html_mode) {
			"<center><p><img src=\"images/cyoa.png\"></p></center>";
		}
		
		CYOA_die();
	}
;

p_28: Place
	statusRoot = "p.28"
	author = "Rob"
	desc = "You don't want to be involved with these creatures. \"I demand to 
		be released!\" you bellow. The creatures give unhappy stares at you, 
		but they release you anyway, by a strange beam of light again.\n
		\tYou decide not to try the shuttle-crafts after all, because who 
		knows what is in them! You board your own ship and take off. You 
		set it to auto-pilot and begin to check to see if it was changed in 
		your absence. It was. You find a hand made electronium bomb with a 
		note saying: WE WARNED YOU! (signed) the XXX GANG.\n
		\tWhat should you do with the bomb? There are only seconds left!"
	choices = "\t1) IF YOU JETTISON IT OUT THE HATCH, TURN TO p.20\n
			\t2) IF YOU TRY TO DEACTIVATE THE DELICATE EXPLOSIVE, 
			TURN TO p.25"
	choice1 = p_20
	choice2 = p_25
;

p_29: Place
	statusRoot = "p.29"
	author = "Rob"
	desc = 
	{
		"Just as you reach for the controls, the creature strikes the 
		ship, knocking out your main engines. With your engines out, you 
		can't escape fast enough. You have to fire the laser.\n
		\tYou fire the laser at the monster three or four times before 
		you realize that he's absorbing the laser rays, so you stop. 
		You look out at the creature. To your surprise, it's growing! 
		The energy has built it up to a critical mass! Before you can do 
		anything, the creature explodes into oblivion, taking you with it.";
		CYOA_die();
	}
;

p_30: Place
	statusRoot = "p.30"
	author = "Rob"
	desc = "\"I'd like to talk to you a little more in person before I go 
		out on another wlld goose chase again,\" you say.\n
		\t\"Fine. I'm at police base number 117, I'll expect you in at 
		about twenty minutes from now. If you're not there by then, I'll 
		be gone on another mission. Got that?!\"\n
		\t\"Loud and clear. I'll be there.\"\n
		\tAs you near the Police Base, your sensors indicate a radioactive 
		creature directly in your path. You have enough time to escape, 
		but then you'll miss the Inspector. You decide to just blast the 
		thing out of your way. Should you do it manually or set it on 
		automatic? You decide to do it manually, because you aren't going 
		to trust this foreign ship."
	choices = "\t1) TURN TO p.17"
	choice1 = p_17
;

p_31: Place
	statusRoot = "p.31"
	author = "Mike"
	desc = 
	{
		"You decide you should try and escape the tractor beam, because 
		down on the surface of the planet, you know you couldn't survive 
		because of all the strange creatures living on the planet. You 
		hit the reverse thrusters, and your ship shakes violently. You 
		feel a crushing sensation as you and your ship are torn into 
		glowing fragments.";
		CYOA_die();
	}
;

p_32: Place
	statusRoot = "p.32"
	author = "Colin"
	desc = "\"Wait!\" you shout, \"You're all under arrest!\"\n
		\t\"But why?\" shouts the captain's assistant.\n
		\t\"I have proof positive that you're all XXX agents,\" you bellow.\n
		\t\"Nice reasoning, but it'll do you no good,\" he says while trying 
		to disintegrate you. You dive to the ground, and dodge the beam. 
		Fortunately, the others aren't agents, and subdue him before he has 
		another chance at you. The danger's over, but you suspect there 
		to be other spies."
	choices = "\t1) IF YOU DECIDE TO STAY AND FLUSH OUT THE SPIES, GO TO p.41\n
			\t2) IF YOU TELL THEM TO DROP YOU OFF AT ZORNACK'S, GO TO p.56"
	choice1 = p_41
	choice2 = p_56
;

p_33: Place
	statusRoot = "p.33"
	author = "Rob"
	desc = 
	{
		"\"I'm on my way,\" you respond, setting the course for the 
		Yttocs system, which holds the planet Kcops. You realize that you 
		don't have quite enough fuel to make it all the way to Kcops, but 
		enough to make it to its moon.\n
		\tThe moon seems to have an atmosphere capable of sustaining life. 
		You plan to land and look around for someone to help you with fuel 
		problems.\n
		\tAfter you land, you don your space helmet and turn on your 
		life-support controls. As you step outside, a huge shadow blots 
		out all the light. You turn around just to see the mighty Gronk, 
		who lifts one foot steps on you, crushing you to a gelatinous 
		substance.";
		
		if (CYOA_global.html_mode) {
			"<center><p><img src=\"images/cyoa.png\"></p></center>";
		}
		
		CYOA_die();
	}
;

p_34: Place
	statusRoot = "p.34"
	author = "Colin"
	desc = "Since the beam isn't moving very fast and it looks like it's not 
		on course at all, you decide to advance slowly, ducking underneath 
		it. You have your laser drawn, and you fire five or six times, wildly. 
		Luck must have been with you that day, because you hit every one of 
		them. Glory at last.\n
		\tYou think that there are still more of them. Quickly you run into 
		their spaceship and search around. You find nothing, because as soon 
		as you get into the spaceship, it takes off. You immediately jump 
		into the nearest seat and buckle up. After a while, you find two 
		things, big things, on your radar. You can't exactly figure it out, 
		but the computer reads that the two objects are exactly the same. 
		Confusing, isn't it? The one on the left seems a little more 
		promising, so. you go to it. As soon as you get within twenty 
		miles of it, the other one disappears! Very interesting, but you 
		don't know what to do next."
	choices = "\t1) GO TO p.39"
;

p_35: Place
	statusRoot = "p.35"
	author = "Colin"
	desc = 
	{
		"Now you remember what the familiar thing was. It was a black 
		hole! Even after trying everything, you can't get out. It's too late...";
		CYOA_die();
	}
;

p_36: Place
	statusRoot = "p.36"
	author = "Colin"
	desc = "You take the one on the left because it seems more promising.\n
		\t\"20, 19, 18, 17, 16,\" your altitude measurer reads in miles, 
		and because you are so close, you decide to flip on the computer 
		scan. You breathe a sigh of relief, because it shows that the level 
		of radioactivity is not high.\n 
		\tAs soon as you get within a ten mile radius of the planet, you 
		hear a deafening boom to your right, which shakes your ship 
		vigorously. You look over and see that the \"right\" Daldor is 
		blown up in a million pieces, as you expected. You think for a 
		while, and finally deduce that the other planet was booby-trapped for YOU.\n
		\tWhen you get to the planet, you get some aid from an affiliate 
		policeman at the port you landed at. You're on your way to Naberfas, 
		and you run out of fuel. You are lucky, because there's a station 
		right close to where you are. It's old and rugged, has an old-timey 
		sign on it, dangling from side to side. To your dismay, it's the 
		kind that old gasoline-using cars used. Fortunately, to your left, 
		there's a big tail fin, which you deduce to be a space ship's.\n
		\tYou get in, cautiously, and after checking that there are no 
		people, you suddenly spot a piece of paper. After investigating it, 
		you find that it's a map."
	choices = "\t1) GO TO p.8"
	choice1 = p_8
;

p_37: Place
	statusRoot = "p.37"
	author = "Mike"
	desc = "What object do you wish to inspect?"
	choices = "\t1) THE WALLET, GO TO p.51\n
			\t2) THE RING, GO TO p.66\n
			\t3) THE SCROLL, GO TO p.40\n
			\t4) THE GLASSES, GO TO p.52\n
			\t5) THE WATCH, GO TO p.59"
	choice1 = p_51
	choice2 = p_66
	choice3 = p_40
	choice4 = p_52
	choice5 = p_59
;

p_38: Place
	statusRoot = "p.38"
	author = "Colin"
	desc = 
	{
		"You go outside of the ship, but take a whalloping fall. You land 
		flat on your face and are unconscious. The gang suddenly gathers 
		around you and it's now...";
		CYOA_die();
	}
;

p_39: Place
	statusRoot = "p.39"
	author = "Colin"
	desc = 
	{
		"You don't know what to do, so you drift in orbit around the planet. 
		Suddenly, a gray-greenish light shoots from the planet, and hits you! 
		Slowly, you are drawn closer to the planet. A tractor beam! You could 
		try to escape, but your ship would get torn apart, because of the 
		great pulling forces.";
		
		if (CYOA_global.html_mode) {
			"<center><p><img src=\"images/cyoa.png\"></p></center>";
		}
	}
	choices = "\t1) IF YOU TRY AND ESCAPE, GO TO p.31\n
			\t2) IF YOU LET THE TRACTOR BEAM GUIDE YOU DOWN, GO TO p.46"
	choice1 = p_31
	choice2 = p_46
;

p_40: Place
	statusRoot = "p.40"
	author = "Mike"
	desc = "You unroll the paper, and find something strange. The whole 
		covering is red, and you see faint black lines underneath it. 
		The substance is red and sticky."
	choices = "\t1) GO BACK TO p.37"
	choice1 = p_37
;

p_41: Place
	statusRoot = "p.41 "
	author = "Rob"
	desc = 
	{
		"You call a meeting of all the ship's crew. \n
		\t\"People!\" you yell, \"We believe there are members of the 
		XXX gang here on board!\" Everyone looks puzzled as you explain 
		about the XXX gang.\n
		\t\"Anyone in the XXX gang, I warn you to surrender now!\" you 
		say loudly. A fat man says, \"We won't surrender to you,\" in a 
		gruff voice, then, \"Get 'im!\" Suddenly, more than half the crew 
		is firing vaporisers at you! You and the rest of the ship are 
		destroyed.";
		CYOA_die();
	}
;

p_42: Place
	statusRoot = "p.42"
	author = "Colin"
	desc = "\"No,\" you say to yourself, it can't be, it just sounds too 
		unreal. But, still, what if it is, by some slim, unlikely chance?\n
		\t\"Wait, wait,\" you scream into the bomb, \"Tell me more, is it 
		true?\" you say with a booming curse. Suddenly, a famillar ticking 
		noise starts up behind you. You whip around, fast as a lightning 
		bolt, hoping it isn't the bomb. You're lucky, because it's just the 
		sound of your computer printing out a readout that very bluntly 
		states that you are out of fuel. You are diving, diving into 
		endless space. A planet is rapidly approaching, so you could bail out."
	choices = "\t1) IF YOU BAIL OUT, GO TO P.68\n
			\t2) IF YOU KEEP ON GOING INTO ENDLESS SPACE, GO TO p.62"
	choice1 = p_68
	choice2 = p_62
;

p_43: Place
	statusRoot = "p.43"
	author = "Mike"
	desc = 
	{
		"You take the items to the lab technician. After he examines them, 
		he becomes extremely quiet.\n
		\t\"I'm very sorry you came in here,\" he says as he points a laser 
		pistol at you, directly at your head. Then he reveals the triple X on 
		his shirt, and for you, it's...";
		CYOA_die();
	}
;

p_44: Place
	statusRoot = "p.44"
	author = "Colin"
	desc = "You decide that just staying there would be the best thing to do. 
		Then the man faces you and says, \"All right, I'm willing to reason 
		with you. If you tell us what you were doing out there, then we'll 
		let you go.\"\n
		\t\"Well, see...\"\n
		\t\"Quick, everybody duck!\" says the man driving. You all duck, 
		but not in enough time, because the man talking to you is stunned."
	choices = "\t1) GO TO p.72"
	choice1 = p_72
;

p_45: Place
	statusRoot = "p.45"
	author = "Colin"
	desc = "You decide not to get in front of it, because the risk of getting 
		hit is much higher than you want. As it is passing by, you spot a 
		perfect place to hang onto for a stowaway, but should you do it? 
		You think deeply about it, but you haven't got much time, and you 
		must decide quickly."
	choices = "\t1) IF YOU HANG ON THE BACK, GO TO p.61\n
			\t2) IF YOU JUST DRIFT ALONG INTO NEVERENDING SPACE, GO TO p.54"
	choice1 = p_61
	choice2 = p_54
;

p_46: Place
	statusRoot = "p.46 "
	author = "Colin"
	desc = "You decide to let the tractor beam guide you down to the ground, 
		because you can probably can escape the ship once on the ground. 
		When you get on the surface, you find yourself in an airport, and 
		with people that have XXX shirts all running around."
	choices = "\t1) IF YOU STAY IN THE SHIP, GO TO p.49\n
			\t2) IF YOU TRY AND ESCAPE, GO TO p.38"
	choice1 = p_49
	choice2 = p_38
;

p_47: Place
	statusRoot = "p.47"
	author = "Mike"
	desc = "You finally realize something. When you put the red-tinted glasses 
		on, you can see a map on the red paper clearly. After stealing a 
		hover car, you follow the map to an extinct volcano. You see a 
		circular window at the bottom, and this might be the XXX gang's 
		hideout."
	choices = "\t1) IF YOU CLIMB DOWN THE CRATER, GO TO p.70\n
			\t2) IF YOU SEARCH AROUND THE EDGE OF THE CRATER, GO TO p.75"
	choice1 = p_70
	choice2 = p_75
;

p_48: Place
	statusRoot = "p.48"
	author = "Rob"
	desc = 
	{
		"The secret of Daldor. You've never heard of Daldor having a secret 
		before. If there is one, it's worth investigatlng. You set the controls 
		for Daldor. Once on Daldor, you go to a center that holds everything 
		there is to know about Daldor. You search for a while and find nothing 
		about a secret. It's then that you remember that the space crystals 
		came from Daldor. It's a slim chance, but it could be.\n
		\tYou find that a long time ago, Daldoreans called the crystals their 
		\"secret.\" The secret is that the space crystals, which there are 
		six of, keep Daldor's energy and power in check, they also keep the 
		planet's stability okay. Without them, Daldor will become unstable 
		and expolde!\n
		\tThe only way to find out where the XXX gang is, is to work it out 
		on the ship's computer.\n
		\tYou board the ship and tell the computer everything you know, and 
		leave it to recall the XXX gang's history.\n
		\t\"TIME LEFT FOR SPACE CRYSTALS RETURN-- 1.5 STARDATES OR 5.2 DAYS. 
		XXX GANG HIDING IN TIME WARP.\"\n
		\t\"Which one?\" you ask it.\n
		\tThe computer prints out a map, which looks like this:";
		
		if (CYOA_global.html_mode) {
			"<center><p><img src=\"images/cyoa.png\"></p></center>";
		}
		else
		{
			"\b\t[map]\b";
		}
		
		"\tYou need to know, if you're going to return the crystals to their 
		underground.\n
		\t\"Which EXACT one is it?\" you ask.\n
		\t\"XXX SHIPS CAN ONLY HOLD ENOUGH FUEL FOR THEM TO BE ABLE TO 
		REACH QUADRANTS 4,4 and 5,1.\"\n
		\t\"Those are the ones closest to us, right?\"\n
		\t\"YES.\"\n
		\t\"How long will it take to reach one in days?\"\n
		\t\"1.4 DAYS.\"\n
		\t\"Take the ship to the time warp in quadrant 5,1.\"\n
		\t\"AFFIRMATIVE.\"\n
		\tThe computer transfers the coordinates to its navigational center, 
		and the ship blasts off and heads to the time-warp. You chose the one 
		at 5,1 because it would be logical that they doubled-back to shake off 
		the police. Also, they would have to turn around to get to the one 
		at 5,1. You congratulate yourself on your great reasoning.\n
		\tYou look at the view-screen and see two blobby images. The computer 
		tells you that they have no mass or gravity, so they must be the 
		time-warps. Or at least one is. The other must be an illusion to 
		fool you. You haven't much time, so which one?";
	}
	choices = "\t1) IF YOU GO THROUGH THE ONE ON THE LEFT, GO TO p.57\n
			\t2) IF YOU GO THROUGH THE ONE ON THE RIGHT, GO TO p.65"
	choice1 = p_57
	choice2 = p_65
;

p_49: Place
	statusRoot = "p.49"
	author = "Colin"
	desc = "You stay in the ship for fear of being massacred by the XXX gang. 
		After a little while, you deduce with great confidence that the people 
		dancing in front of you are drunk. Deciding that you might take 
		advantage of them, you go outside with your laser drawn, but..."
	choices = "\t1) GO TO p.38"
	choice1 = p_38
;

p_50: Place
	statusRoot = "p.50"
	author = "Rob"
	desc = 
	{
		"You quickly strap on your jet-pack and leap out of your ship. You 
		rocket far away before your ship explodes in an astounding flash of 
		light. In your hurry, you forget to check the jet-pack's circuits to 
		see if all was working. You also hit it on the hull on your way out. 
		Because of these factors, your engine sputters, and begins to die.\n
		\tIn order to stop your momentum, you flip on your low-power retro 
		thrusters in your boots. You try examining the jet-pack, but in 
		doing so, you touch a wrong wire, setting off a chain reaction of 
		sparks for a few seconds. Then one spark hits your near-full fuel 
		tank, and that of course means it's...";
		CYOA_die();
	}
;

p_51: Place
	statusRoot = "p.51"
	author = "Mike"
	desc = "You find nothing in the wallet that's of importance but a 
		few coins and an I.D. card."
	choices = "\t1) GO BACK TO p.37"
	choice1 = p_37
;

p_52: Place
	statusRoot = "p.52"
	author = "Mike"
	desc = "The glasses are strange, and you know that they must be used for 
		something. Wierdly enough, the glasses are totally red on the lenses, 
		and it is hard to see through them."
	choices = "\t1) GO TO p.47"
	choice1 = p_47
;

p_53: Place
	statusRoot = "p.53"
	author = "Rob"
	desc = "After finding out that the atmosphere outside is okay, you 
		decide to go outside.\n
		\tAs you turn and walk towards the hatch, the dials change with a
		noticeable click which catches your attention. To your surprise, the
		altimeter reads that you are not at ground level, but up 13,000 
		feet!\n
		\tYou think it's just a trick, so you decide to go out anyway."
	choices = "\t1) GO TO p.73"
	choice1 = p_73
;

p_54: Place
	statusRoot = "p.54"
	author = "Mike"
	desc =
	{
		"You drift along for days and days, with no food or companionship. 
		You are getting weaker and weaker because of malnutrition...";
		CYOA_die();
	}
;

p_55: Place
	statusRoot = "p.55" 
	author = "Rob"
	desc = "\"We'll get them when they come in,\" you say to X-14. \"I'd 
		just like to get my hands on the Big X.\"\n
		\t\"I don't think you'll have the chance,\" says X-14. \"The Big X will 
		most likely get his hands on you.\"\n
		\tYou turn around in surprise and shock to see your friend X-14 
		holding a gun at you.\n
		\t\"You can't, X-14 I won't let you!\" you shout.\n
		\t\"How will you stop me?\" he replies as the Big X and two guards 
		step in."
	choices = "\t1) If you trust X-14 and think he's bluffing, turn to p.60\n
				\t2) If you think that he really is a traitor, turn to p.74"
	choice1 = p_60
	choice2 = p_74
;

p_56: Place
	statusRoot = "p.56" 
	author = "Rob"
	desc = "\"I'd like to stay longer and flush out more XXX spies, but I 
		must be golng,\" you say.\n
		\t\"Fine. Where should we let you off?\" asks a crew member.\n
		\t\"Police base 7. To talk to inspector Zornack.\"\n
		\tAfter a discussion of who will take over the position of being 
		captain, you head for police base 7. The new captain is dim-witted 
		and forgetful. He begins to ask you your destination again."
	choices = "\t1) GO TO p.81"
	choice1 = p_81
;

p_57: Place
	statusRoot = "p.57"
	author = "Rob"
	desc = "You steer the craft through the one on the left, and you hope 
		it's the correct one. It's eerie, glowing, and very scary. Inside, 
		planets and stars zip by as you bypass time and space. Finally, you 
		come to the end of your journey, and see something unexpected. There 
		are two planets in front of you! Not only do you have to find the XXX 
		Gang, but you have to also find the right planet! You have to decide 
		NOW! There is a blue planet and a yellow one. There isn't time to try
		both!"
	choices = "\t1) IF YOU TRY THE BLUE PLANET, GO TO p.67\n
				\t2) IF YOU TRY THE YELLOW PLANET, GO TO p.64\n"
	choice1 = p_67
	choice2 = p_64
;

p_58: Place
	statusRoot = "p.58"
	author = "Mike"
	desc = 
	{
		"You wake up in a brightly lit room, and are surrounded by people 
		in white suits and XXX shirts.\n
		\t\"We are glad you woke up,\" one man says softly.\n
		\t\"Why?\" you question him.\n
		\t\"We need to tell you something very important.\"\n
		\t\"What?!\"\n
		\t\"You are going to die!\" he says as he cocks his laser rifle.";
		CYOA_die();
	} 
;

p_59: Place
	statusRoot = "p.59"
	author = "Mike"
	desc = "There is nothing special about the watch, so you decide to keep it."
	choices = "\t1) GO BACK TO p.37"
	choice1 = p_37
;

p_60: Place
	statusRoot = "p.60" 
	author = "Colin"
	desc = 
	{
		"You turn your head, as the Big X looks away for a moment to look 
		around, and wink at X-14. To your relief, he winks back.\n
		\t\"X-14?\" the Big X asks as he looks at X-14.\n
		\t\"Yeah, X-14 here. I got an agent.\" X-14 says in a deep, gruffy, 
		XXX like manner.\n
		\t\"Very good, ver...\"\n
		\tSuddenly, before the Big X can repeat his words, X-14 guns him 
		and his guards down. \"Whew!\" X-14 says, \"That was close. I almost
		thought that you thought I was a traitor until you winked.\"\n
		\"I wasn't sure,\" you say, \"but I trusted you,\"\n
		About a week later, you round up the last of the XXX Gang easily 
		because they couldn't function without a leader. Unfortunately, you 
		still cannot find the stolen space crystals. ";
		CYOA_die();
	} 
;

p_61: Place
	statusRoot = "p.61"
	author = "Colin"
	desc = "You cling onto the back of the ship, and after making a lot of 
		noise, you hide behind a barrel and wait. Wait for what? You decide 
		that what you're doing is just wasting your time, so you discreetly
		maneuver yourself to the cockpit, with your laser drawn, and stick 
		it up in the pilot's ear.\n
		\t\"All right, mister, I'm taking over, and you better move and let 
		me take control,\" you say in a very gruffy voice.\n
		\t\"O.K., buddy, you can move along now, and go back to where you 
		came from,\" comes a voice followed by a sharp pain of a laser pistol
		barrel in your left ear.\n
		\tNow you're in double trouble, and there are only two things you 
		can do. Either use your abilities, that you learned at the academy, 
		just for emergency situations as this. But you could try to be civil 
		about it, and try to negotiate."
	choices = "\t1) IF YOU QUICKLY TURN AROUND AND TRY TO INJURE THE MAN, 
				GO TO p.63\n
				\t2) IF YOU JUST STAY THERE CIVILLY, GO TO p.44"
	choice1 = p_63
	choice2 = p_44
;

p_62: Place
	statusRoot = "p.62" 
	author = "Colin"
	desc = 
	{
		"You stay in the spaceship, because it seems too dangerous to 
		bail out since it might explode. So you decide to just drift along, 
		and cross your fingers. As you're interntly watching the view 
		screen, a sudden wailing comes through the cockpit. Turning around 
		on the swivel chair, you see that the noise is coming from the radar, 
		but nothing's on the screen! You check out the computer, and the status
		shows that the gravitation force around the spaceship is much, 
		much greater than usual... which ovbiously means that you're 
		entering a BLACK HOLE! You become unconscious, your ship gaining 
		momentum every second, and strangely enough your ship is NOT being
		crushed!\n
		\tYou are gaining speed and you have totally no control over your 
		ship. Suddenly, on your view screen, you see two identical objects, 
		one on the far left, and one which is almost directly in front of you. 
		You plunge into the one in front of you, because you have no fuel 
		and no control. Suddenly you get the sudden sensation of being alone, 
		and now you know that it's";
		CYOA_die();
	}
;

p_63: Place
	statusRoot = "p.63" 
	author = "Rob"
	desc = "You feel your hand around and grasp a piece of metal. You swing 
		around and hit the man in the jaw with it. He falls over and you see 
		his face.\n
		\t\"Z-12?\" he asks.\n
		\tYou recognize him. It's Inspector Zornack. \"Inspector! What 
		are you doing here?\" you ask.\n
		\t\"I have been following you. I thought you were an XXX man. 
		Oh, by the way, meet agent X-14.\" Zornack points to the pilot.\n
		\t\"Hello, X-14,\" you say. Suddenly you notice that X-14's collar 
		has the insignia XXX on it. You pretend not to notice, and then 
		look at Zornack. He has the same insignia."
	choices = "\t1) If you try to fire at the two XXX agents, turn to p.77\n
				\t2) If you play along, turn to p.71"
	choice1 = p_77
	choice2 = p_71
;

p_64: Place
	statusRoot = "p.64"
	author = "Rob"
	desc = "You think about it for a while, then you decide to try for 
		the yellow planet. You turn your ship and thrust in the direction 
		of the yellow planet. As you near the yellow planet's outer 
		atmosphere, you notice a ship heading toward you from the 
		direction of the yellow planet. You can't tell whether it's 
		a Galactic Patrol ship, an insidious XXX ship, or just a passing 
		craft."
	choices = "\t1) If you think it's an XXX ship, then turn to p.97\n
				\t2) If you think it's a Galactic Patrol ship, turn to p.98\n
				\t3) If you believe that it's just a passing craft, turn to p.99"
	choice1 = p_97
	choice2 = p_98
	choice3 = p_99
;

p_65: Place
	statusRoot = "p.65" 
	author = "Rob"
	desc = "You steer your craft through the one on the right, and you 
		hope it's the correct one. It's eerie, glowing, and very scary. 
		Inside, planets and stars zip by as you bypass time and space. 
		Finally, you come to the end of your journey, and see something
		unexpected. There are three planets nearby. One red, one blue, 
		and one yellow. Which should you go to? What should you do?"
	choices = "\t1) If you let the computer decide, turn to p.83\n
				\t2) If you just sit and wait, go to p.82"
	choice1 = p_83
	choice2 = p_82
;

p_66: Place
	statusRoot = "p.66"
	author = "Mike"
	desc = "You find nothing special about the ring, and you trade it with 
		a jeweler for a couple of bucks."
	choices = "\t1) GO BACK TO p.37"
	choice1 = p_37
;

p_67: Place
	statusRoot = "p.67" 
	author = "Rob"
	desc = "You take your chances with blue, because blue is your 
		favorite color. You decide to land, but you don't know where. 
		Finding a nice spot, you land with great ease and safety. You want 
		to go outside, but after one look at your suit, you are a bit more
		reluctant. The atmosphere seems o.k., but you're not so sure."
	choices = "\t1) IF YOU GO OUTSIDE, GO TO P.53\n
				\t2) IF NOT, GO TO p.69"
	choice1 = p_53
	choice2 = p_69
;

p_68: Place
	statusRoot = "p.68"
	author = "Rob"
	desc = "You quickly jump into your spacesuit and bail out. You begin 
		to drift towards the planet. Slowly, you look around, and see a 
		spaceship. The insignia on the side of it says that it's part of 
		the Intergalactic Space Patrol. Whew! What a relief, but you're 
		not out of it yet. You need to make sure that the craft sees you, 
		but if you just get in front of it, it might run you over."
	choices = "\t1) IF YOU TAKE THE CHANCE OF GETTING IN FRONT OF THE 
			CRAFT, GO TO p.22\n
				\t2) IF NOT, GO TO p.45"
	choice1 = p_22
	choice2 = p_45
;

p_69: Place
	statusRoot = "p.69"
	author = "Rob"
	desc = "You decide not to go out, because it would be a bad way to 
		go. But you decide to put on your view-screen anyway. To your 
		surprise, you see a whole bunch of people walking around.\n
		\t\"That XXX Gang is too much. But I'll admit their illusions 
		are good,\" you say to yourself. But in the back in your mind, 
		you still think it might be true."
	choices = "\t1) IF YOU GO OUTSIDE, GO TO p.80\n
				\t2) IF YOU GO TO THE COMPUTER FOR MORE INFORMATION, 
				GO TO p.53"
	choice1 = p_80
	choice2 = p_53
;

p_70: Place
	statusRoot = "p.70"
	author = "Mike"
	desc = 
	{
		"As you climb down the crater, you realize you were wrong! 
		The volcano isn't extinct. Just before you are burnt to a 
		cinder, you look in the window, and see the smiling faces 
		of the XXX Gang.";
		CYOA_die();
	}
;

p_71: Place
	statusRoot = "p.71" 
	author = "Rob"
	desc = "You decide to play along, because you might be killed 
		otherwise. You speak up. \"Where are we going?\" you ask.\n
		\t\"The astro-city of Naberfas,\" Zornack replies. \"We may find 
		a clue of some kind there.\"\n
		\t\"But...\" you try to say.\n
		\t\"No buts,\" says Zornack roughly."
	choices = "\t1) Go to p.76"
	choice1 = p_76
;

p_72: Place
	statusRoot = "p.72"
	author = "Colin"
	desc = "You try to arouse him, and finally, when he comes to, he says, 
		\"I hate the XXX Gang, oooh, what would I give to...\"\n
		\t\"Wait,\" you reply, \"you know about them too?\"\n
		\t\"Yes, of course, I'm special agent X-14, associated with 
		Inspector Yubak.\"\n
		\t\"Wow!\" you exclaim. \"What a small world, I'm special agent 
		Z-12, associated with Inspecter Zornack. Maybe we could work 
		together,\" you say.\n
		\t\"Fine,\" he replies, \"but we've got to go and see if M-29 is 
		all right.\"\n
		\t\"Yeah,I'm all right,\" comes a mysterious voice from the 
		background.\n
		\tYou grow a liking for these people, and learn to trust them. 
		Suddenly, all of your heads turn to a strange beeping noise in the
		backround."
	choices = "\t1) GO To p.79"
	choice1 = p_79
;

p_73: Place
	statusRoot = "p.73"
	author = "Rob"
	desc = 
	{
		"As you turn to leave, the dials change, and they read ground 
		level. They stay that way until you're satisfied that they are 
		tricks. You look around, and see through the hatch that the planet 
		is between Daldor and what was 20th century Earth. Sunshine, plants,
		animals, trees and people. You jump out ofthe ship. As your feet 
		are about to touch the ground, the planet fades away, and you 
		are drifting in space.\n
		\tDays later, as you are about to meet your doom at the heart of 
		a star, you hear the faint but clear words over the helmet's 
		radio:\n
		\t\"SO LONG, SUCKER!\"";
		CYOA_die();
	}
;

p_74: Place
	statusRoot = "p.74" 
	author = "Rob"
	desc = 
	{
		"\"X-14?\" the Big X asks when he sees X-14. Suddenly you elbow 
		X-14 in the stomach and try to draw your laser. The XXX guards are 
		too fast, though. They shoot you down before you can get up.\n
		\tAs your vision is about to fade and things start getting dark, 
		you hear the Big X saying, \"I don't like spies.\" After that, the 
		screech of laser fire.\n
		\tYou should have trusted him after all.";
		CYOA_die();
	} 
;

p_75: Place
	statusRoot = "p.75"
	author = "Mike"
	desc = "You can't find anything, so you decide to investigate the 
		window. Just as you are getting ready to go down, you slip on a
		medium-sized rock. Suddenly a pit opens in the ground, and 
		swallows you. You hit your head on something hard and everything 
		grows dark."
	choices = "\t1) GO TO p.58"
	choice1 = p_58
;

p_76: Place
	statusRoot = "p.76"
	author = "Rob"
	desc = 
	{
		"You and Zornack are flown to Naberfas, and are dropped off at 
		a wareouse. Zornack steps inside, and you follow. When you step 
		in, Zornack gives you a karate chop to the neck. You slump into
		unconsciousness.\n
		\tWhen you wake up hours later, you see the Big and Bigger X's 
		standing over you. The Big X is holding a mask which looks exactly 
		like Zornack's face.\n
		\t\"You should have done something when you found out, Z-12,\" 
		the Big X says. The Bigger X gestures behind him and sets food 
		in front of you. You haven't eaten in a while, so you start to 
		wolf down the food. Suddenly you feel sick and stop eating.\n
		\t\"Haven't you ever heard of poison, Z-12?\" the Bigger X 
		inquires. You are too sick to answer.";
		CYOA_die();
	} 
;

p_77: Place
	statusRoot = "p.77" 
	author = "Rob"
	desc = 
	{
		"You quickly draw your laser pistol and fire at Zornack and X-14. 
		A shower of sparks comes from where you hit each of them, and in 
		two seconds, both explode.\n
		\tA voice from the ship's tele-viewer says, \"Hello Z-12. Meet our
		androids. Also meet our exploding ship.\" The voice clicks off, 
		and you hear a familiar ticking. In short, it's...";
		CYOA_die();
	}
;

p_78: Place
	statusRoot = "p.78"
	author = "Rob"
	desc = "You decide to stay inside. As you sit at the dials, the 
		instruments say you're floating, then you're at 13,000 feet, 
		then 12,000 feet. It must be a trick. You decide to go outside 
		anyway."
	choices = "\t1) GO TO P.73"
	choice1 = p_73
;

p_79: Place
	statusRoot = "p.79"
	author = "Colin"
	desc = "The noise mysteriously comes from the intercom-speaker.\n
		\t\"This is the big X speaking, and we know you have one of our 
		agents in ther. You better surrender now!\" he says.\n
		\t\"But ....,\" X-14 says feebly, before you interrupt him, 
		and say, \"Help, get me out!\" You cover up the speaker and 
		whisper, \"Sssh, let's play along.\"\n
		\t\"O.K., we're coming over,\" the voice says, and clicks off 
		Ieaving an eerie silence with you."
	choices = "\t1) GO TO P.55"
	choice1 = p_55
;

p_80: Place
	statusRoot = "p.80"
	author = "Rob"
	desc = "You decide to outside first, even though it might be an 
		illusion. You check for another spacesuit, and succeed. You 
		slip it on, and check the dials in the control room. To your 
		surprise, they read that you are not on ground level, but 
		floating in space!"
	choices = "\t1) IF YOU THINK IT'S A TRICK, AND WANT TO LEAVE THE 
				SHIP, GO TO P.73\n
				\t2) IF YOU CHOOSE TO REMAIN INSIDE, GO TO P.78"
	choice1 = p_73
	choice2 = p_78
;

p_81: Place
	statusRoot = "p.81"
	author = "Rob"
	picture = true
	desc = 
	{
		"\"Drop me off at police base 7.\"\n
		\t\"Roger!\" says the new captain.\n
		\tSoon you're at police base 7, and you enter Zornack's office.\n
		\t\"Aaah!\" says Zornack. \"Agent Z-12, you've returned, any 
		leads?\" Zornack reaches out to touch your hand. As you grip 
		his hand, it suddenly comes off! A good amount of tranquilizer 
		gas rushes out from the hole in his hand.\n";
		
		if (CYOA_global.html_mode) {
			"<center><p><img src=\"images/cyoa.png\"></p></center>";
		}
		
		"\tAs you drift into unconsciounsess, you hear faint voices: 
		\"It worked, the Zornack robot worked!\" As you regain 
		consciounsess, you find yourself in a room with inspector 
		Zornack.\n
		\t\"I have something for you,\" says Zornack, as he pulls out 
		his laser and guns you down.\n
		\tIn your last moments, you hear faint voices saying, \"I never 
		thought he would fall for that trick twice!\"";
		CYOA_die();
	}
;

p_82: Place
	statusRoot = "p.82" 
	author = "Rob"
	desc = "You are really confused now, so you decide to just sit 
		and think a while. As you sit staring out your frontal 
		viewscreen, something strange occurs. The red planet merges 
		with the blue planet and make a purple planet. Then a smaller 
		purple planet drifts away from the first and merges with the 
		yellow to make a brown planet. You have known the XXX Gang to 
		be tricky and fool you with illusions, but shifting planets?"
	choices = "\t1) If you feel this is just one big trick, and want 
			to go back, turn to p.57 and through the warp on your left.\n
				\t2) If you steer for the brown planet, turn to p. 84\n
				\t3) If you go to the purple planet, turn to p.85"
	choice1 = p_57
	choice2 = p_84
	choice3 = p_85
;

p_83: Place
	statusRoot = "p.83"
	author = "Rob"
	picture = true
	desc = "You type in your problem on the console, and a few clicks 
		and whirrs later the readout spews out. You tear off the paper, 
		and read it. It says:\n
		\t\(Go\ \ To\ \ The\ \ Blue\ \ Planet.\)"
	choices = "\t1) If you take the computer's advice, turn to p.86\n
				\t2) If not, turn to p.82"
	choice1 = p_86
	choice2 = p_82
;

p_84: Place
	statusRoot = "p.84"
	author = "Rob"
	picture = true
	desc = "You set the ship on manual control, and veer toward the 
		brown planet. As you near it, the brown tint fades, and looks 
		only yellow. The purple planet has become red and blue planets 
		again. You were right, it was just an XXX trick to throw you 
		off course.\n
		\tAs you land your ship on the yellow planet, you see nothing 
		different from the outside landscape than from Daldor's. No 
		wonder the XXX Gang stole the crystals. They made their own 
		Daldor, and needed the crystals for energy and power!\n
		\tYou search around, and find nothing but a shiny stick. As 
		you pull on it, a large sguare hole opens in the ground. You 
		duck behind a large rock, waiting for something to appear. After 
		a while, nothing does."
	choices = "\t1) If you go down the hole, turn to p.89\n
				\t2) If not, turn to p.90"
	choice1 = p_89
	choice2 = p_90
;

p_85: Place
	statusRoot = "p.85" 
	author = "Rob"
	desc = "As you get very near to the purple planet, it splits 
		and becomes red and blue planets. You were right about the 
		trick, but too late to stop your momentum. You speed in between 
		the planets, and see a space station, probably belonging to 
		the XXX Gang. You dock and investigate.\n
		\tAs you step inside, you notice that it looks a lot like a 
		storage area. You think you hear a noise behind you. You decide 
		to go through a door in front of you."
	choices = "\t1) Go to p.9"
	choice1 = p_9
;

p_86: Place
	statusRoot = "p.86" 
	author = "Rob"
	desc = "Throwing away the paper, you take the controls and head 
		for the blue planet. You begin to feel uneasy, as if you know 
		that something not too pleasant is going to happen."
	choices = "\t1) If you continue to the blue planet, turn to p.67\n
				\t2) If you go to the red planet, turn to p.88\n
				\t3) If you want to hear what the computer says, turn to p.87"
	choice1 = p_67
	choice2 = p_88
	choice3 = p_87
;

p_87: Place
	statusRoot = "p.87" 
	author = "Rob"
	desc = "You type in the current situation on the computer. After 
		a few minutes, sparks begin to fly about, coming from your 
		console. The computer speaks suddenly, in the voice of the 
		Big X, \"Sorry to foul up your ship's and computer's circutry, 
		but we warned you a long time ago not to be a snoop!\"\n
		\tThe voice stops, and a moment thereafter everything begins 
		to explode. You have to bail out!"
	choices = "\t1) Go to p.68"
	choice1 = p_68
;

p_88: Place
	statusRoot = "p.88" 
	author = "Rob"
	desc = 
	{
		"You make it to the red planet with no trouble. You zip up 
		your suit and step outside. You walk around for a while, 
		when suddenly you feel a laser rifle barrel to your back. 
		You turn your head, and see an XXX agent. He tears off your 
		helmet and says, \"You won't need that in this atmosphere.\"\n
		\tLater, they line you up against a wall with guns aimed at 
		your heart. You hear the Big X say, \"One, two, three, NOW!\"\n
		\tYou expect to hear laser shots, but instead the wall tips 
		over on top of you. The XXX Gang was always comprised of 
		practical jokers.";
		CYOA_die();
	} 
;

p_89: Place
	statusRoot = "p.89" 
	author = "Rob"
	desc = 
	{
		"You cock and ready your laser pistol. You ready yourself 
		for anything, then you step down into the hole. You put one 
		foot down, and realize that there is a ladder. You swiftly but 
		silently climb down.\n
		\tYou sneak around for a while, and then eventually end up 
		where you first came down. You hear a click, then you realize 
		that you have been watched. \"Smile! You're on spy camera!!\" 
		shouts a voice. Suddenly, a large rock rolls down the hole. You 
		try to run away, but get trapped in a small alcove. You pass out 
		from exhaustion.\n
		\tYou wake up with blurred vision, to see the XXX leaders 
		standing above you. The Big X frowns, but the Bigger X smiles. 
		You hear the cocking of an XXX laser rifle and then you realize 
		that it's...";
		CYOA_die();
	} 
;

p_90: Place
	statusRoot = "p.90" 
	author = "Rob"
	desc = "You stay behind the rock and wait. You finally decide 
		to try something daring. You will remove the uniform of an 
		XXX agent and slip inside unnoticed. Several agents come to 
		investigate the hatch opening, but the first one was too small. 
		The next one was too fat, the one after that, too tall, etc. 
		After a while, one that you judge to be your size appears. You 
		club him with your gun handle, then take his gun. You ditch 
		your suit behind the rock and wear his suit. Unfortunately, 
		the suit is a little big, but not too big that anyone will 
		notice.\n
		\tYou step down the hole and follow the passages until you 
		finally come to the room with the Big and Bigger X's. They look 
		at each other and then turn to you and say, \"Agent X-49k?\"\n
		\tThe guard next to them cocks his rifle."
	choices = "\t1) If you answer, \"Yes, I'm X-49k.\" then turn to p.91\n
				\t2) If instead you draw your pistol and reveal your 
				identity, turn to p.92"
	choice1 = p_91
	choice2 = p_92
;

p_91: Place
	statusRoot = "p.91" 
	author = "Rob"
	desc = 
	{
		"You remember that when you clobbered the guy whose uniform 
		you have, he cursed in a deep voice. Standing up straight, you 
		answer in the deepest voice you can, \"Yeah, X-49k here.\"\n
		\tThe Bigger X smiles. \"An impressive display of theatrics, 
		Z-12. Unfortunately, it didn't work.\" He then turns to the 
		guard behind him and the Big X. \"Now, agent X-49k, the REAL 
		one, please do your duty. We have an agent in our midst.\"\n
		\tYou realize your mistake too late. You've been duped. It's 
		too late to do anything else.";
		CYOA_die();
	}
;

p_92: Place
	statusRoot = "p.92" 
	author = "Rob"
	desc = "You quickly draw your laser and gun down the guard before 
		he can do anything. You then aim the pistol at the Big X.\n
		\t\"Don't try anything funny!\" you shout. You point your 
		laser at the Bigger X. \"You too!\" you say.\n
		\tFrom behind the Big and Bigger X's opens a small panel. 
		You set your laser to stun and shoot the Big X. Unfortunately, 
		the Bigger X escapes."
	choices = "\t1) If you follow the Bigger X, turn to p.89.\n
				\t2) If not, go to p.93"
	choice1 = p_89
	choice2 = p_93
;

p_93: Place
	statusRoot = "p.93" 
	author = "Rob"
	desc = "You decide not to follow because the Bigger X knows 
		the place and you don't. You search around the office, and 
		in doing so step on a special floor register and the chair 
		that the Big X is sitting in slides over, revealing a secret 
		staircase. You shove the unconscious Big X out of the way 
		and descend."
	choices = "\t1) Turn to p.94"
	choice1 = p_94
;


p_94: Place
	statusRoot = "p.94"
	author = "Rob"
	picture = true
	desc = 
	{
		"As you reach the bottom, you see a glowing behind a corner. 
		You carefully walk around the corner, and in a large case is 
		one of the power crystals of Daldor! You search some more and 
		find the rest. You stash them in one box so you can carry them 
		easier.\b";
		
		if (CYOA_global.html_mode) {
			"<center><p><img src=\"images/p94.png\"></p></center>";
		}
		
		"\b\tYou find that whatever you say happens. As you are going out, 
		when you say to the XXX guards, \"Step aside,\" they move to let 
		you pass. You make it into your spaceship before you realize that 
		one crystal is not in the box you are carrying. You remember that 
		you dropped one in the room where you found them.\n
		\t\"After all that?!?\" you yell to yourself. \"I could just 
		kill myself!\"\n
		\tYou then realize that you said the wrong thing with the space 
		crystals around. You should be more careful, you think as you 
		draw your laser pistol...";
		CYOA_die();
	}
;

p_95: Place
	statusRoot = "p.95"
	author = "Rob"
	desc = 
	{
		"You walk through the panel and run down the hall that it 
		opens into. You see the Bigger X trying to engage a lever. You 
		fire, but nothing happens. He is still conscious. You set it 
		to kill, but the same results.\n
		\t\"That won't work, Z-12. I'm protected aqainst any type of 
		charge from conventional laser pistols and rifles,\" he says as 
		he removes a small piece of plastic from his fingernail.\n
		\t\"That's nice,\" you say, gunning him down. You place it on 
		your own fingernail and hope it protects you from XXX fire.\n
		\tYou manage to flip the lever, and another panel opens. You 
		step through, and find the power crystals. You remove them, 
		and make it back to your ship. The fingernail gadget worked, 
		probably to prevent an assasination atempt by an XXX agent. 
		You blast off and return the crystals to Daldor with hours to 
		spare.\n
		\tYou become known as 'The agent who saved Daldor'. You try 
		to be modest, but you can't. Nobody likes you for bragging, 
		so you get ditched in the end.";
		CYOA_die();
	} 
;

p_96: Place
	statusRoot = "p.96"
	author = "Mike"
	desc = 
	{
		"As you continue on your journey, the ship guns you down, 
		sending you spinning toward the yellow planet. It was an XXX 
		ship after all.";
		CYOA_die();
	} 
;

p_97: Place
	statusRoot = "p.97"
	author = "Colin"
	desc = 
	{
		"You set your ship's laser on automatic, and lock in on the XXX 
		ship. Just before you fire, Zornack's voice comes over on your 
		tele-viewer. Unfortunately, you can't stop in time. You press 
		fire, and feel too guilty to continue your mission.";
		CYOA_die();
	} 
;

p_98: Place
	statusRoot = "p.98"
	author = "Colin"
	desc = "You use your tele-viewer to contact the ship, and to 
		your relief, Zornack answers.\n
		\t\"Z-12, come aboard,\" he says as his picture fades. There 
		is one thing wrong. Zornack's voice sounded different."
	choices = "\t1) If you think it's an XXX trap and continue on 
				your journey to the yellow planet, turn to p.99\n
				\t2) If you dock on the ship anyway, turn to p.100"
	choice1 = p_99
	choice2 = p_100
;

p_99: Place
	statusRoot = "p.99 "
	author = "Colin"
	desc = "You turn off your viewer and think before you continue. If 
		you continue on your way, they might gun you down if it is an 
		XXX ship."
	choices = "\t1) If you are sure it is an XXX trap, then turn to p.97\n
				\t2) If you continue on your journey, then turn to p.96"
	choice1 = p_97
	choice2 = p_96
;

p_100: Place
	statusRoot = "p.100"
	author = "Rob"
	picture = true
	desc = 
	{
		"You steer carefully toward the ship and see the Galactic 
		Patrol insignia on the side. You dock, and step inside. Once 
		inside, you remove your space suit. Suddenly you notice that 
		everyone else is wearing a suit. Then you realize that the 
		insignia was on the wrong side. You quickly don your suit as 
		a button is pressed to dissolve the ship.\n
		\tThe XXX members who were disguised rocket off via jet packs. 
		Since you weren't expecting anything to happen, you don't have 
		yours. You silently drift away, seeing the gloating XXX members 
		shoot off to their hideaway.";
		
		if (CYOA_global.html_mode) {
			"<center><p><img src=\"images/p100.png\"></p></center>";
		}
		
		CYOA_die();
	}
;
