#charset "us-ascii"
#include <adv3.h>
#include <en_us.h>


DefineSystemAction(HtmlSuggest)
    execSystemAction()
    {
        local stat;
        if(systemInfo(SysInfoInterpClass) != SysInfoIClassHTML)
        {
            reportFailure(&needsHtmlTerpMsg);
            exit;
        }
        
        switch(mode)
        {
            case 'toggle': stat = !(gameMain.hyperlinkSuggestedTopics); break;
            case 'on': stat = true; break;
            case 'off': stat = nil; break;
        }
        gameMain.hyperlinkSuggestedTopics = stat;
        mainReport(&htmlSuggestMsg);
        if(gPlayerChar.getCurrentInterlocutor != nil)
            say('<.topics>');
    }  
;


VerbRule(HtmlSuggest)
    'toggle'->mode ('hyperlink'|'hyper') ('suggestions'|)
    | ('hyperlink'|'hyper'|'link') ('suggestions'|) ('on'->mode|'off'->mode)
    : HtmlSuggestAction
    verbPhrase = 'toggle/toggling suggestions'
;

/*
 *   The EnumSuggestions Action is provided to allow players to decide 
 *   whether or not to enable te menu-like choice of conversation topics by 
 *   entering a number at the command prompt. It may be, however, that some 
 *   authors will want to keep this under their own control, in which case 
 *   the VerbRule can be modified to something unmatchable, e.g.:
 *
 *   modify VerbRule(EnumSuggestions) '': ;
 */

DefineSystemAction(EnumSuggestions)
    execSystemAction()
    {
        gameMain.enumerateSuggestedTopics = (mode=='on');
        mainReport(&enumerationStatusMsg);
        if(gPlayerChar.getCurrentInterlocutor != nil)
            say('<.topics>');
    }
;

VerbRule(EnumSuggestions)
    ('enum' | 'enumerate') ('suggestions'|) ('on'->mode|'off'->mode)
    :EnumSuggestionsAction
    verbPhrase = ('turn/turning suggestion enumeration ' + gAction.mode)
;

modify playerActionMessages
    htmlSuggestMsg = ('Hyperlinking of suggested conversation topics is
        now ' + (gameMain.hyperlinkSuggestedTopics ? 'ON.' : 'OFF.'))
    
    enumerationStatusMsg = ('Enumeration of suggested conversation topics
        is now ' + (gameMain.enumerateSuggestedTopics ? 'ON.' : 'OFF.'))
    
    needsHtmlTerpMsg = 'This feature requires an HTML interpreter. '
;

modify suggestionYesNoGroup
    sayYesOrNo = "say yes or no"
    groupPrefix = "say "
;

/* 
 *   The explainHyperEnum() function can be called from user code (e.g. an 
 *   introductory instruction menu) to explain the use of this extension to 
 *   players.
 */


explainHyperEnum()
{
    local htmlTerp = (systemInfo(SysInfoInterpClass) == SysInfoIClassHTML);

    "<<htmlTerp ? 'Since you are' : 'If you were'>> using an HTML interpreter
    you <<htmlTerp ? 'can' : 'could'>> have the topic inventory (the list of
    suggested topics you can address to the NPC the PC is currently conversing
    with) hyperlinked, so that you can select one of these suggested topics by
    clicking on the link.\b
    Hyperlinking is activated with the command HYPERLINK SUGGESTIONS ON, which
    may be abbreviated to HYPER ON; it can be turned off again with HYPERLINK
    SUGGESTIONS OFF or HYPER OFF.\b
    Alternatively (or additionally) you can have the game enumerate the
    suggested topics, and then select a topic by simply entering the
    appropriate number at the command line.\b
    For example, with this option turned on you might see:\b
    (You could say [1] yes, or [2] no, or [3] ask who she is.)\b
    Then to ask who she is you could simply enter the command 3 at the prompt,
    making this act a little like a conversation menu.\b
    To turn this enumeration interface on, use the command ENUMERATE
    SUGGESTIONS ON, which can be abbreviated to ENUM ON. To turn it off use
    ENUMERATE SUGGESTIONS OFF or ENUM OFF.\b
    Please note that both the hyperlinking and the enumerating interfaces will
    only show conversation topics that would otherwise be listed in response to
    a TOPICS command, in other words, topics that the game author has arranged
    to be suggested at this point. There may well be other conversation topics
    available that can only be reached by entering ASK, TELL, GIVE, SHOW etc.
    commands in full. These interface options are thus <i>not</i> a full
    substitute for the standard conversation interface.<.p>";   
}

/* 
 *   This function can optionally be called after explainHyperEnum() to warn 
 *   players about the limitations of the hyperlinking/enumerating interfaces
 */

warnHyperEnum()
{
    "Although hyperlinking and/or enumerating suggested topics may seem a great
    convenience feature, we recommend that it be used with caution. In
    particular, both alternative interfaces have a number of disadvantages:\b
    (1)  They only work with suggested topics; there may be other interesting
    topics available that they don't cover, so that relying on clicking links or
    typing numbers may result in your missing other interesting topics.\b
    (2)  You may find switching from entering commands to clicking links or
    entering menu-style numbers breaks immersion by calling attention to the
    interface.\b
    (3)  Conducting conversations with NPCs by entering numbers or clicking
    hyperlinks can lead to a very mechanical style of play in which you cease to
    think about what you want your PC to say to the NPC and instead simply work
    through a list of suggested topics.\b
    You are therefore likely to have a better playing experience if you use the
    standard command-line interface for conversation commands. We strongly
    recommend that you use these alternative interfaces only if you find the
    ordinary command-line interface unsatisfactory. ";
}