!------------------------------------------------------------------------------
!
!							N P C _ W A I T . h
!
!
!
!	Written by:
!	- Andrew Clover
!	- L. Ross Raszewski
!	- Nicholas Daley
!	- Volker Lanz
!
!
!------------------------------------------------------------------------------

#ifndef tw_waiting;
	object tw_waiting "tw";
#endif;

#IFNDEF MAX_WAIT;
	Constant MAX_WAIT 180;
#ENDIF;


!-------------------------------------------------------------------------------
[ WaitMovesSub w_until;
	if (noun > MAX_WAIT && w_until ~= 1)
	{
		give tw_waiting locked;
		return(NPC_Msg(##Wait, 1));
	}
	
	if (noun == 0)
	{
		give tw_waiting locked;
		return(NPC_Msg(##Wait, 2));
	}

	NPC_Msg(##Wait, 3);

	.keep_waiting;
	give tw_waiting ~on;
	
	for (: noun > 0 && deadflag == 0 && tw_waiting hasnt on: noun--)
	{
		InformLibrary.End_Turn_Sequence();

		DisplayStatus();
		DrawStatusLine();
	}

	if (tw_waiting has on && noun > 0 && deadflag == 0)
	{
		NPC_Msg(##Wait, 4);
		if (YesOrNo())
			jump keep_waiting;
	}
	 
	NPC_Msg(##Wait, 5);
	LanguageTimeOfDay (the_time / 60, the_time % 60);
	return(NPC_Msg(##Wait, 6));
];


!-------------------------------------------------------------------------------
[ WaitHoursSub;
	noun = noun * 60;
	WaitMovesSub(0);
];


!-------------------------------------------------------------------------------
[ WaitUntilSub;
	if (parsed_number >= the_time)
		noun = parsed_number - the_time;

	if (parsed_number < the_time) 
	{
		parsed_number = the_time - parsed_number;
		noun = 1440 - parsed_number;
		NPC_Msg(##Wait, 7);
	}

	WaitMovesSub(1);   
];


!------------------------------------------------------------------------------
[ NPC_WaitForSub i;
	if (~~(noun ofclass NPC_Engine))
		return(NPC_Msg(##Wait, 8));

	if (ScopeCeiling(noun) == location)
		return(NPC_Msg(##Wait, 9, noun));

	NPC_Msg(##Wait, 3);

	do
	{
		give tw_waiting ~on;
		
		for (i = 30: i > 0 && tw_waiting hasnt on && ~~(ScopeCeiling(noun) == location): i--)
		{
			InformLibrary.End_Turn_Sequence();

			DisplayStatus();
			DrawStatusLine();
		}
	
		if (ScopeCeiling(noun) == location)
			return(NPC_Msg(##Wait, 10, noun));

		if (tw_waiting hasnt on)
			NPC_Msg(##Wait, 11, noun);

		NPC_Msg(##Wait, 4);
	} until (~~YesOrNo());

	return(NPC_Msg(##Wait, 12));
];
	

!-------------------------------------------------------------------------------
!
!	ParseTime takes data from the next words (using wn) and returns a
!	the_time format time number, or -1 for unrecognisable. It can recognise
!	time expressed in any of the following formats:
!
!	a.	<"0"-"59">|<"one"-"twenty">|"half"|"quarter" ["minutes"|"minute"]
!		"past"|"to" <"1"-"12">|<"one"-"twelve"> ["am"|"pm"]
!	b.	<"1"-"12">|<"one"-"twelve"> ["o'clock"] ["am"|"pm"]
!	c.	<"1"-"12">|<"one"-"twelve"> <"0"-"59">|<"one"-"twenty"> ["am"|"pm"]
!	d.	<"1"-"12">":"<"0"-"59"> ["am"|"pm"]
!	e.	"midnight"|"midday"|"noon"
!
!	If no am/pm is specified, the next time likely to come up is chosen; that
!	is, the one that's just ahead of the current time. However, if this
!	happens, the tw_waiting object is given the 'general' attribute. Thus you
!	can change the time returned by twelve hours in an action like SetClock
!	if necessary.
!
!	The next dictionary command is there to allow us to compare a typed
!	string with "o'clock", something we can't normally do as it is bounded by
!	single quotes.
!
!-------------------------------------------------------------------------------

constant tw_oclock 'o^clock';

[ ParseTime i j k flg loop dig hr mn;
	give tw_waiting ~general;
	i=NextWord();

	if (i=='midday' or 'noon' or 'midnight')           ! then case (e) applies
	{
		if (i=='midnight')
			hr=0;
		else
			hr=12;
		mn=0;
		parsed_number = (hr*60+mn);
	}
	else
	{
		k = (wn-1)*4+1;                                    ! test for case (d)
		j = parse->k;
		j = j+buffer;
		k = parse->(k-1);
		flg = 0;
		
		for (loop = 0: loop < k: loop++)
		{
			dig = j->loop;
			
			if (dig==':')
				flg=1;
		}

		if ((k>2) && (k<6) && (flg==1))                      ! then case (d) applies
		{
			hr = 0;
			mn = 0;
			loop = 0;

			.tw_diglph;
			dig = j->loop;
			loop++;
			if (dig~=':')
				hr=hr*10;
			if (dig == '0') { hr=hr+0; jump tw_diglph; }
			if (dig == '1') { hr=hr+1; jump tw_diglph; }
			if (dig == '2') { hr=hr+2; jump tw_diglph; }
			if (dig == '3') { hr=hr+3; jump tw_diglph; }
			if (dig == '4') { hr=hr+4; jump tw_diglph; }
			if (dig == '5') { hr=hr+5; jump tw_diglph; }
			if (dig == '6') { hr=hr+6; jump tw_diglph; }
			if (dig == '7') { hr=hr+7; jump tw_diglph; }
			if (dig == '8') { hr=hr+8; jump tw_diglph; }
			if (dig == '9') { hr=hr+9; jump tw_diglph; }
			if (dig ~= ':') return -1;

			while (loop<k)
			{
				dig = j->loop;
				mn = mn*10;
				if (dig == '0') { mn=mn+0; jump tw_digokm; }
				if (dig == '1') { mn=mn+1; jump tw_digokm; }
				if (dig == '2') { mn=mn+2; jump tw_digokm; }
				if (dig == '3') { mn=mn+3; jump tw_digokm; }
				if (dig == '4') { mn=mn+4; jump tw_digokm; }
				if (dig == '5') { mn=mn+5; jump tw_digokm; }
				if (dig == '6') { mn=mn+6; jump tw_digokm; }
				if (dig == '7') { mn=mn+7; jump tw_digokm; }
				if (dig == '8') { mn=mn+8; jump tw_digokm; }
				if (dig == '9') { mn=mn+9; jump tw_digokm; }
				return -1;
				.tw_digokm;
				loop++;
			}                                            ! decode digital time
		}
		else
		{
			j = NextWordStopped();
			if ((j==tw_oclock or -1) || (j=='am' or 'pm'))   ! then case (c) applies
			{
				hr = TryNumber(wn-2);
				mn = 0;
				if (j~=tw_oclock)
					wn--;
			}
			else
			{
				k = TryNumber(wn-1);
				if (k ~= -1000)                                ! then case (b) applies
				{
					mn = k;
					hr = TryNumber(wn-2);
				}
				else                                         ! well, must be case (a)
				{
					mn=TryNumber(wn-2);
					if (i == 'quarter')
						mn = 15;
					if (i == 'twenty-five')
						mn = 25;
					if (i == 'half' or 'thirty')
						mn = 30;
					if (j == 'minute' or 'minutes')
						j = NextWord();                            ! ignore 'minutes'
					hr = TryNumber(wn);
					wn++;
					if (j ~= 'past' or 'to')
						hr = -1;
					if (j=='to')
					{
						hr--;
						mn = 60-mn;
						if (hr == 0)
					    	hr=12;
					}
				}
			}
		}

		if ((hr > 12) || (hr < 1) || (mn > 59) || (mn < 0))
			parsed_number = -1;
		else
		{
			if (hr==12)                                    ! now sort out am/pm
				hr=0;
			
			i = NextWord();
			
			if (i == 'pm')
				hr=hr+12;
			else if (i ~= 'am')                                 ! am or pm implied, then?
			{
				give tw_waiting general;
				wn--;
				i = (hr*60+mn);
				j = ((hr+12)*60+mn);
				i = i-the_time;
				j = j-the_time;
				
				if (i < 0)
					i = i + (24*60);
				
				if (j < 0)
					j = j + (24*60);
				
				if (i > j)
					hr = hr+12;
			}
			parsed_number=(hr*60+mn);
		}
	}

	if (parsed_number==-1)
		return -1;
	else
		return 1;
];


!-------------------------------------------------------------------------------
	
extend 'wait'
	* 'until' parsetime				-> WaitUntil
	* 'til' parsetime				-> WaitUntil
	* 'till' parsetime				-> WaitUntil
	* 'for' scope = NPC_Scope		-> NPC_WaitFor
	* 'for' number 'minute'			-> WaitMoves
	* 'for' number 'minutes'		-> WaitMoves
	* number 'minute'				-> WaitMoves
	* number 'minutes'				-> WaitMoves
	* 'for' number 'hour'			-> WaitHours
	* 'for' number 'hours'			-> WaitHours
	* number 'hour'					-> WaitHours
	* number 'hours'				-> WaitHours
	* number						-> WaitMoves
	* parsetime						-> WaitUntil;


