//===========================================================================
// Copyright  1998 Thin Air Enterprises and Robert Dunn
//===========================================================================
//---------------------------------------------------------------------------
// class TIRichEditOle - adds basic OLE functionality to TRichEdit.
// Based on code found at http://www.dystopia.fi/~janij/techinfo/richedit.htm
// and presumably written by Jani Jrvinen.  Thanks, Jani.
//
// Additional code developed through examination of Borland's VCL library,
// Microsoft's MFC source code, and sample code available on Microsoft's
// developer web site.
//
// Note that this code is very experimental -- the author admits to only a
// vague familiarity with OLE and accepts no criticism of the code.  Many,
// if not most, of the interfaces return failure codes arbitrarily chosen by
// the author with no particular reason to think that the values are correct.
// In particular, no great effort has been expended looking for "memory
// leaks," and these are considered quite probable.  You have been warned.
//---------------------------------------------------------------------------
#ifndef RichEditOLEH
#define RichEditOLEH

#include <vcl\comctrls.hpp>
#include <vcl\comobj.hpp>
#include <vcl\ole2.hpp>
#include <vcl\oledlg.hpp>
#include <richole.h>
#include "richeditolecallback.h"
//---------------------------------------------------------------------------
class TIRichEditOle
{
protected:
	TRichEdit* FRichEdit;
	IRichEditOle* FIRichEditOle;
	TIRichEditOleCallback* FIRichEditCallback;

	LONG GetObjectCount(void);
	LONG GetLinkCount(void);

	UINT CFObjectDescriptor;
	UINT CFEmbeddedObject;
	UINT CFLinkSource;
	UINT CFRtf;
	UINT CFRtfNoObjs;
	UINT CFReTextObjs;

public:
	TIRichEditOle(TRichEdit* richedit);
	~TIRichEditOle(void);
	void SetHostNames(AnsiString hostApp, AnsiString hostDoc);
	bool InsertPicture(Graphics::TBitmap *bitmap);
	bool PasteSpecial(void);
	bool CloseActiveObjects(bool savePrompt);

	LPOLECLIENTSITE GetClientSite(void);

	__property LONG ObjectCount = { read = GetObjectCount };
	__property LONG LinkCount = { read = GetLinkCount };
};
#endif
//===========================================================================
// Copyright  1998 Thin Air Enterprises and Robert Dunn
//===========================================================================

