//---------------------------------------------------------------------------
#include <vcl.h>

#pragma hdrstop

#include "globals.h"

//---------------------------------------------------------------------------

#pragma package(smart_init)

String restore_string(int size,TStream *stream)
{
String result="";
char buffer;
for (int i=0;i<size;i++){
  stream->Read(&buffer,1);
  result+=buffer;};
return(result);
};
//---------------------------------------------------------------------------

unsigned int restore_long(TStream *stream)
{                                      
unsigned int result=0;
unsigned char buffer;
for (int i=0;i<3;i++){
  stream->Read(&buffer,1);
  result+=buffer;
  result<<=8;};
stream->Read(&buffer,1);
result+=buffer;
return(result);
};
//----------------------------------------------------------------------------
bool seek_chunk(String text,int boundary,TStream *stream)
{
stream->Seek(12,soFromBeginning);
while(restore_string(4,stream)!=text){
  unsigned int chunk_length=restore_long(stream);
  stream->Position=stream->Position+chunk_length;
  stream->Position=stream->Position+(stream->Position%2);
  if (stream->Position>=boundary)
    return(false);};
return(true);
};
//----------------------------------------------------------------------------
unsigned short restore_short(TStream *stream)
{
unsigned short result=0;
unsigned char buffer;
stream->Read(&buffer,1);
result+=buffer;
result<<=8;
stream->Read(&buffer,1);
result+=buffer;
return(result);
};
//----------------------------------------------------------------------------
void save_string(String text,TMemoryStream *stream)
{
char *buffer;
buffer=new char[text.Length()];
strcpy(buffer,text.c_str());
for (int i=0;i<text.Length();i++)
  stream->Write(&buffer[i],1);
};
//----------------------------------------------------------------------------
void save_long(unsigned int num,TMemoryStream *stream)
{
unsigned char buffer;
for (int i=24;i>=0;i-=8){
  buffer=num>>i;
  stream->Write(&buffer,1);};
};
//----------------------------------------------------------------------------
void save_short(unsigned short num,TMemoryStream *stream)
{
unsigned char buffer;
for (int i=8;i>=0;i-=8){
  buffer=num>>i;
  stream->Write(&buffer,1);};
};
//----------------------------------------------------------------------------
void save_24bit(unsigned int num,TMemoryStream *stream)
{
unsigned char buffer;
for (int i=16;i>=0;i-=8){
  buffer=num>>i;
  stream->Write(&buffer,1);};
};
//------------------------------------------------------------------\----------
void save_char(unsigned char num,TMemoryStream *stream)
{
stream->Write(&num,1);
};
//----------------------------------------------------------------------------
unsigned int restore_24bit(TStream *stream)
{
unsigned int result=0;
unsigned char buffer;
for (int i=0;i<2;i++){
  stream->Read(&buffer,1);
  result+=buffer;
  result<<=8;};
stream->Read(&buffer,1);
result+=buffer;
return(result);
};
//----------------------------------------------------------------------------
unsigned char restore_char(TStream *stream)
{
unsigned char result;
stream->Read(&result,1);
return(result);
};
//----------------------------------------------------------------------------

int find_resource(int rsc_type,int id,TStream *stream)
{
String rsc="";
switch (rsc_type){
  case PICT:
    rsc="Pict";
    break;
  case SND:
    rsc="Snd ";
    break;
  case EXEC:
    rsc="Exec";
    break;
  default:
    return (NULL);};

seek_chunk("RIdx",stream->Size,stream);
stream->Position+=4;
unsigned int rsc_count=restore_long(stream);
for (int i=0;i<rsc_count;i++){
  if (restore_string(4,stream)!=rsc){
    stream->Position+=8;
    continue;};
  unsigned int rsc_num=restore_long(stream);
  if (rsc_num==id){
    stream->Position=restore_long(stream);
    break;};
  stream->Position+=4;};
String type=restore_string(4,stream);
type=type.Trim();
if (type=="FORM")
  return (FORM);
if (type=="MOD")
  return (MOD_MUSIC);
if (type=="OGGV")
  return (OGGV);
stream->Position+=4;
if (type=="JPEG")
  return (JPEG);
if (type=="PNG")
  return (PNG);
return (NULL);
};
//----------------------------------------------------------------------------

