/* jump.c
 *
 *  foblub -- a Z-machine for TI calculators
 *  based on pinfocom by InfoTaskForce and Paul Smith
 *  Ported and extended by Nils Gesbert, 2003
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; see the file COPYING.  If not, write to the
 *  Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include    "infocom.h"

#ifndef VERSION_QUATRE
inline
#endif
void gosub A2(word, num, const word *, param)
{
#ifdef DEBUG3
  if (tracing) {
    char buf[25 + 7 * num];
    int offs = sprintf (buf, "gosub : %lX (", ((long) param[0]) << (STANDARD ? 1 : 2));
    unsigned int i;
    for (i = 1; i < num; i++)
      offs += sprintf (buf + offs, "%hd, ", param[i]);
    if (i > 1) offs -= 2;
    buf[offs++] = ')';
    buf[offs] = 0;
    scr_putline (buf);
  }
#endif
    /*
     * The first param is the address to gosub to
     */
    if (param[0] == 0)
        store(param[0]);
    else
    {
        const word *pp;
        byte vars;

        *(--stack) = pc_page;
        *(--stack) = pc_offset;

        /* Push offset of old stack_var_ptr from stack_base onto stack */

        *(--stack) = stack_base - stack_var_ptr;

	pc_page = 0;
	pc_offset = ((long) param[0]) << (STANDARD ? 1 : 2); /* x 2 et mod. 4096 */
        fix_pc();

        /*
            The value of the current stack pointer is the
            new value of stack_var_ptr.
        */

        stack_var_ptr = stack;

        /*
         * Global variables 1 to 15 are Local variables, which
         * reside on the stack (and so are local to each procedure).
         *
         * Get number of local variables to push onto the stack.
         * param[1] through param[num-1], if defined, are the first
         * local variables. There are also bytes reserved after the
         * gosub opcode in the calling procedure to initialise all
         * local variables - including the first 3 local variables
         * (and so are ignored).
         */
        NEXT_BYTE(vars);

        for (--num, pp=&param[1]; (num > 0) && (vars > 0); ++pp, --num, --vars)
        {
            if (!ADVANCED) next_word();
            *(--stack) = *pp;
        }

        while (vars-- > 0)
            *(--stack) = ADVANCED ? 0 : next_word();
    }
}

void
rtn A1(word, value)
{
    stack = stack_var_ptr;
    stack_var_ptr = stack_base - *stack++;
    pc_offset = *stack++;
    pc_page = *stack++;
    fix_pc();

#ifdef DEBUG3
    if (tracing) {
      char buf[50];
      sprintf (buf, "rtn (%hd) -> %lX", value, ((long)pc_page) * BLOCK_SIZE + pc_offset);
      scr_putline (buf);
    }
#endif

    store(value);
}

inline void
jump A1(word, offset)
{
    pc_offset += ((signed) offset) - 2;
    fix_pc();
}

inline void
rts()
{
    rtn(*stack++);
}

inline void
pop_stack()
{
    ++stack;
}
