/*
Macros.cpp: the macros dialog.

Copyright (C) 2005 Fabio Concas
Copyright (C) 2007 Vladimir Korablin

You can redistribute this file and/or modify it under the terms
of version 2 of the GNU General Public License as published by
the Free Software Foundation.  You should have received a copy
of the license along with this file; see the file GPL.txt.

This file is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
license for more details.
*/

#include "Zroft.h"

//****************************************************************************
//		DlgMacros
//	Dialog Box event handling procedure
//****************************************************************************
LRESULT CALLBACK DlgMacros (HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
    SHINITDLGINFO shidi;

    switch (message)
    {	
    case WM_DESTROY:
        Application.GoFullScreen ();
        break;

    case WM_INITDIALOG:
        shidi.dwMask = SHIDIM_FLAGS;
        shidi.dwFlags = SHIDIF_SIZEDLGFULLSCREEN;
        shidi.hDlg = hDlg;
        SHInitDialog (&shidi);
        // Add macros to the listbox
        {
            HWND hNameList = GetDlgItem (hDlg, IDC_MACROLIST);
            HWND hActionList = GetDlgItem (hDlg, IDC_ACTIONLIST);
            HWND hNLList = GetDlgItem (hDlg, IDC_NL_LIST);

            for (unsigned int Cnt = 0; Cnt < MAX_MACROS; ++Cnt)
                if (Application.Macros[Cnt].isDefined)
                {
                    TCHAR wNLStyle[2];
                    switch (Application.Macros[Cnt].nlStyle)
                    {
                    case 2:
                        wcscpy (wNLStyle, L"2");
                        break;
                    case 1:
                        wcscpy (wNLStyle, L"1");
                        break;
                    case 0:
                    default:
                        wcscpy (wNLStyle, L"0");
                        break;
                    }

                    SendMessage (hNameList, LB_ADDSTRING, 0,
                        (LPARAM)Application.Macros[Cnt].wName);
                    SendMessage (hActionList, LB_ADDSTRING, 0,
                        (LPARAM)Application.Macros[Cnt].wAction);
                    SendMessage (hNLList, LB_ADDSTRING, 0,
                        (LPARAM)wNLStyle);
                }
        }
        return TRUE;

    case WM_COMMAND:
        switch (LOWORD(wParam))
        {
        case IDC_MACROLIST:		// A macro is selected from the list
            {
                HWND hNameList = GetDlgItem (hDlg, IDC_MACROLIST);
                HWND hActionList = GetDlgItem (hDlg, IDC_ACTIONLIST);
                HWND hNLList = GetDlgItem (hDlg, IDC_NL_LIST);
                HWND hNoNL = GetDlgItem (hDlg, IDC_NL_NONL);
                HWND hImmNL = GetDlgItem (hDlg, IDC_NL_IMMEDIATE);
                HWND hAftNL = GetDlgItem (hDlg, IDC_NL_AFTER);

                // Get currently selected item index
                short CurSel = (short)SendMessage (hNameList, LB_GETCURSEL, 0, 0);
                if (CurSel != LB_ERR)
                {
                    wchar_t wBuffer[32];

                    SendMessage (hNameList, LB_GETTEXT, (WPARAM)CurSel,
                        (LPARAM)wBuffer);
                    SetDlgItemTextW(hDlg, IDC_MACRONAME, wBuffer);

                    SendMessage (hActionList, LB_GETTEXT, (WPARAM)CurSel,
                        (LPARAM)wBuffer);
                    SetDlgItemTextW(hDlg, IDC_MACROACTION, wBuffer);

                    SendMessage (hNLList, LB_GETTEXT, (WPARAM)CurSel,
                        (LPARAM)wBuffer);
                    switch (wBuffer[0])
                    {
                    case _T('2'):
                        SendMessage (hAftNL, BM_SETCHECK, (WPARAM)BST_CHECKED, 0);
                        SendMessage (hImmNL, BM_SETCHECK, (WPARAM)BST_UNCHECKED, 0);
                        SendMessage (hNoNL, BM_SETCHECK, (WPARAM)BST_UNCHECKED, 0);
                        break;
                    case _T('1'):
                        SendMessage (hAftNL, BM_SETCHECK, (WPARAM)BST_UNCHECKED, 0);
                        SendMessage (hImmNL, BM_SETCHECK, (WPARAM)BST_CHECKED, 0);
                        SendMessage (hNoNL, BM_SETCHECK, (WPARAM)BST_UNCHECKED, 0);
                        break;
                    case _T('0'):
                    default:
                        SendMessage (hAftNL, BM_SETCHECK, (WPARAM)BST_UNCHECKED, 0);
                        SendMessage (hImmNL, BM_SETCHECK, (WPARAM)BST_UNCHECKED, 0);
                        SendMessage (hNoNL, BM_SETCHECK, (WPARAM)BST_CHECKED, 0);
                        break;
                    }
                }
            }
            break;

        case ID_MACRODELETE:
            {
                HWND hNameList = GetDlgItem (hDlg, IDC_MACROLIST);
                HWND hActionList = GetDlgItem (hDlg, IDC_ACTIONLIST);
                HWND hNLList = GetDlgItem (hDlg, IDC_NL_LIST);

                short CurSel = (short)SendMessage (hNameList, LB_GETCURSEL, 0, 0);
                if (CurSel != LB_ERR)
                {
                    // Delete currently selected item from all lists
                    SendMessage (hNameList, LB_DELETESTRING, CurSel, 0);
                    SendMessage (hActionList, LB_DELETESTRING, CurSel, 0);
                    SendMessage (hNLList, LB_DELETESTRING, CurSel, 0);
                }
                else
                    MessageBeep (MB_ICONSTOP);
            }
            break;

        case ID_MACROADD:
            {
                HWND hNameList = GetDlgItem (hDlg, IDC_MACROLIST);
                HWND hActionList = GetDlgItem (hDlg, IDC_ACTIONLIST);
                HWND hNLList = GetDlgItem (hDlg, IDC_NL_LIST);
                HWND hImmNL = GetDlgItem (hDlg, IDC_NL_IMMEDIATE);
                HWND hAftNL = GetDlgItem (hDlg, IDC_NL_AFTER);

                // Check if there are already MAX_MACROS macros in the list
                if (LB_ERR != SendMessage (hNameList, LB_GETTEXTLEN, MAX_MACROS - 1, 0))
                    MessageBeep (MB_ICONSTOP);
                else
                {
                    wchar_t wName[32], wAction[32], wNLStyle[2];

                    // Check if a name AND an action have been specified
                    if (GetDlgItemTextW(hDlg, IDC_MACRONAME, wName, 32) > 0
                        &&
                        GetDlgItemTextW(hDlg, IDC_MACROACTION, wAction, 32) > 0)
                    {
                        // All ok, add macro to the lists
                        SendMessage (hNameList, LB_ADDSTRING, 0, (LPARAM)wName);
                        SendMessage (hActionList, LB_ADDSTRING, 0, (LPARAM)wAction);
                        // See which radio button is checked
                        if (SendMessage (hAftNL, BM_GETCHECK, 0, 0) == BST_CHECKED)
                            wcscpy (wNLStyle, L"2");
                        else if (SendMessage (hImmNL, BM_GETCHECK, 0, 0) == BST_CHECKED)
                            wcscpy (wNLStyle, L"1");
                        else
                            wcscpy (wNLStyle, L"0");
                        SendMessage (hNLList, LB_ADDSTRING, 0, (LPARAM)wNLStyle);
                    }
                    else
                        MessageBeep (MB_ICONSTOP);
                }
            }
            break;

        case ID_CANCEL:
            // Quit without updating macros
            EndDialog (hDlg, LOWORD(wParam));
            return TRUE;

        case IDOK:
            // Update Macros
            {
                HWND hNameList = GetDlgItem (hDlg, IDC_MACROLIST);
                HWND hActionList = GetDlgItem (hDlg, IDC_ACTIONLIST);
                HWND hNLList = GetDlgItem (hDlg, IDC_NL_LIST);
                wchar_t wBuffer[32];
                long Ret;

                if (hNameList && hActionList)
                    for (wchar_t Cnt = 0; Cnt < MAX_MACROS; ++Cnt)
                    {
                        // Get text of next item in the names list
                        wBuffer[0] = (wchar_t)0;
                        Ret = SendMessage (hNameList, LB_GETTEXT, (WPARAM)Cnt,
                            (LPARAM)wBuffer);
                        if (Ret == LB_ERR)
                        {
                            // There's no item with that index, so make this macro undefined
                            Application.Macros[Cnt].isDefined = false;
                            Application.Macros[Cnt].wName[0] = (wchar_t)0;
                            Application.Macros[Cnt].nlStyle = 0;
                        }
                        else
                        {
                            // All ok, write macro data
                            Application.Macros[Cnt].isDefined = true;
                            wcscpy (Application.Macros[Cnt].wName, wBuffer);
                            SendMessage (hActionList, LB_GETTEXT, (WPARAM)Cnt,
                                (LPARAM)wBuffer);
                            wcscpy (Application.Macros[Cnt].wAction, wBuffer);
                            SendMessage (hNLList, LB_GETTEXT, (WPARAM)Cnt,
                                (LPARAM)wBuffer);
                            switch (wBuffer[0])
                            {
                            case _T('2'):
                                Application.Macros[Cnt].nlStyle = 2;
                                break;
                            case _T('1'):
                                Application.Macros[Cnt].nlStyle = 1;
                                break;
                            case _T('0'):
                            default:
                                Application.Macros[Cnt].nlStyle = 0;
                                break;
                            }
                        }
                    }

                    Application.UpdateMacros ();
            }

            EndDialog (hDlg, LOWORD(wParam));
            return TRUE;
        }
        break;
    }
    return FALSE;
}

