/*
Utils.cpp: utilities.
Copyright (C) 2007 Vladimir Korablin

You can redistribute this file and/or modify it under the terms
of version 2 of the GNU General Public License as published by
the Free Software Foundation.  You should have received a copy
of the license along with this file; see the file GPL.txt.

This file is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
license for more details.
*/

#include <Windows.h>
#include <string>
#include <algorithm>
#include <assert.h>

HANDLE Util_OpenFile(LPCTSTR filename, DWORD accessMode, DWORD ifExists)
{
    return CreateFile(filename, 
        accessMode,  // Access mode
        0, // Share mode (no sharing)
        0, // ignored
        ifExists, // if exists
        FILE_ATTRIBUTE_NORMAL | FILE_FLAG_RANDOM_ACCESS,
        0); // ignored
}

BOOL Util_WriteBufferToFile(HANDLE hFile,
               LPCVOID lpBuffer,
               DWORD nNumberOfBytesToWrite)
{
    DWORD written = 1;
    DWORD total = 0;
    while(total < nNumberOfBytesToWrite) {
        if(!WriteFile(hFile, (char*)lpBuffer + total, nNumberOfBytesToWrite - total, &written, 0)) {
            return FALSE;
        }
        total += written;
    }
    return TRUE;
}

void ReportError(wchar_t *message)
{
    //wchar_t buffer[4048];
    //mbstowcs(buffer, message, 4048);
    MessageBox(NULL, message, L"Error", MB_OK | MB_ICONEXCLAMATION);
}

void ReportErrorEx(wchar_t *message, char *sourceFile, int lineno)
{
    wchar_t wSourceFile[128];
    mbstowcs(wSourceFile, sourceFile, 128);
    wchar_t formatted[1024];
    wsprintf(formatted, L"%s\n\n%s:%i", message, wSourceFile, lineno);
    ReportError(formatted);
}

bool pred(char c1, char c2)
{
    if(c1 == ' ' && c1 == c2) {
        return true;
    } else {
        return false;
    }
}

// Normalize the given string -- replace newlines with spaces
// and space runs with single spaces.
void Util_NormalizeString(std::wstring& s)
{
    std::replace(s.begin(), s.end(), L'\n', L' ');
    std::replace(s.begin(), s.end(), L'\r', L' ');
    std::replace(s.begin(), s.end(), L'\t', L' ');
    // Replace every run of spaces with exactly one space
    std::wstring::iterator newend = std::unique(s.begin(), s.end(), pred);
    // And finalize
    s.erase(newend, s.end());
}

///
/// Replace all occurences of a substring in a string with another
/// string, in-place.
///
/// @param s String to replace in. Will be modified.
/// @param sub Substring to replace.
/// @param other String to replace substring with.
///
/// @return The string after replacements.
std::string&
Util_ReplaceSubstring(std::string& s,
          const std::string& sub,
          const std::string& other)
{
    assert(!sub.empty());
    size_t b = 0;
    for (;;) {
        b = s.find(sub, b);
        if (b == s.npos) break;
        s.replace(b, sub.size(), other);
        b += other.size();
    }
    return s;
}
