#include "giz.ipp"


[zo_init;
    readw(zo_tree, $0a);

    if (z_ver < 4)
    {
        zo_len = 9;
        zo_zero = zo_tree + 62 - zo_len;
        zo_parent = 4;
        zo_sibling = 5;
        zo_child = 6;
        zo_prop_tbl = 7;
        zo_prop_num_mask = $1f;
        zo_prop_size-->1 = 1;
    }
    else
    {
        zo_len = 14;
        zo_zero = zo_tree + 126 - zo_len;
        zo_parent = 6;
        zo_sibling = 8;
        zo_child = 10;
        zo_prop_tbl = 12;
        zo_prop_num_mask = $3f;
    }
];

[zo_get_relative num relative loc res foo;
    if (num)
    {
        loc = zo_zero + (zo_len * num) + relative;
        if (z_ver < 4)
        {             
            readb(res, loc);
        }
        else
        {
            readw(res, loc);
        }
/*  !       if (foo) print res, "^"; */
        return res;
    }
    else
    {
        zio_alert("Attempt to reference object 0.");
    }
];

[zo_set_relative num relative res loc;
    if (num)
    {
        loc = zo_zero + (zo_len * num) + relative;
        if (z_ver < 4)
        {
            writeb(loc, res);
        }
        else
        {
            writew(loc, res);
        }
    }
    else
    {
        zio_alert("Attempt to reference object 0.");
    }
];

/* !! returns the starting address of the first prop for this obj */
[zo_get_first_property obj_num prop_addr size;
    /* !! 1: find the prop table */
    prop_addr = zo_zero + (zo_len * obj_num) + zo_prop_tbl;
    readw(prop_addr, prop_addr);

    /* !! 2: skip short name */
    readb(size, prop_addr);
    return prop_addr + (2 * size) + 1;
];

[zo_get_property_size prop_addr size_byte;

    readb(size_byte, prop_addr);
    
    if (z_ver < 4)
    {
        @ushiftr size_byte 5 size_byte;
        zo_prop_size-->0 = size_byte + 1;
    }
    else
    {
        if (size_byte & $$10000000)
        {
            prop_addr++;
            readb(size_byte, prop_addr);
            size_byte = (size_byte & $$00111111);
            if (size_byte == 0)
                zo_prop_size-->0 = 64;
            else
                zo_prop_size-->0 = size_byte;
            zo_prop_size-->1 = 2;
        }
        else
        {
            zo_prop_size-->1 = 1;
            if (size_byte & $$01000000)
                zo_prop_size-->0 = 2;
            else
                zo_prop_size-->0 = 1;
        }
    }
];
            

[zo_get_property_data obj_num prop_num reference prop_addr cur_num size;

    prop_addr = zo_get_first_property(obj_num);

   /*  !! find the number of this (the first) property */
    readb(size, prop_addr);
    cur_num = size & zo_prop_num_mask;

   /*  !! loop over properties until we find the one we're looking for, */
/*     !! or a size of 0 */
    while (cur_num ~= prop_num && cur_num ~= 0)
    {
        zo_get_property_size(prop_addr);
        prop_addr = prop_addr + (zo_prop_size-->0) + (zo_prop_size-->1);
        
        /* !! find the number of the new property */
        readb(size, prop_addr);
        cur_num = size & zo_prop_num_mask;
    }

    /* !! we've found the right property (or the obj does not have it). */
/*     !! If it does exist, are we looking for an address or data? */
    if (cur_num)
    {
        if (reference)
        {
            /* !! Just find the number of size bytes and return the address */
/*             !! plus that */
            if (z_ver < 4)
            {
                return prop_addr + 1;
            }
            else
            {
                if (size & $$10000000)
                    return prop_addr + 2;
                else
                    return prop_addr + 1;
            }
        }
        else
        {
            /* !! We want the data, so we need to know its length */
            zo_get_property_size(prop_addr);
            
            /* !! Return the data */
            prop_addr = prop_addr + zo_prop_size-->1;
            
            if (zo_prop_size-->0 == 1)
            {
                readb(size, prop_addr);
            }
            else
            {
                readw(size, prop_addr);
            }

            return size;
        }
    }
    else
    {
/*         !! The property does not exist for the specified object. */
/*         !! If we are looking for an address, then return 0, otherwise */
/*         !! look up the property default */
        if (reference)
        {
            return 0;
        }
        else
        {
            size = zo_tree + 2 * (prop_num - 1);
            readw(size, size);
            return size;
        }
    }
];

[zo_set_property_data obj_num prop_num val prop_addr size cur_num;

    prop_addr = zo_get_first_property(obj_num);
    
/*     !! find the number of this (the first) property */
    readb(size, prop_addr);
    cur_num = size & zo_prop_num_mask;

/*     !! loop over properties until we find the one we're looking for, */
/*     !! or a num of 0 */
    while (cur_num ~= prop_num && cur_num ~= 0)
    {
        zo_get_property_size(prop_addr);
        prop_addr = prop_addr + (zo_prop_size-->0) + (zo_prop_size-->1);
        
/*         !! find the number of the new property */
        readb(size, prop_addr);
        cur_num = size & zo_prop_num_mask;
    }

    if (cur_num)
    {
        zo_get_property_size(prop_addr);
        prop_addr = prop_addr + zo_prop_size-->1;
        
        if (zo_prop_size-->0 == 1)
        {
            writeb(prop_addr, val);
        }
        else
        {
            writew(prop_addr, val);
        }
    }
    else
    {
        fatalError("Attempt to set the value of a non-existent property.");
    }
];

[zo_get_attribute obj_num att_num byte bit;
    byte = zmem + zo_zero + (zo_len * obj_num) + (att_num / 8);
    bit = 7 - (att_num % 8);
    @aloadbit byte bit bit;
    return bit;
];

[zo_set_attribute obj_num att_num val byte bit;
    byte = zmem + zo_zero + (zo_len * obj_num) + (att_num / 8);
    bit = 7 - (att_num % 8);
    @astorebit byte bit val;
];

[zo_get_name obj_num addr;
    addr = zo_zero + (zo_len * obj_num) + zo_prop_tbl;
    readw(addr, addr);
    return addr + 1;
];

[zo_remove obj_num parent sibling next;
    parent = zo_get_relative(obj_num, zo_parent);

    if (~~parent) return;

    sibling = zo_get_relative(parent, zo_child);
    if (sibling == obj_num)
    {
        zo_set_relative(parent, zo_child,
                        zo_get_relative(obj_num, zo_sibling));
    }
    else
    {
        next = zo_get_relative(sibling, zo_sibling);
        while (next ~= obj_num)
        {
            sibling = next;
            next = zo_get_relative(next, zo_sibling);
        }
        zo_set_relative(sibling, zo_sibling,
                        zo_get_relative(obj_num, zo_sibling));
    }

    zo_set_relative(obj_num, zo_parent, 0);
    zo_set_relative(obj_num, zo_sibling, 0);
];

[zo_insert obj_num dest_num;
    zo_remove(obj_num);
    zo_set_relative(obj_num, zo_parent, dest_num);
    zo_set_relative(obj_num, zo_sibling, zo_get_relative(dest_num, zo_child));
    zo_set_relative(dest_num, zo_child, obj_num);
];
