#include "giz.ipp"

Array operands --> 8;
Array operand_types --> 8;
Array funargs --> 16;
Array filename -> 256;
Array input_line -> 256;

/* !Array types -->5; */
/* !Array times0 -->32; */
/* !Array times1 -->32; */
/* !Array times2 -->32; */
/* !Array times3 -->32; */
/* !Array times4 -->32; */
/* !Global startup = 0; */
/* !Global short = 0; */


Global type;
Global op_code;
Global num_operands = 0;

Global startup;
Global readvart;


Constant ZERO_OP = 0;
Constant ONE_OP = 1;
Constant TWO_OP = 2;
Constant VAR_OP = 3;
Constant EXT_OP = 4;

Constant LC = 0;
Constant SC = 1;
Constant VAR = 2;
Constant NO = 3;


[unpack_string addr tmp;
    switch (z_ver)
    {
     1,2,3:
        return 2 * addr;
     4,5:
        return 4 * addr;
     6,7:
        readw(tmp, $2a);
        return 4 * addr + tmp;
     default:
        return 8 * addr;
    }
];

[unpack_routine addr tmp;
    switch (z_ver)
    {
     1,2,3:
        return 2 * addr;
     4,5:
        return 4 * addr;
     6,7:
        readw(tmp, $28);
        return 4 * addr + tmp;
     default:
        return 8 * addr;
    }
];

[fetch_var i nopop;
    if (i == 0)
    {
        if (nopop)
            return (zstack-->sp) & $0000ffff;
        else
            return (zstack-->--sp) & $0000ffff;
    }
    else if (i < $10)
    {
        return (zstack-->(fp + (i - 1))) & $0000ffff;
    }
    else
    {
        i = i - $10;
        @aloads zglobals i i;
        return i;
    }
];

[store_var i val nopush;
    if (i == 0)
    {
        if (nopush)
            zstack-->sp = val;
        else
            zstack-->sp++ = val;
    }
    else if (i < $10)
    {
        zstack-->(fp + (i - 1)) = val;
    }
    else
    {
        i = i - $10;
        @astores zglobals i val;
    }
];


[fetch_operand i v;
    switch (operand_types-->i)
    {
     VAR:
        v = operands-->i;
        
        if (v == 0)
            return (zstack-->--sp) & $0000ffff;
        else if (v < $10)
            return (zstack-->(fp + (v - 1))) & $0000ffff;
        else
        {
            v = v - $10;
            @aloads zglobals v v;
            return v;
        }
     LC, SC:
        return operands-->i;
     default:
        print "[type: ", type, "; op_code: ", (hex) op_code, "]^";
        print "[pc = ", pc, "; num_operands = ", num_operands, "]^";
        fatalError("Attempt to fetch non-existent operand.");
    }
];

[do_branch test byte1 byte2 offset;
    byte1 = zmem->(pc++);
    
    offset = byte1 & $$00111111;
    if (~~(byte1 & $$01000000))
    {
        byte2 = zmem->(pc++);
        @shiftl offset 8 offset;
        offset = offset | byte2;

/*         ! sign-extending a 14-bit number */
        if (byte1 & $$00100000)
            offset = offset | $$11111111111111111100000000000000;
    }

    if (((byte1 & $$10000000) == $$10000000) == test)
    {
        if (offset == 0)
            zstack_pop_frame(0, 0);
        else if (offset == 1)
            zstack_pop_frame(1, 0);
        else
            pc = pc + offset - 2;
    }
];


[execute op bit test branch store word len f s;
/*     !    print "[pc: ",pc,"]^"; */

/*     !! The decoding stage */
    op = zmem->pc++;

    if (op & $00000080)
    {
        if (op & $$01000000)
        {
/*             !! we have a variable form op */
            op_code = op & $$00011111;
            if (op & $$00100000)
                type = VAR_OP;
            else
                type = TWO_OP;
            
            read_var_operands(op_code, type);
        }
        else if (op == $be && z_ver >= 5)
        {
/*             !! we have an extended op */
            type = EXT_OP;
            op_code = zmem->(pc++);
            read_var_operands(op_code, type);
        }
        else
        {
/*             !! we have a short form op */
            op_code = op & $$00001111;

            @ushiftr op 4 bit;
            operand_types-->0 = bit & $$00000011;
            switch (operand_types-->0)
            {
             LC:
                type = ONE_OP;
                num_operands = 1;
                readw(word, pc);
                operands-->0 = word;
                pc = pc + 2;
             SC, VAR:
                type = ONE_OP;
                num_operands = 1;
                operands-->0 = zmem->(pc++);
             default:
                type = ZERO_OP;
                num_operands = 0;
            }
        }
    }
    else
    {
/*         !! we have a long form op */
        type = TWO_OP;
        op_code = op & $$00011111;
        num_operands = 2;

        if (op & $$01000000)
            operand_types-->0 = VAR;
        else
            operand_types-->0 = SC;

        if (op & $$00100000)
            operand_types-->1 = VAR;
        else
            operand_types-->1 = SC;

        operands-->0 = zmem->(pc++);
        operands-->1 = zmem->(pc++);
    }

/* !    print "[pc ", pc, "; op ",(hex) op_code,"; type ",(hex) type,"]^"; */
    
    
/*     !! execution stage */
    switch (type)
    {
     TWO_OP:
        switch (op_code)
        {
         $01: /* !! je a b ?(label) */
            switch (num_operands)
            {
             2: do_branch(fetch_operand(0) == fetch_operand(1));
             1: do_branch(0);
             default:
                bit = fetch_operand(0);
                test = 0;
                
                for (branch = 1 : branch < num_operands : branch++)
                {
                    store = fetch_operand(branch);
                    
                    if (bit == store)
                        test = 1;
                }
            
                do_branch(test);
            }
            
         $02: /* !! jl a b ?(label) */
/* !            Fetch_operand(bit, 0); */
/* !            Fetch_operand(store, 1); */
            
            bit = fetch_operand(0);
            @sexs bit bit;
            store = fetch_operand(1);
            @sexs store store;
            do_branch(bit < store);
         $03: /* !! jg */
/* !            Fetch_operand(bit, 0); */
/* !            Fetch_operand(store, 1); */
            bit = fetch_operand(0);
            @sexs bit bit;
            store = fetch_operand(1);
            @sexs store store;
            do_branch(bit > store);
         $04: /* !! dec_chk (variable) value ?(label) */
            bit = fetch_var(operands-->0, true);
            @sexs bit bit;
            bit--;
            store = fetch_operand(1);
            @sexs store store;
            
            store_var(operands-->0, bit, true);
            do_branch(bit < store);
         $05: /* !! inc_chk */
            bit = fetch_var(operands-->0, true);
            @sexs bit bit;
            bit++;
            store = fetch_operand(1);
            @sexs store store;
            
            store_var(operands-->0, bit, true);
            do_branch(bit > store);
         $06: /* !! jin obj1 obj2 ?(label) */
            bit = fetch_operand(0);
            
            test = (zo_get_relative(bit, zo_parent) == fetch_operand(1));
            do_branch(test);
         $07: /* !! test bitmap flags ?(label) */
            store = fetch_operand(0);
            bit = fetch_operand(1);
            do_branch((store & bit) == bit);
         $08: /* !! or a b -> (result) */
            store_var(zmem->(pc++), (fetch_operand(0) |
                                     fetch_operand(1)));
         $09: /* !! and a b -> (result) */
            store_var(zmem->(pc++), (fetch_operand(0) &
                                     fetch_operand(1)));
         $0a: /* !! test_attr object attribute ?(label) */
            bit = fetch_operand(0);
            store = fetch_operand(1);
            test = zo_get_attribute(bit, store);
            do_branch(test);
         $0b: /* !! set_attr object attribute */
            bit = fetch_operand(0);
            zo_set_attribute(bit, fetch_operand(1), 1);
         $0c: /* !! clear_attr */
            bit = fetch_operand(0);
            zo_set_attribute(bit, fetch_operand(1), 0);
         $0d: /* !! store (varible) value */
            store_var(operands-->0, fetch_operand(1), true);
         $0e:/*  !! insert_obj object destination */
            store = fetch_operand(0);
            bit = fetch_operand(1);
            zo_insert(store, bit);
                
         $0f: /* !! loadw array word-index -> (result) */
            bit = fetch_operand(0);
            store = bit + (2 * fetch_operand(1));
            readw(word, store);
            store_var(zmem->(pc++), word);
         $10: /* !! loadb */
            bit = fetch_operand(0);
            store = fetch_operand(1);
            store_var(zmem->(pc++), zmem->(bit + store));
         $11: /* !! get_prop object property -> (result) */
            bit = fetch_operand(0);
            store = fetch_operand(1);
            store_var(zmem->(pc++), zo_get_property_data(bit, store, 0));
         $12: /* !! get_prop_addr */
            bit = fetch_operand(0);
            store = fetch_operand(1);

            store_var(zmem->pc++,
                      zo_get_property_data(bit, store, 1));

         $13: /* !! get_next_prop object property -> (result) */
            bit = zo_get_first_property(fetch_operand(0));
            store = fetch_operand(1);
            word = zmem->bit & zo_prop_num_mask;

            if (store == 0)
            {
                store_var(zmem->(pc++), word);
            }
            else
            {
                branch = -1;
                while (branch ~= store && word ~= 0)
                {
                    branch = word;
                    zo_get_property_size(bit);
                    bit = bit + zo_prop_size-->0 + zo_prop_size-->1;
                    word = zmem->bit & zo_prop_num_mask;
                }
                store_var(zmem->(pc++), word);
            }
         $14: /* !! add a b -> (result) */
            bit = fetch_operand(0);
            store = fetch_operand(1);
/* !            Fetch_operand(bit, 0); */
/* !            Fetch_operand(store, 1); */
            
            @sexs bit bit;
            @sexs store store;
            store_var(zmem->(pc++), bit + store);
         $15: /* !! sub */
            bit = fetch_operand(0);
            store = fetch_operand(1);
/* !            Fetch_operand(bit, 0); */
/* !            Fetch_operand(store, 1); */

            @sexs bit bit;
            @sexs store store;
            store_var(zmem->(pc++), bit - store);
         $16: /* !! mul */
            bit = fetch_operand(0);
            store = fetch_operand(1);

/* !            Fetch_operand(bit, 0); */
/* !            Fetch_operand(store, 1); */
            @sexs bit bit;
            @sexs store store;
            store_var(zmem->(pc++), bit * store);
         $17: /* !! div */
            bit = fetch_operand(0);
            store = fetch_operand(1);

/* !            Fetch_operand(bit, 0); */
/* !            Fetch_operand(store, 1); */
            @sexs bit bit;
            @sexs store store;
            if (store ~= 0)
                store_var(zmem->(pc++), bit / store);
            else
                fatalError("Division by zero.");
         $18: /* !! mod */
            bit = fetch_operand(0);
            store = fetch_operand(1);

/* !            Fetch_operand(bit, 0); */
/* !            Fetch_operand(store, 1); */
            @sexs bit bit;
            @sexs store store;
            test = bit % store;
            if ((bit < 0 && test > 0) || (test < 0 && bit > 0))
                test = 0 - test;
            
            if (store ~= 0)
                store_var(zmem->(pc++), test);
            else
                fatalError("Division by zero.");
         $19:/*  !! call_2s routine arg1 -> (result) */
            bit = unpack_routine(fetch_operand(0));
            if (bit == 0)
            {
                store_var(zmem->pc++, 0);
            }
            else
            {
                branch = fetch_operand(1);
                store = zstack_push_frame(bit, 1, zmem->pc++);
                
                if (store > 0)
                    zstack-->fp = branch;
            }
            
         $1a: /* !! call_2n routine arg1 */
            bit = unpack_routine(fetch_operand(0));
            if (bit ~= 0)
            {
                branch = fetch_operand(1);
                store = zstack_push_frame(bit, 1, -1);

                if (store > 0)
                    zstack-->fp = branch;
            }
         $1b: /* !! set_colour foreground background */
            /* !! NOOP */
            fetch_operand(0);
            fetch_operand(1);
            
         $1c: /* !! throw value stack-frame */
            store = fetch_operand(0);
            bit = fetch_operand(1);
            if (bit <= numFrames)
            {
                /* !! unwind the stack */
                while (numFrames > bit)
                    zstack_pop_frame(0, 1);

                zstack_pop_frame(store, 0);
            }
            else
            {
                fatalError("There is no current catch token.");
            }
         $1d, $1e, $1f:
            print "[type: ", type, "; code: ", (hex) op_code, "]^";
            fatalError("Non-existent opcode.");
        }
        
     ONE_OP:
        switch (op_code)
        {
         $00: /* !! jz a ?(label) */
            do_branch(fetch_operand(0) == 0);
         $01: /* !! get_sibling object -> (result) ?(label) */
            bit = zo_get_relative(fetch_operand(0), zo_sibling);
            store_var(zmem->pc++, bit);
            do_branch(bit ~= 0);
         $02: /* !! get_child object -> (result) ?(label) */
            bit = zo_get_relative(fetch_operand(0), zo_child);
            store_var(zmem->pc++, bit);
            do_branch(bit ~= 0);
         $03: /* !! get_parent object -> (result) */
            bit = fetch_operand(0);
            test = zo_get_relative(bit, zo_parent);
            
            store_var(zmem->pc++, test);

         $04: /* !! get_prop_len property-address -> (result) */
            bit = zmem->(fetch_operand(0) - 1);

            if (z_ver < 4)
            {
                if (bit ~= 0)
                {
                    @ushiftr bit 5 bit;
                    bit++;
                }
                
                store_var(zmem->pc++, bit);
            }
            else
            {
                if ((bit & $$10000000) == $$10000000)
                {
                    store = bit & $$00111111;
                    if (store == 0)
                        store_var(zmem->pc++, 64);
                    else
                        store_var(zmem->pc++, store);
                }
                else
                {
                    @aloadbit bit 6 store;
                    if ((bit & $$01000000) == $$01000000)
                        store_var(zmem->pc++, 2);
                    else
                        store_var(zmem->pc++, 1);
                }
            }
         $05: /* !! inc (variable) */
            bit = operands-->0;
            store = fetch_var(bit, true);
            @sexs store store;
            
            store_var(bit, store + 1, true);
         $06: /* !! dec (variable) */
            bit = operands-->0;
            store = fetch_var(bit, true);
            @sexs store store;
            
            store_var(bit, store - 1, true);
         $07: /* !! print_addr byte-address-of-string */
            zscii_decode(fetch_operand(0), zio_put_char);
         $08: /* !! call_1s routine -> (result) */
            bit = unpack_routine(fetch_operand(0));
            
            if (bit == 0)
                store_var(zmem->pc++, 0);
            else
                zstack_push_frame(bit, 0, zmem->pc++);
         $09: /* !! remove_obj object */
            zo_remove(fetch_operand(0));
         $0a: /* !! print_obj object */
            zscii_decode(zo_get_name(fetch_operand(0)), zio_put_char);
         $0b: /* !! ret value */
            zstack_pop_frame(fetch_operand(0), 0);
         $0c: /* !! jump ?(label) */
            bit = fetch_operand(0);
            @sexs bit bit;
            pc = pc + bit - 2;
         $0d: /* !! print_packed_addr address-of-string */
            bit = unpack_string(fetch_operand(0));
            zscii_decode(bit, zio_put_char);
         $0e: /* !! load (variable) -> (result) */
            bit = fetch_var(operands-->0, true);
            store_var(zmem->pc++, bit);
         $0f:
            if (z_ver < 5)
            {
                /* !! not value -> (result) */
                store_var(zmem->pc++, (~ fetch_operand(0)));
            }
            else
            {
                /* !! call_1n routine */
                bit = unpack_routine(fetch_operand(0));
                if (bit ~= 0)
                    zstack_push_frame(bit, 0, -1);
            }
        }

     ZERO_OP:
        switch (op_code)
        {
         $00: /* !! rtrue */
            zstack_pop_frame(1, 0);
         $01: /* !! rfalse */
            zstack_pop_frame(0, 0);
         $02: /* !! print (literal-string) */
            bit = zscii_decode(pc, zio_put_char);
            pc = pc + bit;
         $03: /* !! print_ret */
            bit = zscii_decode(pc, zio_put_char);
            pc = pc + bit;
            zio_put_char(13);
            zstack_pop_frame(1, 0);
         $04: /* !! nop */
         $05: /* !! save ?(label) or save -> (result) */
            if (z_ver <= 4)
            {
                bit = write_quetzal();
                if (bit < 0)
                {
                    if (z_ver < 4)
                        do_branch(0);
                    else
                        store_var(zmem->pc++, 0);
                }
                else
                {
                    if (z_ver < 4)
                        do_branch(1);
                    else
                        store_var(zmem->pc++, 1);
                }
            }
            else
            {
                fatalError("Illegal opcode.");
            }
         $06:  /* !! restore ?(label) or restore -> (result) */
            if (z_ver <= 4)
            {
                bit = glk($0062, fileusage_BinaryMode, filemode_Read, 0);
                store = read_quetzal(ZMachine.ref, bit);
                if (store > 0)
                {
                    zmem_init(ZMachine.ref);
                    
                    /* !! now replace the actual z-machine state with the */
/*                     !! new information */
                    
                    for (branch = 0 : branch < MEM_MAX_SIZE : branch++)
                        zmem->branch = zmem_copy->branch;
                    for (branch = 0 : branch < STACK_SIZE : branch++)
                        zstack->branch = zstack_copy->branch;

                    sp = restore_sp;
                    fp = restore_fp;
                    pc = restore_pc;

                    zmem_init_header(ZMachine.mainwin);
                    
                    if (z_ver == 4)
                        store_var(zmem->pc++, 2);
                    else
                        do_branch(1);
                }
                else
                {
                    if (z_ver == 4)
                        store_var(zmem->pc++, 0);
                    else
                        do_branch(0);
                }
            }
            else
            {
                fatalError("Illegal opcode.");
            }
         $07: /* !! restart */
/*             !! this *should* preserve the transcribing to printer bit */
/*             !! (0 in flags 2) and the force fixed-pitch font (1 in */
/*             !! flags 2), but it doesn't right now */
            ZMachine.init(0, 0);
            ZMachine.start();
         $08:
            zstack_pop_frame(zstack-->--sp, 0);
         $09:
            if (z_ver < 5)
            {
              /* !! pop */
                sp--;
            }
            else
            {
                /* !! catch -> (result) */
                store_var(zmem->pc++, numFrames);
            }
         $0a: /* !! quit */
            quit_flag = 1;
            zio_flush_lower();
            zio_flush_upper();
            
/* !            print "startup: ", startup,"^"; */
/* !            print "short: ", short, "^"; */
/* !             */
/* !            for (bit = 0 : bit < 5 : bit++) */
/* !            { */
/* !                print "TYPE: ",bit,"^"; */
/* !                for (test = 0 : test < 32 : test++) */
/* !                    print "code: ", test, "; calls: ", */
/* !                        (types-->bit)-->test,"^"; */
/* !            } */
            
         $0b: /* !! newline */
            zio_put_char(13);
         $0c:
            if (z_ver == 3)
                print_status_line();
         $0d: /* !! verify ?(label) */
            do_branch(do_verify);
         $0f: /* !! piracy ?(label) */
            do_branch(1);
         default:
            print "[type: ", type, "; code: ", (hex) op_code, "]^";
            fatalError("Non-existent opcode.");
        }
        
     VAR_OP:
        switch (op_code)
        {
         $00:
            /* !! call routine ...0 to 3 args... -> (result) */
            store = fetch_operand(0);
            bit = unpack_routine(store);
            
            if (bit == 0)
            {
                store_var(zmem->pc++, 0);
            }
            else
            {
                store = zmem->bit;

                for (branch = 1 : branch < num_operands : branch++)
                    funargs-->(branch - 1) = fetch_operand(branch);
                
                store = zstack_push_frame(bit, num_operands - 1, zmem->pc++);

                for (branch = 0 : branch < store && 
                     branch < (num_operands - 1) : branch++)
                    zstack-->(fp + branch) = funargs-->branch;
            }
         $01: /* !! storew array word-index value */
            bit = fetch_operand(0);
            store = fetch_operand(1);
            word = fetch_operand(2);
            test = bit + (2 * store);

            if (test == $10)
            {
                if (word & $$00000010)
                    zio_force_fixed_pitch = true;
                else
                    zio_force_fixed_pitch = false;

                if (word & $$00000001)
                    zio_start_transcript();
                else
                    zio_stop_transcript();
            }
            
            writew(test, word);
            
         $02: /* !! storeb array byte-index value */
            bit = fetch_operand(0);
            bit = bit + fetch_operand(1);
            if (bit == $11)
            {
                if (bit & $$00000010)
                    zio_force_fixed_pitch = true;
                else
                    zio_force_fixed_pitch = false;

                if (bit & $$00000001)
                    zio_start_transcript();
                else
                    zio_stop_transcript();
            }
            
            zmem->(bit) = fetch_operand(2);
         $03: /* !! put_prop object property value */
            bit = fetch_operand(0);
            store = fetch_operand(1);
            test = fetch_operand(2);
            
            zo_set_property_data(bit, store, test);
         $04:  /* !! sread/aread text parse time routine [-> (result)] */

            /* !! handle arrange events */
            glk($00c1, event_struct);
            if (event_struct-->0 == 5)
                zio_set_upper_dimensions();
                
            if (z_ver < 4)
                print_status_line();
            
            bit = fetch_operand(0);
            if (num_operands > 1)
                test = fetch_operand(1);
            if (num_operands > 2)
            {
                store = fetch_operand(2);
                branch = fetch_operand(3);
            }
            
            branch = aread(bit, store, branch);
            
            if (branch && test)
            {
                /* !! perform lexical analysis */
                zdict_init($08);
                zdict_tokenize(bit, test, 1);
            }

            if (z_ver >= 5)
                store_var(zmem->pc++, branch);
         $05: /* !! print_char output-char-code */
            zio_put_char(fetch_operand(0));
         $06: /* !! print_num */
            bit = fetch_operand(0);
            @sexs bit bit;

            zio_print_num(bit, zio_put_char);
            
         $07: /* !! random range -> (result) */
            bit = fetch_operand(0);
            @sexs bit bit;
            
            if (bit <= 0)
            {
                @setrandom bit;
                store_var(zmem->pc++, 0);
            }
            else
            {
                @random bit store;
                store_var(zmem->pc++, store + 1);
            }
         $08: /* !! push value */
            zstack-->sp++ = fetch_operand(0);
         $09: /* !! pull (variable) */
           store_var(operands-->0, zstack-->--sp, true);
         $0a: /* !! split_window lines */
            bit = fetch_operand(0);
            zio_split_window(bit);
         $0b: /* !! set_window window */
            bit = fetch_operand(0);
            if (bit == 0)
                zio_set_window(zio_lower);
            else
                zio_set_window(zio_upper);

         $0c: /* !! call routine ...0 to 7 args... -> (result) */
            bit = unpack_routine(fetch_operand(0));
            if (bit == 0)
            {
                store_var(zmem->pc++, 0);
            }
            else
            {
                store = zmem->bit;

                for (branch = 1 : branch < num_operands : branch++)
                    funargs-->(branch - 1) = fetch_operand(branch);
                
                store = zstack_push_frame(bit, num_operands - 1, zmem->pc++);

                for (branch = 0 : branch < store &&
                     branch < (num_operands - 1) : branch++)
                    zstack-->(fp + branch) = funargs-->branch;
            }
         $0d: /* !! erase_window window */
            bit = fetch_operand(0);
            @sexs bit bit;

            if (bit == 0)
            {
                zio_clear(zio_lower);
            }
            else if (bit == 1)
            {
                zio_clear(zio_upper);
            }
            else if (bit == -1)
            {
                zio_clear(zio_upper);
                zio_clear(zio_lower);
                zio_split_window(0);
                zio_set_window(zio_lower);
            }
            else
            {
                zio_clear(zio_upper);
                zio_clear(zio_lower);
            }
            
         $0e: /* !! erase_line value */
            bit = fetch_operand(0);
            if (bit == 1 && zio_current == zio_upper)
                zio_erase_line();
            
         $0f: /* !! set_cursor line column */
            bit = fetch_operand(0);
            store = fetch_operand(1);
            
            if (zio_current == zio_upper)
                zio_set_cursor(store - 1, bit - 1);
            
         $10: /* !! get_cursor array */
            bit = fetch_operand(0);
            store = bit + 2;
            
            word = zio_y + 1;
            writew(bit, word);
            word = zio_x + 1;
            writew(store, word);
         $11: /* !! set_text_style style */
            zio_set_style(fetch_operand(0));
            
         $12: /* !! buffer_mode flag */
            /* !! NOOP */
            fetch_operand(0);
            
         $13: /* !! output_stream number table */
            bit = fetch_operand(0);
            @sexs bit bit;
            
            switch(bit)
            {
             0: /* !! NOOP */
             -1: /* !! turn off the screen? */
                glk($0047, 0);
                output_one = 0;
             -2: /* !! turn off transcript */
                zio_stop_transcript();
             -3: /* !! turn off table */
                if (stream_tbl_index >= 0)
                {
                    bit = StreamTables-->stream_tbl_index;
                    word = (StreamTablePositions-->stream_tbl_index) - 2;
                    writew(bit, word);
                    stream_tbl_index--;
                }
             -4: /* !! turn off script file */
                zio_stop_command_record();
             1: /* !! turn on screen */
                bit = glk($002c, zio_current);
                glk($0047, bit);
                output_one = 1;
             2: /* !! turn on transcript */
                zio_start_transcript();
             3: /* !! turn on table stream */
                store = fetch_operand(1);
                StreamTables-->(++stream_tbl_index) = store;
                StreamTablePositions-->stream_tbl_index = 2;
             4: /* !! turn on script */
                zio_start_command_record();
             default:
                fatalError("illegal output stream");
            }
         $14: /* !! input_stream stream-num */
            switch (fetch_operand(0))
            {
             0:
                if (zio_input == 1)
                {
                    glk($0044, zio_script_stream, 0);
                    glk($0063, zio_script_file);
                    zio_input = 0;
                }
             1:
                if (zio_input == 0)
                {
                    zio_script_file =
                        glk($0062, fileusage_BinaryMode, filemode_Read, 0);
                    zio_script_stream =
                        glk($0042, zio_script_file, filemode_Read, 0);
                    if (zio_script_stream)
                        zio_input = 1;
                }
             default:
                fatalError("Illegal input stream.");
            }
                    
         $15:
            if (num_operands > 0)
                bit = fetch_operand(0);
            if (num_operands > 1)
                store = fetch_operand(1);
            if (num_operands > 2)
                branch = fetch_operand(2);
            if (num_operands > 3)
                test = fetch_operand(3);
            /* !! FIXME: implement this */
         $16: /* !! read_char 1 time routine -> (result) */
            /* !! just in case */
            fetch_operand(0);
            
            /* !! handle arrange events */
            glk($00c1, event_struct);
            if (event_struct-->0 == 5)
                zio_set_upper_dimensions();

            /* !! flush the buffers */
            zio_flush_lower();
            zio_flush_upper();
            
            if (z_ver < 4)
                print_status_line();
            if (num_operands > 1)
                bit = fetch_operand(1);
            if (num_operands > 2)
                store = fetch_operand(2);
            if (zio_input == 0)
                test = read_char(bit, store);
            else
                test = read_char_from_file(bit, store);

            if (zio_transcript_stream)
                glk($0081, zio_transcript_stream, zscii_charset->test);
            if (zio_command_stream)
            {
                /* !! handle mouse click specially */
                if (test == 254)
                {
                    readw(bit, zio_mouse_x);
                    readw(store, zio_mouse_y);
                    glk($0083, zio_command_stream, "[x: ");
                    zio_print_num(bit, zio_print_to_command);
                    glk($0083, zio_command_stream, ", y: ");
                    zio_print_num(store, zio_print_to_command);
                    glk($0083, zio_command_stream, "]^");
                }
                else
                {
                    glk($0081, zio_command_stream, zscii_charset->test);
                    glk($0081, zio_command_stream, 10);
                }
            }
            
            store_var(zmem->pc++, latin_to_zscii(test));

         $17: /* !! scan_table x table len form -> (result) */
            bit = fetch_operand(0);
            store = fetch_operand(1);
            branch = fetch_operand(2);

            if (num_operands > 3)
            {
                test = fetch_operand(3);
                if (test & $$10000000)
                    f = 2;
                else
                    f = 1;
                s = test & $$01111111;
            }
            else
            {
                f = 2;
                s = 2;
            }
                
            word = zmem + store;
            @linearsearch bit f word s branch 0 0 test;

            if (test)
            {
                store_var(zmem->pc++, test - zmem);
                do_branch(1);
            }
            else
            {
                store_var(zmem->pc++, 0);
                do_branch(0);
            }
            
         $18: /* !! not value -> (result) */
            store_var(zmem->pc++, (~ fetch_operand(0)));
            
         $19, $1a: /* !! call_vn routine ...up to 3 args... */
                   /* !! call_vn2 routine ...up to 7 args... */
            store = fetch_operand(0);
            bit = unpack_routine(store);
            
            if (bit ~= 0)
            {
                store = zmem->bit;
                for (branch = 1 : branch < num_operands : branch++)
                    funargs-->(branch - 1) = fetch_operand(branch);
                
                store = zstack_push_frame(bit, num_operands - 1, -1);

                for (branch = 0 : branch < store &&
                     branch < (num_operands - 1) : branch++)
                    zstack-->(fp + branch) = funargs-->branch;
            }
            
         $1b: /* !! tokenise text parse dictionary flag */
            bit = fetch_operand(0);
            store = fetch_operand(1);
            if (num_operands > 2)
                branch = fetch_operand(2);
            if (num_operands > 3)
                test = fetch_operand(3);

            if (branch)
                zdict_init(branch);
            zdict_tokenize(bit, store, (test == 0));

         $1c: /* !! encode_text zscii-text length from coded-text */
            store = fetch_operand(0);
            branch = fetch_operand(1);
            word = fetch_operand(2);
            
            zscii_encode(store + word, branch, 3, encode_buffer);
            bit = fetch_operand(3);
            zmem->bit = encode_buffer->0;
            zmem->(bit + 1) = encode_buffer->1;
            zmem->(bit + 2) = encode_buffer->2;
            zmem->(bit + 3) = encode_buffer->3;
            zmem->(bit + 4) = encode_buffer->4;
            zmem->(bit + 5) = encode_buffer->5;
            
         $1d: /* !! copy_table first second size */
            bit = fetch_operand(0);
            store = fetch_operand(1);
            test = fetch_operand(2);
            @sexs test test;
            
            if (store == 0)
            {
                for (branch = 0 : branch < test : branch++)
                    zmem->(bit + branch) = 0;
            }
            else
            {
                if (bit > store || test < 0)
                {
                    if (test < 0)
                        test = 0 - test;

                    for (branch = 0 : branch < test : branch++)
                        zmem->(store + branch) = zmem->(bit + branch);
                }
                else
                {
                    for (branch = test - 1 : branch >= 0 : branch--)
                        zmem->(store + branch) = zmem->(bit + branch);
                }
            }

         $1e: /* !! print_table zscii-text width height skip */
            bit = fetch_operand(0);
            test = fetch_operand(1);
            if (num_operands > 2)
                branch = fetch_operand(2);
            else
                branch = 1;
            if (num_operands > 3)
                store = fetch_operand(3);
            else
                store = 0;

            zscii_print_table(bit, test, branch, store);
            
         $1f: /* !! check_arg_count argument-number */
            test = (zstack-->(fp - 2) >= fetch_operand(0));
            do_branch(test);
            
         default:
            print "[type: ", type, "; code: ", (hex) op_code, "]^";
            fatalError("Non-existent opcode.");
        }
     EXT_OP:
        /* !! FIXME: implement EXT ops */
        switch (op_code)
        {
         $00: /* !! save table bytes name -> (result) */
            switch (num_operands)
            {
             0: 
                bit = write_quetzal();
                if (bit < 0)
                    store_var(zmem->pc++, 0);
                else
                    store_var(zmem->pc++, 1);
             2,3:
                bit = fetch_operand(0);
                store = fetch_operand(1);
                if (num_operands == 3)
                {
                    test = fetch_operand(2);
                    len = zmem->test++;
                    filename->0 = $e0;
                    for (word = 0 : word < len && word < 255 : word++)
                        filename->(word + 1) = zmem->(test + word);
                    filename->(word + 1) = 0;
                    f = glk($0061, fileusage_BinaryMode, filename, 0);
                }
                else
                {
                    f = glk($0062, fileusage_BinaryMode,
                            filemode_Write, 0);
                }
                if (f)
                    s = glk($0042, f, filemode_Write, 0);
                if (s)
                {
                    glk($0085, s, zmem + bit, store);
                    glk($0044, s, 0);
                    glk($0063, f);
                }
                store_var(zmem->pc++, 1);
             default:
                fatalError("Illegal number of operands to save.");
            }
            
         $01: /* !! restore table bytes name -> (result) */
            switch (num_operands)
            {
             0:
                bit = glk($0062, fileusage_BinaryMode, filemode_Read, 0);
                store = read_quetzal(ZMachine.ref, bit);
                
                if (store > 0)
                {
                    zmem_init(ZMachine.ref);
                    
                    /* !! now replace the actual z-machine state with the */
                    /* !! new information */
                
                    for (branch = 0 : branch < MEM_MAX_SIZE : branch++)
                        zmem->branch = zmem_copy->branch;
                    for (branch = 0 : branch < STACK_SIZE : branch++)
                        zstack->branch = zstack_copy->branch;
                    
                    sp = restore_sp;
                    fp = restore_fp;
                    pc = restore_pc;

                    zmem_init_header(ZMachine.mainwin);
                    
                    store_var(zmem->pc++, 2);
                }
                else
                {
                    store_var(zmem->pc++, 0);
                }
             2,3:
                bit = fetch_operand(0);
                store = fetch_operand(1);
                if (num_operands == 3)
                {
                    test = fetch_operand(2);
                    len = zmem->test++;
                    filename->0 = $e0;
                    for (word = 0 : word < len && word < 255 : word++)
                        filename->(word + 1) = zmem->(test + word);
                    filename->(word + 1) = 0;
                    f = glk($0061, fileusage_BinaryMode, filename, 0);
                }
                else
                {
                    f = glk($0062, fileusage_BinaryMode, filemode_Write, 0);
                }
                if (f)
                    s = glk($0042, f, filemode_Read, 0);
                if (s)
                {
                    word = glk($0092, s, zmem + bit, store);
                    glk($0044, s, 0);
                    glk($0063, f);
                }
                store_var(zmem->pc++, word);
            }                

         $02: /* !! log_shift number places -> (result) */
            bit = fetch_operand(0);
            store = fetch_operand(1);
            @sexs store store;
            
            if (store < 0)
            {
                store = 0 - store;
                @ushiftr bit store test;
            }
            else
            {
                @shiftl bit store test;
            }
            
            store_var(zmem->pc++, test & $0000ffff);

         $03: /* !! art_shift number places -> (result) */
            bit = fetch_operand(0);
            store = fetch_operand(1);
            @sexs bit bit;
            @sexs store store;
            
            if (store < 0)
            {
                store = 0 - store;
                @sshiftr bit store test;
            }
            else
            {
                @shiftl bit store test;
            }
            
            store_var(zmem->pc++, test & $0000ffff);
                
         $04: /* !! set_font font -> (result) */
            bit = zio_font;
            
            switch (fetch_operand(0))
            {
             1:
                if (bit == 4)
                {
                    if (zmem->$11 & $$00000010)
                        zio_force_fixed_pitch = false;
                    zio_font = 1;
                }
                store_var(zmem->pc++, bit);
             4:
                if (bit == 1)
                {
                    zio_force_fixed_pitch = true;
                    zio_font = 4;
                }
                store_var(zmem->pc++, bit);
             default:
                store_var(zmem->pc++, 0);
            }
            
         $09: /* !! save_undo -> (result) */
            zio_save_undo();
            store_var(zmem->pc++, 1);
            
         $0a: /* !! restore_undo -> (result) */
            if (zio_undo_sp > 0)
            {
                zio_restore_undo();
                store_var(zmem->pc++, 2);
            }
            else
            {
                store_var(zmem->pc++, 0);
            }
         $0b: /* !! print_unicode char-number */
            bit = fetch_operand(0);
            if (bit < 256)
                zio_put_char(bit, true);
            else
                zio_put_char('?');
         $0c: /* !! check_unicode char-number */
            bit = fetch_operand(0);
            
            /* !! we only handle 8-bit chars */
            if (bit > 255)
            {
                store_var(zmem->pc++, 0);
            }
            else
            {
                test = glk($0004, 3, bit);
                word = glk($0004, 1, bit);
                branch = 0;
                
                if (test > 0)
                    branch = branch | 1;
                if (word)
                    branch = branch | 2;
                    
                store_var(zmem->pc++, branch);
            }                    
         default:
            print "[type: ", type, "; code: ", (hex) op_code, "]^";
            fatalError("Non-existent opcode.");
        }
    }        

/* !    @systime stop2; */
    
/* !    (types-->type)-->op_code = (types-->type)-->op_code + (stop2 - stop1); */
];


[read_var_operands op_code type bit bit2 i notdone a b;
/* !    @systime a; */
    
    num_operands = 0;
    
/*     !! for variable number of operands (either VAR or EXT forms) */
    bit = zmem->(pc++);
    
    operand_types-->3 = (bit & $$00000011);
    @ushiftr bit 2 bit;
    operand_types-->2 = (bit & $$00000011);
    @ushiftr bit 2 bit;
    operand_types-->1 = (bit & $$00000011);
    @ushiftr bit 2 bit;
    operand_types-->0 = (bit & $$00000011);

    
    if (type == VAR_OP && op_code == 12 or 26)
    {
/*         !! special double var opcodes */
        bit2 = zmem->(pc++);
        operand_types-->7 = (bit2 & $$00000011);
        @ushiftr bit2 2 bit2;
        operand_types-->6 = (bit2 & $$00000011);
        @ushiftr bit2 2 bit2;
        operand_types-->5 = (bit2 & $$00000011);
        @ushiftr bit2 2 bit2;
        operand_types-->4 = (bit2 & $$00000011);
    }
        
    notdone = 1;
    
    for (i = 0 : notdone && i < 4 : i++)
    {
        if (operand_types-->i == LC)
        {
            num_operands++;
            readw(bit, pc);
            operands-->i = bit;
            pc = pc + 2;
        }
        else if (operand_types-->i == SC or VAR)
        {
            num_operands++;
            operands-->i = zmem->(pc++);
        }
        else
        {
            notdone = 0;
        }
    }
    
    if (type == VAR_OP && notdone && op_code == 12 or 26)
    {
        for (i = 4 : notdone ~= 0 && i < 8 : i++)
        {
            if (operand_types-->i == LC)
            {
                num_operands++;
                readw(bit, pc);
                operands-->i = bit;
                pc = pc + 2;
            }
            else if (operand_types-->i == SC or VAR)
            {
                num_operands++;
                operands-->i = zmem->(pc++);
            }
            else
            {
                notdone = 0;
            }
        }
    }
/* !    @systime b; */
/* !    readvart = readvart + (b - a); */
    
];

[read_char time routine x y;
    if (zio_reset_height)
    {
        if (zio_pending_height >= 0)
            zio_split_window(zio_pending_height);
        zio_reset_height = false;
    }
    if (zio_changed_height)
    {
        zio_changed_height = false;
        zio_reset_height = true;
    }        
    
    glk($00d2, zio_current);

    if (zio_mouse_x ~= 0 && zio_current == zio_upper)
        glk($00d4, zio_current);
    
    if (time)
        glk($00d6, time * 100);
    
    while (1)
    {
        glk($00c0, event_struct);

        switch(event_struct-->0)
        {
         1:
            /* !! turn off timer before entering */
            glk($00d6, 0);

            /* !! turn off mouse request */
            glk($00d5, zio_current);

            zstack_push_frame(unpack_routine(routine), 0, -2);
            ZMachine.start();

            timer_flag = 0;
            zio_flush_lower();
            zio_flush_upper();
            
            if (timer_val)
            {
                timer_val = 0;
                glk($00d3, zio_current);
                
                return 0;
            }

            /* !! turn the timer on again */
            if (time)
                glk($00d6, time * 100);
            
            /* !! turn on the mouse request */
            if (zio_mouse_x ~= 0 && zio_current == zio_upper)
                glk($00d4, zio_current);
         2:
            glk($00d6, 0);
            glk($00d5, zio_current);
            return event_struct-->2;
         4:
            x = event_struct-->2 + 1;
            y = event_struct-->3 + 1;

            writew(zio_mouse_x, x);
            writew(zio_mouse_y, y);
            glk($00d3, zio_current);
            glk($00d5, zio_current);
            glk($00d6, 0);
            return 254;
        }
    }
    
];
    
    
[aread buf time routine writeloc maxlen init gotline len i j style;
    if (zio_reset_height)
    {
        if (zio_pending_height >= 0)
            zio_split_window(zio_pending_height);
        zio_reset_height = false;
    }
    if (zio_changed_height)
    {
        zio_changed_height = false;
        zio_reset_height = true;
    }        

    maxlen = zmem->buf;

    if (z_ver > 4)
    {
        maxlen = zmem->buf;
        writeloc = buf + 2;
        init = zmem->(buf + 1);

        if (init > 0)
        {
            /* !! hopefully the buffer has not just been flushed... */
            if (zio_current == zio_lower)
            {
                if (zio_lower_buffer_pos >= init)
                    zio_lower_buffer_pos = zio_lower_buffer_pos - init;
            }
            else
            {
                /* !! Wow, I have *no* idea if this will work. */
                /* !! Luckily, it will probably never happen */
                i = (zio_x + (zio_y * zio_width)) - init;

                if (i >= 0)
                {
                    for (j = 0 : j < init : j++)
                    {
                        zio_upper_buffer->(i + j) = ' ';
                        zio_upper_style_buffer->(i + j) = 0;
                    }
                }
            }
        }
    }
    else
    {
        maxlen = zmem->buf - 1;
        writeloc = buf + 1;
    }

    /* !! now flush the buffer */
    zio_flush_lower();
    zio_flush_upper();
    
    
    if (zio_input == 0)
    {
        gotline = 0;
        /* !! request line event */
        if (~~ zio_pending_input)
        {
            glk($00d0, zio_current, zmem + writeloc, maxlen, init);
            zio_pending_input = zio_current;
        }

        if (time)
        {
            /* !! request timer event */
            glk($00d6, time * 100);
        }
    
        
        while (gotline == 0)
        {
            /* !! glk_select */
            glk($00c0, event_struct);
            switch (event_struct-->0)
            {
             1: /* !! timer */
                /* !! turn it off before entering */
                glk($00d6, 0);

                zstack_push_frame(unpack_routine(routine), 0, -2);
                ZMachine.start();

                timer_flag = 0;

                zio_flush_lower();
                zio_flush_upper();
                
                if (timer_val)
                {
                    timer_val = 0;
                    glk($00d1, zio_current, event_struct);
                    zio_pending_input = false;
                    
                    /* !! zero the buffer */
                    for (i = writeloc : i < writeloc + maxlen : i++)
                        zmem->i = 0;

                    /* !! interrupt terminator */
                    return 0;
                }
                /* !! turn the timer back on */
                if (time)
                    glk($00d6, time * 100);
                /* !! re-request input if necessary */
                if (~~ zio_pending_input)
                {
                    glk($00d0, zio_current, zmem + writeloc, maxlen, event_struct-->2);
                    zio_pending_input = zio_current;
                }
                
             3: /* !! lineinput */
                gotline = 1;
                zio_pending_input = false;
                
                /* !! turn off timer */
                glk($00d6, 0);
            }
        }
        len = event_struct-->2;
    }
    else
    {
        len = glk($0091, zio_script_stream, zmem + writeloc, maxlen);
        if (len <= 0)
        {
            glk($0044, zio_script_stream, 0);
            glk($0063, zio_script_file);
            zio_input = 0;
            return aread(buf, time, routine);
        }
        len--;
        /* !! print out the command */
        style = zio_current_style;
        zio_set_style(2);        
        for (i = writeloc : i < writeloc + len : i++)
            zio_put_char(zmem->i);
        zio_put_char(13);
        zio_set_style(style);
    }        

    /* !! handle command and transcript streams */
    if (zio_command_stream || zio_transcript_stream)
    {
        for (i = writeloc : i < writeloc + len : i++)
        {
            if (zio_command_stream)
                glk($0081, zio_command_stream, zmem->i);
            if (zio_transcript_stream)
                glk($0081, zio_transcript_stream, zmem->i);
        }
        /* !! print a newline to the command stream */
        if (zio_command_stream)
            glk($0081, zio_command_stream, 10);
    }

    /* !! print a newline */
    zio_put_char(13);

    /* !! to lower case */
    for (i = writeloc : i < writeloc + len : i++)
        zmem->i = glk($00a0, zmem->i);
    
        
    if (z_ver > 4)
        zmem->(buf + 1) = len;
    else
        zmem->(buf + len + 1) = 0;

    /* !! newline terminator */
    return 10;
];

[read_char_from_file time routine len;
    len = glk($0091, zio_script_stream, input_line, 255);
    if (len < 0)
    {
        zio_input = 0;
        glk($0044, zio_script_stream, 0);
        glk($0063, zio_script_file);
        return read_char(time, routine);
    }
    else
    {
        return input_line->0;
    }
];
    
[print_decimal val place n;
    n = val / place;
    zio_put_char(n + '0');
    return val - (n * place);
];
