/*
 * Decompiled with CFR 0.152.
 */
package zpplet.data;

import zpplet.machine.ZMachine;
import zpplet.misc.ZError;

public class ZObjectTree {
    protected ZMachine zm;
    protected int table;
    protected int tree;

    public ZObjectTree(ZMachine zm) {
        this.zm = zm;
        this.table = zm.hd.getObjectTableAddr();
        this.tree = this.table + this.numProperties() * 2;
    }

    public final int defaultProperty(int prop) {
        return this.zm.getWord(this.table + (prop - 1) * 2);
    }

    protected int numProperties() {
        return 31;
    }

    protected int getEntryLoc(int obj) {
        return this.tree + (obj - 1) * 9;
    }

    public final boolean getAttribute(int obj, int attr) {
        int entryloc = this.getEntryLoc(obj);
        int bytenum = attr >> 3;
        int bitmask = 1 << 7 - (attr & 7);
        return (this.zm.getByte(entryloc + bytenum) & bitmask) != 0;
    }

    public final void setAttribute(int obj, int attr, boolean value) {
        int entryloc = this.getEntryLoc(obj);
        int bytenum = attr >> 3;
        int bitmask = 1 << 7 - (attr & 7);
        if (value) {
            this.zm.setByte(entryloc + bytenum, this.zm.getByte(entryloc + bytenum) | bitmask);
        } else {
            this.zm.setByte(entryloc + bytenum, this.zm.getByte(entryloc + bytenum) & ~bitmask);
        }
    }

    public int getParent(int obj) {
        return obj == 0 ? 0 : this.zm.getByte(this.getEntryLoc(obj) + 4);
    }

    public int getSibling(int obj) {
        return obj == 0 ? 0 : this.zm.getByte(this.getEntryLoc(obj) + 5);
    }

    public int getChild(int obj) {
        return obj == 0 ? 0 : this.zm.getByte(this.getEntryLoc(obj) + 6);
    }

    public void setParent(int obj, int newparent) {
        if (obj != 0) {
            this.zm.setByte(this.getEntryLoc(obj) + 4, newparent);
        }
    }

    public void setSibling(int obj, int newsibling) {
        if (obj != 0) {
            this.zm.setByte(this.getEntryLoc(obj) + 5, newsibling);
        }
    }

    public void setChild(int obj, int newchild) {
        if (obj != 0) {
            this.zm.setByte(this.getEntryLoc(obj) + 6, newchild);
        }
    }

    public int getPropertyTableAddr(int obj) {
        return obj == 0 ? 0 : this.zm.getWord(this.getEntryLoc(obj) + 7);
    }

    public final int getShortNameAddr(int obj) {
        return this.getPropertyTableAddr(obj) + 1;
    }

    public int getPropEntryAddr(int obj, int prop) {
        if (obj == 0) {
            return 0;
        }
        int addr = this.getPropertyTableAddr(obj);
        addr += this.zm.getByte(addr) * 2 + 1;
        int sizebyte = this.zm.getByte(addr);
        while (sizebyte != 0) {
            if ((sizebyte & 0x1F) == prop) {
                return addr;
            }
            if ((sizebyte & 0x1F) < prop) {
                return 0;
            }
            sizebyte = this.zm.getByte(addr += (sizebyte >> 5) + 2);
        }
        return 0;
    }

    public int getNextProp(int obj, int prop) throws ZError {
        int addr;
        if (prop == 0) {
            addr = this.getPropertyTableAddr(obj);
            if (addr == 0) {
                throw new ZError("Tried to get next property for object with no properties");
            }
            addr += this.zm.getByte(addr) * 2 + 1;
        } else {
            addr = this.getPropEntryAddr(obj, prop);
            if (addr == 0) {
                throw new ZError("Tried to get next property for nonexistent property");
            }
            addr += (this.zm.getByte(addr) >> 5) + 2;
        }
        return this.zm.getByte(addr) & 0x1F;
    }

    public int getPropAddr(int obj, int prop) {
        int addr = this.getPropEntryAddr(obj, prop);
        if (addr == 0) {
            return 0;
        }
        return addr + 1;
    }

    public int getPropLen(int addr) {
        if (addr == 0) {
            return 0;
        }
        int sizebyte = this.zm.getByte(addr - 1);
        return (sizebyte >> 5) + 1;
    }

    public final int getProp(int obj, int prop) {
        int addr = this.getPropEntryAddr(obj, prop);
        if (addr == 0) {
            return this.defaultProperty(prop);
        }
        int size = (this.zm.getByte(addr) >> 5) + 1;
        if (size == 1) {
            return this.zm.getByte(addr + 1);
        }
        return this.zm.getWord(addr + 1);
    }

    public final void setProp(int obj, int prop, int val) throws ZError {
        int addr = this.getPropEntryAddr(obj, prop);
        if (addr == 0) {
            throw new ZError("Tried to set nonexistent property");
        }
        int size = (this.zm.getByte(addr) >> 5) + 1;
        if (size == 1) {
            this.zm.setByte(addr + 1, val);
        } else {
            this.zm.setWord(addr + 1, val);
        }
    }

    private void debugDumpObject(int obj, int indent) {
        String shortname;
        try {
            shortname = this.zm.getStringAt(this.getShortNameAddr(obj));
        }
        catch (Exception exception) {
            shortname = "<error>";
        }
        int i = 0;
        while (i < indent) {
            System.out.print(" ");
            ++i;
        }
        System.out.println("[" + obj + "] " + shortname);
        int child = this.getChild(obj);
        while (child != 0) {
            this.debugDumpObject(child, indent + 4);
            child = this.getSibling(child);
        }
    }

    public void debugDumpTree() {
        int firstproperty = this.zm.getMem().length;
        int obj = 0;
        while (this.getEntryLoc(obj) < firstproperty) {
            int propaddr;
            if (this.getParent(obj) == 0) {
                this.debugDumpObject(obj, 0);
            }
            if ((propaddr = this.getPropertyTableAddr(obj)) != 0 && propaddr < firstproperty) {
                firstproperty = propaddr;
            }
            ++obj;
        }
    }
}

