/*
 * Decompiled with CFR 0.152.
 */
package zpplet.data;

import zpplet.data.ZObjectTree;
import zpplet.machine.ZMachine;
import zpplet.misc.ZError;

public class ZObjectTree4
extends ZObjectTree {
    public ZObjectTree4(ZMachine zm) {
        super(zm);
    }

    protected int getEntryLoc(int obj) {
        return obj == 0 ? 0 : this.tree + (obj - 1) * 14;
    }

    protected int numProperties() {
        return 63;
    }

    public int getParent(int obj) {
        return obj == 0 ? 0 : this.zm.getWord(this.getEntryLoc(obj) + 6);
    }

    public int getSibling(int obj) {
        return obj == 0 ? 0 : this.zm.getWord(this.getEntryLoc(obj) + 8);
    }

    public int getChild(int obj) {
        return obj == 0 ? 0 : this.zm.getWord(this.getEntryLoc(obj) + 10);
    }

    public void setParent(int obj, int newparent) {
        if (obj != 0) {
            this.zm.setWord(this.getEntryLoc(obj) + 6, newparent);
        }
    }

    public void setSibling(int obj, int newsibling) {
        if (obj != 0) {
            this.zm.setWord(this.getEntryLoc(obj) + 8, newsibling);
        }
    }

    public void setChild(int obj, int newchild) {
        if (obj != 0) {
            this.zm.setWord(this.getEntryLoc(obj) + 10, newchild);
        }
    }

    public int getPropertyTableAddr(int obj) {
        return obj == 0 ? 0 : this.zm.getWord(this.getEntryLoc(obj) + 12);
    }

    public int getPropEntryAddr(int obj, int propnum) {
        if (obj == 0) {
            return 0;
        }
        int addr = this.getPropertyTableAddr(obj);
        addr += this.zm.getByte(addr) * 2 + 1;
        int sizebyte = this.zm.getByte(addr);
        while (sizebyte != 0) {
            int length;
            int curpropnum = sizebyte & 0x3F;
            if (curpropnum == propnum) {
                return addr;
            }
            if (curpropnum < propnum) {
                return 0;
            }
            if ((sizebyte & 0x80) != 0) {
                length = (this.zm.getByte(addr + 1) & 0x3F) + 2;
                if (length == 2) {
                    length += 64;
                }
            } else {
                length = (sizebyte >> 6) + 2;
            }
            sizebyte = this.zm.getByte(addr += length);
        }
        return 0;
    }

    public int getNextProp(int obj, int propnum) throws ZError {
        int addr;
        if (propnum == 0) {
            addr = this.getPropertyTableAddr(obj);
            if (addr == 0) {
                throw new ZError("Tried to get next property for object with no properties");
            }
            addr += this.zm.getByte(addr) * 2 + 1;
        } else {
            int length;
            addr = this.getPropEntryAddr(obj, propnum);
            if (addr == 0) {
                throw new ZError("Tried to get next property for nonexistent property");
            }
            int sizebyte = this.zm.getByte(addr);
            if ((sizebyte & 0x80) != 0) {
                length = (this.zm.getByte(addr + 1) & 0x3F) + 2;
                if (length == 2) {
                    length += 64;
                }
            } else {
                length = (sizebyte >> 6) + 2;
            }
            addr += length;
        }
        return this.zm.getByte(addr) & 0x3F;
    }

    public int getPropAddr(int obj, int propnum) {
        int addr = this.getPropEntryAddr(obj, propnum);
        if (addr == 0) {
            return 0;
        }
        if ((this.zm.getByte(addr) & 0x80) != 0) {
            return addr + 2;
        }
        return addr + 1;
    }

    public int getPropLen(int addr) {
        if (addr == 0) {
            return 0;
        }
        int sizebyte = this.zm.getByte(addr - 1);
        if ((sizebyte & 0x80) != 0) {
            return (sizebyte & 0x3F) == 0 ? 64 : sizebyte & 0x3F;
        }
        return (sizebyte >> 6) + 1;
    }
}

