/*
 * Decompiled with CFR 0.152.
 */
package zpplet.misc;

import zpplet.machine.ZMachine;
import zpplet.misc.ZError;

public final class ZChars {
    public static final int ABORT = -1;
    public static final int TIMEOUT = 0;
    public static final int INVALID = -2;
    public static final int BACKSPACE = 8;
    public static final int TAB = 9;
    public static final int SENTENCE_SPACE = 11;
    public static final int RETURN_CHAR = 13;
    public static final int ESCAPE = 27;
    public static final int DELETE = 127;
    public static final int CURSOR_UP = 129;
    public static final int CURSOR_DOWN = 130;
    public static final int CURSOR_LEFT = 131;
    public static final int CURSOR_RIGHT = 132;
    public static final int FUNCTION_KEYS = 133;
    public static final int KEYPAD_KEYS = 145;
    public static final int MOUSE_MENU = 252;
    public static final int MOUSE_DBLCLICK = 253;
    public static final int MOUSE_CLICK = 254;
    public static final char FORMAT_ESCAPE = '\uffff';
    private static char[] unicode_defaults = new char[]{'\u00e4', '\u00f6', '\u00fc', '\u00c4', '\u00d6', '\u00dc', '\u00df', '\u00bb', '\u00ab', '\u00eb', '\u00ef', '\u00ff', '\u00cb', '\u00cf', '\u00e1', '\u00e9', '\u00ed', '\u00f3', '\u00fa', '\u00fd', '\u00c1', '\u00c9', '\u00cd', '\u00d3', '\u00da', '\u00dd', '\u00e0', '\u00e8', '\u00ec', '\u00f2', '\u00f9', '\u00c0', '\u00c8', '\u00cc', '\u00d2', '\u00d9', '\u00e2', '\u00ea', '\u00ee', '\u00f4', '\u00fb', '\u00c2', '\u00ca', '\u00ce', '\u00d4', '\u00da', '\u00e5', '\u00c5', '\u00f8', '\u00d8', '\u00e3', '\u00f1', '\u00f5', '\u00c3', '\u00d1', '\u00d5', '\u00e6', '\u00c6', '\u00e7', '\u00c7', '\u00fe', '\u00f0', '\u00de', '\u00d0', '\u00a3', '\u0153', '\u0152', '\u00a1', '\u00bf'};
    private ZMachine zm;
    private int alphabase;
    private int terminatorbase;
    private int unicodebase;
    private static final String A2DEFAULT = " \n0123456789.,!?_#'\"/\\-:()";

    public ZChars(ZMachine zm) {
        this.zm = zm;
    }

    public void setCustomAddresses(int alphabase, int terminatorbase, int unicodebase) {
        this.alphabase = alphabase;
        this.terminatorbase = terminatorbase;
        this.unicodebase = unicodebase;
    }

    public static int fromActionKeyToZAscii(int key) {
        switch (key) {
            case 27: {
                return 27;
            }
            case 38: {
                return 129;
            }
            case 40: {
                return 130;
            }
            case 37: {
                return 131;
            }
            case 39: {
                return 132;
            }
            case 36: {
                return 152;
            }
            case 35: {
                return 146;
            }
        }
        if (key >= 112 && key <= 123) {
            return key - 112 + 133;
        }
        if (key >= 96 && key <= 105) {
            return key - 96 + 145;
        }
        return -2;
    }

    public int fromUnicodeToZAscii(char unicode) {
        if (this.isTerminator(unicode)) {
            return 13;
        }
        if (unicode == '\b') {
            return 8;
        }
        if (unicode == '\u001b') {
            return 27;
        }
        if (unicode < ' ') {
            return -2;
        }
        if (unicode <= '\u007f') {
            return unicode;
        }
        if (this.unicodebase == 0) {
            int i = 0;
            while (i < unicode_defaults.length) {
                if (unicode_defaults[i] == unicode) {
                    return 155 + i;
                }
                ++i;
            }
            return -2;
        }
        int n = this.zm.getByte(this.unicodebase);
        int i = 0;
        while (i < n) {
            if (this.zm.getWord(this.unicodebase + 1 + i * 2) == unicode) {
                return 155 + i;
            }
            ++i;
        }
        return -2;
    }

    public boolean isStorable(int zch) {
        return zch >= 32 && zch <= 126 || zch == 13 || zch >= 155 && zch <= 251;
    }

    public char toOutput(int zascii) {
        if (zascii >= 32 && zascii <= 126) {
            return (char)zascii;
        }
        if (zascii >= 155 && zascii <= 251) {
            if (this.unicodebase == 0) {
                if (zascii - 155 < unicode_defaults.length) {
                    return unicode_defaults[zascii - 155];
                }
                return '\u0000';
            }
            int n = this.zm.getByte(this.unicodebase);
            if (zascii - 155 < n) {
                return (char)this.zm.getWord(this.unicodebase + 1 + (zascii - 155) * 2);
            }
            return '\u0000';
        }
        return '\u0000';
    }

    public char fromTable(int zchar, int alpha) throws ZError {
        if (this.alphabase == 0) {
            switch (alpha) {
                case 0: {
                    return (char)(97 + zchar - 6);
                }
                case 1: {
                    return (char)(65 + zchar - 6);
                }
                case 2: {
                    return A2DEFAULT.charAt(zchar - 6);
                }
            }
            throw new ZError("Bad alphabet " + alpha);
        }
        return (char)this.zm.getByte(this.alphabase + alpha * 26 + zchar - 6);
    }

    public boolean isFunctionKey(int ch) {
        if (ch >= 129 && ch <= 154) {
            return true;
        }
        return ch >= 252 && ch <= 254;
    }

    public boolean isTerminator(int ch) {
        if (ch == 13 || ch == 10) {
            return true;
        }
        if (this.terminatorbase != 0) {
            int i = this.terminatorbase;
            while (this.zm.getByte(i) != 0) {
                if (this.zm.getByte(i) == 255) {
                    return this.isFunctionKey(ch);
                }
                if (this.zm.getByte(i++) != ch) continue;
                return true;
            }
        }
        return false;
    }

    private int getAlphaTranslation(int ch) {
        if (this.alphabase == 0) {
            if (ch >= 97 && ch <= 122) {
                return ch - 97;
            }
            if (ch >= 65 && ch <= 90) {
                return ch - 65 + 256;
            }
            int index = A2DEFAULT.indexOf((char)ch);
            if (index >= 0) {
                return index + 512;
            }
            return ch + 768;
        }
        int i = 0;
        while (i < 78) {
            if (this.zm.getByte(this.alphabase + i) == ch) {
                return i % 26 + i / 26 * 256;
            }
            ++i;
        }
        return ch + 768;
    }

    public int[] encode(int addr, int len, int nwords) {
        int i;
        int[] result = new int[nwords];
        int[] zchars = new int[nwords * 3];
        int zi = 0;
        try {
            i = 0;
            while (i < len) {
                int ch = this.getAlphaTranslation(this.zm.getByte(addr + i));
                switch (ch >> 8) {
                    case 0: 
                    case 1: {
                        zchars[zi++] = (ch & 0xFF) + 6;
                        break;
                    }
                    case 2: {
                        zchars[zi++] = 5;
                        zchars[zi++] = (ch & 0xFF) + 6;
                        break;
                    }
                    default: {
                        zchars[zi++] = 5;
                        zchars[zi++] = 6;
                        zchars[zi++] = (ch &= 0xFF) >> 5;
                        zchars[zi++] = ch & 0x1F;
                    }
                }
                ++i;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        while (zi < zchars.length) {
            zchars[zi++] = 5;
        }
        zi = 0;
        i = 0;
        while (i < nwords) {
            result[i] = (zchars[zi++] << 10) + (zchars[zi++] << 5) + zchars[zi++];
            ++i;
        }
        int n = nwords - 1;
        result[n] = result[n] | 0x8000;
        return result;
    }
}

