package zpplet.iff;

import java.io.*;

public class IFFInput
		extends IFF
	{
	public IFFInput(File file)
			throws IOException
		{
		super(file, "r");
		}

	public IFFInput(String name)
			throws IOException
		{
		super(name, "r");
		}

	public synchronized ChunkInfo openChunk()
			throws IOException
		{
		ChunkInfo result = new ChunkInfo();
		result.start = getFilePointer();
		result.type = read4Chars();
		result.length = readInt();
		result.composite = result.type.equals("FORM");
		// NOTE: doesn't handle other composite types
		if (result.composite)
			result.type += read4Chars(); 
		openchunks.push(result);
		return result;
		}

	public synchronized ChunkInfo skipToChunk(String type)
			throws IOException
		{
		ChunkInfo ci;
		while (true)
			{
			ci = (ChunkInfo)openchunks.peek();
			long chunkend = ci.start + ci.length + 8;
			if (getFilePointer() >= chunkend)
				return null;
			ci = openChunk();
			if (ci.type.equals(type)) 
				return ci;
			closeChunk();
			}
		}

	public synchronized void closeChunk()
			throws IOException
		{
		ChunkInfo ci = (ChunkInfo)openchunks.pop();
		seek((ci.start + ci.length + 8 + 1) & ~1L);
		}

	public synchronized void close()
			throws IOException
		{
		openchunks.clear();
		super.close();
		}
	}
