package zpplet.iff;

import java.io.*;

public class IFFOutput
		extends IFF
	{
	public IFFOutput(File file)
			throws IOException
		{
		super(file, "rw");
		}

	public IFFOutput(File file, String type)
			throws IOException
		{
		this(file);
		openChunk(type);
		}

	public IFFOutput(String name)
			throws IOException
		{
		super(name, "rw");
		}

	public IFFOutput(String name, String type)
			throws IOException
		{
		this(name);
		openChunk(type);
		}

	public synchronized void openChunk(String type)
			throws IOException
		{
		ChunkInfo ci = new ChunkInfo();
		ci.start = getFilePointer();
		ci.length = 0;
		ci.type = type; 
		ci.composite = (type.length() > 4);

		write(type.getBytes(), 0, 4);
		writeInt(0);
		if (ci.composite)
			write(type.getBytes(), 4, 4);
		openchunks.push(ci);
		}

	public synchronized void closeChunk()
			throws IOException
		{
		ChunkInfo ci = (ChunkInfo)openchunks.peek();
		long pos = getFilePointer();
		ci.length = getChunkPosition();
		seek(ci.start + 4);
		writeInt(ci.length);

		openchunks.pop();
		seek(pos);
		if ((ci.length & 1) != 0)
			writeByte(0);
		}

	public synchronized void close()
			throws IOException
		{
		while (!openchunks.empty())
			closeChunk();
		super.close();
		}
	
	public void writeShortAt(short n, long location)
			throws IOException
		{
			long save = getFilePointer();
			seek(location);
			writeShort(n);
			seek(save);
		}
	}
