package zpplet.ops;

import java.io.*;

import zpplet.machine.*;
import zpplet.misc.*;
import zpplet.data.*;
import zpplet.system.*;

public class ZInstruction5
		extends ZInstruction4
	{
	public ZInstruction5(ZMachine zm)
		{
		super(zm);
		}

	protected void initOps()
		{
		super.initOps();

		ops[26] = new OP_CALLN(); // CALL_2N
		ops[27] = new OP_SET_COLOUR();
		ops[28] = new OP_THROW();
		ops[143] = new OP_CALLN(); // CALL_1N
		ops[181] = null; // old save
		ops[182] = null; // old restore
		ops[185] = new OP_CATCH();
		ops[190] = null; // over-extended opcode
		ops[191] = new OP_PIRACY();
		
		ops[248] = new OP_NOT();
		ops[249] = new OP_CALLN(); // CALL_VN
		ops[250] = new OP_CALLN(); // CALL_VN2
		ops[251] = new OP_TOKENISE();
		ops[252] = new OP_ENCODE_TEXT();
		ops[253] = new OP_COPY_TABLE();
		ops[254] = new OP_PRINT_TABLE();
		ops[255] = new OP_CHECK_ARG_COUNT();
		
		ops[256 + 0] = new OP_SAVE();
		ops[256 + 1] = new OP_RESTORE();
		ops[256 + 2] = new OP_LOG_SHIFT();
		ops[256 + 3] = new OP_ART_SHIFT();
		ops[256 + 4] = new OP_SET_FONT();
		ops[256 + 9] = new OP_SAVE_UNDO();
		ops[256 + 10] = new OP_RESTORE_UNDO();
		ops[256 + 11] = new OP_PRINT_UNICODE();
		ops[256 + 12] = new OP_CHECK_UNICODE();
		}

	class OP_CALLN
			implements IOP
		{
		public void x()
			{
			doCall(false);
			}
		}

	class OP_SET_COLOUR
			implements IOP
		{
		public void x()
			{
			doSetColour();
			}
		}

	class OP_THROW
			implements IOP
		{
		public void x()
			{
			// unroll stack to a given frame; return value provided
			while (zm.st.size() > o[1])
				zm.st.pop();
			doReturn(o[0]);
			}
		}

	class OP_CATCH
			implements IOP
		{
		public void x()
			{
			doStore(zm.st.size());
			}
		}

	class OP_PIRACY
			implements IOP
		{
		public void x()
			{
			doBranch(false);
			}
		}

	class OP_SET_CURSOR
			implements IOP
		{
		public void x()
			{
			zm.curw.moveCursor(o[1], o[0]);
			}
		}

	class OP_TOKENISE
			implements IOP
		{
		public void x()
			{
			ZDictionary4 dict;
			if ((noperands < 3) || (o[2] == 0))
				dict = (ZDictionary4)zm.zd;
			else
				dict = new ZUserDictionary(zm, o[2]);

			boolean parseunknown = (noperands < 4) || (o[3] == 0);
			int tbuf = o[0];
			int tlen = zm.getByte(tbuf + 1);

			dict.tokenize(tbuf + 2, tlen, o[1], parseunknown);
			}
		}

	class OP_ENCODE_TEXT
			implements IOP
		{
		public void x()
			{
			int ascii_text = o[0] + o[2];
			int coded_text = o[3];

			int[] encword = zm.zc.encode(ascii_text, o[1], 3);
			for (int i = 0; i < 3; i++)
				zm.setWord(coded_text + i * 2, encword[i]);
			}
		}

	class OP_COPY_TABLE
			implements IOP
		{
		public void x()
			{
			int first = o[0];
			int second = o[1];
			int length = (short)o[2];

			if (o[1] == 0)
				{
				// zero a section of memory
				if (length < 0)
					length = -length;
				for (int i = o[0] + length - 1; i >= o[0]; i--)
					zm.setByte(i, 0);
				}
			else if (length > 0) // copy forward or backward, avoiding
				// overwriting as-yet uncopied data
				System.arraycopy(zm.getMem(), first, zm.getMem(), second, length);
			else
				// copy forwards
				{
				length = -length;
				for (int i = 0; i < length; i++)
					zm.setByte(second + i, zm.getByte(first + i));
				}
			}
		}

	class OP_PRINT_TABLE
			implements IOP
		{
		public void x()
			{
			int textpos = o[0];
			int width = o[1];
			int height = 1;
			int skip = 0;

			if (noperands > 2)
				height = o[2];
			if (noperands > 3)
				skip = o[3];

			zm.curw.flush();
			int x = zm.curw.getCursorX();
			int y = zm.curw.getCursorY();
			for (int j = 0; j < height; j++)
				{
				zm.curw.moveCursor(x, y + j);
				for (int i = 0; i < width; i++)
					zm.printAsciiChar((char)zm.getByte(textpos++));
				textpos += skip;
				}
			}
		}

	class OP_CHECK_ARG_COUNT
			implements IOP
		{
		public void x()
			{
			doBranch(o[0] <= nargs);
			}
		}

	class OP_LOG_SHIFT
			implements IOP
		{
		public void x()
			{
			short n = (short)o[1];
			if (n >= 0)
				doStore(o[0] << n);
			else
				doStore(o[0] >>> -n);
			}
		}

	class OP_ART_SHIFT
			implements IOP
		{
		public void x()
			{
			short n = (short)o[1];
			if (n >= 0)
				doStore(o[0] << n);
			else
				doStore((short)o[0] >> -n);
			}
		}

	class OP_SET_FONT
			implements IOP
		{
		public void x()
			{
			ZWindow w = noperands < 2 ? zm.curw : zm.w[o[1]];
			doStore(w.setFont(o[0]));
			}
		}

	class OP_SAVE_UNDO
			implements IOP
		{
		public void x()
			{
			doStore(((ZMachine5)zm).saveUndo());
			}
		}

	class OP_RESTORE_UNDO
			implements IOP
		{
		public void x()
			{
			doStore(((ZMachine5)zm).restoreUndo());
			}
		}

	class OP_PRINT_UNICODE
			implements IOP
		{
		public void x()
			{
			int ch = zm.zc.fromUnicodeToZAscii((char)o[0]);
			if (ch != ZChars.INVALID)
				zm.printAsciiChar(ch);
			}
		}

	class OP_CHECK_UNICODE
			implements IOP
		{
		public void x()
			{
			int bits = 3; // bit 0 = outputable, 1 = inputable
			int ch = zm.zc.fromUnicodeToZAscii((char)o[0]);
			if (ch == ZChars.INVALID)
				bits &= ~2; // not inputable
			if (zm.zc.toOutput(ch) == 0)
				bits &= ~1; // not outputable
			doStore(bits);
			}
		}

	protected void doRead() // AREAD
			throws ZError
		{
		if (noperands < 3)
			o[2] = 0;
		if (noperands < 4)
			o[3] = 0;

		int tbuf = o[0];
		zm.curw.flush();
		zm.curw.resetLineCount();
		int tsize = zm.getByte(tbuf);
		if (tsize < 3)
			throw new ZError("Text buffer < 3 bytes");
		int count = zm.getByte(tbuf + 1);
		tsize -= count;
		int ch = ZChars.RETURN_CHAR;
		while (tsize-- > 0)
			{
			ch = zm.getInput(true, o[2], o[3]);
			if (ch == -1)
				throw new ZError(null); // terminating
			if (zm.zc.isTerminator(ch))
				break;
			if ((ch >= 'A') && (ch <= 'Z'))
				ch += 'a' - 'A';
			zm.setByte(tbuf + 2 + count++, ch);
			}
		zm.setByte(tbuf + 1, count);
		if (o[1] != 0)
			zm.zd.tokenize(tbuf + 2, count, o[1], true);
		doStore(ch);
		}

	protected void doSave()
		{
		if (noperands == 0)
			{
			super.doSave();
			return;
			}
		try
			{
			String fname = zm.getStringAt(o[2]).toUpperCase();
			if (fname.indexOf('.') == -1)
				fname += ".AUX";
			System.out.println("Writing " + fname);
			FileOutputStream f = new FileOutputStream(fname);
			f.write(zm.getMem(), o[0], o[1]);
			f.close();
			doStore(1);
			return;
			}
		catch (IOException e)
			{}
		catch (ZError e2)
			{}
		doStore(0);
		}

	protected void doRestore()
		{
		if (noperands == 0)
			{
			super.doRestore();
			return;
			}
		try
			{
			String fname = zm.getStringAt(o[2]).toUpperCase();
			if (fname.indexOf('.') == -1)
				fname += ".AUX";
			System.out.println("Reading " + fname);
			FileInputStream f = new FileInputStream(fname);
			f.read(zm.getMem(), o[0], o[1]);
			f.close();
			doStore(1);
			return;
			}
		catch (IOException e)
			{}
		catch (ZError e2)
			{}
		doStore(0);
		}

	protected void doEraseWindow()
		{
		short n = (short)o[0];
		if (n == SCREEN_UNSPLIT)
			{
			doSplitWindow(0);
			zm.s.clear();
			zm.w[0].moveCursor(1, 1);
			}
		else if (n == SCREEN_NOUNSPLIT)
			{
			zm.s.clear();
			zm.w[0].moveCursor(1, 1);
			zm.w[1].moveCursor(1, 1);
			}
		else
			{
			zm.w[o[0]].clear();
			zm.w[o[0]].moveCursor(1, 1);
			}
		}
	
	protected void loadParameters(int count)
		{
		for (int i = 0; i < count; i++)
			if (i < (noperands - 1))
				zm.l[i] = o[i + 1];
		}
	
	protected void doSetColour()
		{
		if (noperands < 3)
			zm.curw.setColor((short)o[0], (short)o[1]);
		else
			zm.w[o[2]].setColor((short)o[0], (short)o[1]);
		}
	}