package zpplet.system;

import java.awt.*;

public class ZColor
	{
	public final static int Z_UNDERCURSOR = -1;
	public final static int Z_CURRENT = 0;
	public final static int Z_DEFAULT = 1;
	public final static int Z_BLACK = 2;
	public final static int Z_RED = 3;
	public final static int Z_GREEN = 4;
	public final static int Z_YELLOW = 5;
	public final static int Z_BLUE = 6;
	public final static int Z_MAGENTA = 7;
	public final static int Z_CYAN = 8;
	public final static int Z_WHITE = 9;
	public final static int Z_LIGHTGRAY = 10;
	public final static int Z_GRAY = 11;
	public final static int Z_DARKGRAY = 12;
	public final static int Z_TRANSPARENT = 15;

	final static int INITIAL_FG_COLOR = ZColor.Z_LIGHTGRAY;
	final static int INITIAL_BG_COLOR = ZColor.Z_BLACK;
	public static ZColor def = new ZColor(INITIAL_FG_COLOR, INITIAL_BG_COLOR);

	/*
	 * Standard 1.1 equivalences (true colors are 5 bits x 3) 
	 * -1 = sample (true -3) [V6 only] 
	 * 0 = current (true -2) 
	 * 1 = default (true -1) 
	 * 2 = black (true $0000, $$0000000000000000) 
	 * 3 = red (true $001D, $$0000000000011101) 
	 * 4 = green (true $0340, $$0000001101000000) 
	 * 5 = yellow (true $03BD, $$0000001110111101) 
	 * 6 = blue (true $59A0, $$0101100110100000) 
	 * 7 = magenta (true $7C1F, $$0111110000011111) 
	 * 8 = cyan (true $77A0, $$0111011110100000) 
	 * 9 = white (true $7FFF, $$0111111111111111) 
	 * 10 = light grey (true $5AD6, $$0101101011010110) 
	 * 11 = medium grey (true $4631, $$0100011000110001) 
	 * 12 = dark grey (true $2D6B, $$0010110101101011) 
	 * 13 reserved 
	 * 14 reserved 
	 * 15 = transparent (true -4) [V6 only]
	 */

	public int zfg, zbg;
	public Color fg, bg;

	public ZColor()
		{
		zfg = def.zfg;
		zbg = def.zbg;
		fg = def.fg;
		bg = def.bg;
		}

	public ZColor(int fg, int bg)
		{
		setZColor(fg, bg);
		}

	static public void setDefaultForeground(String name)
		{
		def.setZColor(getZColor(name), Z_CURRENT);
		}

	static public void setDefaultBackground(String name)
		{
		def.setZColor(Z_CURRENT, getZColor(name));
		}

	public void setZColor(int fore, int back)
		{
		if (fore != Z_CURRENT)
			{
			if (fore == Z_DEFAULT)
				zfg = def.zfg;
			else
				zfg = fore;
			this.fg = getColor(zfg);
			}
		if (back != Z_CURRENT)
			{
			if (back == Z_DEFAULT)
				zbg = def.zbg;
			else
				zbg = back;
			this.bg = getColor(zbg);
			}
		}

	private static Color getColor(int number)
		{
		switch (number)
			{
			case Z_BLACK:
				return Color.black;
			case Z_RED:
				return Color.red.darker();
			case Z_GREEN:
				return Color.green.darker();
			case Z_YELLOW:
				return Color.yellow;
			case Z_BLUE:
				return Color.blue.darker();
			case Z_MAGENTA:
				return Color.magenta;
			case Z_CYAN:
				return Color.cyan;
			case Z_WHITE:
				return Color.white;
			case Z_LIGHTGRAY:
				return Color.lightGray;
			case Z_GRAY:
				return Color.gray;
			case Z_DARKGRAY:
				return Color.darkGray;
			case Z_TRANSPARENT:
				return null;
			default:
				System.err.println("getColor(" + number + ") attempted");
				return Color.black;
			}
		}

	private static int getZColor(String name)
		{
		if (name.equalsIgnoreCase("black"))
			return Z_BLACK;
		if (name.equalsIgnoreCase("red"))
			return Z_RED;
		if (name.equalsIgnoreCase("green"))
			return Z_GREEN;
		if (name.equalsIgnoreCase("yellow"))
			return Z_YELLOW;
		if (name.equalsIgnoreCase("blue"))
			return Z_BLUE;
		if (name.equalsIgnoreCase("magenta"))
			return Z_MAGENTA;
		if (name.equalsIgnoreCase("cyan"))
			return Z_CYAN;
		if (name.equalsIgnoreCase("white"))
			return Z_WHITE;
		if (name.equalsIgnoreCase("lightgray"))
			return Z_LIGHTGRAY;
		if (name.equalsIgnoreCase("gray"))
			return Z_GRAY;
		if (name.equalsIgnoreCase("darkgray"))
			return Z_DARKGRAY;
		System.err.println("Unknown color name '" + name + "'");
		return Z_DEFAULT;
		}
	}