package zpplet.system;

import java.io.*;
import java.awt.*;

import javax.sound.sampled.*;
import javax.imageio.*;
import java.awt.image.*;
import com.sun.media.sound.AiffFileReader;

import zpplet.iff.*;
import zpplet.ZUserConfig;
import zpplet.machine.ZMachine;

// TODO: png palette handling
// TODO: IFhd header matching
// NOTE: does not cache

public class ZMedia
		implements LineListener
	{
	private IFFInput iff;
	private Object[] pics; // Image, Dimension, or null
	private byte[][] sounds; // byte[] or null
	private int[] loops; // loops for V3
	private Clip clip; // currently playing sample
	private short release;
	private byte[] zimage;

	private class ResourceInfo
		{
		public ResourceInfo(String u, int i, int s)
			{
			usage = u;
			index = i;
			start = s;
			}

		public String usage;
		public int index;
		public int start;
		}

	public ZMedia()
		{}

	public boolean readBlorbFile(String fname)
		{
		try
			{
			iff = new IFFInput(fname);
			IFF.ChunkInfo ci = iff.openChunk();
			if (!ci.type.equals("FORMIFRS")) throw new IOException("Not a valid Blorb file");
			if (iff.skipToChunk("RIdx") == null) throw new IOException("Missing Blorb index chunk");
			int nResources = iff.readInt();

			// count Pict/Snd resources
			ResourceInfo[] info = new ResourceInfo[nResources];
			int maxpics = 0, maxsounds = 0;
			for (int i = 0; i < nResources; i++)
				{
				String usage = iff.read4Chars();
				int index = iff.readInt();
				int start = iff.readInt();
				info[i] = new ResourceInfo(usage, index, start);

				if (usage.equals("Pict"))
					{
					if (maxpics < index) maxpics = index;
					}
				else if (usage.equals("Snd "))
					{
					if (maxsounds < index) maxsounds = index;
					}
				}
			iff.closeChunk();

			pics = new Object[maxpics + 1];
			sounds = new byte[maxsounds + 1][];

			// load resources
			for (int i = 0; i < nResources; i++)
				{
				ResourceInfo ri = info[i];
				if (ri.usage.equals("Pict"))
					pics[ri.index] = loadImage(ri.start);

				else if (ri.usage.equals("Snd ")) sounds[ri.index] = loadSound(ri.start);
				}

			// look for loop data
			if ((ci = iff.skipToChunk("Loop")) != null)
				{
				loops = new int[maxsounds + 1];
				for (int i = 0; i < loops.length; i++)
					loops[i] = 1;
				for (int i = 0; i < ci.length / 8; i++)
					{
					int n = iff.readInt(); // sample #
					loops[n] = iff.readInt(); // loops (0 = forever)
					}
				iff.closeChunk();
				}
			
			if ((ci = iff.skipToChunk("RelN")) != null)
				{
				release = iff.readShort();
				iff.closeChunk();
				}
			else
				release = 0;
			
			if ((ci = iff.skipToChunk("ZCOD")) != null)
				{
				zimage = new byte[ci.length];
				iff.read(zimage, 0, ci.length);
				iff.closeChunk();
				}
			else
				zimage = null;

			iff.close();
			}
		catch (Exception e)
			{
			//e.printStackTrace();
			return false;
			}
		return true;
		}
	
	public ZMachine getZM(ZScreen s)
		{
		if (zimage == null)
			return null;
		return ZMachine.NewZMachine(zimage, s);
		}

	public int getPictureCount()
		{
		return pics.length + 1;
		}
	
	public short getRelease()
		{
		return release;
		}

	private byte[] loadSound(int start)
			throws Exception
		{
		byte[] result;
		iff.seek(start);
		IFF.ChunkInfo ci = iff.openChunk();

		if (ci.type.equals("FORMAIFF"))
			{
			result = new byte[ci.length];
			iff.seek(start);
			iff.read(result);
			}

		else
			{
			result = null;
			System.err.println("Unsupported sound type " + ci.type);
			}

		iff.closeChunk();
		return result;
		}

	private Object loadImage(int start)
			throws Exception
		{
		Object result;
		iff.seek(start);
		IFF.ChunkInfo ci = iff.openChunk();

		// TODO: handle PNG palette
		if (ci.type.equals("PNG "))
			{
			byte[] image = new byte[ci.length];
			iff.read(image);
			ByteArrayInputStream ba = new ByteArrayInputStream(image);
			BufferedImage bi = ImageIO.read(ba);
			if (ZUserConfig.v6scale != 1)
				result = bi.getScaledInstance(bi.getWidth() * ZUserConfig.v6scale, -1, Image.SCALE_SMOOTH);
			else
				result = bi;
			}

		else if (ci.type.equals("JPEG"))
			{
			byte[] image = new byte[ci.length];
			iff.read(image);
			ByteArrayInputStream ba = new ByteArrayInputStream(image);
			BufferedImage bi = ImageIO.read(ba);
			if (ZUserConfig.v6scale != 1)
				result = bi.getScaledInstance(bi.getWidth() * ZUserConfig.v6scale, -1, Image.SCALE_SMOOTH);
			else
				result = bi;
			}

		else if (ci.type.equals("Rect"))
			result = new Dimension(iff.readInt() * ZUserConfig.v6scale, iff.readInt() * ZUserConfig.v6scale);

		else
			{
			result = null;
			System.err.println("Invalid image type " + ci.type);
			}

		return result;
		}

	public void update(LineEvent event)
		{
		if (event.getType() == LineEvent.Type.STOP)
			{
			clip.removeLineListener(this);
			clip.close();
			clip = null;
			}
		}
	
	private int getLoops(int index)
		{
		if (loops == null) return 1;
		if (loops[index] == 0) return 255;
		return loops[index];
		}
	
	public static void beep(int n)
		{
		// NOTE: should have distinct high/low beeps...
		Toolkit.getDefaultToolkit().beep();
		}
	
	public void playSound(int n, int vol, int loops)
		{
		stopSound();

		if ((n < 0) || (n >= sounds.length) || (sounds[n] == null))
			{
			System.err.println("Tried to play invalid sound " + n);
			return;
			}

		try
			{
			ByteArrayInputStream ba = new ByteArrayInputStream(sounds[n]);
			AiffFileReader fr = new AiffFileReader();
			AudioInputStream as = fr.getAudioInputStream(ba);
			clip = AudioSystem.getClip();

			clip.open(as);
			clip.addLineListener(this);
			FloatControl gain = (FloatControl)clip.getControl(FloatControl.Type.MASTER_GAIN);
			
			if (vol < 8)
				gain.setValue(vol - 8);
			if (loops == 0)
				loops = getLoops(n);
			clip.loop(loops == 255 ? Clip.LOOP_CONTINUOUSLY : loops - 1);
			}
		catch (Exception e)
			{
			System.err.println("playSound() error: " + e.getMessage());
			}
		}
	
	public void stopSound()
		{
		if (clip != null)
			{
			clip.stop();
			while (clip != null)
				{}
			}
		}

	public Image getImage(int index)
		{
		return (Image)pics[index];
		}

	public Dimension getImageData(int index)
		{
		Object p = pics[index];
		if (p instanceof Image)
			return new Dimension(((Image)p).getWidth(null), ((Image)p).getHeight(null));

		if (p instanceof Dimension)
			return (Dimension)p;

		return null;
		}
	
	public void cacheSound(int index)
		{
		// not used...
		}
	
	public void uncacheSound(int index)
		{
		// 0 = all
		stopSound();
		}
	}