unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, jpeg;

type
  TDecoder = class(TForm)
    RadioColor: TRadioGroup;
    RadioNumber: TRadioGroup;
    AccessCodeOutput: TEdit;
    Label1: TLabel;
    StaticText1: TStaticText;
    procedure InitDecoder(Sender: TObject);
    procedure GetColor(Sender: TObject);
    procedure GetNumber(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Decoder: TDecoder;
  ColorSelected: boolean;
  NumberSelected: boolean;
  AccessCode: array [0..31] of ShortString;

procedure DisplayAccessCode;

implementation

{$R *.dfm}

procedure TDecoder.InitDecoder(Sender: TObject);
begin
  ColorSelected := false;
  NumberSelected := false;
  AccessCode[0] := '12';
  AccessCode[1] := '66';
  AccessCode[2] := '73';
  AccessCode[3] := '36';
  AccessCode[4] := '90';
  AccessCode[5] := '41';
  AccessCode[6] := '19';
  AccessCode[7] := '48';
  AccessCode[8] := '62';
  AccessCode[9] := '92';
  AccessCode[10] := '55';
  AccessCode[11] := '23';
  AccessCode[12] := '84';
  AccessCode[13] := '99';
  AccessCode[14] := '57';
  AccessCode[15] := '20';
  AccessCode[16] := '78';
  AccessCode[17] := '67';
  AccessCode[18] := '51';
  AccessCode[19] := '88';
  AccessCode[20] := '17';
  AccessCode[21] := '31';
  AccessCode[22] := '70';
  AccessCode[23] := '39';
  AccessCode[24] := '96';
  AccessCode[25] := '25';
  AccessCode[26] := '81';
  AccessCode[27] := '83';
  AccessCode[28] := '47';
  AccessCode[29] := '54';
  AccessCode[30] := '13';
  AccessCode[31] := '43'
end;

procedure TDecoder.GetColor(Sender: TObject);
begin
  ColorSelected := true;
  if ColorSelected and NumberSelected then
    DisplayAccessCode
end;

procedure TDecoder.GetNumber(Sender: TObject);
begin
  NumberSelected := true;
  if ColorSelected and NumberSelected then
  DisplayAccessCode
end;

procedure DisplayAccessCode;
var
  BaseIndex: integer;
  Offset: integer;
  AccessIndex: integer;
begin
  BaseIndex := Decoder.RadioNumber.ItemIndex;
  Offset := Decoder.RadioColor.ItemIndex * 2;
  AccessIndex := (BaseIndex + Offset) MOD 32;
  Decoder.AccessCodeOutput.Text := AccessCode[AccessIndex]
end;

end.
