//===========================================================================
// Copyright  1998 Thin Air Enterprises and Robert Dunn
//===========================================================================
//---------------------------------------------------------------------------
#ifndef RichEdit20H
#define RichEdit20H
//---------------------------------------------------------------------------
#ifdef _RICHEDIT_VER
#undef _RICHEDIT_VER
#endif
#define _RICHEDIT_VER	0x0200

#include <vcl\Controls.hpp>
#include <vcl\Classes.hpp>
#include <vcl\Forms.hpp>
#include <vcl\SysUtils.hpp>
#include <vcl\ComCtrls.hpp>
#include <vcl\StdCtrls.hpp>

#include <vector>
#include <values.h>
#include <jpeg.hpp>

#include "richedit20format.h"
#include "pngimage.hpp"

//---------------------------------------------------------------------------
struct HYPERTEXT{
  int start,end;
  int linkval;};
                                        
// need to change to derive from TCustomRichEdit and publish only
// those properties desired -- for example, this code will probably
// end up with a different implementation of tabs
//
class TRichEdit20 : public TRichEdit
{
private:
	int FLibHandle;

  unsigned int start_count;
  int lmargin,rmargin;

  TNotifyEvent FOnVertScroll;
  MESSAGE void __fastcall CNCommand(TMessage &Msg);
  MESSAGE void __fastcall WMVScroll(TMessage &Msg);
  void __fastcall OnFocus(TObject *Sender);
  void __fastcall on_MouseDown(TObject *Sender,TMouseButton Button,TShiftState Shift,int X,int Y);
  void __fastcall on_SelectionChange(TObject *Sender);
  void __fastcall on_MouseWheel(TObject *Sender,TShiftState shift,int WheelDelta,const TPoint &MousePos,bool &Handled);
	bool __fastcall InsertPicture(Graphics::TBitmap *bitmap,bool below_baseline);
  void __fastcall on_wheel_up(TObject *Sender,TShiftState Shift,const TPoint &MousePos,bool &Handled);
  void __fastcall on_wheel_down(TObject *Sender,TShiftState Shift,const TPoint &MousePos,bool &Handled);

protected:
	TNotifyEvent FOnUrlClick;
	TTextAttributes2* FSelAttributes2;
	TTextAttributes2* FDefAttributes2;
	TParaAttributes2* FParaAttributes2;

#ifdef USERICHEDITOLE
	TIRichEditOle* FRichEditOle;
#endif

	virtual void __fastcall CreateParams(Controls::TCreateParams &Params);
	virtual void __fastcall DestroyWnd(void);
	virtual void __fastcall CreateWnd(void);
//	__property WordWrap;			// hide property (still visible in editor?)

	void __fastcall SetSelAttributes2(TTextAttributes2* attr);
	void __fastcall SetDefAttributes2(TTextAttributes2* attr);

public:
	__fastcall TRichEdit20(TComponent* Owner,int tag,int left_margin,int right_margin,bool borders,bool scrollbar);
	__fastcall ~TRichEdit20();

	bool FindTextEx(WideString text, int startPos, TFindOptions findOptions,
		int& foundPos, int& length);

	virtual void __fastcall RecreateWnd(void);	// not virtual in base!!!

	TRect TwipsToTargetRect(HDC hdc, TRect rect);

	__property TTextAttributes2* SelAttributes2 = { read = FSelAttributes2, write = SetSelAttributes2, default = 0};
	__property TTextAttributes2* DefAttributes2 = { read = FDefAttributes2, write = SetDefAttributes2, default = 0};
	__property TParaAttributes2* Paragraph2 = { read = FParaAttributes2, write = FParaAttributes2, default = 0 };

  void add_to_hist(String command);
  void retrieve_hist(int pos);
  void __fastcall post_output();
  void clear(TColor color);
  bool insert_picture(TGraphic *picture,int width,int height,bool below_baseline);

  TStringList *history;
  int hist_pos;
  CHARRANGE input_pos;
  bool had_output;
  HYPERTEXT hypertext[100];
  int hyper_count;
  bool hyper_active;
  bool sel_change;
};
//---------------------------------------------------------------------------
#endif
//===========================================================================
// Copyright  1998 Thin Air Enterprises and Robert Dunn
//===========================================================================
