/* support.c
 *
 *  foblub -- a Z-machine for TI calculators
 *  based on pinfocom by InfoTaskForce and Paul Smith
 *  Ported and extended by Nils Gesbert, 2003
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; see the file COPYING.  If not, write to the
 *  Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <string.h>
#include <ctype.h>
#ifndef NO_SIGNALS
#include <signal.h>
#endif

#include "infocom.h"

inline void
null()
{
    /* The NULL function */
}

void
change_status()
{

    stack_var_ptr = stack = stack_base - 1;

    pbf_p->len = 0;
    pc_page = 0;
    pc_offset = data_head.game_o;
    fix_pc();

}

void
restart()
{
    header_t header;
    unsigned int i;
    scr_setup();
    new_line();
    /* conserver le contenu du header... */
    header = data_head;
    for (i = 0; i < data_head.save_bytes / BLOCK_SIZE + 1; i++)
      load_page(i, base_ptr + i * BLOCK_SIZE);
    data_head = header;
    change_status();
}

__attribute__ ((noreturn)) void
quit()
{
  if (base_ptr) free (base_ptr);
  if (pg_table) free (pg_table);
  if (text.buf) free (text.buf);
  if (room.buf) free (room.buf);
  if (stack_base) free (stack_base - STACK_SIZE / 2);
#ifdef DEBUG2
  ngetchx();
#endif
  if (sauvegarde_ecran) LCD_restore (sauvegarde_ecran);
  exit (0);
}

inline void
verify()
{
  ret_value(1); /* Qui peut bien vouloir s'amuser  calculer des checksums ? */
}

void
store A1(word, value)
{
    /*extern word     *stack;*/

    word            var;

    NEXT_BYTE(var);
    if (var == 0)
        *(--stack) = value;
    else
        put_var(var, value);
}

void
ret_value A1(word, result)
{
    /*extern word     pc_offset;*/

    word    branch;

    NEXT_BYTE(branch);

    /* Test bit 7 */
    if ((branch & 0x80) != 0)
    {
        /* Clear bit 7 */
        branch &= 0x7F;
        ++result;
    }

    /* Test bit 6 */
    if ((branch & 0x40) == 0)
    {
        byte b;

        NEXT_BYTE(b);
        branch = (branch << 8) + b;
        /* Test bit D. If set, make branch negative. */
        if (branch & 0x2000)
            branch |= 0xC000;
    }
    else
        /* Clear bit 6 */
        branch &= 0xBF;

    if ((--result) != 0)
    {
        switch (branch)
        {
            case 0 :    rtn(0);
                        break;
            case 1 :    rtn(1);
                        break;
            default :   pc_offset += ((signed) branch) - 2;
                        fix_pc();
        }
    }
}

byte get_byte (unsigned long address) {
  
  return (address < data_head.resident_bytes ? base_ptr[address]
	  : fetch_page(address / BLOCK_SIZE)[address % BLOCK_SIZE]);
}

word get_word (unsigned long address) {
  word temp = get_byte(address++) << 8;
  return ((word)(temp | get_byte(address)));
}

word get_aligned_word (unsigned long address) {

  return (*(word*)(address < data_head.resident_bytes ? base_ptr + address
		   : fetch_page(address / BLOCK_SIZE) + address % BLOCK_SIZE));
}

word
next_word()
{
    word    temp;
    byte    b;

    NEXT_BYTE(b);
    temp = b << 8;
    NEXT_BYTE(b);
    return ((word)(temp | b));
}

__attribute__ ((noreturn)) void
error A2(const char *, buffer, int, value)
{
  char    buf[81];

  sprintf(buf, buffer, value);
  ecrit_texte (FRENCH ? "[Erreur : " : "Error: "); 
  ecrit_texte (buf);
  scr_putline (FRENCH ? " -- appuyez sur une touche]" : " --press a key]");
  ngetchx(); /* a va quitter, faut qu'on puisse lire le message */
  quit();
}
