/******************************************************************************
*
* project name:    TIGCC Tools Suite
* file name:       ttunpack.h
* initial date:    01/02/2001
* author:          thomas.nussbaumer@gmx.net
*
* description:     defines for exepack functionalities including unpack routine
*                  (complete rewrite of TIGCC Tools Suite header file)
*
* $Id: ttunpack.h,v 1.5 2002/05/22 08:54:45 tnussb Exp $
*
******************************************************************************/

#ifndef __TTUNPACK_H__
#define __TTUNPACK_H__

typedef struct {
    unsigned char  osize_lo;   // original size lowbyte
    unsigned char  osize_hi;   // original size highbyte
    unsigned char  magic1;     // must be equal to TTUNPACK_MAGIC1
    unsigned char  magic2;     // must be equal to TTUNPACK_MAGIC2
    unsigned char  csize_lo;   // compressed size lowbyte
    unsigned char  csize_hi;   // compressed size lowbyte
    unsigned char  esc1;       // escape >> (8-escBits)
    unsigned char  notused3;
    unsigned char  notused4;
    unsigned char  esc2;       // escBits
    unsigned char  gamma1;     // maxGamma + 1
    unsigned char  gamma2;     // (1<<maxGamma)
    unsigned char  extralz;    // extraLZPosBits
    unsigned char  notused1;
    unsigned char  notused2;
    unsigned char  rleentries; // rleUsed
} TTUNPACK_HEADER;

#define TTUNPACK_MAGIC1 0x54
#define TTUNPACK_MAGIC2 0x50

#define ttunpack_size(_p_)  ((unsigned short)(((TTUNPACK_HEADER*)(_p_))->osize_lo | (((TTUNPACK_HEADER*)(_p_))->osize_hi << 8)))
#define ttunpack_valid(_p_) (((TTUNPACK_HEADER*)(_p_))->magic1 == TTUNPACK_MAGIC1 && ((TTUNPACK_HEADER*)(_p_))->magic2 == TTUNPACK_MAGIC2)

#define TTUNPACK_OKAY             0
#define TTUNPACK_NOESCFOUND     248
#define TTUNPACK_ESCBITS        249
#define TTUNPACK_MAXGAMMA       250
#define TTUNPACK_EXTRALZP       251
#define TTUNPACK_NOMAGIC        252
#define TTUNPACK_OUTBUFOVERRUN  253
#define TTUNPACK_LZPOSUNDERRUN  254

#if 1
#define ttunpack_decompress \
((__attribute__ ((stkparm)) unsigned short(*)(unsigned char*,unsigned char*))(unsigned short[]){\
0x48e7,0x7ffa,0x4fef,0xffe8,0x206f,0x0050,0x0c28,0x0054,0x0002,0x6608,\
0x0c28,0x0050,0x0003,0x6708,0x303c,0x00fc,0x6000,0x0264,0x4286,0x1c28,\
0x0006,0x4247,0x1e28,0x0009,0x4245,0x1a28,0x000a,0x5345,0x4240,0x1028,\
0x000c,0x3c40,0x7201,0xeb69,0x3f41,0x000e,0x7002,0xeb68,0x3f40,0x000c,\
0x7208,0x9245,0x3f41,0x000a,0x7008,0x9047,0x3840,0x303c,0x00f9,0x0c47,\
0x0008,0x6200,0x021e,0x4240,0x1028,0x000b,0xb06f,0x000e,0x660c,0x0c45,\
0x0004,0x6306,0x0c45,0x0007,0x6308,0x303c,0x00fa,0x6000,0x01fe,0x7204,\
0xb24e,0x6408,0x303c,0x00fb,0x6000,0x01f0,0x43e8,0x000f,0x2f49,0x0010,\
0x266f,0x0054,0x43fa,0x01ea,0x2f49,0x0006,0x226f,0x0010,0x4280,0x1011,\
0x41f0,0x0810,0x226f,0x0006,0x2288,0x41fa,0x01d4,0x2f48,0x0002,0x30bc,\
0x0080,0x3606,0x4a47,0x670c,0x3f07,0x41fa,0x0274,0x4e90,0x3600,0x548f,\
0x3043,0xbc88,0x6600,0x018c,0x3f05,0x45fa,0x021a,0x4e92,0x3800,0x426f,\
0x0002,0x548f,0x0c44,0x0001,0x6754,0x3f05,0x4e92,0x3600,0x5343,0x302f,\
0x000e,0x5540,0x548f,0xb043,0x6618,0x0c44,0x0003,0x6300,0x0170,0x45fa,\
0x017e,0x4e92,0x3f40,0x0000,0x4e92,0x6000,0x0120,0x300e,0x6710,0x3f0e,\
0x41fa,0x021a,0x4e90,0x320e,0xe36b,0x8640,0x548f,0x41fa,0x015a,0x4e90,\
0x0a40,0x00ff,0x3203,0xe149,0x8240,0x6000,0x00fe,0x226f,0x0006,0x2051,\
0x4240,0x1010,0x206f,0x0002,0x3210,0xc041,0x6700,0x00ca,0xe219,0x6402,\
0x5291,0x3081,0x2051,0x4240,0x1010,0xc041,0x6630,0x3001,0xe218,0x6402,\
0x5291,0x226f,0x0002,0x3280,0x3f07,0x45fa,0x01c0,0x4e92,0x3600,0x3f0c,\
0x4e92,0x320c,0x48c1,0xe3ae,0x8c00,0x16c6,0x4286,0x3c03,0x588f,0x6000,\
0xff26,0x3001,0xe218,0x6402,0x5291,0x206f,0x0002,0x3080,0x3f05,0x4e92,\
0x3600,0x548f,0xb66f,0x000e,0x6522,0x3f2f,0x000a,0x41fa,0x0180,0x4e90,\
0x966f,0x0010,0x322f,0x000c,0xe36b,0x8640,0x3f05,0x4e92,0x5340,0xe148,\
0x8640,0x588f,0x3f05,0x4e92,0x3800,0x548f,0x0c44,0x001f,0x6210,0x4280,\
0x3004,0x206f,0x0010,0x1230,0x0800,0x4881,0x6016,0x3f3c,0x0003,0x41fa,\
0x0140,0x4e90,0x3204,0x0641,0xffe0,0xe749,0x8240,0x548f,0x4242,0xb642,\
0x6500,0xfeac,0x16c1,0x5242,0xb642,0x64f8,0x6000,0xfea0,0x3001,0x226f,\
0x0006,0xe218,0x6402,0x5291,0x206f,0x0002,0x3080,0x41fa,0x0056,0x4e90,\
0x3200,0x0a41,0x00ff,0x4242,0xb842,0x6500,0xfe7a,0x4280,0x3001,0x204b,\
0x91c0,0x102f,0x0001,0xd028,0xffff,0x16c0,0x5242,0xb842,0x64e8,0x6000,\
0xfe5e,0x3f0c,0x41fa,0x00d6,0x4e90,0x320c,0xe36b,0x8600,0x16c3,0x548f,\
0x6000,0xfe48,0x4240,0x4fef,0x0018,0x4cdf,0x5ffe,0x4e75,0x0000,0x0000,\
0x0000,0x41fa,0xfff8,0x2250,0x4240,0x1019,0x2089,0x323a,0xfff0,0x0c01,\
0x0080,0x6602,0x4e75,0xe148,0x1011,0x0c01,0x0008,0x6212,0x6630,0x0240,\
0x0fff,0xe848,0x4e75,0x0240,0x7fff,0xee48,0x4e75,0x0c01,0x0020,0x62f2,\
0x6508,0x0240,0x3fff,0xec48,0x4e75,0x0240,0x1fff,0xea48,0x4e75,0x0240,\
0x07ff,0xe648,0x4e75,0x0c01,0x0002,0x62f2,0x6608,0x0240,0x03ff,0xe448,\
0x4e75,0x0240,0x01ff,0xe248,0x4e75,0x2f03,0x4281,0x302f,0x0008,0x207a,\
0xff84,0x343a,0xff84,0xb041,0x6312,0x3602,0xc610,0xe21a,0x6402,0x5288,\
0x4a03,0x6704,0x5241,0x60ea,0x2608,0x41fa,0xff64,0x2083,0x41fa,0xff62,\
0x3082,0x2043,0x7601,0xe36b,0x3f01,0x6108,0x544f,0x8043,0x261f,0x4e75,\
0x4240,0x322f,0x0004,0x6730,0x207a,0xff3e,0x2243,0x343a,0xff3c,0x5341,\
0xe348,0x3602,0xc610,0x6702,0x5200,0xe21a,0x6402,0x5288,0x51c9,0xffee,\
0x2609,0x43fa,0xff20,0x3282,0x43fa,0xff16,0x2288,0x2243,0x4e75})

#else

// BUGGY VERSION - DON'T USE!!!

#define ttunpack_decompress ((unsigned short(*)(unsigned char*,unsigned char*))(unsigned short[]){\
0x4fef,0xfff4,0x48e7,0x1f3a,0x226f,0x0034,0x266f,0x0038,0x0c29,0x0054,\
0x0002,0x6708,0x303c,0x00fc,0x6000,0x023a,0x0c29,0x0050,0x0003,0x66f0,\
0x0c29,0x0008,0x000a,0x6708,0x303c,0x00fa,0x6000,0x0222,0x0c29,0x0080,\
0x000b,0x66f0,0x4247,0x1e29,0x0009,0x303c,0x00f9,0x0c47,0x0008,0x6200,\
0x0208,0x4240,0x1029,0x000c,0x3c40,0x303c,0x00fb,0x7204,0xb24e,0x6500,\
0x01f4,0x4243,0x1629,0x0006,0x3f43,0x002a,0x7808,0x9847,0x3844,0x41e9,\
0x000f,0x2f48,0x0026,0x7000,0x1010,0x41fa,0x01de,0x43f1,0x0810,0x2089,\
0x41fa,0x01d8,0x30bc,0x0080,0x3a2f,0x002a,0x4a47,0x670a,0x3207,0x41fa,\
0x0278,0x4e90,0x3a00,0xba6f,0x002a,0x671a,0x320c,0xe36d,0x244b,0x528b,\
0x380c,0x3204,0x41fa,0x025e,0x4e90,0x3600,0x8a03,0x1485,0x60ce,0x95ca,\
0x41fa,0x020c,0x4e90,0x3c00,0x0c46,0x0001,0x6774,0x41fa,0x01fe,0x4e90,\
0x3800,0x5344,0x0c44,0x00fe,0x6740,0x300e,0x6710,0xe16c,0x3a0e,0x3205,\
0x41fa,0x0226,0x4e90,0x3600,0x8843,0x41fa,0x016e,0x4e90,0x3600,0x0a43,\
0x00ff,0xe14c,0x8644,0x4241,0x7000,0x3003,0x204b,0x91c0,0x300a,0xd028,\
0xffff,0x16c0,0x5241,0xbc41,0x64ea,0x6000,0xff70,0x0c46,0x0003,0x6318,\
0x41fa,0x013c,0x4e90,0x3a00,0x3445,0x41fa,0x0132,0x4e90,0x3600,0x0a43,\
0x00ff,0x60c6,0x4240,0x6000,0x0110,0x207a,0x0116,0x4240,0x1010,0xc07a,\
0x0112,0x6620,0x41fa,0x0108,0x43fa,0x0108,0x3211,0xe219,0x6402,0x5290,\
0x3281,0x41fa,0x00fe,0x4e90,0x3600,0x0a43,0x00ff,0x6092,0x41fa,0x00e8,\
0x43fa,0x00e8,0x3211,0xe219,0x6402,0x5290,0x3281,0x207a,0x00d6,0x4240,\
0x1010,0xc07a,0x00d2,0x6700,0x0086,0x41fa,0x00c6,0x43fa,0x00c6,0x3211,\
0xe219,0x6402,0x5290,0x3281,0x41fa,0x0128,0x4e90,0x3600,0x3a03,0x0c43,\
0x007f,0x6320,0x0645,0xff80,0xe34d,0x3206,0x41fa,0x0152,0x4e90,0x3600,\
0x8a43,0x41fa,0x0106,0x4e90,0x3600,0x5343,0xe14b,0x8a43,0x41fa,0x00f8,\
0x4e90,0x3600,0x0c43,0x001f,0x621c,0x7000,0x3003,0x206f,0x0026,0x4244,\
0x1830,0x0800,0x4241,0x16c4,0x5241,0xba41,0x64f8,0x6000,0xfe90,0x3803,\
0x0644,0xffe0,0xe74c,0x7603,0x3203,0x41fa,0x0104,0x4e90,0x3600,0x8843,\
0x60da,0x41fa,0x0042,0x43fa,0x0042,0x3211,0xe219,0x6402,0x5290,0x3281,\
0x3207,0x41fa,0x00e4,0x4e90,0x3800,0x3c0c,0xed6d,0x244b,0x528b,0x3206,\
0x41fa,0x00d2,0x4e90,0x3600,0x8a03,0x1485,0x3f44,0x002a,0x6000,0xfe3e,\
0x4cdf,0x5cf8,0x4fef,0x000c,0x4e75,0x0000,0x0000,0x0000,0x4e75,0x41fa,\
0xfff6,0x2250,0x4240,0x1019,0x2089,0x323a,0xffee,0x0c01,0x0080,0x6602,\
0x4e75,0xe148,0x1011,0x0c01,0x0008,0x6212,0x6630,0x0240,0x0fff,0xe848,\
0x4e75,0x0240,0x7fff,0xee48,0x4e75,0x0c01,0x0020,0x62f2,0x6508,0x0240,\
0x3fff,0xec48,0x4e75,0x0240,0x1fff,0xea48,0x4e75,0x0240,0x07ff,0xe648,\
0x4e75,0x0c01,0x0002,0x62f2,0x6608,0x0240,0x03ff,0xe448,0x4e75,0x0240,\
0x01ff,0xe248,0x4e75,0x2f03,0x7200,0x303c,0x0007,0x207a,0xff82,0x343a,\
0xff82,0xb041,0x6312,0x3602,0xc610,0xe21a,0x6402,0x5288,0x4a03,0x6704,\
0x5241,0x60ea,0x2608,0x41fa,0xff62,0x2083,0x5888,0x3082,0x7601,0xe36b,\
0x41fa,0x000a,0x4e90,0x8043,0x261f,0x4e75,0x4240,0x4a41,0x672c,0x207a,\
0xff42,0x2243,0x343a,0xff40,0x5341,0xe348,0x3602,0xc610,0x6702,0x5200,\
0xe21a,0x6402,0x5288,0x51c9,0xffee,0x2609,0x43fa,0xff20,0x2288,0x5889,\
0x3282,0x4e75})
#endif

#endif
//=============================================================================
// Revision History
//=============================================================================
//
// $Log: ttunpack.h,v $
// Revision 1.5  2002/05/22 08:54:45  tnussb
// stepped back to old ttunpack code
//
// Revision 1.4  2002/03/28 21:17:28  tnussb
// project name in header changed to TIGCC Tools Suite
//
// Revision 1.3  2002/03/13 15:09:58  tnussb
// new exepack decompression function generated from old/unpack.c added
// (its a little bit smaller now). The new function should work as the old one,
// but if there are problems I will leave the old hexcode array here, too
//
// Revision 1.2  2001/02/05 20:33:01  Thomas Nussbaumer
// (1) magic of ttunpack header splitted again into 2 bytes to prevent address errors
// (2) new (stable?) pc-relative version of unpacking routine
//
//
