// ----------------------------------------------------------------------------
// DS Frotz
// 	
// description	:	DS version of GBA Frotz 
//					made with PAlib - www.palib.com -
//
// ----------------------------------------------------------------------------
// (c) 2006 papafuji - using PAlib
// ----------------------------------------------------------------------------

// ----------------------------------------------------------------------------
// PAlib Includes
// ----------------------------------------------------------------------------

#include <PA9.h>

// ----------------------------------------------------------------------------
// XFlib Includes
// ----------------------------------------------------------------------------

#include "main.h"
#include "draw.h"
#include "sound.h"

// ----------------------------------------------------------------------------
// sounds Includes
// ----------------------------------------------------------------------------

//#include "snd_menu.h"
//#include "snd_start.h"
#include "snd_click.h"
#include "snd_jingle_in.h"
#include "snd_jingle_out.h"
#include "music_intro.h"

// ----------------------------------------------------------------------------
// constants
// ----------------------------------------------------------------------------

#define SOUND_IS_ON					1

// ----------------------------------------------------------------------------
// constants
// ----------------------------------------------------------------------------

#define CHANNEL_0					0
#define CHANNEL_1					1
#define CHANNEL_2					2
#define CHANNEL_3					3
#define CHANNEL_4					4
#define CHANNEL_5					5
#define CHANNEL_6					6
#define CHANNEL_7					7

#define NB_CHANNELS_MAX				8

// ----------------------------------------------------------------------------
// sounds global table
// ----------------------------------------------------------------------------

void*	sounds[NB_SOUNDS];
int		soundsSize[NB_SOUNDS];
int		channels[NB_SOUNDS];
int		volume[NB_SOUNDS];
bool	loop[NB_SOUNDS];
bool 	isPlaying[NB_SOUNDS];

// ----------------------------------------------------------------------------
// MACROS
// ----------------------------------------------------------------------------

#define INIT_SOUND( _index_, _snd_, _snd_size_, _channel_, _vol_, _loop_ )		\
	sounds[_index_] 		= (void*)_snd_;									\
	soundsSize[_index_] 	= (int)_snd_size_;									\
	channels[_index_] 		= _channel_;										\
	volume[_index_]			= _vol_;											\
	loop[_index_]			= _loop_;											\
	isPlaying[_index_] 		= false
	
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// INIT SOUNDS
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

bool Sounds_Init( void )
{
	INIT_SOUND( SOUND_INTRO, 		music_intro,	music_intro_size, 		CHANNEL_0, 100, 	false );
DBG_MSG3( "Sounds_Init %d - %d %d", SOUND_INTRO,		 (int)music_intro,		(int)music_intro_size	 )	;
	INIT_SOUND( SOUND_CLICK, 		snd_click,		snd_click_size, 		CHANNEL_1, 100, 	false );
DBG_MSG3( "Sounds_Init %d - %d %d", SOUND_CLICK, 		(int)snd_click,		(int)snd_click_size )	;
	INIT_SOUND( SOUND_JINGLE_IN, 	snd_jingle_in,	snd_jingle_in_size, 	CHANNEL_1, 100, 	false );
DBG_MSG3( "Sounds_Init %d - %d %d", SOUND_JINGLE_IN, 	(int)snd_jingle_in,	(int)snd_jingle_in_size )	;
	INIT_SOUND( SOUND_START, 		snd_jingle_out,	snd_jingle_out_size, 	CHANNEL_1, 100, 	false );
DBG_MSG3( "Sounds_Init %d - %d %d", SOUND_START, 		(int)snd_jingle_out,	(int)snd_jingle_out_size )	;

	return true;
}

// ----------------------------------------------------------------------------
// 
// ----------------------------------------------------------------------------

bool Sounds_StopAll( void )
{
	int	i;
	for( i=0; i<NB_SOUNDS; i++ )
	{
		SoundStop( i );
	}
	return true;
}

// ----------------------------------------------------------------------------
// 
// ----------------------------------------------------------------------------

bool SoundPlay( int _soundIndex )
{
	if ( isPlaying[_soundIndex] ) 	return false;

	isPlaying[_soundIndex] = loop[_soundIndex];

	PA_StopStream	( 	channels[_soundIndex] );

DBG_MSG2( "SoundPlay idx %d - chn %d   ", _soundIndex, channels[_soundIndex] )	;
DBG_MSG2( "SoundPlay frq %d - fmt %d   ", PA_SoundOption.freq, PA_SoundOption.format)	;

#if SOUND_IS_ON
	PA_PlaySoundEx2	( 	channels[_soundIndex], 
						sounds[_soundIndex], 
						(u32)soundsSize[_soundIndex], 
						volume[_soundIndex], 
						PA_SoundOption.freq, 
						PA_SoundOption.format, 
						loop[ _soundIndex ], 
						0 
					);
#endif

	return true;
}

// ----------------------------------------------------------------------------
// 
// ----------------------------------------------------------------------------

bool SoundIsPlaying( int _soundIndex )
{
	return isPlaying[_soundIndex];
}

// ----------------------------------------------------------------------------
// 
// ----------------------------------------------------------------------------

bool SoundStop( int _soundIndex )
{
	isPlaying[_soundIndex] = false;
	PA_StopStream( channels[_soundIndex] );
	//PA_StopSound( channels[_soundIndex] );

	return true;
}


// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------
// Nintendo DS game by papafuji - 2006 - created with PA_lib
// ----------------------------------------------------------------------------
// ----------------------------------------------------------------------------

